import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VideoAnalyzerEdgeModuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/video_analyzer_edge_module#name VideoAnalyzerEdgeModule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/video_analyzer_edge_module#resource_group_name VideoAnalyzerEdgeModule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/video_analyzer_edge_module#video_analyzer_name VideoAnalyzerEdgeModule#video_analyzer_name}
    */
    readonly videoAnalyzerName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/video_analyzer_edge_module#timeouts VideoAnalyzerEdgeModule#timeouts}
    */
    readonly timeouts?: VideoAnalyzerEdgeModuleTimeouts;
}
export interface VideoAnalyzerEdgeModuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/video_analyzer_edge_module#create VideoAnalyzerEdgeModule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/video_analyzer_edge_module#delete VideoAnalyzerEdgeModule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/video_analyzer_edge_module#read VideoAnalyzerEdgeModule#read}
    */
    readonly read?: string;
}
export declare function videoAnalyzerEdgeModuleTimeoutsToTerraform(struct?: VideoAnalyzerEdgeModuleTimeoutsOutputReference | VideoAnalyzerEdgeModuleTimeouts | cdktf.IResolvable): any;
export declare class VideoAnalyzerEdgeModuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VideoAnalyzerEdgeModuleTimeouts | undefined;
    set internalValue(value: VideoAnalyzerEdgeModuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/video_analyzer_edge_module azurerm_video_analyzer_edge_module}
*/
export declare class VideoAnalyzerEdgeModule extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/video_analyzer_edge_module azurerm_video_analyzer_edge_module} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VideoAnalyzerEdgeModuleConfig
    */
    constructor(scope: Construct, id: string, config: VideoAnalyzerEdgeModuleConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _videoAnalyzerName?;
    get videoAnalyzerName(): string;
    set videoAnalyzerName(value: string);
    get videoAnalyzerNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): VideoAnalyzerEdgeModuleTimeoutsOutputReference;
    putTimeouts(value: VideoAnalyzerEdgeModuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VideoAnalyzerEdgeModuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
