import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualMachineConfigurationPolicyAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#location VirtualMachineConfigurationPolicyAssignment#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#name VirtualMachineConfigurationPolicyAssignment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#virtual_machine_id VirtualMachineConfigurationPolicyAssignment#virtual_machine_id}
    */
    readonly virtualMachineId: string;
    /**
    * configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#configuration VirtualMachineConfigurationPolicyAssignment#configuration}
    */
    readonly configuration: VirtualMachineConfigurationPolicyAssignmentConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#timeouts VirtualMachineConfigurationPolicyAssignment#timeouts}
    */
    readonly timeouts?: VirtualMachineConfigurationPolicyAssignmentTimeouts;
}
export interface VirtualMachineConfigurationPolicyAssignmentConfigurationParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#name VirtualMachineConfigurationPolicyAssignment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#value VirtualMachineConfigurationPolicyAssignment#value}
    */
    readonly value: string;
}
export declare function virtualMachineConfigurationPolicyAssignmentConfigurationParameterToTerraform(struct?: VirtualMachineConfigurationPolicyAssignmentConfigurationParameter | cdktf.IResolvable): any;
export interface VirtualMachineConfigurationPolicyAssignmentConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#name VirtualMachineConfigurationPolicyAssignment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#version VirtualMachineConfigurationPolicyAssignment#version}
    */
    readonly version?: string;
    /**
    * parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#parameter VirtualMachineConfigurationPolicyAssignment#parameter}
    */
    readonly parameter?: VirtualMachineConfigurationPolicyAssignmentConfigurationParameter[] | cdktf.IResolvable;
}
export declare function virtualMachineConfigurationPolicyAssignmentConfigurationToTerraform(struct?: VirtualMachineConfigurationPolicyAssignmentConfigurationOutputReference | VirtualMachineConfigurationPolicyAssignmentConfiguration): any;
export declare class VirtualMachineConfigurationPolicyAssignmentConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineConfigurationPolicyAssignmentConfiguration | undefined;
    set internalValue(value: VirtualMachineConfigurationPolicyAssignmentConfiguration | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _parameter?;
    get parameter(): VirtualMachineConfigurationPolicyAssignmentConfigurationParameter[] | cdktf.IResolvable;
    set parameter(value: VirtualMachineConfigurationPolicyAssignmentConfigurationParameter[] | cdktf.IResolvable);
    resetParameter(): void;
    get parameterInput(): cdktf.IResolvable | VirtualMachineConfigurationPolicyAssignmentConfigurationParameter[] | undefined;
}
export interface VirtualMachineConfigurationPolicyAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#create VirtualMachineConfigurationPolicyAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#delete VirtualMachineConfigurationPolicyAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#read VirtualMachineConfigurationPolicyAssignment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment#update VirtualMachineConfigurationPolicyAssignment#update}
    */
    readonly update?: string;
}
export declare function virtualMachineConfigurationPolicyAssignmentTimeoutsToTerraform(struct?: VirtualMachineConfigurationPolicyAssignmentTimeoutsOutputReference | VirtualMachineConfigurationPolicyAssignmentTimeouts | cdktf.IResolvable): any;
export declare class VirtualMachineConfigurationPolicyAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineConfigurationPolicyAssignmentTimeouts | undefined;
    set internalValue(value: VirtualMachineConfigurationPolicyAssignmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment azurerm_virtual_machine_configuration_policy_assignment}
*/
export declare class VirtualMachineConfigurationPolicyAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_configuration_policy_assignment azurerm_virtual_machine_configuration_policy_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualMachineConfigurationPolicyAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: VirtualMachineConfigurationPolicyAssignmentConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _virtualMachineId?;
    get virtualMachineId(): string;
    set virtualMachineId(value: string);
    get virtualMachineIdInput(): string | undefined;
    private _configuration;
    get configuration(): VirtualMachineConfigurationPolicyAssignmentConfigurationOutputReference;
    putConfiguration(value: VirtualMachineConfigurationPolicyAssignmentConfiguration): void;
    get configurationInput(): VirtualMachineConfigurationPolicyAssignmentConfiguration | undefined;
    private _timeouts;
    get timeouts(): VirtualMachineConfigurationPolicyAssignmentTimeoutsOutputReference;
    putTimeouts(value: VirtualMachineConfigurationPolicyAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VirtualMachineConfigurationPolicyAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
