import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualMachineScaleSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#automatic_os_upgrade VirtualMachineScaleSet#automatic_os_upgrade}
    */
    readonly automaticOsUpgrade?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#eviction_policy VirtualMachineScaleSet#eviction_policy}
    */
    readonly evictionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#health_probe_id VirtualMachineScaleSet#health_probe_id}
    */
    readonly healthProbeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#license_type VirtualMachineScaleSet#license_type}
    */
    readonly licenseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#location VirtualMachineScaleSet#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#overprovision VirtualMachineScaleSet#overprovision}
    */
    readonly overprovision?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#priority VirtualMachineScaleSet#priority}
    */
    readonly priority?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#proximity_placement_group_id VirtualMachineScaleSet#proximity_placement_group_id}
    */
    readonly proximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#resource_group_name VirtualMachineScaleSet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#single_placement_group VirtualMachineScaleSet#single_placement_group}
    */
    readonly singlePlacementGroup?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#tags VirtualMachineScaleSet#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#upgrade_policy_mode VirtualMachineScaleSet#upgrade_policy_mode}
    */
    readonly upgradePolicyMode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#zones VirtualMachineScaleSet#zones}
    */
    readonly zones?: string[];
    /**
    * boot_diagnostics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#boot_diagnostics VirtualMachineScaleSet#boot_diagnostics}
    */
    readonly bootDiagnostics?: VirtualMachineScaleSetBootDiagnostics;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#extension VirtualMachineScaleSet#extension}
    */
    readonly extension?: VirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#identity VirtualMachineScaleSet#identity}
    */
    readonly identity?: VirtualMachineScaleSetIdentity;
    /**
    * network_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#network_profile VirtualMachineScaleSet#network_profile}
    */
    readonly networkProfile: VirtualMachineScaleSetNetworkProfile[] | cdktf.IResolvable;
    /**
    * os_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#os_profile VirtualMachineScaleSet#os_profile}
    */
    readonly osProfile: VirtualMachineScaleSetOsProfile;
    /**
    * os_profile_linux_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#os_profile_linux_config VirtualMachineScaleSet#os_profile_linux_config}
    */
    readonly osProfileLinuxConfig?: VirtualMachineScaleSetOsProfileLinuxConfig;
    /**
    * os_profile_secrets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#os_profile_secrets VirtualMachineScaleSet#os_profile_secrets}
    */
    readonly osProfileSecrets?: VirtualMachineScaleSetOsProfileSecrets[] | cdktf.IResolvable;
    /**
    * os_profile_windows_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#os_profile_windows_config VirtualMachineScaleSet#os_profile_windows_config}
    */
    readonly osProfileWindowsConfig?: VirtualMachineScaleSetOsProfileWindowsConfig;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#plan VirtualMachineScaleSet#plan}
    */
    readonly plan?: VirtualMachineScaleSetPlan;
    /**
    * rolling_upgrade_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#rolling_upgrade_policy VirtualMachineScaleSet#rolling_upgrade_policy}
    */
    readonly rollingUpgradePolicy?: VirtualMachineScaleSetRollingUpgradePolicy;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#sku VirtualMachineScaleSet#sku}
    */
    readonly sku: VirtualMachineScaleSetSku;
    /**
    * storage_profile_data_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#storage_profile_data_disk VirtualMachineScaleSet#storage_profile_data_disk}
    */
    readonly storageProfileDataDisk?: VirtualMachineScaleSetStorageProfileDataDisk[] | cdktf.IResolvable;
    /**
    * storage_profile_image_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#storage_profile_image_reference VirtualMachineScaleSet#storage_profile_image_reference}
    */
    readonly storageProfileImageReference?: VirtualMachineScaleSetStorageProfileImageReference;
    /**
    * storage_profile_os_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#storage_profile_os_disk VirtualMachineScaleSet#storage_profile_os_disk}
    */
    readonly storageProfileOsDisk: VirtualMachineScaleSetStorageProfileOsDisk;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#timeouts VirtualMachineScaleSet#timeouts}
    */
    readonly timeouts?: VirtualMachineScaleSetTimeouts;
}
export interface VirtualMachineScaleSetBootDiagnostics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#enabled VirtualMachineScaleSet#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#storage_uri VirtualMachineScaleSet#storage_uri}
    */
    readonly storageUri: string;
}
export declare function virtualMachineScaleSetBootDiagnosticsToTerraform(struct?: VirtualMachineScaleSetBootDiagnosticsOutputReference | VirtualMachineScaleSetBootDiagnostics): any;
export declare class VirtualMachineScaleSetBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetBootDiagnostics | undefined;
    set internalValue(value: VirtualMachineScaleSetBootDiagnostics | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageUri?;
    get storageUri(): string;
    set storageUri(value: string);
    get storageUriInput(): string | undefined;
}
export interface VirtualMachineScaleSetExtension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#auto_upgrade_minor_version VirtualMachineScaleSet#auto_upgrade_minor_version}
    */
    readonly autoUpgradeMinorVersion?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#protected_settings VirtualMachineScaleSet#protected_settings}
    */
    readonly protectedSettings?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#provision_after_extensions VirtualMachineScaleSet#provision_after_extensions}
    */
    readonly provisionAfterExtensions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#publisher VirtualMachineScaleSet#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#settings VirtualMachineScaleSet#settings}
    */
    readonly settings?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#type VirtualMachineScaleSet#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#type_handler_version VirtualMachineScaleSet#type_handler_version}
    */
    readonly typeHandlerVersion: string;
}
export declare function virtualMachineScaleSetExtensionToTerraform(struct?: VirtualMachineScaleSetExtension | cdktf.IResolvable): any;
export interface VirtualMachineScaleSetIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#identity_ids VirtualMachineScaleSet#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#type VirtualMachineScaleSet#type}
    */
    readonly type: string;
}
export declare function virtualMachineScaleSetIdentityToTerraform(struct?: VirtualMachineScaleSetIdentityOutputReference | VirtualMachineScaleSetIdentity): any;
export declare class VirtualMachineScaleSetIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetIdentity | undefined;
    set internalValue(value: VirtualMachineScaleSetIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface VirtualMachineScaleSetNetworkProfileDnsSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#dns_servers VirtualMachineScaleSet#dns_servers}
    */
    readonly dnsServers: string[];
}
export declare function virtualMachineScaleSetNetworkProfileDnsSettingsToTerraform(struct?: VirtualMachineScaleSetNetworkProfileDnsSettingsOutputReference | VirtualMachineScaleSetNetworkProfileDnsSettings): any;
export declare class VirtualMachineScaleSetNetworkProfileDnsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetNetworkProfileDnsSettings | undefined;
    set internalValue(value: VirtualMachineScaleSetNetworkProfileDnsSettings | undefined);
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    get dnsServersInput(): string[] | undefined;
}
export interface VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#domain_name_label VirtualMachineScaleSet#domain_name_label}
    */
    readonly domainNameLabel: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#idle_timeout VirtualMachineScaleSet#idle_timeout}
    */
    readonly idleTimeout: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}
    */
    readonly name: string;
}
export declare function virtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfigurationToTerraform(struct?: VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfigurationOutputReference | VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration): any;
export declare class VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration | undefined;
    set internalValue(value: VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration | undefined);
    private _domainNameLabel?;
    get domainNameLabel(): string;
    set domainNameLabel(value: string);
    get domainNameLabelInput(): string | undefined;
    private _idleTimeout?;
    get idleTimeout(): number;
    set idleTimeout(value: number);
    get idleTimeoutInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface VirtualMachineScaleSetNetworkProfileIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#application_gateway_backend_address_pool_ids VirtualMachineScaleSet#application_gateway_backend_address_pool_ids}
    */
    readonly applicationGatewayBackendAddressPoolIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#application_security_group_ids VirtualMachineScaleSet#application_security_group_ids}
    */
    readonly applicationSecurityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#load_balancer_backend_address_pool_ids VirtualMachineScaleSet#load_balancer_backend_address_pool_ids}
    */
    readonly loadBalancerBackendAddressPoolIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#load_balancer_inbound_nat_rules_ids VirtualMachineScaleSet#load_balancer_inbound_nat_rules_ids}
    */
    readonly loadBalancerInboundNatRulesIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#primary VirtualMachineScaleSet#primary}
    */
    readonly primary: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#subnet_id VirtualMachineScaleSet#subnet_id}
    */
    readonly subnetId: string;
    /**
    * public_ip_address_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#public_ip_address_configuration VirtualMachineScaleSet#public_ip_address_configuration}
    */
    readonly publicIpAddressConfiguration?: VirtualMachineScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration;
}
export declare function virtualMachineScaleSetNetworkProfileIpConfigurationToTerraform(struct?: VirtualMachineScaleSetNetworkProfileIpConfiguration | cdktf.IResolvable): any;
export interface VirtualMachineScaleSetNetworkProfile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#accelerated_networking VirtualMachineScaleSet#accelerated_networking}
    */
    readonly acceleratedNetworking?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#ip_forwarding VirtualMachineScaleSet#ip_forwarding}
    */
    readonly ipForwarding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#network_security_group_id VirtualMachineScaleSet#network_security_group_id}
    */
    readonly networkSecurityGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#primary VirtualMachineScaleSet#primary}
    */
    readonly primary: boolean | cdktf.IResolvable;
    /**
    * dns_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#dns_settings VirtualMachineScaleSet#dns_settings}
    */
    readonly dnsSettings?: VirtualMachineScaleSetNetworkProfileDnsSettings;
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#ip_configuration VirtualMachineScaleSet#ip_configuration}
    */
    readonly ipConfiguration: VirtualMachineScaleSetNetworkProfileIpConfiguration[] | cdktf.IResolvable;
}
export declare function virtualMachineScaleSetNetworkProfileToTerraform(struct?: VirtualMachineScaleSetNetworkProfile | cdktf.IResolvable): any;
export interface VirtualMachineScaleSetOsProfile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#admin_password VirtualMachineScaleSet#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#admin_username VirtualMachineScaleSet#admin_username}
    */
    readonly adminUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#computer_name_prefix VirtualMachineScaleSet#computer_name_prefix}
    */
    readonly computerNamePrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#custom_data VirtualMachineScaleSet#custom_data}
    */
    readonly customData?: string;
}
export declare function virtualMachineScaleSetOsProfileToTerraform(struct?: VirtualMachineScaleSetOsProfileOutputReference | VirtualMachineScaleSetOsProfile): any;
export declare class VirtualMachineScaleSetOsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetOsProfile | undefined;
    set internalValue(value: VirtualMachineScaleSetOsProfile | undefined);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    get adminUsernameInput(): string | undefined;
    private _computerNamePrefix?;
    get computerNamePrefix(): string;
    set computerNamePrefix(value: string);
    get computerNamePrefixInput(): string | undefined;
    private _customData?;
    get customData(): string;
    set customData(value: string);
    resetCustomData(): void;
    get customDataInput(): string | undefined;
}
export interface VirtualMachineScaleSetOsProfileLinuxConfigSshKeys {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#key_data VirtualMachineScaleSet#key_data}
    */
    readonly keyData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#path VirtualMachineScaleSet#path}
    */
    readonly path: string;
}
export declare function virtualMachineScaleSetOsProfileLinuxConfigSshKeysToTerraform(struct?: VirtualMachineScaleSetOsProfileLinuxConfigSshKeys | cdktf.IResolvable): any;
export interface VirtualMachineScaleSetOsProfileLinuxConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#disable_password_authentication VirtualMachineScaleSet#disable_password_authentication}
    */
    readonly disablePasswordAuthentication?: boolean | cdktf.IResolvable;
    /**
    * ssh_keys block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#ssh_keys VirtualMachineScaleSet#ssh_keys}
    */
    readonly sshKeys?: VirtualMachineScaleSetOsProfileLinuxConfigSshKeys[] | cdktf.IResolvable;
}
export declare function virtualMachineScaleSetOsProfileLinuxConfigToTerraform(struct?: VirtualMachineScaleSetOsProfileLinuxConfigOutputReference | VirtualMachineScaleSetOsProfileLinuxConfig | cdktf.IResolvable): any;
export declare class VirtualMachineScaleSetOsProfileLinuxConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetOsProfileLinuxConfig | undefined;
    set internalValue(value: VirtualMachineScaleSetOsProfileLinuxConfig | undefined);
    private _disablePasswordAuthentication?;
    get disablePasswordAuthentication(): boolean | cdktf.IResolvable;
    set disablePasswordAuthentication(value: boolean | cdktf.IResolvable);
    resetDisablePasswordAuthentication(): void;
    get disablePasswordAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _sshKeys?;
    get sshKeys(): VirtualMachineScaleSetOsProfileLinuxConfigSshKeys[] | cdktf.IResolvable;
    set sshKeys(value: VirtualMachineScaleSetOsProfileLinuxConfigSshKeys[] | cdktf.IResolvable);
    resetSshKeys(): void;
    get sshKeysInput(): cdktf.IResolvable | VirtualMachineScaleSetOsProfileLinuxConfigSshKeys[] | undefined;
}
export interface VirtualMachineScaleSetOsProfileSecretsVaultCertificates {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#certificate_store VirtualMachineScaleSet#certificate_store}
    */
    readonly certificateStore?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#certificate_url VirtualMachineScaleSet#certificate_url}
    */
    readonly certificateUrl: string;
}
export declare function virtualMachineScaleSetOsProfileSecretsVaultCertificatesToTerraform(struct?: VirtualMachineScaleSetOsProfileSecretsVaultCertificates | cdktf.IResolvable): any;
export interface VirtualMachineScaleSetOsProfileSecrets {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#source_vault_id VirtualMachineScaleSet#source_vault_id}
    */
    readonly sourceVaultId: string;
    /**
    * vault_certificates block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#vault_certificates VirtualMachineScaleSet#vault_certificates}
    */
    readonly vaultCertificates?: VirtualMachineScaleSetOsProfileSecretsVaultCertificates[] | cdktf.IResolvable;
}
export declare function virtualMachineScaleSetOsProfileSecretsToTerraform(struct?: VirtualMachineScaleSetOsProfileSecrets | cdktf.IResolvable): any;
export interface VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#component VirtualMachineScaleSet#component}
    */
    readonly component: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#content VirtualMachineScaleSet#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#pass VirtualMachineScaleSet#pass}
    */
    readonly pass: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#setting_name VirtualMachineScaleSet#setting_name}
    */
    readonly settingName: string;
}
export declare function virtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfigToTerraform(struct?: VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig | cdktf.IResolvable): any;
export interface VirtualMachineScaleSetOsProfileWindowsConfigWinrm {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#certificate_url VirtualMachineScaleSet#certificate_url}
    */
    readonly certificateUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#protocol VirtualMachineScaleSet#protocol}
    */
    readonly protocol: string;
}
export declare function virtualMachineScaleSetOsProfileWindowsConfigWinrmToTerraform(struct?: VirtualMachineScaleSetOsProfileWindowsConfigWinrm | cdktf.IResolvable): any;
export interface VirtualMachineScaleSetOsProfileWindowsConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#enable_automatic_upgrades VirtualMachineScaleSet#enable_automatic_upgrades}
    */
    readonly enableAutomaticUpgrades?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#provision_vm_agent VirtualMachineScaleSet#provision_vm_agent}
    */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
    * additional_unattend_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#additional_unattend_config VirtualMachineScaleSet#additional_unattend_config}
    */
    readonly additionalUnattendConfig?: VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig[] | cdktf.IResolvable;
    /**
    * winrm block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#winrm VirtualMachineScaleSet#winrm}
    */
    readonly winrm?: VirtualMachineScaleSetOsProfileWindowsConfigWinrm[] | cdktf.IResolvable;
}
export declare function virtualMachineScaleSetOsProfileWindowsConfigToTerraform(struct?: VirtualMachineScaleSetOsProfileWindowsConfigOutputReference | VirtualMachineScaleSetOsProfileWindowsConfig | cdktf.IResolvable): any;
export declare class VirtualMachineScaleSetOsProfileWindowsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetOsProfileWindowsConfig | undefined;
    set internalValue(value: VirtualMachineScaleSetOsProfileWindowsConfig | undefined);
    private _enableAutomaticUpgrades?;
    get enableAutomaticUpgrades(): boolean | cdktf.IResolvable;
    set enableAutomaticUpgrades(value: boolean | cdktf.IResolvable);
    resetEnableAutomaticUpgrades(): void;
    get enableAutomaticUpgradesInput(): boolean | cdktf.IResolvable | undefined;
    private _provisionVmAgent?;
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    resetProvisionVmAgent(): void;
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _additionalUnattendConfig?;
    get additionalUnattendConfig(): VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig[] | cdktf.IResolvable;
    set additionalUnattendConfig(value: VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig[] | cdktf.IResolvable);
    resetAdditionalUnattendConfig(): void;
    get additionalUnattendConfigInput(): cdktf.IResolvable | VirtualMachineScaleSetOsProfileWindowsConfigAdditionalUnattendConfig[] | undefined;
    private _winrm?;
    get winrm(): VirtualMachineScaleSetOsProfileWindowsConfigWinrm[] | cdktf.IResolvable;
    set winrm(value: VirtualMachineScaleSetOsProfileWindowsConfigWinrm[] | cdktf.IResolvable);
    resetWinrm(): void;
    get winrmInput(): cdktf.IResolvable | VirtualMachineScaleSetOsProfileWindowsConfigWinrm[] | undefined;
}
export interface VirtualMachineScaleSetPlan {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#product VirtualMachineScaleSet#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#publisher VirtualMachineScaleSet#publisher}
    */
    readonly publisher: string;
}
export declare function virtualMachineScaleSetPlanToTerraform(struct?: VirtualMachineScaleSetPlanOutputReference | VirtualMachineScaleSetPlan | cdktf.IResolvable): any;
export declare class VirtualMachineScaleSetPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetPlan | undefined;
    set internalValue(value: VirtualMachineScaleSetPlan | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
}
export interface VirtualMachineScaleSetRollingUpgradePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#max_batch_instance_percent VirtualMachineScaleSet#max_batch_instance_percent}
    */
    readonly maxBatchInstancePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#max_unhealthy_instance_percent VirtualMachineScaleSet#max_unhealthy_instance_percent}
    */
    readonly maxUnhealthyInstancePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#max_unhealthy_upgraded_instance_percent VirtualMachineScaleSet#max_unhealthy_upgraded_instance_percent}
    */
    readonly maxUnhealthyUpgradedInstancePercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#pause_time_between_batches VirtualMachineScaleSet#pause_time_between_batches}
    */
    readonly pauseTimeBetweenBatches?: string;
}
export declare function virtualMachineScaleSetRollingUpgradePolicyToTerraform(struct?: VirtualMachineScaleSetRollingUpgradePolicyOutputReference | VirtualMachineScaleSetRollingUpgradePolicy): any;
export declare class VirtualMachineScaleSetRollingUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetRollingUpgradePolicy | undefined;
    set internalValue(value: VirtualMachineScaleSetRollingUpgradePolicy | undefined);
    private _maxBatchInstancePercent?;
    get maxBatchInstancePercent(): number;
    set maxBatchInstancePercent(value: number);
    resetMaxBatchInstancePercent(): void;
    get maxBatchInstancePercentInput(): number | undefined;
    private _maxUnhealthyInstancePercent?;
    get maxUnhealthyInstancePercent(): number;
    set maxUnhealthyInstancePercent(value: number);
    resetMaxUnhealthyInstancePercent(): void;
    get maxUnhealthyInstancePercentInput(): number | undefined;
    private _maxUnhealthyUpgradedInstancePercent?;
    get maxUnhealthyUpgradedInstancePercent(): number;
    set maxUnhealthyUpgradedInstancePercent(value: number);
    resetMaxUnhealthyUpgradedInstancePercent(): void;
    get maxUnhealthyUpgradedInstancePercentInput(): number | undefined;
    private _pauseTimeBetweenBatches?;
    get pauseTimeBetweenBatches(): string;
    set pauseTimeBetweenBatches(value: string);
    resetPauseTimeBetweenBatches(): void;
    get pauseTimeBetweenBatchesInput(): string | undefined;
}
export interface VirtualMachineScaleSetSku {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#capacity VirtualMachineScaleSet#capacity}
    */
    readonly capacity: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#tier VirtualMachineScaleSet#tier}
    */
    readonly tier?: string;
}
export declare function virtualMachineScaleSetSkuToTerraform(struct?: VirtualMachineScaleSetSkuOutputReference | VirtualMachineScaleSetSku): any;
export declare class VirtualMachineScaleSetSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetSku | undefined;
    set internalValue(value: VirtualMachineScaleSetSku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    get capacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
}
export interface VirtualMachineScaleSetStorageProfileDataDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#caching VirtualMachineScaleSet#caching}
    */
    readonly caching?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#create_option VirtualMachineScaleSet#create_option}
    */
    readonly createOption: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#disk_size_gb VirtualMachineScaleSet#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#lun VirtualMachineScaleSet#lun}
    */
    readonly lun: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#managed_disk_type VirtualMachineScaleSet#managed_disk_type}
    */
    readonly managedDiskType?: string;
}
export declare function virtualMachineScaleSetStorageProfileDataDiskToTerraform(struct?: VirtualMachineScaleSetStorageProfileDataDisk | cdktf.IResolvable): any;
export interface VirtualMachineScaleSetStorageProfileImageReference {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#id VirtualMachineScaleSet#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#offer VirtualMachineScaleSet#offer}
    */
    readonly offer?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#publisher VirtualMachineScaleSet#publisher}
    */
    readonly publisher?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#sku VirtualMachineScaleSet#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#version VirtualMachineScaleSet#version}
    */
    readonly version?: string;
}
export declare function virtualMachineScaleSetStorageProfileImageReferenceToTerraform(struct?: VirtualMachineScaleSetStorageProfileImageReferenceOutputReference | VirtualMachineScaleSetStorageProfileImageReference | cdktf.IResolvable): any;
export declare class VirtualMachineScaleSetStorageProfileImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetStorageProfileImageReference | undefined;
    set internalValue(value: VirtualMachineScaleSetStorageProfileImageReference | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _offer?;
    get offer(): string;
    set offer(value: string);
    resetOffer(): void;
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    resetPublisher(): void;
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface VirtualMachineScaleSetStorageProfileOsDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#caching VirtualMachineScaleSet#caching}
    */
    readonly caching?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#create_option VirtualMachineScaleSet#create_option}
    */
    readonly createOption: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#image VirtualMachineScaleSet#image}
    */
    readonly image?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#managed_disk_type VirtualMachineScaleSet#managed_disk_type}
    */
    readonly managedDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#name VirtualMachineScaleSet#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#os_type VirtualMachineScaleSet#os_type}
    */
    readonly osType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#vhd_containers VirtualMachineScaleSet#vhd_containers}
    */
    readonly vhdContainers?: string[];
}
export declare function virtualMachineScaleSetStorageProfileOsDiskToTerraform(struct?: VirtualMachineScaleSetStorageProfileOsDiskOutputReference | VirtualMachineScaleSetStorageProfileOsDisk | cdktf.IResolvable): any;
export declare class VirtualMachineScaleSetStorageProfileOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetStorageProfileOsDisk | undefined;
    set internalValue(value: VirtualMachineScaleSetStorageProfileOsDisk | undefined);
    private _caching?;
    get caching(): string;
    set caching(value: string);
    resetCaching(): void;
    get cachingInput(): string | undefined;
    private _createOption?;
    get createOption(): string;
    set createOption(value: string);
    get createOptionInput(): string | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _managedDiskType?;
    get managedDiskType(): string;
    set managedDiskType(value: string);
    resetManagedDiskType(): void;
    get managedDiskTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    resetOsType(): void;
    get osTypeInput(): string | undefined;
    private _vhdContainers?;
    get vhdContainers(): string[];
    set vhdContainers(value: string[]);
    resetVhdContainers(): void;
    get vhdContainersInput(): string[] | undefined;
}
export interface VirtualMachineScaleSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#create VirtualMachineScaleSet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#delete VirtualMachineScaleSet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#read VirtualMachineScaleSet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set#update VirtualMachineScaleSet#update}
    */
    readonly update?: string;
}
export declare function virtualMachineScaleSetTimeoutsToTerraform(struct?: VirtualMachineScaleSetTimeoutsOutputReference | VirtualMachineScaleSetTimeouts | cdktf.IResolvable): any;
export declare class VirtualMachineScaleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VirtualMachineScaleSetTimeouts | undefined;
    set internalValue(value: VirtualMachineScaleSetTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set azurerm_virtual_machine_scale_set}
*/
export declare class VirtualMachineScaleSet extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_machine_scale_set azurerm_virtual_machine_scale_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualMachineScaleSetConfig
    */
    constructor(scope: Construct, id: string, config: VirtualMachineScaleSetConfig);
    private _automaticOsUpgrade?;
    get automaticOsUpgrade(): boolean | cdktf.IResolvable;
    set automaticOsUpgrade(value: boolean | cdktf.IResolvable);
    resetAutomaticOsUpgrade(): void;
    get automaticOsUpgradeInput(): boolean | cdktf.IResolvable | undefined;
    private _evictionPolicy?;
    get evictionPolicy(): string;
    set evictionPolicy(value: string);
    resetEvictionPolicy(): void;
    get evictionPolicyInput(): string | undefined;
    private _healthProbeId?;
    get healthProbeId(): string;
    set healthProbeId(value: string);
    resetHealthProbeId(): void;
    get healthProbeIdInput(): string | undefined;
    get id(): string;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    resetLicenseType(): void;
    get licenseTypeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _overprovision?;
    get overprovision(): boolean | cdktf.IResolvable;
    set overprovision(value: boolean | cdktf.IResolvable);
    resetOverprovision(): void;
    get overprovisionInput(): boolean | cdktf.IResolvable | undefined;
    private _priority?;
    get priority(): string;
    set priority(value: string);
    resetPriority(): void;
    get priorityInput(): string | undefined;
    private _proximityPlacementGroupId?;
    get proximityPlacementGroupId(): string;
    set proximityPlacementGroupId(value: string);
    resetProximityPlacementGroupId(): void;
    get proximityPlacementGroupIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _singlePlacementGroup?;
    get singlePlacementGroup(): boolean | cdktf.IResolvable;
    set singlePlacementGroup(value: boolean | cdktf.IResolvable);
    resetSinglePlacementGroup(): void;
    get singlePlacementGroupInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _upgradePolicyMode?;
    get upgradePolicyMode(): string;
    set upgradePolicyMode(value: string);
    get upgradePolicyModeInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _bootDiagnostics;
    get bootDiagnostics(): VirtualMachineScaleSetBootDiagnosticsOutputReference;
    putBootDiagnostics(value: VirtualMachineScaleSetBootDiagnostics): void;
    resetBootDiagnostics(): void;
    get bootDiagnosticsInput(): VirtualMachineScaleSetBootDiagnostics | undefined;
    private _extension?;
    get extension(): VirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    set extension(value: VirtualMachineScaleSetExtension[] | cdktf.IResolvable);
    resetExtension(): void;
    get extensionInput(): cdktf.IResolvable | VirtualMachineScaleSetExtension[] | undefined;
    private _identity;
    get identity(): VirtualMachineScaleSetIdentityOutputReference;
    putIdentity(value: VirtualMachineScaleSetIdentity): void;
    resetIdentity(): void;
    get identityInput(): VirtualMachineScaleSetIdentity | undefined;
    private _networkProfile?;
    get networkProfile(): VirtualMachineScaleSetNetworkProfile[] | cdktf.IResolvable;
    set networkProfile(value: VirtualMachineScaleSetNetworkProfile[] | cdktf.IResolvable);
    get networkProfileInput(): cdktf.IResolvable | VirtualMachineScaleSetNetworkProfile[] | undefined;
    private _osProfile;
    get osProfile(): VirtualMachineScaleSetOsProfileOutputReference;
    putOsProfile(value: VirtualMachineScaleSetOsProfile): void;
    get osProfileInput(): VirtualMachineScaleSetOsProfile | undefined;
    private _osProfileLinuxConfig;
    get osProfileLinuxConfig(): VirtualMachineScaleSetOsProfileLinuxConfigOutputReference;
    putOsProfileLinuxConfig(value: VirtualMachineScaleSetOsProfileLinuxConfig): void;
    resetOsProfileLinuxConfig(): void;
    get osProfileLinuxConfigInput(): VirtualMachineScaleSetOsProfileLinuxConfig | undefined;
    private _osProfileSecrets?;
    get osProfileSecrets(): VirtualMachineScaleSetOsProfileSecrets[] | cdktf.IResolvable;
    set osProfileSecrets(value: VirtualMachineScaleSetOsProfileSecrets[] | cdktf.IResolvable);
    resetOsProfileSecrets(): void;
    get osProfileSecretsInput(): cdktf.IResolvable | VirtualMachineScaleSetOsProfileSecrets[] | undefined;
    private _osProfileWindowsConfig;
    get osProfileWindowsConfig(): VirtualMachineScaleSetOsProfileWindowsConfigOutputReference;
    putOsProfileWindowsConfig(value: VirtualMachineScaleSetOsProfileWindowsConfig): void;
    resetOsProfileWindowsConfig(): void;
    get osProfileWindowsConfigInput(): VirtualMachineScaleSetOsProfileWindowsConfig | undefined;
    private _plan;
    get plan(): VirtualMachineScaleSetPlanOutputReference;
    putPlan(value: VirtualMachineScaleSetPlan): void;
    resetPlan(): void;
    get planInput(): VirtualMachineScaleSetPlan | undefined;
    private _rollingUpgradePolicy;
    get rollingUpgradePolicy(): VirtualMachineScaleSetRollingUpgradePolicyOutputReference;
    putRollingUpgradePolicy(value: VirtualMachineScaleSetRollingUpgradePolicy): void;
    resetRollingUpgradePolicy(): void;
    get rollingUpgradePolicyInput(): VirtualMachineScaleSetRollingUpgradePolicy | undefined;
    private _sku;
    get sku(): VirtualMachineScaleSetSkuOutputReference;
    putSku(value: VirtualMachineScaleSetSku): void;
    get skuInput(): VirtualMachineScaleSetSku | undefined;
    private _storageProfileDataDisk?;
    get storageProfileDataDisk(): VirtualMachineScaleSetStorageProfileDataDisk[] | cdktf.IResolvable;
    set storageProfileDataDisk(value: VirtualMachineScaleSetStorageProfileDataDisk[] | cdktf.IResolvable);
    resetStorageProfileDataDisk(): void;
    get storageProfileDataDiskInput(): cdktf.IResolvable | VirtualMachineScaleSetStorageProfileDataDisk[] | undefined;
    private _storageProfileImageReference;
    get storageProfileImageReference(): VirtualMachineScaleSetStorageProfileImageReferenceOutputReference;
    putStorageProfileImageReference(value: VirtualMachineScaleSetStorageProfileImageReference): void;
    resetStorageProfileImageReference(): void;
    get storageProfileImageReferenceInput(): VirtualMachineScaleSetStorageProfileImageReference | undefined;
    private _storageProfileOsDisk;
    get storageProfileOsDisk(): VirtualMachineScaleSetStorageProfileOsDiskOutputReference;
    putStorageProfileOsDisk(value: VirtualMachineScaleSetStorageProfileOsDisk): void;
    get storageProfileOsDiskInput(): VirtualMachineScaleSetStorageProfileOsDisk | undefined;
    private _timeouts;
    get timeouts(): VirtualMachineScaleSetTimeoutsOutputReference;
    putTimeouts(value: VirtualMachineScaleSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VirtualMachineScaleSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
