import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VmwareExpressRouteAuthorizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization#name VmwareExpressRouteAuthorization#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization#private_cloud_id VmwareExpressRouteAuthorization#private_cloud_id}
    */
    readonly privateCloudId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization#timeouts VmwareExpressRouteAuthorization#timeouts}
    */
    readonly timeouts?: VmwareExpressRouteAuthorizationTimeouts;
}
export interface VmwareExpressRouteAuthorizationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization#create VmwareExpressRouteAuthorization#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization#delete VmwareExpressRouteAuthorization#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization#read VmwareExpressRouteAuthorization#read}
    */
    readonly read?: string;
}
export declare function vmwareExpressRouteAuthorizationTimeoutsToTerraform(struct?: VmwareExpressRouteAuthorizationTimeoutsOutputReference | VmwareExpressRouteAuthorizationTimeouts | cdktf.IResolvable): any;
export declare class VmwareExpressRouteAuthorizationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VmwareExpressRouteAuthorizationTimeouts | undefined;
    set internalValue(value: VmwareExpressRouteAuthorizationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization azurerm_vmware_express_route_authorization}
*/
export declare class VmwareExpressRouteAuthorization extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization azurerm_vmware_express_route_authorization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VmwareExpressRouteAuthorizationConfig
    */
    constructor(scope: Construct, id: string, config: VmwareExpressRouteAuthorizationConfig);
    get expressRouteAuthorizationId(): string;
    get expressRouteAuthorizationKey(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateCloudId?;
    get privateCloudId(): string;
    set privateCloudId(value: string);
    get privateCloudIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): VmwareExpressRouteAuthorizationTimeoutsOutputReference;
    putTimeouts(value: VmwareExpressRouteAuthorizationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VmwareExpressRouteAuthorizationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
