import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WebPubsubHubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#anonymous_connections_enabled WebPubsubHub#anonymous_connections_enabled}
    */
    readonly anonymousConnectionsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#name WebPubsubHub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#web_pubsub_id WebPubsubHub#web_pubsub_id}
    */
    readonly webPubsubId: string;
    /**
    * event_handler block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#event_handler WebPubsubHub#event_handler}
    */
    readonly eventHandler: WebPubsubHubEventHandler[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#timeouts WebPubsubHub#timeouts}
    */
    readonly timeouts?: WebPubsubHubTimeouts;
}
export interface WebPubsubHubEventHandlerAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#managed_identity_id WebPubsubHub#managed_identity_id}
    */
    readonly managedIdentityId: string;
}
export declare function webPubsubHubEventHandlerAuthToTerraform(struct?: WebPubsubHubEventHandlerAuthOutputReference | WebPubsubHubEventHandlerAuth): any;
export declare class WebPubsubHubEventHandlerAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): WebPubsubHubEventHandlerAuth | undefined;
    set internalValue(value: WebPubsubHubEventHandlerAuth | undefined);
    private _managedIdentityId?;
    get managedIdentityId(): string;
    set managedIdentityId(value: string);
    get managedIdentityIdInput(): string | undefined;
}
export interface WebPubsubHubEventHandler {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#system_events WebPubsubHub#system_events}
    */
    readonly systemEvents?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#url_template WebPubsubHub#url_template}
    */
    readonly urlTemplate: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#user_event_pattern WebPubsubHub#user_event_pattern}
    */
    readonly userEventPattern?: string;
    /**
    * auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#auth WebPubsubHub#auth}
    */
    readonly auth?: WebPubsubHubEventHandlerAuth;
}
export declare function webPubsubHubEventHandlerToTerraform(struct?: WebPubsubHubEventHandler | cdktf.IResolvable): any;
export interface WebPubsubHubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#create WebPubsubHub#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#delete WebPubsubHub#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#read WebPubsubHub#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub#update WebPubsubHub#update}
    */
    readonly update?: string;
}
export declare function webPubsubHubTimeoutsToTerraform(struct?: WebPubsubHubTimeoutsOutputReference | WebPubsubHubTimeouts | cdktf.IResolvable): any;
export declare class WebPubsubHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): WebPubsubHubTimeouts | undefined;
    set internalValue(value: WebPubsubHubTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub azurerm_web_pubsub_hub}
*/
export declare class WebPubsubHub extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_hub azurerm_web_pubsub_hub} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WebPubsubHubConfig
    */
    constructor(scope: Construct, id: string, config: WebPubsubHubConfig);
    private _anonymousConnectionsEnabled?;
    get anonymousConnectionsEnabled(): boolean | cdktf.IResolvable;
    set anonymousConnectionsEnabled(value: boolean | cdktf.IResolvable);
    resetAnonymousConnectionsEnabled(): void;
    get anonymousConnectionsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _webPubsubId?;
    get webPubsubId(): string;
    set webPubsubId(value: string);
    get webPubsubIdInput(): string | undefined;
    private _eventHandler?;
    get eventHandler(): WebPubsubHubEventHandler[] | cdktf.IResolvable;
    set eventHandler(value: WebPubsubHubEventHandler[] | cdktf.IResolvable);
    get eventHandlerInput(): cdktf.IResolvable | WebPubsubHubEventHandler[] | undefined;
    private _timeouts;
    get timeouts(): WebPubsubHubTimeoutsOutputReference;
    putTimeouts(value: WebPubsubHubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): WebPubsubHubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
