"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsAppSpec = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents an AppSpec to be used for ECS services.
 *
 * see: https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-resources.html#reference-appspec-file-structure-resources-ecs
 */
class EcsAppSpec {
    constructor(targetService) {
        this.targetService = targetService;
    }
    /**
     * Render JSON string for this AppSpec to be used
     *
     * @returns string representation of this AppSpec
     */
    toString() {
        const appSpec = {
            version: '0.0',
            Resources: [{
                    TargetService: {
                        Type: 'AWS::ECS::Service',
                        Properties: {
                            TaskDefinition: this.targetService.taskDefinition.taskDefinitionArn,
                            LoadBalancerInfo: {
                                ContainerName: this.targetService.containerName,
                                ContainerPort: this.targetService.containerPort,
                            },
                            PlatformVersion: this.targetService.platformVersion,
                            NetworkConfiguration: this.configureAwsVpcNetworkingWithSecurityGroups(this.targetService.awsvpcConfiguration),
                            CapacityProviderStrategy: this.targetService.capacityProviderStrategy?.map(capacityProviderStrategy => {
                                return {
                                    Base: capacityProviderStrategy.base,
                                    CapacityProvider: capacityProviderStrategy.capacityProvider,
                                    Weight: capacityProviderStrategy.weight,
                                };
                            }),
                        },
                    },
                }],
        };
        return JSON.stringify(appSpec);
    }
    configureAwsVpcNetworkingWithSecurityGroups(awsvpcConfiguration) {
        if (!awsvpcConfiguration) {
            return undefined;
        }
        return {
            awsvpcConfiguration: {
                assignPublicIp: awsvpcConfiguration.assignPublicIp ? 'ENABLED' : 'DISABLED',
                subnets: awsvpcConfiguration.vpc.selectSubnets(awsvpcConfiguration.vpcSubnets).subnetIds,
                securityGroups: awsvpcConfiguration.securityGroups?.map((sg) => sg.securityGroupId),
            },
        };
    }
}
exports.EcsAppSpec = EcsAppSpec;
_a = JSII_RTTI_SYMBOL_1;
EcsAppSpec[_a] = { fqn: "@cdklabs/cdk-ecs-codedeploy.EcsAppSpec", version: "0.0.50" };
//# sourceMappingURL=data:application/json;base64,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