# coding: utf-8

"""
    Publisher APIs

    API that is implemented under Agents Events Publisher service

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ApiV1WorkItemsCompleteStagePostRequest(BaseModel):
    """
    ApiV1WorkItemsCompleteStagePostRequest
    """ # noqa: E501
    tenant_id: StrictStr = Field(description="The UUID of the tenant.")
    work_item_id: StrictStr = Field(description="The UUID of the work item.")
    status: StrictStr = Field(description="The status indicating if the current stage completion was successful or failed.")
    status_reason: Optional[StrictStr] = Field(default=None, description="The reason for the failure or additional context for success.")
    log_details_path: Optional[StrictStr] = Field(default=None, description="Detailed trace information for debugging purposes. Typically a large string capturing the error stack trace or relevant logs.")
    __properties: ClassVar[List[str]] = ["tenant_id", "work_item_id", "status", "status_reason", "log_details_path"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SUCCESS', 'FAILURE']):
            raise ValueError("must be one of enum values ('SUCCESS', 'FAILURE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiV1WorkItemsCompleteStagePostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiV1WorkItemsCompleteStagePostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tenant_id": obj.get("tenant_id"),
            "work_item_id": obj.get("work_item_id"),
            "status": obj.get("status"),
            "status_reason": obj.get("status_reason"),
            "log_details_path": obj.get("log_details_path")
        })
        return _obj


