# coding: utf-8

"""
    Document Intelligence API

    Data APIs to retrieve document intelligence data

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from sema4ai.di_client.document_intelligence_client.models.doc_type_tbl_fields_inner import DocTypeTblFieldsInner
from sema4ai.di_client.document_intelligence_client.models.document_processing_workflow import DocumentProcessingWorkflow
from sema4ai.di_client.document_intelligence_client.models.document_type_configuration_non_tbl_fields_inner import DocumentTypeConfigurationNonTblFieldsInner
from typing import Optional, Set
from typing_extensions import Self

class DocType(BaseModel):
    """
    DocType
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="The name of the document type")
    file_format: Optional[StrictStr] = Field(default=None, description="The file format of the document")
    source_location: Optional[StrictStr] = Field(default=None, description="The S3 location of the document.")
    description: Optional[StrictStr] = Field(default=None, description="A brief description of the document Type or use case.")
    validation_expressions: Optional[List[StrictStr]] = Field(default=None, description="List of validation expressions for the document.")
    non_tbl_fields: Optional[List[DocumentTypeConfigurationNonTblFieldsInner]] = Field(default=None, description="List of fields relevant to the document.")
    tbl_fields: Optional[List[DocTypeTblFieldsInner]] = Field(default=None, description="List of tables related to the document.")
    config: Optional[List[StrictStr]] = Field(default=None, description="List of custom config keys for the doc type")
    created_timestamp: Optional[datetime] = None
    updated_timestamp: Optional[datetime] = None
    processing_workflow: Optional[List[DocumentProcessingWorkflow]] = Field(default=None, description="The workflow stages for processing this document type.")
    __properties: ClassVar[List[str]] = ["name", "file_format", "source_location", "description", "validation_expressions", "non_tbl_fields", "tbl_fields", "config", "created_timestamp", "updated_timestamp", "processing_workflow"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in non_tbl_fields (list)
        _items = []
        if self.non_tbl_fields:
            for _item_non_tbl_fields in self.non_tbl_fields:
                if _item_non_tbl_fields:
                    _items.append(_item_non_tbl_fields.to_dict())
            _dict['non_tbl_fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tbl_fields (list)
        _items = []
        if self.tbl_fields:
            for _item_tbl_fields in self.tbl_fields:
                if _item_tbl_fields:
                    _items.append(_item_tbl_fields.to_dict())
            _dict['tbl_fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in processing_workflow (list)
        _items = []
        if self.processing_workflow:
            for _item_processing_workflow in self.processing_workflow:
                if _item_processing_workflow:
                    _items.append(_item_processing_workflow.to_dict())
            _dict['processing_workflow'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "file_format": obj.get("file_format"),
            "source_location": obj.get("source_location"),
            "description": obj.get("description"),
            "validation_expressions": obj.get("validation_expressions"),
            "non_tbl_fields": [DocumentTypeConfigurationNonTblFieldsInner.from_dict(_item) for _item in obj["non_tbl_fields"]] if obj.get("non_tbl_fields") is not None else None,
            "tbl_fields": [DocTypeTblFieldsInner.from_dict(_item) for _item in obj["tbl_fields"]] if obj.get("tbl_fields") is not None else None,
            "config": obj.get("config"),
            "created_timestamp": obj.get("created_timestamp"),
            "updated_timestamp": obj.get("updated_timestamp"),
            "processing_workflow": [DocumentProcessingWorkflow.from_dict(_item) for _item in obj["processing_workflow"]] if obj.get("processing_workflow") is not None else None
        })
        return _obj


