# coding: utf-8

"""
    Document Intelligence API

    Data APIs to retrieve document intelligence data

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from sema4ai.di_client.document_intelligence_client.models.document_type_configuration_tbl_fields_inner_table_definition_inner import DocumentTypeConfigurationTblFieldsInnerTableDefinitionInner
from typing import Optional, Set
from typing_extensions import Self

class DocTypeTblFieldsInner(BaseModel):
    """
    DocTypeTblFieldsInner
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the table.")
    description: StrictStr = Field(description="A brief description of the table.")
    id: StrictStr = Field(description="The ID of the table.")
    table_definition: List[DocumentTypeConfigurationTblFieldsInnerTableDefinitionInner] = Field(description="Definition of the table columns.")
    __properties: ClassVar[List[str]] = ["name", "description", "id", "table_definition"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocTypeTblFieldsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in table_definition (list)
        _items = []
        if self.table_definition:
            for _item_table_definition in self.table_definition:
                if _item_table_definition:
                    _items.append(_item_table_definition.to_dict())
            _dict['table_definition'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocTypeTblFieldsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "table_definition": [DocumentTypeConfigurationTblFieldsInnerTableDefinitionInner.from_dict(_item) for _item in obj["table_definition"]] if obj.get("table_definition") is not None else None
        })
        return _obj


