# coding: utf-8

"""
    Document Intelligence API

    Data APIs to retrieve document intelligence data

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from sema4ai.di_client.document_intelligence_client.models.document_class_non_tbl_fields_mapping_inner import DocumentClassNonTblFieldsMappingInner
from sema4ai.di_client.document_intelligence_client.models.document_class_state import DocumentClassState
from sema4ai.di_client.document_intelligence_client.models.document_class_tables_inner import DocumentClassTablesInner
from typing import Optional, Set
from typing_extensions import Self

class DocumentClass(BaseModel):
    """
    DocumentClass
    """ # noqa: E501
    document_type_name: Optional[StrictStr] = Field(default=None, description="The document type name.")
    document_class_name: StrictStr = Field(description="The name of the document class.")
    non_tbl_fields_mapping: List[DocumentClassNonTblFieldsMappingInner] = Field(description="List of fields relevant to the document.")
    tables: List[DocumentClassTablesInner] = Field(description="List of tables relevant to the document")
    prompt_examples: StrictStr = Field(description="The prompt example for the document class")
    prompt_instructions: StrictStr = Field(description="The prompt instruction for the document class")
    custom_config: Dict[str, Any] = Field(description="The custom config for the document format")
    state: Optional[DocumentClassState] = None
    __properties: ClassVar[List[str]] = ["document_type_name", "document_class_name", "non_tbl_fields_mapping", "tables", "prompt_examples", "prompt_instructions", "custom_config", "state"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentClass from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in non_tbl_fields_mapping (list)
        _items = []
        if self.non_tbl_fields_mapping:
            for _item_non_tbl_fields_mapping in self.non_tbl_fields_mapping:
                if _item_non_tbl_fields_mapping:
                    _items.append(_item_non_tbl_fields_mapping.to_dict())
            _dict['non_tbl_fields_mapping'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tables (list)
        _items = []
        if self.tables:
            for _item_tables in self.tables:
                if _item_tables:
                    _items.append(_item_tables.to_dict())
            _dict['tables'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentClass from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "document_type_name": obj.get("document_type_name"),
            "document_class_name": obj.get("document_class_name"),
            "non_tbl_fields_mapping": [DocumentClassNonTblFieldsMappingInner.from_dict(_item) for _item in obj["non_tbl_fields_mapping"]] if obj.get("non_tbl_fields_mapping") is not None else None,
            "tables": [DocumentClassTablesInner.from_dict(_item) for _item in obj["tables"]] if obj.get("tables") is not None else None,
            "prompt_examples": obj.get("prompt_examples"),
            "prompt_instructions": obj.get("prompt_instructions"),
            "custom_config": obj.get("custom_config"),
            "state": obj.get("state")
        })
        return _obj


