# coding: utf-8

"""
    Document Intelligence API

    Data APIs to retrieve document intelligence data

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from sema4ai.di_client.document_intelligence_client.models.document_class_tables_inner_tbl_fields_mapping_inner import DocumentClassTablesInnerTblFieldsMappingInner
from typing import Optional, Set
from typing_extensions import Self

class DocumentClassTablesInner(BaseModel):
    """
    DocumentClassTablesInner
    """ # noqa: E501
    tbl_fields_mapping: List[DocumentClassTablesInnerTblFieldsMappingInner] = Field(description="List of table fields mapping relevant to the table in the document")
    __properties: ClassVar[List[str]] = ["tbl_fields_mapping"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentClassTablesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tbl_fields_mapping (list)
        _items = []
        if self.tbl_fields_mapping:
            for _item_tbl_fields_mapping in self.tbl_fields_mapping:
                if _item_tbl_fields_mapping:
                    _items.append(_item_tbl_fields_mapping.to_dict())
            _dict['tbl_fields_mapping'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentClassTablesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tbl_fields_mapping": [DocumentClassTablesInnerTblFieldsMappingInner.from_dict(_item) for _item in obj["tbl_fields_mapping"]] if obj.get("tbl_fields_mapping") is not None else None
        })
        return _obj


