# coding: utf-8

"""
    Document Intelligence API

    Data APIs to retrieve document intelligence data

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from sema4ai.di_client.document_intelligence_client.models.content_state import ContentState
from sema4ai.di_client.document_intelligence_client.models.processing_status import ProcessingStatus
from sema4ai.di_client.document_intelligence_client.models.source_document import SourceDocument
from typing import Optional, Set
from typing_extensions import Self

class DocumentWorkItem(BaseModel):
    """
    DocumentWorkItem
    """ # noqa: E501
    source_document: Optional[SourceDocument] = None
    current_content: Optional[ContentState] = None
    processing_status: Optional[ProcessingStatus] = None
    retry_count: Optional[StrictInt] = None
    last_run: Optional[datetime] = None
    workspace_id: Optional[StrictStr] = None
    non_tbl_data: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["source_document", "current_content", "processing_status", "retry_count", "last_run", "workspace_id", "non_tbl_data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentWorkItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source_document
        if self.source_document:
            _dict['source_document'] = self.source_document.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentWorkItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "source_document": SourceDocument.from_dict(obj["source_document"]) if obj.get("source_document") is not None else None,
            "current_content": obj.get("current_content"),
            "processing_status": obj.get("processing_status"),
            "retry_count": obj.get("retry_count"),
            "last_run": obj.get("last_run"),
            "workspace_id": obj.get("workspace_id"),
            "non_tbl_data": obj.get("non_tbl_data")
        })
        return _obj


