# coding: utf-8

"""
    Document Intelligence API

    Data APIs to retrieve document intelligence data

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DocumentWorkItems(BaseModel):
    """
    Document work item details
    """ # noqa: E501
    document_id: StrictStr = Field(description="The document ID")
    document_name: StrictStr = Field(description="The simple name of the document file")
    state: StrictStr = Field(description="The current state of the document work item")
    created_date: Optional[datetime] = Field(default=None, description="The timestamp the document was added for processing")
    last_run_date: Optional[datetime] = Field(default=None, description="The timestamp the document was last processed")
    counter_party: StrictStr = Field(description="The counterparty name")
    document_type_name: Optional[StrictStr] = Field(default=None, description="The name of the document type")
    document_format_state: Optional[StrictStr] = Field(default=None, description="The state of the document format")
    workspace_id: StrictStr = Field(description="The workspace ID")
    fields: Optional[Dict[str, Any]] = Field(default=None, description="The special fields extracted from the document as key value pairs in json format")
    __properties: ClassVar[List[str]] = ["document_id", "document_name", "state", "created_date", "last_run_date", "counter_party", "document_type_name", "document_format_state", "workspace_id", "fields"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['New', 'Queued', 'Extraction In Process', 'Extraction Completed', 'Extraction Failed', 'Validation In Process', 'Validation Completed', 'Validation Failed', 'Needs Training']):
            raise ValueError("must be one of enum values ('New', 'Queued', 'Extraction In Process', 'Extraction Completed', 'Extraction Failed', 'Validation In Process', 'Validation Completed', 'Validation Failed', 'Needs Training')")
        return value

    @field_validator('document_format_state')
    def document_format_state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Inactive', 'Active', 'In Training']):
            raise ValueError("must be one of enum values ('Inactive', 'Active', 'In Training')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentWorkItems from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentWorkItems from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "document_id": obj.get("document_id"),
            "document_name": obj.get("document_name"),
            "state": obj.get("state"),
            "created_date": obj.get("created_date"),
            "last_run_date": obj.get("last_run_date"),
            "counter_party": obj.get("counter_party"),
            "document_type_name": obj.get("document_type_name"),
            "document_format_state": obj.get("document_format_state"),
            "workspace_id": obj.get("workspace_id"),
            "fields": obj.get("fields")
        })
        return _obj


