# coding: utf-8

"""
    Document Intelligence API

    Data APIs to retrieve document intelligence data

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from sema4ai.di_client.document_intelligence_client.models.computed_document_content import ComputedDocumentContent
from sema4ai.di_client.document_intelligence_client.models.extracted_document_content import ExtractedDocumentContent
from sema4ai.di_client.document_intelligence_client.models.raw_document_content import RawDocumentContent
from sema4ai.di_client.document_intelligence_client.models.transformed_document_content import TransformedDocumentContent
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

GETDOCUMENTCONTENT200RESPONSE_ONE_OF_SCHEMAS = ["ComputedDocumentContent", "ExtractedDocumentContent", "RawDocumentContent", "TransformedDocumentContent"]

class GetDocumentContent200Response(BaseModel):
    """
    GetDocumentContent200Response
    """
    # data type: RawDocumentContent
    oneof_schema_1_validator: Optional[RawDocumentContent] = None
    # data type: ExtractedDocumentContent
    oneof_schema_2_validator: Optional[ExtractedDocumentContent] = None
    # data type: TransformedDocumentContent
    oneof_schema_3_validator: Optional[TransformedDocumentContent] = None
    # data type: ComputedDocumentContent
    oneof_schema_4_validator: Optional[ComputedDocumentContent] = None
    actual_instance: Optional[Union[ComputedDocumentContent, ExtractedDocumentContent, RawDocumentContent, TransformedDocumentContent]] = None
    one_of_schemas: Set[str] = { "ComputedDocumentContent", "ExtractedDocumentContent", "RawDocumentContent", "TransformedDocumentContent" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = GetDocumentContent200Response.model_construct()
        error_messages = []
        match = 0
        # validate data type: RawDocumentContent
        if not isinstance(v, RawDocumentContent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RawDocumentContent`")
        else:
            match += 1
        # validate data type: ExtractedDocumentContent
        if not isinstance(v, ExtractedDocumentContent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ExtractedDocumentContent`")
        else:
            match += 1
        # validate data type: TransformedDocumentContent
        if not isinstance(v, TransformedDocumentContent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TransformedDocumentContent`")
        else:
            match += 1
        # validate data type: ComputedDocumentContent
        if not isinstance(v, ComputedDocumentContent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ComputedDocumentContent`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in GetDocumentContent200Response with oneOf schemas: ComputedDocumentContent, ExtractedDocumentContent, RawDocumentContent, TransformedDocumentContent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in GetDocumentContent200Response with oneOf schemas: ComputedDocumentContent, ExtractedDocumentContent, RawDocumentContent, TransformedDocumentContent. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into RawDocumentContent
        try:
            instance.actual_instance = RawDocumentContent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ExtractedDocumentContent
        try:
            instance.actual_instance = ExtractedDocumentContent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TransformedDocumentContent
        try:
            instance.actual_instance = TransformedDocumentContent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ComputedDocumentContent
        try:
            instance.actual_instance = ComputedDocumentContent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into GetDocumentContent200Response with oneOf schemas: ComputedDocumentContent, ExtractedDocumentContent, RawDocumentContent, TransformedDocumentContent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into GetDocumentContent200Response with oneOf schemas: ComputedDocumentContent, ExtractedDocumentContent, RawDocumentContent, TransformedDocumentContent. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ComputedDocumentContent, ExtractedDocumentContent, RawDocumentContent, TransformedDocumentContent]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


