# coding: utf-8

"""
    Document Intelligence API

    Data APIs to retrieve document intelligence data

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from sema4ai.di_client.document_intelligence_client.models.doc_type import DocType
from sema4ai.di_client.document_intelligence_client.models.document_format import DocumentFormat
from typing import Optional, Set
from typing_extensions import Self

class SourceDocument(BaseModel):
    """
    SourceDocument
    """ # noqa: E501
    document_id: Optional[StrictStr] = None
    document_name: Optional[StrictStr] = None
    document_src_path: Optional[StrictStr] = None
    document_type: Optional[DocType] = None
    document_format: Optional[DocumentFormat] = None
    doc_size: Optional[StrictInt] = None
    pages: Optional[StrictInt] = None
    created_date: Optional[datetime] = None
    content_type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["document_id", "document_name", "document_src_path", "document_type", "document_format", "doc_size", "pages", "created_date", "content_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SourceDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of document_type
        if self.document_type:
            _dict['document_type'] = self.document_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of document_format
        if self.document_format:
            _dict['document_format'] = self.document_format.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SourceDocument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "document_id": obj.get("document_id"),
            "document_name": obj.get("document_name"),
            "document_src_path": obj.get("document_src_path"),
            "document_type": DocType.from_dict(obj["document_type"]) if obj.get("document_type") is not None else None,
            "document_format": DocumentFormat.from_dict(obj["document_format"]) if obj.get("document_format") is not None else None,
            "doc_size": obj.get("doc_size"),
            "pages": obj.get("pages"),
            "created_date": obj.get("created_date"),
            "content_type": obj.get("content_type")
        })
        return _obj


