# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TacacsProfileArgs', 'TacacsProfile']

@pulumi.input_type
class TacacsProfileArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 session_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['TacacsProfileSessionAttributeArgs']]]] = None):
        """
        The set of arguments for constructing a TacacsProfile resource.
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] name: The name of the TACACS profile
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if session_attributes is not None:
            pulumi.set(__self__, "session_attributes", session_attributes)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the TACACS profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sessionAttributes")
    def session_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TacacsProfileSessionAttributeArgs']]]]:
        return pulumi.get(self, "session_attributes")

    @session_attributes.setter
    def session_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TacacsProfileSessionAttributeArgs']]]]):
        pulumi.set(self, "session_attributes", value)


@pulumi.input_type
class _TacacsProfileState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 session_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['TacacsProfileSessionAttributeArgs']]]] = None):
        """
        Input properties used for looking up and filtering TacacsProfile resources.
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] name: The name of the TACACS profile
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if session_attributes is not None:
            pulumi.set(__self__, "session_attributes", session_attributes)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the TACACS profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sessionAttributes")
    def session_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TacacsProfileSessionAttributeArgs']]]]:
        return pulumi.get(self, "session_attributes")

    @session_attributes.setter
    def session_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TacacsProfileSessionAttributeArgs']]]]):
        pulumi.set(self, "session_attributes", value)


@pulumi.type_token("ise:deviceadmin/tacacsProfile:TacacsProfile")
class TacacsProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 session_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TacacsProfileSessionAttributeArgs', 'TacacsProfileSessionAttributeArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a TACACS Profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.TacacsProfile("example",
            name="Profile1",
            description="My TACACS profile",
            session_attributes=[{
                "type": "MANDATORY",
                "name": "attr1",
                "value": "value",
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:deviceadmin/tacacsProfile:TacacsProfile example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] name: The name of the TACACS profile
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TacacsProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a TACACS Profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.TacacsProfile("example",
            name="Profile1",
            description="My TACACS profile",
            session_attributes=[{
                "type": "MANDATORY",
                "name": "attr1",
                "value": "value",
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:deviceadmin/tacacsProfile:TacacsProfile example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param TacacsProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TacacsProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 session_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TacacsProfileSessionAttributeArgs', 'TacacsProfileSessionAttributeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TacacsProfileArgs.__new__(TacacsProfileArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["session_attributes"] = session_attributes
        super(TacacsProfile, __self__).__init__(
            'ise:deviceadmin/tacacsProfile:TacacsProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            session_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TacacsProfileSessionAttributeArgs', 'TacacsProfileSessionAttributeArgsDict']]]]] = None) -> 'TacacsProfile':
        """
        Get an existing TacacsProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] name: The name of the TACACS profile
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TacacsProfileState.__new__(_TacacsProfileState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["session_attributes"] = session_attributes
        return TacacsProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the TACACS profile
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sessionAttributes")
    def session_attributes(self) -> pulumi.Output[Optional[Sequence['outputs.TacacsProfileSessionAttribute']]]:
        return pulumi.get(self, "session_attributes")

