# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EndpointCustomAttributeArgs', 'EndpointCustomAttribute']

@pulumi.input_type
class EndpointCustomAttributeArgs:
    def __init__(__self__, *,
                 attribute_name: pulumi.Input[builtins.str],
                 attribute_type: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a EndpointCustomAttribute resource.
        :param pulumi.Input[builtins.str] attribute_name: The name of the attribute
        :param pulumi.Input[builtins.str] attribute_type: Attribute type - Choices: `Boolean`, `Date`, `Float`, `IP`, `Int`, `Long`, `String`
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "attribute_type", attribute_type)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the attribute
        """
        return pulumi.get(self, "attribute_name")

    @attribute_name.setter
    def attribute_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attribute_name", value)

    @property
    @pulumi.getter(name="attributeType")
    def attribute_type(self) -> pulumi.Input[builtins.str]:
        """
        Attribute type - Choices: `Boolean`, `Date`, `Float`, `IP`, `Int`, `Long`, `String`
        """
        return pulumi.get(self, "attribute_type")

    @attribute_type.setter
    def attribute_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attribute_type", value)


@pulumi.input_type
class _EndpointCustomAttributeState:
    def __init__(__self__, *,
                 attribute_name: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EndpointCustomAttribute resources.
        :param pulumi.Input[builtins.str] attribute_name: The name of the attribute
        :param pulumi.Input[builtins.str] attribute_type: Attribute type - Choices: `Boolean`, `Date`, `Float`, `IP`, `Int`, `Long`, `String`
        """
        if attribute_name is not None:
            pulumi.set(__self__, "attribute_name", attribute_name)
        if attribute_type is not None:
            pulumi.set(__self__, "attribute_type", attribute_type)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the attribute
        """
        return pulumi.get(self, "attribute_name")

    @attribute_name.setter
    def attribute_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attribute_name", value)

    @property
    @pulumi.getter(name="attributeType")
    def attribute_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Attribute type - Choices: `Boolean`, `Date`, `Float`, `IP`, `Int`, `Long`, `String`
        """
        return pulumi.get(self, "attribute_type")

    @attribute_type.setter
    def attribute_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attribute_type", value)


@pulumi.type_token("ise:identitymanagement/endpointCustomAttribute:EndpointCustomAttribute")
class EndpointCustomAttribute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_name: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage an Endpoint Custom Attribute.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.identitymanagement.EndpointCustomAttribute("example",
            attribute_name="isMobile",
            attribute_type="Boolean")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:identitymanagement/endpointCustomAttribute:EndpointCustomAttribute example "isMobile"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attribute_name: The name of the attribute
        :param pulumi.Input[builtins.str] attribute_type: Attribute type - Choices: `Boolean`, `Date`, `Float`, `IP`, `Int`, `Long`, `String`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointCustomAttributeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage an Endpoint Custom Attribute.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.identitymanagement.EndpointCustomAttribute("example",
            attribute_name="isMobile",
            attribute_type="Boolean")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:identitymanagement/endpointCustomAttribute:EndpointCustomAttribute example "isMobile"
        ```

        :param str resource_name: The name of the resource.
        :param EndpointCustomAttributeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointCustomAttributeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_name: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointCustomAttributeArgs.__new__(EndpointCustomAttributeArgs)

            if attribute_name is None and not opts.urn:
                raise TypeError("Missing required property 'attribute_name'")
            __props__.__dict__["attribute_name"] = attribute_name
            if attribute_type is None and not opts.urn:
                raise TypeError("Missing required property 'attribute_type'")
            __props__.__dict__["attribute_type"] = attribute_type
        super(EndpointCustomAttribute, __self__).__init__(
            'ise:identitymanagement/endpointCustomAttribute:EndpointCustomAttribute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attribute_name: Optional[pulumi.Input[builtins.str]] = None,
            attribute_type: Optional[pulumi.Input[builtins.str]] = None) -> 'EndpointCustomAttribute':
        """
        Get an existing EndpointCustomAttribute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attribute_name: The name of the attribute
        :param pulumi.Input[builtins.str] attribute_type: Attribute type - Choices: `Boolean`, `Date`, `Float`, `IP`, `Int`, `Long`, `String`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointCustomAttributeState.__new__(_EndpointCustomAttributeState)

        __props__.__dict__["attribute_name"] = attribute_name
        __props__.__dict__["attribute_type"] = attribute_type
        return EndpointCustomAttribute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the attribute
        """
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="attributeType")
    def attribute_type(self) -> pulumi.Output[builtins.str]:
        """
        Attribute type - Choices: `Boolean`, `Date`, `Float`, `IP`, `Int`, `Long`, `String`
        """
        return pulumi.get(self, "attribute_type")

