# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeviceArgs', 'Device']

@pulumi.input_type
class DeviceArgs:
    def __init__(__self__, *,
                 ips: pulumi.Input[Sequence[pulumi.Input['DeviceIpArgs']]],
                 authentication_dtls_required: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_enable_key_wrap: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_enable_multi_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_encryption_key: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_encryption_key_format: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_message_authenticator_code_key: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_network_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_radius_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_second_radius_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 coa_port: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dtls_dns_name: Optional[pulumi.Input[builtins.str]] = None,
                 model_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_device_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_link_trap_query: Optional[pulumi.Input[builtins.bool]] = None,
                 snmp_mac_trap_query: Optional[pulumi.Input[builtins.bool]] = None,
                 snmp_originating_policy_service_node: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_polling_interval: Optional[pulumi.Input[builtins.int]] = None,
                 snmp_ro_community: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_version: Optional[pulumi.Input[builtins.str]] = None,
                 software_version: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_connect_mode_options: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_coa_source_host: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_device_id: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_device_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_download_environment_data_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_download_peer_authorization_policy_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_download_sgacl_lists_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_enable_mode_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_exec_mode_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_exec_mode_username: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_include_when_deploying_sgt_updates: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_other_sga_devices_to_trust_this_device: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_re_authentication_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_rest_api_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_rest_api_username: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_send_configuration_to_device: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_send_configuration_to_device_using: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Device resource.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceIpArgs']]] ips: List of IP subnets
        :param pulumi.Input[builtins.bool] authentication_dtls_required: Enforce use of DTLS
        :param pulumi.Input[builtins.bool] authentication_enable_key_wrap: Enable key wrap
        :param pulumi.Input[builtins.bool] authentication_enable_multi_secret: Enable multiple RADIUS shared secrets
        :param pulumi.Input[builtins.str] authentication_encryption_key: Encryption key
        :param pulumi.Input[builtins.str] authentication_encryption_key_format: Key input format - Choices: `ASCII`, `HEXADECIMAL`
        :param pulumi.Input[builtins.str] authentication_message_authenticator_code_key: Message authenticator code key
        :param pulumi.Input[builtins.str] authentication_network_protocol: Network protocol - Choices: `RADIUS`, `TACACS_PLUS`
        :param pulumi.Input[builtins.str] authentication_radius_shared_secret: RADIUS shared secret
        :param pulumi.Input[builtins.str] authentication_second_radius_shared_secret: Second RADIUS shared secret
        :param pulumi.Input[builtins.int] coa_port: CoA port - Default value: `1700`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] dtls_dns_name: This value is used to verify the client identity contained in the X.509 RADIUS/DTLS client certificate
        :param pulumi.Input[builtins.str] model_name: Model name
        :param pulumi.Input[builtins.str] name: The name of the network device
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_device_groups: List of network device groups, e.g. `Device Type#All Device Types#ACCESS`
        :param pulumi.Input[builtins.str] profile_name: Profile name - Default value: `Cisco`
        :param pulumi.Input[builtins.bool] snmp_link_trap_query: SNMP link Trap Query
        :param pulumi.Input[builtins.bool] snmp_mac_trap_query: SNMP MAC Trap Query
        :param pulumi.Input[builtins.str] snmp_originating_policy_service_node: Originating Policy Services Node
        :param pulumi.Input[builtins.int] snmp_polling_interval: SNMP Polling Interval in seconds - Range: `600`-`86400`
        :param pulumi.Input[builtins.str] snmp_ro_community: SNMP RO Community
        :param pulumi.Input[builtins.str] snmp_version: SNMP version - Choices: `ONE`, `TWO_C`, `THREE`
        :param pulumi.Input[builtins.str] software_version: Software version
        :param pulumi.Input[builtins.str] tacacs_connect_mode_options: Connect mode options - Choices: `OFF`, `ON_LEGACY`, `ON_DRAFT_COMPLIANT`
        :param pulumi.Input[builtins.str] tacacs_shared_secret: Shared secret
        :param pulumi.Input[builtins.str] trustsec_coa_source_host: CoA source host
        :param pulumi.Input[builtins.str] trustsec_device_id: TrustSec device ID
        :param pulumi.Input[builtins.str] trustsec_device_password: TrustSec device password
        :param pulumi.Input[builtins.int] trustsec_download_environment_data_every_x_seconds: Download environment data every X seconds
        :param pulumi.Input[builtins.int] trustsec_download_peer_authorization_policy_every_x_seconds: Download peer authorization policy every X seconds
        :param pulumi.Input[builtins.int] trustsec_download_sgacl_lists_every_x_seconds: Download SGACL lists every X seconds
        :param pulumi.Input[builtins.str] trustsec_enable_mode_password: Enable mode password
        :param pulumi.Input[builtins.str] trustsec_exec_mode_password: EXEC mode password
        :param pulumi.Input[builtins.str] trustsec_exec_mode_username: EXEC mode username
        :param pulumi.Input[builtins.bool] trustsec_include_when_deploying_sgt_updates: Include this device when deploying Security Group Tag Mapping Updates
        :param pulumi.Input[builtins.bool] trustsec_other_sga_devices_to_trust_this_device: Other TrustSec devices to trust this device
        :param pulumi.Input[builtins.int] trustsec_re_authentication_every_x_seconds: Re-authenticate every X seconds
        :param pulumi.Input[builtins.str] trustsec_rest_api_password: REST API password
        :param pulumi.Input[builtins.str] trustsec_rest_api_username: REST API username
        :param pulumi.Input[builtins.bool] trustsec_send_configuration_to_device: Send configuration to device
        :param pulumi.Input[builtins.str] trustsec_send_configuration_to_device_using: Send configuration to device using - Choices: `DISABLE_ALL`, `ENABLE_USING_CLI`, `ENABLE_USING_COA`
        """
        pulumi.set(__self__, "ips", ips)
        if authentication_dtls_required is not None:
            pulumi.set(__self__, "authentication_dtls_required", authentication_dtls_required)
        if authentication_enable_key_wrap is not None:
            pulumi.set(__self__, "authentication_enable_key_wrap", authentication_enable_key_wrap)
        if authentication_enable_multi_secret is not None:
            pulumi.set(__self__, "authentication_enable_multi_secret", authentication_enable_multi_secret)
        if authentication_encryption_key is not None:
            pulumi.set(__self__, "authentication_encryption_key", authentication_encryption_key)
        if authentication_encryption_key_format is not None:
            pulumi.set(__self__, "authentication_encryption_key_format", authentication_encryption_key_format)
        if authentication_message_authenticator_code_key is not None:
            pulumi.set(__self__, "authentication_message_authenticator_code_key", authentication_message_authenticator_code_key)
        if authentication_network_protocol is not None:
            pulumi.set(__self__, "authentication_network_protocol", authentication_network_protocol)
        if authentication_radius_shared_secret is not None:
            pulumi.set(__self__, "authentication_radius_shared_secret", authentication_radius_shared_secret)
        if authentication_second_radius_shared_secret is not None:
            pulumi.set(__self__, "authentication_second_radius_shared_secret", authentication_second_radius_shared_secret)
        if coa_port is not None:
            pulumi.set(__self__, "coa_port", coa_port)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dtls_dns_name is not None:
            pulumi.set(__self__, "dtls_dns_name", dtls_dns_name)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_device_groups is not None:
            pulumi.set(__self__, "network_device_groups", network_device_groups)
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if snmp_link_trap_query is not None:
            pulumi.set(__self__, "snmp_link_trap_query", snmp_link_trap_query)
        if snmp_mac_trap_query is not None:
            pulumi.set(__self__, "snmp_mac_trap_query", snmp_mac_trap_query)
        if snmp_originating_policy_service_node is not None:
            pulumi.set(__self__, "snmp_originating_policy_service_node", snmp_originating_policy_service_node)
        if snmp_polling_interval is not None:
            pulumi.set(__self__, "snmp_polling_interval", snmp_polling_interval)
        if snmp_ro_community is not None:
            pulumi.set(__self__, "snmp_ro_community", snmp_ro_community)
        if snmp_version is not None:
            pulumi.set(__self__, "snmp_version", snmp_version)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if tacacs_connect_mode_options is not None:
            pulumi.set(__self__, "tacacs_connect_mode_options", tacacs_connect_mode_options)
        if tacacs_shared_secret is not None:
            pulumi.set(__self__, "tacacs_shared_secret", tacacs_shared_secret)
        if trustsec_coa_source_host is not None:
            pulumi.set(__self__, "trustsec_coa_source_host", trustsec_coa_source_host)
        if trustsec_device_id is not None:
            pulumi.set(__self__, "trustsec_device_id", trustsec_device_id)
        if trustsec_device_password is not None:
            pulumi.set(__self__, "trustsec_device_password", trustsec_device_password)
        if trustsec_download_environment_data_every_x_seconds is not None:
            pulumi.set(__self__, "trustsec_download_environment_data_every_x_seconds", trustsec_download_environment_data_every_x_seconds)
        if trustsec_download_peer_authorization_policy_every_x_seconds is not None:
            pulumi.set(__self__, "trustsec_download_peer_authorization_policy_every_x_seconds", trustsec_download_peer_authorization_policy_every_x_seconds)
        if trustsec_download_sgacl_lists_every_x_seconds is not None:
            pulumi.set(__self__, "trustsec_download_sgacl_lists_every_x_seconds", trustsec_download_sgacl_lists_every_x_seconds)
        if trustsec_enable_mode_password is not None:
            pulumi.set(__self__, "trustsec_enable_mode_password", trustsec_enable_mode_password)
        if trustsec_exec_mode_password is not None:
            pulumi.set(__self__, "trustsec_exec_mode_password", trustsec_exec_mode_password)
        if trustsec_exec_mode_username is not None:
            pulumi.set(__self__, "trustsec_exec_mode_username", trustsec_exec_mode_username)
        if trustsec_include_when_deploying_sgt_updates is not None:
            pulumi.set(__self__, "trustsec_include_when_deploying_sgt_updates", trustsec_include_when_deploying_sgt_updates)
        if trustsec_other_sga_devices_to_trust_this_device is not None:
            pulumi.set(__self__, "trustsec_other_sga_devices_to_trust_this_device", trustsec_other_sga_devices_to_trust_this_device)
        if trustsec_re_authentication_every_x_seconds is not None:
            pulumi.set(__self__, "trustsec_re_authentication_every_x_seconds", trustsec_re_authentication_every_x_seconds)
        if trustsec_rest_api_password is not None:
            pulumi.set(__self__, "trustsec_rest_api_password", trustsec_rest_api_password)
        if trustsec_rest_api_username is not None:
            pulumi.set(__self__, "trustsec_rest_api_username", trustsec_rest_api_username)
        if trustsec_send_configuration_to_device is not None:
            pulumi.set(__self__, "trustsec_send_configuration_to_device", trustsec_send_configuration_to_device)
        if trustsec_send_configuration_to_device_using is not None:
            pulumi.set(__self__, "trustsec_send_configuration_to_device_using", trustsec_send_configuration_to_device_using)

    @property
    @pulumi.getter
    def ips(self) -> pulumi.Input[Sequence[pulumi.Input['DeviceIpArgs']]]:
        """
        List of IP subnets
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: pulumi.Input[Sequence[pulumi.Input['DeviceIpArgs']]]):
        pulumi.set(self, "ips", value)

    @property
    @pulumi.getter(name="authenticationDtlsRequired")
    def authentication_dtls_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enforce use of DTLS
        """
        return pulumi.get(self, "authentication_dtls_required")

    @authentication_dtls_required.setter
    def authentication_dtls_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authentication_dtls_required", value)

    @property
    @pulumi.getter(name="authenticationEnableKeyWrap")
    def authentication_enable_key_wrap(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable key wrap
        """
        return pulumi.get(self, "authentication_enable_key_wrap")

    @authentication_enable_key_wrap.setter
    def authentication_enable_key_wrap(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authentication_enable_key_wrap", value)

    @property
    @pulumi.getter(name="authenticationEnableMultiSecret")
    def authentication_enable_multi_secret(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable multiple RADIUS shared secrets
        """
        return pulumi.get(self, "authentication_enable_multi_secret")

    @authentication_enable_multi_secret.setter
    def authentication_enable_multi_secret(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authentication_enable_multi_secret", value)

    @property
    @pulumi.getter(name="authenticationEncryptionKey")
    def authentication_encryption_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Encryption key
        """
        return pulumi.get(self, "authentication_encryption_key")

    @authentication_encryption_key.setter
    def authentication_encryption_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_encryption_key", value)

    @property
    @pulumi.getter(name="authenticationEncryptionKeyFormat")
    def authentication_encryption_key_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key input format - Choices: `ASCII`, `HEXADECIMAL`
        """
        return pulumi.get(self, "authentication_encryption_key_format")

    @authentication_encryption_key_format.setter
    def authentication_encryption_key_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_encryption_key_format", value)

    @property
    @pulumi.getter(name="authenticationMessageAuthenticatorCodeKey")
    def authentication_message_authenticator_code_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Message authenticator code key
        """
        return pulumi.get(self, "authentication_message_authenticator_code_key")

    @authentication_message_authenticator_code_key.setter
    def authentication_message_authenticator_code_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_message_authenticator_code_key", value)

    @property
    @pulumi.getter(name="authenticationNetworkProtocol")
    def authentication_network_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network protocol - Choices: `RADIUS`, `TACACS_PLUS`
        """
        return pulumi.get(self, "authentication_network_protocol")

    @authentication_network_protocol.setter
    def authentication_network_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_network_protocol", value)

    @property
    @pulumi.getter(name="authenticationRadiusSharedSecret")
    def authentication_radius_shared_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        RADIUS shared secret
        """
        return pulumi.get(self, "authentication_radius_shared_secret")

    @authentication_radius_shared_secret.setter
    def authentication_radius_shared_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_radius_shared_secret", value)

    @property
    @pulumi.getter(name="authenticationSecondRadiusSharedSecret")
    def authentication_second_radius_shared_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Second RADIUS shared secret
        """
        return pulumi.get(self, "authentication_second_radius_shared_secret")

    @authentication_second_radius_shared_secret.setter
    def authentication_second_radius_shared_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_second_radius_shared_secret", value)

    @property
    @pulumi.getter(name="coaPort")
    def coa_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        CoA port - Default value: `1700`
        """
        return pulumi.get(self, "coa_port")

    @coa_port.setter
    def coa_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "coa_port", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dtlsDnsName")
    def dtls_dns_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This value is used to verify the client identity contained in the X.509 RADIUS/DTLS client certificate
        """
        return pulumi.get(self, "dtls_dns_name")

    @dtls_dns_name.setter
    def dtls_dns_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dtls_dns_name", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Model name
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the network device
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkDeviceGroups")
    def network_device_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of network device groups, e.g. `Device Type#All Device Types#ACCESS`
        """
        return pulumi.get(self, "network_device_groups")

    @network_device_groups.setter
    def network_device_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "network_device_groups", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Profile name - Default value: `Cisco`
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="snmpLinkTrapQuery")
    def snmp_link_trap_query(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        SNMP link Trap Query
        """
        return pulumi.get(self, "snmp_link_trap_query")

    @snmp_link_trap_query.setter
    def snmp_link_trap_query(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "snmp_link_trap_query", value)

    @property
    @pulumi.getter(name="snmpMacTrapQuery")
    def snmp_mac_trap_query(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        SNMP MAC Trap Query
        """
        return pulumi.get(self, "snmp_mac_trap_query")

    @snmp_mac_trap_query.setter
    def snmp_mac_trap_query(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "snmp_mac_trap_query", value)

    @property
    @pulumi.getter(name="snmpOriginatingPolicyServiceNode")
    def snmp_originating_policy_service_node(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Originating Policy Services Node
        """
        return pulumi.get(self, "snmp_originating_policy_service_node")

    @snmp_originating_policy_service_node.setter
    def snmp_originating_policy_service_node(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snmp_originating_policy_service_node", value)

    @property
    @pulumi.getter(name="snmpPollingInterval")
    def snmp_polling_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        SNMP Polling Interval in seconds - Range: `600`-`86400`
        """
        return pulumi.get(self, "snmp_polling_interval")

    @snmp_polling_interval.setter
    def snmp_polling_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "snmp_polling_interval", value)

    @property
    @pulumi.getter(name="snmpRoCommunity")
    def snmp_ro_community(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SNMP RO Community
        """
        return pulumi.get(self, "snmp_ro_community")

    @snmp_ro_community.setter
    def snmp_ro_community(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snmp_ro_community", value)

    @property
    @pulumi.getter(name="snmpVersion")
    def snmp_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SNMP version - Choices: `ONE`, `TWO_C`, `THREE`
        """
        return pulumi.get(self, "snmp_version")

    @snmp_version.setter
    def snmp_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snmp_version", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Software version
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="tacacsConnectModeOptions")
    def tacacs_connect_mode_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Connect mode options - Choices: `OFF`, `ON_LEGACY`, `ON_DRAFT_COMPLIANT`
        """
        return pulumi.get(self, "tacacs_connect_mode_options")

    @tacacs_connect_mode_options.setter
    def tacacs_connect_mode_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tacacs_connect_mode_options", value)

    @property
    @pulumi.getter(name="tacacsSharedSecret")
    def tacacs_shared_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Shared secret
        """
        return pulumi.get(self, "tacacs_shared_secret")

    @tacacs_shared_secret.setter
    def tacacs_shared_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tacacs_shared_secret", value)

    @property
    @pulumi.getter(name="trustsecCoaSourceHost")
    def trustsec_coa_source_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CoA source host
        """
        return pulumi.get(self, "trustsec_coa_source_host")

    @trustsec_coa_source_host.setter
    def trustsec_coa_source_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_coa_source_host", value)

    @property
    @pulumi.getter(name="trustsecDeviceId")
    def trustsec_device_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TrustSec device ID
        """
        return pulumi.get(self, "trustsec_device_id")

    @trustsec_device_id.setter
    def trustsec_device_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_device_id", value)

    @property
    @pulumi.getter(name="trustsecDevicePassword")
    def trustsec_device_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TrustSec device password
        """
        return pulumi.get(self, "trustsec_device_password")

    @trustsec_device_password.setter
    def trustsec_device_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_device_password", value)

    @property
    @pulumi.getter(name="trustsecDownloadEnvironmentDataEveryXSeconds")
    def trustsec_download_environment_data_every_x_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Download environment data every X seconds
        """
        return pulumi.get(self, "trustsec_download_environment_data_every_x_seconds")

    @trustsec_download_environment_data_every_x_seconds.setter
    def trustsec_download_environment_data_every_x_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "trustsec_download_environment_data_every_x_seconds", value)

    @property
    @pulumi.getter(name="trustsecDownloadPeerAuthorizationPolicyEveryXSeconds")
    def trustsec_download_peer_authorization_policy_every_x_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Download peer authorization policy every X seconds
        """
        return pulumi.get(self, "trustsec_download_peer_authorization_policy_every_x_seconds")

    @trustsec_download_peer_authorization_policy_every_x_seconds.setter
    def trustsec_download_peer_authorization_policy_every_x_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "trustsec_download_peer_authorization_policy_every_x_seconds", value)

    @property
    @pulumi.getter(name="trustsecDownloadSgaclListsEveryXSeconds")
    def trustsec_download_sgacl_lists_every_x_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Download SGACL lists every X seconds
        """
        return pulumi.get(self, "trustsec_download_sgacl_lists_every_x_seconds")

    @trustsec_download_sgacl_lists_every_x_seconds.setter
    def trustsec_download_sgacl_lists_every_x_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "trustsec_download_sgacl_lists_every_x_seconds", value)

    @property
    @pulumi.getter(name="trustsecEnableModePassword")
    def trustsec_enable_mode_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable mode password
        """
        return pulumi.get(self, "trustsec_enable_mode_password")

    @trustsec_enable_mode_password.setter
    def trustsec_enable_mode_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_enable_mode_password", value)

    @property
    @pulumi.getter(name="trustsecExecModePassword")
    def trustsec_exec_mode_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        EXEC mode password
        """
        return pulumi.get(self, "trustsec_exec_mode_password")

    @trustsec_exec_mode_password.setter
    def trustsec_exec_mode_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_exec_mode_password", value)

    @property
    @pulumi.getter(name="trustsecExecModeUsername")
    def trustsec_exec_mode_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        EXEC mode username
        """
        return pulumi.get(self, "trustsec_exec_mode_username")

    @trustsec_exec_mode_username.setter
    def trustsec_exec_mode_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_exec_mode_username", value)

    @property
    @pulumi.getter(name="trustsecIncludeWhenDeployingSgtUpdates")
    def trustsec_include_when_deploying_sgt_updates(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Include this device when deploying Security Group Tag Mapping Updates
        """
        return pulumi.get(self, "trustsec_include_when_deploying_sgt_updates")

    @trustsec_include_when_deploying_sgt_updates.setter
    def trustsec_include_when_deploying_sgt_updates(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "trustsec_include_when_deploying_sgt_updates", value)

    @property
    @pulumi.getter(name="trustsecOtherSgaDevicesToTrustThisDevice")
    def trustsec_other_sga_devices_to_trust_this_device(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Other TrustSec devices to trust this device
        """
        return pulumi.get(self, "trustsec_other_sga_devices_to_trust_this_device")

    @trustsec_other_sga_devices_to_trust_this_device.setter
    def trustsec_other_sga_devices_to_trust_this_device(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "trustsec_other_sga_devices_to_trust_this_device", value)

    @property
    @pulumi.getter(name="trustsecReAuthenticationEveryXSeconds")
    def trustsec_re_authentication_every_x_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Re-authenticate every X seconds
        """
        return pulumi.get(self, "trustsec_re_authentication_every_x_seconds")

    @trustsec_re_authentication_every_x_seconds.setter
    def trustsec_re_authentication_every_x_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "trustsec_re_authentication_every_x_seconds", value)

    @property
    @pulumi.getter(name="trustsecRestApiPassword")
    def trustsec_rest_api_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        REST API password
        """
        return pulumi.get(self, "trustsec_rest_api_password")

    @trustsec_rest_api_password.setter
    def trustsec_rest_api_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_rest_api_password", value)

    @property
    @pulumi.getter(name="trustsecRestApiUsername")
    def trustsec_rest_api_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        REST API username
        """
        return pulumi.get(self, "trustsec_rest_api_username")

    @trustsec_rest_api_username.setter
    def trustsec_rest_api_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_rest_api_username", value)

    @property
    @pulumi.getter(name="trustsecSendConfigurationToDevice")
    def trustsec_send_configuration_to_device(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Send configuration to device
        """
        return pulumi.get(self, "trustsec_send_configuration_to_device")

    @trustsec_send_configuration_to_device.setter
    def trustsec_send_configuration_to_device(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "trustsec_send_configuration_to_device", value)

    @property
    @pulumi.getter(name="trustsecSendConfigurationToDeviceUsing")
    def trustsec_send_configuration_to_device_using(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Send configuration to device using - Choices: `DISABLE_ALL`, `ENABLE_USING_CLI`, `ENABLE_USING_COA`
        """
        return pulumi.get(self, "trustsec_send_configuration_to_device_using")

    @trustsec_send_configuration_to_device_using.setter
    def trustsec_send_configuration_to_device_using(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_send_configuration_to_device_using", value)


@pulumi.input_type
class _DeviceState:
    def __init__(__self__, *,
                 authentication_dtls_required: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_enable_key_wrap: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_enable_multi_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_encryption_key: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_encryption_key_format: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_message_authenticator_code_key: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_network_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_radius_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_second_radius_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 coa_port: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dtls_dns_name: Optional[pulumi.Input[builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceIpArgs']]]] = None,
                 model_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_device_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_link_trap_query: Optional[pulumi.Input[builtins.bool]] = None,
                 snmp_mac_trap_query: Optional[pulumi.Input[builtins.bool]] = None,
                 snmp_originating_policy_service_node: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_polling_interval: Optional[pulumi.Input[builtins.int]] = None,
                 snmp_ro_community: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_version: Optional[pulumi.Input[builtins.str]] = None,
                 software_version: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_connect_mode_options: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_coa_source_host: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_device_id: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_device_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_download_environment_data_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_download_peer_authorization_policy_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_download_sgacl_lists_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_enable_mode_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_exec_mode_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_exec_mode_username: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_include_when_deploying_sgt_updates: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_other_sga_devices_to_trust_this_device: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_re_authentication_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_rest_api_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_rest_api_username: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_send_configuration_to_device: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_send_configuration_to_device_using: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Device resources.
        :param pulumi.Input[builtins.bool] authentication_dtls_required: Enforce use of DTLS
        :param pulumi.Input[builtins.bool] authentication_enable_key_wrap: Enable key wrap
        :param pulumi.Input[builtins.bool] authentication_enable_multi_secret: Enable multiple RADIUS shared secrets
        :param pulumi.Input[builtins.str] authentication_encryption_key: Encryption key
        :param pulumi.Input[builtins.str] authentication_encryption_key_format: Key input format - Choices: `ASCII`, `HEXADECIMAL`
        :param pulumi.Input[builtins.str] authentication_message_authenticator_code_key: Message authenticator code key
        :param pulumi.Input[builtins.str] authentication_network_protocol: Network protocol - Choices: `RADIUS`, `TACACS_PLUS`
        :param pulumi.Input[builtins.str] authentication_radius_shared_secret: RADIUS shared secret
        :param pulumi.Input[builtins.str] authentication_second_radius_shared_secret: Second RADIUS shared secret
        :param pulumi.Input[builtins.int] coa_port: CoA port - Default value: `1700`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] dtls_dns_name: This value is used to verify the client identity contained in the X.509 RADIUS/DTLS client certificate
        :param pulumi.Input[Sequence[pulumi.Input['DeviceIpArgs']]] ips: List of IP subnets
        :param pulumi.Input[builtins.str] model_name: Model name
        :param pulumi.Input[builtins.str] name: The name of the network device
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_device_groups: List of network device groups, e.g. `Device Type#All Device Types#ACCESS`
        :param pulumi.Input[builtins.str] profile_name: Profile name - Default value: `Cisco`
        :param pulumi.Input[builtins.bool] snmp_link_trap_query: SNMP link Trap Query
        :param pulumi.Input[builtins.bool] snmp_mac_trap_query: SNMP MAC Trap Query
        :param pulumi.Input[builtins.str] snmp_originating_policy_service_node: Originating Policy Services Node
        :param pulumi.Input[builtins.int] snmp_polling_interval: SNMP Polling Interval in seconds - Range: `600`-`86400`
        :param pulumi.Input[builtins.str] snmp_ro_community: SNMP RO Community
        :param pulumi.Input[builtins.str] snmp_version: SNMP version - Choices: `ONE`, `TWO_C`, `THREE`
        :param pulumi.Input[builtins.str] software_version: Software version
        :param pulumi.Input[builtins.str] tacacs_connect_mode_options: Connect mode options - Choices: `OFF`, `ON_LEGACY`, `ON_DRAFT_COMPLIANT`
        :param pulumi.Input[builtins.str] tacacs_shared_secret: Shared secret
        :param pulumi.Input[builtins.str] trustsec_coa_source_host: CoA source host
        :param pulumi.Input[builtins.str] trustsec_device_id: TrustSec device ID
        :param pulumi.Input[builtins.str] trustsec_device_password: TrustSec device password
        :param pulumi.Input[builtins.int] trustsec_download_environment_data_every_x_seconds: Download environment data every X seconds
        :param pulumi.Input[builtins.int] trustsec_download_peer_authorization_policy_every_x_seconds: Download peer authorization policy every X seconds
        :param pulumi.Input[builtins.int] trustsec_download_sgacl_lists_every_x_seconds: Download SGACL lists every X seconds
        :param pulumi.Input[builtins.str] trustsec_enable_mode_password: Enable mode password
        :param pulumi.Input[builtins.str] trustsec_exec_mode_password: EXEC mode password
        :param pulumi.Input[builtins.str] trustsec_exec_mode_username: EXEC mode username
        :param pulumi.Input[builtins.bool] trustsec_include_when_deploying_sgt_updates: Include this device when deploying Security Group Tag Mapping Updates
        :param pulumi.Input[builtins.bool] trustsec_other_sga_devices_to_trust_this_device: Other TrustSec devices to trust this device
        :param pulumi.Input[builtins.int] trustsec_re_authentication_every_x_seconds: Re-authenticate every X seconds
        :param pulumi.Input[builtins.str] trustsec_rest_api_password: REST API password
        :param pulumi.Input[builtins.str] trustsec_rest_api_username: REST API username
        :param pulumi.Input[builtins.bool] trustsec_send_configuration_to_device: Send configuration to device
        :param pulumi.Input[builtins.str] trustsec_send_configuration_to_device_using: Send configuration to device using - Choices: `DISABLE_ALL`, `ENABLE_USING_CLI`, `ENABLE_USING_COA`
        """
        if authentication_dtls_required is not None:
            pulumi.set(__self__, "authentication_dtls_required", authentication_dtls_required)
        if authentication_enable_key_wrap is not None:
            pulumi.set(__self__, "authentication_enable_key_wrap", authentication_enable_key_wrap)
        if authentication_enable_multi_secret is not None:
            pulumi.set(__self__, "authentication_enable_multi_secret", authentication_enable_multi_secret)
        if authentication_encryption_key is not None:
            pulumi.set(__self__, "authentication_encryption_key", authentication_encryption_key)
        if authentication_encryption_key_format is not None:
            pulumi.set(__self__, "authentication_encryption_key_format", authentication_encryption_key_format)
        if authentication_message_authenticator_code_key is not None:
            pulumi.set(__self__, "authentication_message_authenticator_code_key", authentication_message_authenticator_code_key)
        if authentication_network_protocol is not None:
            pulumi.set(__self__, "authentication_network_protocol", authentication_network_protocol)
        if authentication_radius_shared_secret is not None:
            pulumi.set(__self__, "authentication_radius_shared_secret", authentication_radius_shared_secret)
        if authentication_second_radius_shared_secret is not None:
            pulumi.set(__self__, "authentication_second_radius_shared_secret", authentication_second_radius_shared_secret)
        if coa_port is not None:
            pulumi.set(__self__, "coa_port", coa_port)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dtls_dns_name is not None:
            pulumi.set(__self__, "dtls_dns_name", dtls_dns_name)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_device_groups is not None:
            pulumi.set(__self__, "network_device_groups", network_device_groups)
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if snmp_link_trap_query is not None:
            pulumi.set(__self__, "snmp_link_trap_query", snmp_link_trap_query)
        if snmp_mac_trap_query is not None:
            pulumi.set(__self__, "snmp_mac_trap_query", snmp_mac_trap_query)
        if snmp_originating_policy_service_node is not None:
            pulumi.set(__self__, "snmp_originating_policy_service_node", snmp_originating_policy_service_node)
        if snmp_polling_interval is not None:
            pulumi.set(__self__, "snmp_polling_interval", snmp_polling_interval)
        if snmp_ro_community is not None:
            pulumi.set(__self__, "snmp_ro_community", snmp_ro_community)
        if snmp_version is not None:
            pulumi.set(__self__, "snmp_version", snmp_version)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if tacacs_connect_mode_options is not None:
            pulumi.set(__self__, "tacacs_connect_mode_options", tacacs_connect_mode_options)
        if tacacs_shared_secret is not None:
            pulumi.set(__self__, "tacacs_shared_secret", tacacs_shared_secret)
        if trustsec_coa_source_host is not None:
            pulumi.set(__self__, "trustsec_coa_source_host", trustsec_coa_source_host)
        if trustsec_device_id is not None:
            pulumi.set(__self__, "trustsec_device_id", trustsec_device_id)
        if trustsec_device_password is not None:
            pulumi.set(__self__, "trustsec_device_password", trustsec_device_password)
        if trustsec_download_environment_data_every_x_seconds is not None:
            pulumi.set(__self__, "trustsec_download_environment_data_every_x_seconds", trustsec_download_environment_data_every_x_seconds)
        if trustsec_download_peer_authorization_policy_every_x_seconds is not None:
            pulumi.set(__self__, "trustsec_download_peer_authorization_policy_every_x_seconds", trustsec_download_peer_authorization_policy_every_x_seconds)
        if trustsec_download_sgacl_lists_every_x_seconds is not None:
            pulumi.set(__self__, "trustsec_download_sgacl_lists_every_x_seconds", trustsec_download_sgacl_lists_every_x_seconds)
        if trustsec_enable_mode_password is not None:
            pulumi.set(__self__, "trustsec_enable_mode_password", trustsec_enable_mode_password)
        if trustsec_exec_mode_password is not None:
            pulumi.set(__self__, "trustsec_exec_mode_password", trustsec_exec_mode_password)
        if trustsec_exec_mode_username is not None:
            pulumi.set(__self__, "trustsec_exec_mode_username", trustsec_exec_mode_username)
        if trustsec_include_when_deploying_sgt_updates is not None:
            pulumi.set(__self__, "trustsec_include_when_deploying_sgt_updates", trustsec_include_when_deploying_sgt_updates)
        if trustsec_other_sga_devices_to_trust_this_device is not None:
            pulumi.set(__self__, "trustsec_other_sga_devices_to_trust_this_device", trustsec_other_sga_devices_to_trust_this_device)
        if trustsec_re_authentication_every_x_seconds is not None:
            pulumi.set(__self__, "trustsec_re_authentication_every_x_seconds", trustsec_re_authentication_every_x_seconds)
        if trustsec_rest_api_password is not None:
            pulumi.set(__self__, "trustsec_rest_api_password", trustsec_rest_api_password)
        if trustsec_rest_api_username is not None:
            pulumi.set(__self__, "trustsec_rest_api_username", trustsec_rest_api_username)
        if trustsec_send_configuration_to_device is not None:
            pulumi.set(__self__, "trustsec_send_configuration_to_device", trustsec_send_configuration_to_device)
        if trustsec_send_configuration_to_device_using is not None:
            pulumi.set(__self__, "trustsec_send_configuration_to_device_using", trustsec_send_configuration_to_device_using)

    @property
    @pulumi.getter(name="authenticationDtlsRequired")
    def authentication_dtls_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enforce use of DTLS
        """
        return pulumi.get(self, "authentication_dtls_required")

    @authentication_dtls_required.setter
    def authentication_dtls_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authentication_dtls_required", value)

    @property
    @pulumi.getter(name="authenticationEnableKeyWrap")
    def authentication_enable_key_wrap(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable key wrap
        """
        return pulumi.get(self, "authentication_enable_key_wrap")

    @authentication_enable_key_wrap.setter
    def authentication_enable_key_wrap(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authentication_enable_key_wrap", value)

    @property
    @pulumi.getter(name="authenticationEnableMultiSecret")
    def authentication_enable_multi_secret(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable multiple RADIUS shared secrets
        """
        return pulumi.get(self, "authentication_enable_multi_secret")

    @authentication_enable_multi_secret.setter
    def authentication_enable_multi_secret(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authentication_enable_multi_secret", value)

    @property
    @pulumi.getter(name="authenticationEncryptionKey")
    def authentication_encryption_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Encryption key
        """
        return pulumi.get(self, "authentication_encryption_key")

    @authentication_encryption_key.setter
    def authentication_encryption_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_encryption_key", value)

    @property
    @pulumi.getter(name="authenticationEncryptionKeyFormat")
    def authentication_encryption_key_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key input format - Choices: `ASCII`, `HEXADECIMAL`
        """
        return pulumi.get(self, "authentication_encryption_key_format")

    @authentication_encryption_key_format.setter
    def authentication_encryption_key_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_encryption_key_format", value)

    @property
    @pulumi.getter(name="authenticationMessageAuthenticatorCodeKey")
    def authentication_message_authenticator_code_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Message authenticator code key
        """
        return pulumi.get(self, "authentication_message_authenticator_code_key")

    @authentication_message_authenticator_code_key.setter
    def authentication_message_authenticator_code_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_message_authenticator_code_key", value)

    @property
    @pulumi.getter(name="authenticationNetworkProtocol")
    def authentication_network_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network protocol - Choices: `RADIUS`, `TACACS_PLUS`
        """
        return pulumi.get(self, "authentication_network_protocol")

    @authentication_network_protocol.setter
    def authentication_network_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_network_protocol", value)

    @property
    @pulumi.getter(name="authenticationRadiusSharedSecret")
    def authentication_radius_shared_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        RADIUS shared secret
        """
        return pulumi.get(self, "authentication_radius_shared_secret")

    @authentication_radius_shared_secret.setter
    def authentication_radius_shared_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_radius_shared_secret", value)

    @property
    @pulumi.getter(name="authenticationSecondRadiusSharedSecret")
    def authentication_second_radius_shared_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Second RADIUS shared secret
        """
        return pulumi.get(self, "authentication_second_radius_shared_secret")

    @authentication_second_radius_shared_secret.setter
    def authentication_second_radius_shared_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_second_radius_shared_secret", value)

    @property
    @pulumi.getter(name="coaPort")
    def coa_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        CoA port - Default value: `1700`
        """
        return pulumi.get(self, "coa_port")

    @coa_port.setter
    def coa_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "coa_port", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dtlsDnsName")
    def dtls_dns_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This value is used to verify the client identity contained in the X.509 RADIUS/DTLS client certificate
        """
        return pulumi.get(self, "dtls_dns_name")

    @dtls_dns_name.setter
    def dtls_dns_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dtls_dns_name", value)

    @property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceIpArgs']]]]:
        """
        List of IP subnets
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceIpArgs']]]]):
        pulumi.set(self, "ips", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Model name
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the network device
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkDeviceGroups")
    def network_device_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of network device groups, e.g. `Device Type#All Device Types#ACCESS`
        """
        return pulumi.get(self, "network_device_groups")

    @network_device_groups.setter
    def network_device_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "network_device_groups", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Profile name - Default value: `Cisco`
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="snmpLinkTrapQuery")
    def snmp_link_trap_query(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        SNMP link Trap Query
        """
        return pulumi.get(self, "snmp_link_trap_query")

    @snmp_link_trap_query.setter
    def snmp_link_trap_query(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "snmp_link_trap_query", value)

    @property
    @pulumi.getter(name="snmpMacTrapQuery")
    def snmp_mac_trap_query(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        SNMP MAC Trap Query
        """
        return pulumi.get(self, "snmp_mac_trap_query")

    @snmp_mac_trap_query.setter
    def snmp_mac_trap_query(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "snmp_mac_trap_query", value)

    @property
    @pulumi.getter(name="snmpOriginatingPolicyServiceNode")
    def snmp_originating_policy_service_node(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Originating Policy Services Node
        """
        return pulumi.get(self, "snmp_originating_policy_service_node")

    @snmp_originating_policy_service_node.setter
    def snmp_originating_policy_service_node(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snmp_originating_policy_service_node", value)

    @property
    @pulumi.getter(name="snmpPollingInterval")
    def snmp_polling_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        SNMP Polling Interval in seconds - Range: `600`-`86400`
        """
        return pulumi.get(self, "snmp_polling_interval")

    @snmp_polling_interval.setter
    def snmp_polling_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "snmp_polling_interval", value)

    @property
    @pulumi.getter(name="snmpRoCommunity")
    def snmp_ro_community(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SNMP RO Community
        """
        return pulumi.get(self, "snmp_ro_community")

    @snmp_ro_community.setter
    def snmp_ro_community(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snmp_ro_community", value)

    @property
    @pulumi.getter(name="snmpVersion")
    def snmp_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SNMP version - Choices: `ONE`, `TWO_C`, `THREE`
        """
        return pulumi.get(self, "snmp_version")

    @snmp_version.setter
    def snmp_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snmp_version", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Software version
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="tacacsConnectModeOptions")
    def tacacs_connect_mode_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Connect mode options - Choices: `OFF`, `ON_LEGACY`, `ON_DRAFT_COMPLIANT`
        """
        return pulumi.get(self, "tacacs_connect_mode_options")

    @tacacs_connect_mode_options.setter
    def tacacs_connect_mode_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tacacs_connect_mode_options", value)

    @property
    @pulumi.getter(name="tacacsSharedSecret")
    def tacacs_shared_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Shared secret
        """
        return pulumi.get(self, "tacacs_shared_secret")

    @tacacs_shared_secret.setter
    def tacacs_shared_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tacacs_shared_secret", value)

    @property
    @pulumi.getter(name="trustsecCoaSourceHost")
    def trustsec_coa_source_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CoA source host
        """
        return pulumi.get(self, "trustsec_coa_source_host")

    @trustsec_coa_source_host.setter
    def trustsec_coa_source_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_coa_source_host", value)

    @property
    @pulumi.getter(name="trustsecDeviceId")
    def trustsec_device_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TrustSec device ID
        """
        return pulumi.get(self, "trustsec_device_id")

    @trustsec_device_id.setter
    def trustsec_device_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_device_id", value)

    @property
    @pulumi.getter(name="trustsecDevicePassword")
    def trustsec_device_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TrustSec device password
        """
        return pulumi.get(self, "trustsec_device_password")

    @trustsec_device_password.setter
    def trustsec_device_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_device_password", value)

    @property
    @pulumi.getter(name="trustsecDownloadEnvironmentDataEveryXSeconds")
    def trustsec_download_environment_data_every_x_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Download environment data every X seconds
        """
        return pulumi.get(self, "trustsec_download_environment_data_every_x_seconds")

    @trustsec_download_environment_data_every_x_seconds.setter
    def trustsec_download_environment_data_every_x_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "trustsec_download_environment_data_every_x_seconds", value)

    @property
    @pulumi.getter(name="trustsecDownloadPeerAuthorizationPolicyEveryXSeconds")
    def trustsec_download_peer_authorization_policy_every_x_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Download peer authorization policy every X seconds
        """
        return pulumi.get(self, "trustsec_download_peer_authorization_policy_every_x_seconds")

    @trustsec_download_peer_authorization_policy_every_x_seconds.setter
    def trustsec_download_peer_authorization_policy_every_x_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "trustsec_download_peer_authorization_policy_every_x_seconds", value)

    @property
    @pulumi.getter(name="trustsecDownloadSgaclListsEveryXSeconds")
    def trustsec_download_sgacl_lists_every_x_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Download SGACL lists every X seconds
        """
        return pulumi.get(self, "trustsec_download_sgacl_lists_every_x_seconds")

    @trustsec_download_sgacl_lists_every_x_seconds.setter
    def trustsec_download_sgacl_lists_every_x_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "trustsec_download_sgacl_lists_every_x_seconds", value)

    @property
    @pulumi.getter(name="trustsecEnableModePassword")
    def trustsec_enable_mode_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable mode password
        """
        return pulumi.get(self, "trustsec_enable_mode_password")

    @trustsec_enable_mode_password.setter
    def trustsec_enable_mode_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_enable_mode_password", value)

    @property
    @pulumi.getter(name="trustsecExecModePassword")
    def trustsec_exec_mode_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        EXEC mode password
        """
        return pulumi.get(self, "trustsec_exec_mode_password")

    @trustsec_exec_mode_password.setter
    def trustsec_exec_mode_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_exec_mode_password", value)

    @property
    @pulumi.getter(name="trustsecExecModeUsername")
    def trustsec_exec_mode_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        EXEC mode username
        """
        return pulumi.get(self, "trustsec_exec_mode_username")

    @trustsec_exec_mode_username.setter
    def trustsec_exec_mode_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_exec_mode_username", value)

    @property
    @pulumi.getter(name="trustsecIncludeWhenDeployingSgtUpdates")
    def trustsec_include_when_deploying_sgt_updates(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Include this device when deploying Security Group Tag Mapping Updates
        """
        return pulumi.get(self, "trustsec_include_when_deploying_sgt_updates")

    @trustsec_include_when_deploying_sgt_updates.setter
    def trustsec_include_when_deploying_sgt_updates(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "trustsec_include_when_deploying_sgt_updates", value)

    @property
    @pulumi.getter(name="trustsecOtherSgaDevicesToTrustThisDevice")
    def trustsec_other_sga_devices_to_trust_this_device(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Other TrustSec devices to trust this device
        """
        return pulumi.get(self, "trustsec_other_sga_devices_to_trust_this_device")

    @trustsec_other_sga_devices_to_trust_this_device.setter
    def trustsec_other_sga_devices_to_trust_this_device(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "trustsec_other_sga_devices_to_trust_this_device", value)

    @property
    @pulumi.getter(name="trustsecReAuthenticationEveryXSeconds")
    def trustsec_re_authentication_every_x_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Re-authenticate every X seconds
        """
        return pulumi.get(self, "trustsec_re_authentication_every_x_seconds")

    @trustsec_re_authentication_every_x_seconds.setter
    def trustsec_re_authentication_every_x_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "trustsec_re_authentication_every_x_seconds", value)

    @property
    @pulumi.getter(name="trustsecRestApiPassword")
    def trustsec_rest_api_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        REST API password
        """
        return pulumi.get(self, "trustsec_rest_api_password")

    @trustsec_rest_api_password.setter
    def trustsec_rest_api_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_rest_api_password", value)

    @property
    @pulumi.getter(name="trustsecRestApiUsername")
    def trustsec_rest_api_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        REST API username
        """
        return pulumi.get(self, "trustsec_rest_api_username")

    @trustsec_rest_api_username.setter
    def trustsec_rest_api_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_rest_api_username", value)

    @property
    @pulumi.getter(name="trustsecSendConfigurationToDevice")
    def trustsec_send_configuration_to_device(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Send configuration to device
        """
        return pulumi.get(self, "trustsec_send_configuration_to_device")

    @trustsec_send_configuration_to_device.setter
    def trustsec_send_configuration_to_device(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "trustsec_send_configuration_to_device", value)

    @property
    @pulumi.getter(name="trustsecSendConfigurationToDeviceUsing")
    def trustsec_send_configuration_to_device_using(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Send configuration to device using - Choices: `DISABLE_ALL`, `ENABLE_USING_CLI`, `ENABLE_USING_COA`
        """
        return pulumi.get(self, "trustsec_send_configuration_to_device_using")

    @trustsec_send_configuration_to_device_using.setter
    def trustsec_send_configuration_to_device_using(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trustsec_send_configuration_to_device_using", value)


@pulumi.type_token("ise:network/device:Device")
class Device(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_dtls_required: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_enable_key_wrap: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_enable_multi_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_encryption_key: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_encryption_key_format: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_message_authenticator_code_key: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_network_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_radius_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_second_radius_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 coa_port: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dtls_dns_name: Optional[pulumi.Input[builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeviceIpArgs', 'DeviceIpArgsDict']]]]] = None,
                 model_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_device_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_link_trap_query: Optional[pulumi.Input[builtins.bool]] = None,
                 snmp_mac_trap_query: Optional[pulumi.Input[builtins.bool]] = None,
                 snmp_originating_policy_service_node: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_polling_interval: Optional[pulumi.Input[builtins.int]] = None,
                 snmp_ro_community: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_version: Optional[pulumi.Input[builtins.str]] = None,
                 software_version: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_connect_mode_options: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_coa_source_host: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_device_id: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_device_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_download_environment_data_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_download_peer_authorization_policy_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_download_sgacl_lists_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_enable_mode_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_exec_mode_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_exec_mode_username: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_include_when_deploying_sgt_updates: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_other_sga_devices_to_trust_this_device: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_re_authentication_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_rest_api_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_rest_api_username: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_send_configuration_to_device: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_send_configuration_to_device_using: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Network Device.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.network.Device("example",
            name="Device1",
            description="My device",
            authentication_enable_key_wrap=True,
            authentication_encryption_key="cisco123cisco123",
            authentication_encryption_key_format="ASCII",
            authentication_message_authenticator_code_key="cisco123cisco1235678",
            authentication_network_protocol="RADIUS",
            authentication_radius_shared_secret="cisco123",
            authentication_enable_multi_secret=True,
            authentication_second_radius_shared_secret="cisco12345",
            authentication_dtls_required=True,
            coa_port=12345,
            dtls_dns_name="cisco.com",
            ips=[{
                "ipaddress": "2.3.4.5",
                "mask": "32",
            }],
            model_name="Unknown",
            software_version="Unknown",
            profile_name="Cisco",
            snmp_link_trap_query=True,
            snmp_mac_trap_query=True,
            snmp_polling_interval=1200,
            snmp_ro_community="rocom",
            snmp_version="TWO_C",
            tacacs_connect_mode_options="OFF",
            tacacs_shared_secret="cisco123",
            trustsec_device_id="device123",
            trustsec_device_password="cisco123",
            trustsec_rest_api_username="user123",
            trustsec_rest_api_password="Cisco123",
            trustsec_enable_mode_password="cisco123",
            trustsec_exec_mode_password="cisco123",
            trustsec_exec_mode_username="user456",
            trustsec_include_when_deploying_sgt_updates=True,
            trustsec_download_environment_data_every_x_seconds=1000,
            trustsec_download_peer_authorization_policy_every_x_seconds=1000,
            trustsec_download_sgacl_lists_every_x_seconds=1000,
            trustsec_other_sga_devices_to_trust_this_device=True,
            trustsec_re_authentication_every_x_seconds=1000,
            trustsec_send_configuration_to_device=True,
            trustsec_send_configuration_to_device_using="ENABLE_USING_COA")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:network/device:Device example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] authentication_dtls_required: Enforce use of DTLS
        :param pulumi.Input[builtins.bool] authentication_enable_key_wrap: Enable key wrap
        :param pulumi.Input[builtins.bool] authentication_enable_multi_secret: Enable multiple RADIUS shared secrets
        :param pulumi.Input[builtins.str] authentication_encryption_key: Encryption key
        :param pulumi.Input[builtins.str] authentication_encryption_key_format: Key input format - Choices: `ASCII`, `HEXADECIMAL`
        :param pulumi.Input[builtins.str] authentication_message_authenticator_code_key: Message authenticator code key
        :param pulumi.Input[builtins.str] authentication_network_protocol: Network protocol - Choices: `RADIUS`, `TACACS_PLUS`
        :param pulumi.Input[builtins.str] authentication_radius_shared_secret: RADIUS shared secret
        :param pulumi.Input[builtins.str] authentication_second_radius_shared_secret: Second RADIUS shared secret
        :param pulumi.Input[builtins.int] coa_port: CoA port - Default value: `1700`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] dtls_dns_name: This value is used to verify the client identity contained in the X.509 RADIUS/DTLS client certificate
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeviceIpArgs', 'DeviceIpArgsDict']]]] ips: List of IP subnets
        :param pulumi.Input[builtins.str] model_name: Model name
        :param pulumi.Input[builtins.str] name: The name of the network device
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_device_groups: List of network device groups, e.g. `Device Type#All Device Types#ACCESS`
        :param pulumi.Input[builtins.str] profile_name: Profile name - Default value: `Cisco`
        :param pulumi.Input[builtins.bool] snmp_link_trap_query: SNMP link Trap Query
        :param pulumi.Input[builtins.bool] snmp_mac_trap_query: SNMP MAC Trap Query
        :param pulumi.Input[builtins.str] snmp_originating_policy_service_node: Originating Policy Services Node
        :param pulumi.Input[builtins.int] snmp_polling_interval: SNMP Polling Interval in seconds - Range: `600`-`86400`
        :param pulumi.Input[builtins.str] snmp_ro_community: SNMP RO Community
        :param pulumi.Input[builtins.str] snmp_version: SNMP version - Choices: `ONE`, `TWO_C`, `THREE`
        :param pulumi.Input[builtins.str] software_version: Software version
        :param pulumi.Input[builtins.str] tacacs_connect_mode_options: Connect mode options - Choices: `OFF`, `ON_LEGACY`, `ON_DRAFT_COMPLIANT`
        :param pulumi.Input[builtins.str] tacacs_shared_secret: Shared secret
        :param pulumi.Input[builtins.str] trustsec_coa_source_host: CoA source host
        :param pulumi.Input[builtins.str] trustsec_device_id: TrustSec device ID
        :param pulumi.Input[builtins.str] trustsec_device_password: TrustSec device password
        :param pulumi.Input[builtins.int] trustsec_download_environment_data_every_x_seconds: Download environment data every X seconds
        :param pulumi.Input[builtins.int] trustsec_download_peer_authorization_policy_every_x_seconds: Download peer authorization policy every X seconds
        :param pulumi.Input[builtins.int] trustsec_download_sgacl_lists_every_x_seconds: Download SGACL lists every X seconds
        :param pulumi.Input[builtins.str] trustsec_enable_mode_password: Enable mode password
        :param pulumi.Input[builtins.str] trustsec_exec_mode_password: EXEC mode password
        :param pulumi.Input[builtins.str] trustsec_exec_mode_username: EXEC mode username
        :param pulumi.Input[builtins.bool] trustsec_include_when_deploying_sgt_updates: Include this device when deploying Security Group Tag Mapping Updates
        :param pulumi.Input[builtins.bool] trustsec_other_sga_devices_to_trust_this_device: Other TrustSec devices to trust this device
        :param pulumi.Input[builtins.int] trustsec_re_authentication_every_x_seconds: Re-authenticate every X seconds
        :param pulumi.Input[builtins.str] trustsec_rest_api_password: REST API password
        :param pulumi.Input[builtins.str] trustsec_rest_api_username: REST API username
        :param pulumi.Input[builtins.bool] trustsec_send_configuration_to_device: Send configuration to device
        :param pulumi.Input[builtins.str] trustsec_send_configuration_to_device_using: Send configuration to device using - Choices: `DISABLE_ALL`, `ENABLE_USING_CLI`, `ENABLE_USING_COA`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeviceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Network Device.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.network.Device("example",
            name="Device1",
            description="My device",
            authentication_enable_key_wrap=True,
            authentication_encryption_key="cisco123cisco123",
            authentication_encryption_key_format="ASCII",
            authentication_message_authenticator_code_key="cisco123cisco1235678",
            authentication_network_protocol="RADIUS",
            authentication_radius_shared_secret="cisco123",
            authentication_enable_multi_secret=True,
            authentication_second_radius_shared_secret="cisco12345",
            authentication_dtls_required=True,
            coa_port=12345,
            dtls_dns_name="cisco.com",
            ips=[{
                "ipaddress": "2.3.4.5",
                "mask": "32",
            }],
            model_name="Unknown",
            software_version="Unknown",
            profile_name="Cisco",
            snmp_link_trap_query=True,
            snmp_mac_trap_query=True,
            snmp_polling_interval=1200,
            snmp_ro_community="rocom",
            snmp_version="TWO_C",
            tacacs_connect_mode_options="OFF",
            tacacs_shared_secret="cisco123",
            trustsec_device_id="device123",
            trustsec_device_password="cisco123",
            trustsec_rest_api_username="user123",
            trustsec_rest_api_password="Cisco123",
            trustsec_enable_mode_password="cisco123",
            trustsec_exec_mode_password="cisco123",
            trustsec_exec_mode_username="user456",
            trustsec_include_when_deploying_sgt_updates=True,
            trustsec_download_environment_data_every_x_seconds=1000,
            trustsec_download_peer_authorization_policy_every_x_seconds=1000,
            trustsec_download_sgacl_lists_every_x_seconds=1000,
            trustsec_other_sga_devices_to_trust_this_device=True,
            trustsec_re_authentication_every_x_seconds=1000,
            trustsec_send_configuration_to_device=True,
            trustsec_send_configuration_to_device_using="ENABLE_USING_COA")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:network/device:Device example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param DeviceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeviceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_dtls_required: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_enable_key_wrap: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_enable_multi_secret: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_encryption_key: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_encryption_key_format: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_message_authenticator_code_key: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_network_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_radius_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_second_radius_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 coa_port: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dtls_dns_name: Optional[pulumi.Input[builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeviceIpArgs', 'DeviceIpArgsDict']]]]] = None,
                 model_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_device_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_link_trap_query: Optional[pulumi.Input[builtins.bool]] = None,
                 snmp_mac_trap_query: Optional[pulumi.Input[builtins.bool]] = None,
                 snmp_originating_policy_service_node: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_polling_interval: Optional[pulumi.Input[builtins.int]] = None,
                 snmp_ro_community: Optional[pulumi.Input[builtins.str]] = None,
                 snmp_version: Optional[pulumi.Input[builtins.str]] = None,
                 software_version: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_connect_mode_options: Optional[pulumi.Input[builtins.str]] = None,
                 tacacs_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_coa_source_host: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_device_id: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_device_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_download_environment_data_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_download_peer_authorization_policy_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_download_sgacl_lists_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_enable_mode_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_exec_mode_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_exec_mode_username: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_include_when_deploying_sgt_updates: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_other_sga_devices_to_trust_this_device: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_re_authentication_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 trustsec_rest_api_password: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_rest_api_username: Optional[pulumi.Input[builtins.str]] = None,
                 trustsec_send_configuration_to_device: Optional[pulumi.Input[builtins.bool]] = None,
                 trustsec_send_configuration_to_device_using: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeviceArgs.__new__(DeviceArgs)

            __props__.__dict__["authentication_dtls_required"] = authentication_dtls_required
            __props__.__dict__["authentication_enable_key_wrap"] = authentication_enable_key_wrap
            __props__.__dict__["authentication_enable_multi_secret"] = authentication_enable_multi_secret
            __props__.__dict__["authentication_encryption_key"] = authentication_encryption_key
            __props__.__dict__["authentication_encryption_key_format"] = authentication_encryption_key_format
            __props__.__dict__["authentication_message_authenticator_code_key"] = authentication_message_authenticator_code_key
            __props__.__dict__["authentication_network_protocol"] = authentication_network_protocol
            __props__.__dict__["authentication_radius_shared_secret"] = authentication_radius_shared_secret
            __props__.__dict__["authentication_second_radius_shared_secret"] = authentication_second_radius_shared_secret
            __props__.__dict__["coa_port"] = coa_port
            __props__.__dict__["description"] = description
            __props__.__dict__["dtls_dns_name"] = dtls_dns_name
            if ips is None and not opts.urn:
                raise TypeError("Missing required property 'ips'")
            __props__.__dict__["ips"] = ips
            __props__.__dict__["model_name"] = model_name
            __props__.__dict__["name"] = name
            __props__.__dict__["network_device_groups"] = network_device_groups
            __props__.__dict__["profile_name"] = profile_name
            __props__.__dict__["snmp_link_trap_query"] = snmp_link_trap_query
            __props__.__dict__["snmp_mac_trap_query"] = snmp_mac_trap_query
            __props__.__dict__["snmp_originating_policy_service_node"] = snmp_originating_policy_service_node
            __props__.__dict__["snmp_polling_interval"] = snmp_polling_interval
            __props__.__dict__["snmp_ro_community"] = snmp_ro_community
            __props__.__dict__["snmp_version"] = snmp_version
            __props__.__dict__["software_version"] = software_version
            __props__.__dict__["tacacs_connect_mode_options"] = tacacs_connect_mode_options
            __props__.__dict__["tacacs_shared_secret"] = tacacs_shared_secret
            __props__.__dict__["trustsec_coa_source_host"] = trustsec_coa_source_host
            __props__.__dict__["trustsec_device_id"] = trustsec_device_id
            __props__.__dict__["trustsec_device_password"] = trustsec_device_password
            __props__.__dict__["trustsec_download_environment_data_every_x_seconds"] = trustsec_download_environment_data_every_x_seconds
            __props__.__dict__["trustsec_download_peer_authorization_policy_every_x_seconds"] = trustsec_download_peer_authorization_policy_every_x_seconds
            __props__.__dict__["trustsec_download_sgacl_lists_every_x_seconds"] = trustsec_download_sgacl_lists_every_x_seconds
            __props__.__dict__["trustsec_enable_mode_password"] = trustsec_enable_mode_password
            __props__.__dict__["trustsec_exec_mode_password"] = trustsec_exec_mode_password
            __props__.__dict__["trustsec_exec_mode_username"] = trustsec_exec_mode_username
            __props__.__dict__["trustsec_include_when_deploying_sgt_updates"] = trustsec_include_when_deploying_sgt_updates
            __props__.__dict__["trustsec_other_sga_devices_to_trust_this_device"] = trustsec_other_sga_devices_to_trust_this_device
            __props__.__dict__["trustsec_re_authentication_every_x_seconds"] = trustsec_re_authentication_every_x_seconds
            __props__.__dict__["trustsec_rest_api_password"] = trustsec_rest_api_password
            __props__.__dict__["trustsec_rest_api_username"] = trustsec_rest_api_username
            __props__.__dict__["trustsec_send_configuration_to_device"] = trustsec_send_configuration_to_device
            __props__.__dict__["trustsec_send_configuration_to_device_using"] = trustsec_send_configuration_to_device_using
        super(Device, __self__).__init__(
            'ise:network/device:Device',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_dtls_required: Optional[pulumi.Input[builtins.bool]] = None,
            authentication_enable_key_wrap: Optional[pulumi.Input[builtins.bool]] = None,
            authentication_enable_multi_secret: Optional[pulumi.Input[builtins.bool]] = None,
            authentication_encryption_key: Optional[pulumi.Input[builtins.str]] = None,
            authentication_encryption_key_format: Optional[pulumi.Input[builtins.str]] = None,
            authentication_message_authenticator_code_key: Optional[pulumi.Input[builtins.str]] = None,
            authentication_network_protocol: Optional[pulumi.Input[builtins.str]] = None,
            authentication_radius_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
            authentication_second_radius_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
            coa_port: Optional[pulumi.Input[builtins.int]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            dtls_dns_name: Optional[pulumi.Input[builtins.str]] = None,
            ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeviceIpArgs', 'DeviceIpArgsDict']]]]] = None,
            model_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_device_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            profile_name: Optional[pulumi.Input[builtins.str]] = None,
            snmp_link_trap_query: Optional[pulumi.Input[builtins.bool]] = None,
            snmp_mac_trap_query: Optional[pulumi.Input[builtins.bool]] = None,
            snmp_originating_policy_service_node: Optional[pulumi.Input[builtins.str]] = None,
            snmp_polling_interval: Optional[pulumi.Input[builtins.int]] = None,
            snmp_ro_community: Optional[pulumi.Input[builtins.str]] = None,
            snmp_version: Optional[pulumi.Input[builtins.str]] = None,
            software_version: Optional[pulumi.Input[builtins.str]] = None,
            tacacs_connect_mode_options: Optional[pulumi.Input[builtins.str]] = None,
            tacacs_shared_secret: Optional[pulumi.Input[builtins.str]] = None,
            trustsec_coa_source_host: Optional[pulumi.Input[builtins.str]] = None,
            trustsec_device_id: Optional[pulumi.Input[builtins.str]] = None,
            trustsec_device_password: Optional[pulumi.Input[builtins.str]] = None,
            trustsec_download_environment_data_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
            trustsec_download_peer_authorization_policy_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
            trustsec_download_sgacl_lists_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
            trustsec_enable_mode_password: Optional[pulumi.Input[builtins.str]] = None,
            trustsec_exec_mode_password: Optional[pulumi.Input[builtins.str]] = None,
            trustsec_exec_mode_username: Optional[pulumi.Input[builtins.str]] = None,
            trustsec_include_when_deploying_sgt_updates: Optional[pulumi.Input[builtins.bool]] = None,
            trustsec_other_sga_devices_to_trust_this_device: Optional[pulumi.Input[builtins.bool]] = None,
            trustsec_re_authentication_every_x_seconds: Optional[pulumi.Input[builtins.int]] = None,
            trustsec_rest_api_password: Optional[pulumi.Input[builtins.str]] = None,
            trustsec_rest_api_username: Optional[pulumi.Input[builtins.str]] = None,
            trustsec_send_configuration_to_device: Optional[pulumi.Input[builtins.bool]] = None,
            trustsec_send_configuration_to_device_using: Optional[pulumi.Input[builtins.str]] = None) -> 'Device':
        """
        Get an existing Device resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] authentication_dtls_required: Enforce use of DTLS
        :param pulumi.Input[builtins.bool] authentication_enable_key_wrap: Enable key wrap
        :param pulumi.Input[builtins.bool] authentication_enable_multi_secret: Enable multiple RADIUS shared secrets
        :param pulumi.Input[builtins.str] authentication_encryption_key: Encryption key
        :param pulumi.Input[builtins.str] authentication_encryption_key_format: Key input format - Choices: `ASCII`, `HEXADECIMAL`
        :param pulumi.Input[builtins.str] authentication_message_authenticator_code_key: Message authenticator code key
        :param pulumi.Input[builtins.str] authentication_network_protocol: Network protocol - Choices: `RADIUS`, `TACACS_PLUS`
        :param pulumi.Input[builtins.str] authentication_radius_shared_secret: RADIUS shared secret
        :param pulumi.Input[builtins.str] authentication_second_radius_shared_secret: Second RADIUS shared secret
        :param pulumi.Input[builtins.int] coa_port: CoA port - Default value: `1700`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] dtls_dns_name: This value is used to verify the client identity contained in the X.509 RADIUS/DTLS client certificate
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeviceIpArgs', 'DeviceIpArgsDict']]]] ips: List of IP subnets
        :param pulumi.Input[builtins.str] model_name: Model name
        :param pulumi.Input[builtins.str] name: The name of the network device
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_device_groups: List of network device groups, e.g. `Device Type#All Device Types#ACCESS`
        :param pulumi.Input[builtins.str] profile_name: Profile name - Default value: `Cisco`
        :param pulumi.Input[builtins.bool] snmp_link_trap_query: SNMP link Trap Query
        :param pulumi.Input[builtins.bool] snmp_mac_trap_query: SNMP MAC Trap Query
        :param pulumi.Input[builtins.str] snmp_originating_policy_service_node: Originating Policy Services Node
        :param pulumi.Input[builtins.int] snmp_polling_interval: SNMP Polling Interval in seconds - Range: `600`-`86400`
        :param pulumi.Input[builtins.str] snmp_ro_community: SNMP RO Community
        :param pulumi.Input[builtins.str] snmp_version: SNMP version - Choices: `ONE`, `TWO_C`, `THREE`
        :param pulumi.Input[builtins.str] software_version: Software version
        :param pulumi.Input[builtins.str] tacacs_connect_mode_options: Connect mode options - Choices: `OFF`, `ON_LEGACY`, `ON_DRAFT_COMPLIANT`
        :param pulumi.Input[builtins.str] tacacs_shared_secret: Shared secret
        :param pulumi.Input[builtins.str] trustsec_coa_source_host: CoA source host
        :param pulumi.Input[builtins.str] trustsec_device_id: TrustSec device ID
        :param pulumi.Input[builtins.str] trustsec_device_password: TrustSec device password
        :param pulumi.Input[builtins.int] trustsec_download_environment_data_every_x_seconds: Download environment data every X seconds
        :param pulumi.Input[builtins.int] trustsec_download_peer_authorization_policy_every_x_seconds: Download peer authorization policy every X seconds
        :param pulumi.Input[builtins.int] trustsec_download_sgacl_lists_every_x_seconds: Download SGACL lists every X seconds
        :param pulumi.Input[builtins.str] trustsec_enable_mode_password: Enable mode password
        :param pulumi.Input[builtins.str] trustsec_exec_mode_password: EXEC mode password
        :param pulumi.Input[builtins.str] trustsec_exec_mode_username: EXEC mode username
        :param pulumi.Input[builtins.bool] trustsec_include_when_deploying_sgt_updates: Include this device when deploying Security Group Tag Mapping Updates
        :param pulumi.Input[builtins.bool] trustsec_other_sga_devices_to_trust_this_device: Other TrustSec devices to trust this device
        :param pulumi.Input[builtins.int] trustsec_re_authentication_every_x_seconds: Re-authenticate every X seconds
        :param pulumi.Input[builtins.str] trustsec_rest_api_password: REST API password
        :param pulumi.Input[builtins.str] trustsec_rest_api_username: REST API username
        :param pulumi.Input[builtins.bool] trustsec_send_configuration_to_device: Send configuration to device
        :param pulumi.Input[builtins.str] trustsec_send_configuration_to_device_using: Send configuration to device using - Choices: `DISABLE_ALL`, `ENABLE_USING_CLI`, `ENABLE_USING_COA`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeviceState.__new__(_DeviceState)

        __props__.__dict__["authentication_dtls_required"] = authentication_dtls_required
        __props__.__dict__["authentication_enable_key_wrap"] = authentication_enable_key_wrap
        __props__.__dict__["authentication_enable_multi_secret"] = authentication_enable_multi_secret
        __props__.__dict__["authentication_encryption_key"] = authentication_encryption_key
        __props__.__dict__["authentication_encryption_key_format"] = authentication_encryption_key_format
        __props__.__dict__["authentication_message_authenticator_code_key"] = authentication_message_authenticator_code_key
        __props__.__dict__["authentication_network_protocol"] = authentication_network_protocol
        __props__.__dict__["authentication_radius_shared_secret"] = authentication_radius_shared_secret
        __props__.__dict__["authentication_second_radius_shared_secret"] = authentication_second_radius_shared_secret
        __props__.__dict__["coa_port"] = coa_port
        __props__.__dict__["description"] = description
        __props__.__dict__["dtls_dns_name"] = dtls_dns_name
        __props__.__dict__["ips"] = ips
        __props__.__dict__["model_name"] = model_name
        __props__.__dict__["name"] = name
        __props__.__dict__["network_device_groups"] = network_device_groups
        __props__.__dict__["profile_name"] = profile_name
        __props__.__dict__["snmp_link_trap_query"] = snmp_link_trap_query
        __props__.__dict__["snmp_mac_trap_query"] = snmp_mac_trap_query
        __props__.__dict__["snmp_originating_policy_service_node"] = snmp_originating_policy_service_node
        __props__.__dict__["snmp_polling_interval"] = snmp_polling_interval
        __props__.__dict__["snmp_ro_community"] = snmp_ro_community
        __props__.__dict__["snmp_version"] = snmp_version
        __props__.__dict__["software_version"] = software_version
        __props__.__dict__["tacacs_connect_mode_options"] = tacacs_connect_mode_options
        __props__.__dict__["tacacs_shared_secret"] = tacacs_shared_secret
        __props__.__dict__["trustsec_coa_source_host"] = trustsec_coa_source_host
        __props__.__dict__["trustsec_device_id"] = trustsec_device_id
        __props__.__dict__["trustsec_device_password"] = trustsec_device_password
        __props__.__dict__["trustsec_download_environment_data_every_x_seconds"] = trustsec_download_environment_data_every_x_seconds
        __props__.__dict__["trustsec_download_peer_authorization_policy_every_x_seconds"] = trustsec_download_peer_authorization_policy_every_x_seconds
        __props__.__dict__["trustsec_download_sgacl_lists_every_x_seconds"] = trustsec_download_sgacl_lists_every_x_seconds
        __props__.__dict__["trustsec_enable_mode_password"] = trustsec_enable_mode_password
        __props__.__dict__["trustsec_exec_mode_password"] = trustsec_exec_mode_password
        __props__.__dict__["trustsec_exec_mode_username"] = trustsec_exec_mode_username
        __props__.__dict__["trustsec_include_when_deploying_sgt_updates"] = trustsec_include_when_deploying_sgt_updates
        __props__.__dict__["trustsec_other_sga_devices_to_trust_this_device"] = trustsec_other_sga_devices_to_trust_this_device
        __props__.__dict__["trustsec_re_authentication_every_x_seconds"] = trustsec_re_authentication_every_x_seconds
        __props__.__dict__["trustsec_rest_api_password"] = trustsec_rest_api_password
        __props__.__dict__["trustsec_rest_api_username"] = trustsec_rest_api_username
        __props__.__dict__["trustsec_send_configuration_to_device"] = trustsec_send_configuration_to_device
        __props__.__dict__["trustsec_send_configuration_to_device_using"] = trustsec_send_configuration_to_device_using
        return Device(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationDtlsRequired")
    def authentication_dtls_required(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enforce use of DTLS
        """
        return pulumi.get(self, "authentication_dtls_required")

    @property
    @pulumi.getter(name="authenticationEnableKeyWrap")
    def authentication_enable_key_wrap(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable key wrap
        """
        return pulumi.get(self, "authentication_enable_key_wrap")

    @property
    @pulumi.getter(name="authenticationEnableMultiSecret")
    def authentication_enable_multi_secret(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable multiple RADIUS shared secrets
        """
        return pulumi.get(self, "authentication_enable_multi_secret")

    @property
    @pulumi.getter(name="authenticationEncryptionKey")
    def authentication_encryption_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Encryption key
        """
        return pulumi.get(self, "authentication_encryption_key")

    @property
    @pulumi.getter(name="authenticationEncryptionKeyFormat")
    def authentication_encryption_key_format(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Key input format - Choices: `ASCII`, `HEXADECIMAL`
        """
        return pulumi.get(self, "authentication_encryption_key_format")

    @property
    @pulumi.getter(name="authenticationMessageAuthenticatorCodeKey")
    def authentication_message_authenticator_code_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Message authenticator code key
        """
        return pulumi.get(self, "authentication_message_authenticator_code_key")

    @property
    @pulumi.getter(name="authenticationNetworkProtocol")
    def authentication_network_protocol(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Network protocol - Choices: `RADIUS`, `TACACS_PLUS`
        """
        return pulumi.get(self, "authentication_network_protocol")

    @property
    @pulumi.getter(name="authenticationRadiusSharedSecret")
    def authentication_radius_shared_secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        RADIUS shared secret
        """
        return pulumi.get(self, "authentication_radius_shared_secret")

    @property
    @pulumi.getter(name="authenticationSecondRadiusSharedSecret")
    def authentication_second_radius_shared_secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Second RADIUS shared secret
        """
        return pulumi.get(self, "authentication_second_radius_shared_secret")

    @property
    @pulumi.getter(name="coaPort")
    def coa_port(self) -> pulumi.Output[builtins.int]:
        """
        CoA port - Default value: `1700`
        """
        return pulumi.get(self, "coa_port")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dtlsDnsName")
    def dtls_dns_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This value is used to verify the client identity contained in the X.509 RADIUS/DTLS client certificate
        """
        return pulumi.get(self, "dtls_dns_name")

    @property
    @pulumi.getter
    def ips(self) -> pulumi.Output[Sequence['outputs.DeviceIp']]:
        """
        List of IP subnets
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Model name
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the network device
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkDeviceGroups")
    def network_device_groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of network device groups, e.g. `Device Type#All Device Types#ACCESS`
        """
        return pulumi.get(self, "network_device_groups")

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> pulumi.Output[builtins.str]:
        """
        Profile name - Default value: `Cisco`
        """
        return pulumi.get(self, "profile_name")

    @property
    @pulumi.getter(name="snmpLinkTrapQuery")
    def snmp_link_trap_query(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        SNMP link Trap Query
        """
        return pulumi.get(self, "snmp_link_trap_query")

    @property
    @pulumi.getter(name="snmpMacTrapQuery")
    def snmp_mac_trap_query(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        SNMP MAC Trap Query
        """
        return pulumi.get(self, "snmp_mac_trap_query")

    @property
    @pulumi.getter(name="snmpOriginatingPolicyServiceNode")
    def snmp_originating_policy_service_node(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Originating Policy Services Node
        """
        return pulumi.get(self, "snmp_originating_policy_service_node")

    @property
    @pulumi.getter(name="snmpPollingInterval")
    def snmp_polling_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        SNMP Polling Interval in seconds - Range: `600`-`86400`
        """
        return pulumi.get(self, "snmp_polling_interval")

    @property
    @pulumi.getter(name="snmpRoCommunity")
    def snmp_ro_community(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        SNMP RO Community
        """
        return pulumi.get(self, "snmp_ro_community")

    @property
    @pulumi.getter(name="snmpVersion")
    def snmp_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        SNMP version - Choices: `ONE`, `TWO_C`, `THREE`
        """
        return pulumi.get(self, "snmp_version")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Software version
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter(name="tacacsConnectModeOptions")
    def tacacs_connect_mode_options(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Connect mode options - Choices: `OFF`, `ON_LEGACY`, `ON_DRAFT_COMPLIANT`
        """
        return pulumi.get(self, "tacacs_connect_mode_options")

    @property
    @pulumi.getter(name="tacacsSharedSecret")
    def tacacs_shared_secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Shared secret
        """
        return pulumi.get(self, "tacacs_shared_secret")

    @property
    @pulumi.getter(name="trustsecCoaSourceHost")
    def trustsec_coa_source_host(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        CoA source host
        """
        return pulumi.get(self, "trustsec_coa_source_host")

    @property
    @pulumi.getter(name="trustsecDeviceId")
    def trustsec_device_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        TrustSec device ID
        """
        return pulumi.get(self, "trustsec_device_id")

    @property
    @pulumi.getter(name="trustsecDevicePassword")
    def trustsec_device_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        TrustSec device password
        """
        return pulumi.get(self, "trustsec_device_password")

    @property
    @pulumi.getter(name="trustsecDownloadEnvironmentDataEveryXSeconds")
    def trustsec_download_environment_data_every_x_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Download environment data every X seconds
        """
        return pulumi.get(self, "trustsec_download_environment_data_every_x_seconds")

    @property
    @pulumi.getter(name="trustsecDownloadPeerAuthorizationPolicyEveryXSeconds")
    def trustsec_download_peer_authorization_policy_every_x_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Download peer authorization policy every X seconds
        """
        return pulumi.get(self, "trustsec_download_peer_authorization_policy_every_x_seconds")

    @property
    @pulumi.getter(name="trustsecDownloadSgaclListsEveryXSeconds")
    def trustsec_download_sgacl_lists_every_x_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Download SGACL lists every X seconds
        """
        return pulumi.get(self, "trustsec_download_sgacl_lists_every_x_seconds")

    @property
    @pulumi.getter(name="trustsecEnableModePassword")
    def trustsec_enable_mode_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Enable mode password
        """
        return pulumi.get(self, "trustsec_enable_mode_password")

    @property
    @pulumi.getter(name="trustsecExecModePassword")
    def trustsec_exec_mode_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        EXEC mode password
        """
        return pulumi.get(self, "trustsec_exec_mode_password")

    @property
    @pulumi.getter(name="trustsecExecModeUsername")
    def trustsec_exec_mode_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        EXEC mode username
        """
        return pulumi.get(self, "trustsec_exec_mode_username")

    @property
    @pulumi.getter(name="trustsecIncludeWhenDeployingSgtUpdates")
    def trustsec_include_when_deploying_sgt_updates(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Include this device when deploying Security Group Tag Mapping Updates
        """
        return pulumi.get(self, "trustsec_include_when_deploying_sgt_updates")

    @property
    @pulumi.getter(name="trustsecOtherSgaDevicesToTrustThisDevice")
    def trustsec_other_sga_devices_to_trust_this_device(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Other TrustSec devices to trust this device
        """
        return pulumi.get(self, "trustsec_other_sga_devices_to_trust_this_device")

    @property
    @pulumi.getter(name="trustsecReAuthenticationEveryXSeconds")
    def trustsec_re_authentication_every_x_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Re-authenticate every X seconds
        """
        return pulumi.get(self, "trustsec_re_authentication_every_x_seconds")

    @property
    @pulumi.getter(name="trustsecRestApiPassword")
    def trustsec_rest_api_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        REST API password
        """
        return pulumi.get(self, "trustsec_rest_api_password")

    @property
    @pulumi.getter(name="trustsecRestApiUsername")
    def trustsec_rest_api_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        REST API username
        """
        return pulumi.get(self, "trustsec_rest_api_username")

    @property
    @pulumi.getter(name="trustsecSendConfigurationToDevice")
    def trustsec_send_configuration_to_device(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Send configuration to device
        """
        return pulumi.get(self, "trustsec_send_configuration_to_device")

    @property
    @pulumi.getter(name="trustsecSendConfigurationToDeviceUsing")
    def trustsec_send_configuration_to_device_using(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Send configuration to device using - Choices: `DISABLE_ALL`, `ENABLE_USING_CLI`, `ENABLE_USING_COA`
        """
        return pulumi.get(self, "trustsec_send_configuration_to_device_using")

