"""
	File generated by UShareSoft
"""

import objects
import StringIO
import urllib
import sys
import hmac

from hashlib import sha1
from pyxb.utils import domutils

reload(sys)
sys.setdefaultencoding('utf-8')

class _Objects(object):
	@classmethod
	def parseString(cls, string, silence=False):
		exception = Exception('No parser found')
		for xsd in filter(lambda d: not d.startswith('__'), dir(objects)):
			try:
				return  getattr(objects, xsd).CreateFromDocument(string)
			except Exception as e:
				exception = e
		raise exception

class _CommonAPIClass(object):
	def _get(self, arg):
		if hasattr(self, arg):
			ret = getattr(self, arg)
			delattr(self, arg)
			return ret
		elif hasattr(self, '_parent') and self._parent:
			return self._parent._get(arg)
		else:
			raise Exception('Argument "%s" is not set' % (arg))
	def _REST(self, url, method, body, element_name, **kwargs):
		obj = self
		while obj <> None and not hasattr(obj, '_client'):
			if hasattr(obj, '_parent'):
				obj = obj._parent
			else:
				obj = None
		if obj == None:
			raise Exception('HTTP client not found')

		# Build headers
		requestHttpHeader = dict(obj._headers)
		requestHttpHeader['Content-Type'] = 'application/xml'
		requestHttpHeader['Accept'] = 'application/xml'

		# Build request
		if obj._apikeys:
			kwargs["apiKey"] = obj._apikeys["publickey"]
		relativeUrl = url
		if kwargs:
			relativeUrl+="?"
			for key, value in kwargs.iteritems():
				if value is not None:
					keyVal=urllib.urlencode({ key : value})
					relativeUrl+=keyVal+"&"
			if relativeUrl[-1]=="&" or relativeUrl[-1]=="?":
				relativeUrl=relativeUrl[:-1]
		# Build API key authentication
		if obj._apikeys:
			# calculate signature
			signature = self._calc_signature(url=relativeUrl, secretkey=obj._apikeys["secretkey"])
			keyVal=urllib.urlencode({"signature" : signature})
			relativeUrl+="&"+keyVal
		fullUrl = obj._url + relativeUrl
		if body:
			try:
				if type(body) is not file:
					if element_name is not None:
						bds = domutils.BindingDOMSupport(require_xsi_type=True)
						body = body.toxml(encoding="utf-8", bds=bds, element_name=element_name)
					else:
						body = body.toxml(encoding="utf-8")
			except:
				print "Problem converting python object to XML"
				raise

		resp, content = obj._client.request(fullUrl, method.upper(), body = body, headers = requestHttpHeader)
		if resp.status < 200 or (resp.status != 304 and resp.status >= 300):
			if 'content-type' in resp and resp['content-type']=="application/xml":
				raise Exception(_Objects.parseString(content, True))
			else:
				raise Exception("Error http code: "+str(resp.status))
		if 'content-type' in resp and resp['content-type']=="application/xml":
			if resp.status != 204 and resp.status != 304:
				# parse the output only if there is a content. 204 (no content) and 304 (not modified) must not contain any body
				return _Objects.parseString(content, True)
		else:
			return content
	def _calc_signature(self, url, secretkey):
		if url.startswith("/"):
			url=url[1:]
		hashed = hmac.new(secretkey, url, sha1)
		return hashed.digest().encode("base64").rstrip('\n')
class Api(_CommonAPIClass):
	def __init__(self, url, client = None, headers = {}, apikeys = {}):
		self._apikeys = apikeys
		self._client = client
		self._headers = headers
		self._url = url
		self.Status = Api._Status(self)
		self.Marketplace = Api._Marketplace(self)
		self.Users = Api._Users(self)
		self.Maintenance = Api._Maintenance(self)
		self.Entitlements = Api._Entitlements(self)
		self.Orgs = Api._Orgs(self)
		pass
	
	class _Status(_CommonAPIClass):
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			pass
		
		#URL: status
		def Get(self, body=None, element_name=None):
			kwargs = {}
			return self._REST('/status', 'GET', body, element_name, **kwargs)
		
	
	class _Marketplace(_CommonAPIClass):
		def __call__(self, Mid=None):
			self.Mid = Mid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Managers = Api._Marketplace._Managers(self)
			self.Approvals = Api._Marketplace._Approvals(self)
			self.Comments = Api._Marketplace._Comments(self)
			self.Vendors = Api._Marketplace._Vendors(self)
			self.Products = Api._Marketplace._Products(self)
			self.Types = Api._Marketplace._Types(self)
			self.Compatibleproducts = Api._Marketplace._Compatibleproducts(self)
			self.Productsnotifications = Api._Marketplace._Productsnotifications(self)
			self.Badges = Api._Marketplace._Badges(self)
			pass
		
		#URL: marketplace
		def Create(self, body=None, element_name=None):
			kwargs = {}
			return self._REST('/marketplace', 'POST', body, element_name, **kwargs)
		
		#URL: marketplace
		def Getall(self, body=None, element_name=None):
			kwargs = {}
			return self._REST('/marketplace', 'GET', body, element_name, **kwargs)
		
		#URL: marketplace/{mid}
		def Get(self, body=None, element_name=None):
			kwargs = {}
			return self._REST('/marketplace/' + str(self._get('Mid')) + '', 'GET', body, element_name, **kwargs)
		class _Managers(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: marketplace/{mid}/managers
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/managers', 'GET', body, element_name, **kwargs)
			
		
		class _Approvals(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: marketplace/{mid}/approvals
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/approvals', 'GET', body, element_name, **kwargs)
			
		
		class _Comments(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: marketplace/{mid}/comments
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/comments', 'GET', body, element_name, **kwargs)
			
		
		class _Vendors(_CommonAPIClass):
			def __call__(self, Vid=None):
				self.Vid = Vid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: marketplace/{mid}/vendors/{vid}
			def Get(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/vendors/' + str(self._get('Vid')) + '', 'GET', body, element_name, **kwargs)
			
		
		class _Products(_CommonAPIClass):
			def __call__(self, Pid=None):
				self.Pid = Pid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Items = Api._Marketplace._Products._Items(self)
				self.Comments = Api._Marketplace._Products._Comments(self)
				self.Notifications = Api._Marketplace._Products._Notifications(self)
				pass
			
			#URL: marketplace/{mid}/products
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/products', 'GET', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/products/{pid}
			def Get(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '', 'GET', body, element_name, **kwargs)
			class _Items(_CommonAPIClass):
				def __call__(self, Piid=None, Ipid=None):
					self.Piid = Piid
					self.Ipid = Ipid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Artifacts = Api._Marketplace._Products._Items._Artifacts(self)
					self.Logo = Api._Marketplace._Products._Items._Logo(self)
					self.Screenshots = Api._Marketplace._Products._Items._Screenshots(self)
					self.Comments = Api._Marketplace._Products._Items._Comments(self)
					self.Purchases = Api._Marketplace._Products._Items._Purchases(self)
					pass
				
				#URL: marketplace/{mid}/products/{pid}/items/{ipid}
				def Get(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Ipid')) + '', 'GET', body, element_name, **kwargs)
				
				#URL: marketplace/{mid}/products/{pid}/items
				def Getall(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items', 'GET', body, element_name, **kwargs)
				class _Artifacts(_CommonAPIClass):
					def __call__(self, Bpiid=None):
						self.Bpiid = Bpiid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Bin = Api._Marketplace._Products._Items._Artifacts._Bin(self)
						self.Downloads = Api._Marketplace._Products._Items._Artifacts._Downloads(self)
						pass
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/artifacts/{bpiid}
					def Get(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts/' + str(self._get('Bpiid')) + '', 'GET', body, element_name, **kwargs)
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/artifacts
					def Getall(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts', 'GET', body, element_name, **kwargs)
					class _Bin(_CommonAPIClass):
						def __call__(self, Filename=None):
							self.Filename = Filename
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: marketplace/{mid}/products/{pid}/items/{piid}/artifacts/{bpiid}/bin
						def Download(self, Downloadid, body=None, element_name=None):
							kwargs = {'downloadId': Downloadid}
							return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts/' + str(self._get('Bpiid')) + '/bin', 'GET', body, element_name, **kwargs)
						
						#URL: marketplace/{mid}/products/{pid}/items/{piid}/artifacts/{bpiid}/bin/{fileName}
						def Downloadfilename(self, Downloadid, body=None, element_name=None):
							kwargs = {'downloadId': Downloadid}
							return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts/' + str(self._get('Bpiid')) + '/bin/' + str(self._get('Filename')) + '', 'GET', body, element_name, **kwargs)
						
					
					class _Downloads(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: marketplace/{mid}/products/{pid}/items/{piid}/artifacts/{bpiid}/downloads
						def Downloadrequest(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts/' + str(self._get('Bpiid')) + '/downloads', 'POST', body, element_name, **kwargs)
						
					
				
				class _Logo(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/logo
					def Get(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/logo', 'GET', body, element_name, **kwargs)
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/logo/{fileName}
					def Getfilename(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/logo/' + str(self._get('Filename')) + '', 'GET', body, element_name, **kwargs)
					
				
				class _Screenshots(_CommonAPIClass):
					def __call__(self, Sid=None, Filename=None):
						self.Sid = Sid
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/screenshots/{sid}/{fileName}
					def Getfilename(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/screenshots/' + str(self._get('Sid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, **kwargs)
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/screenshots/{sid}
					def Get(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/screenshots/' + str(self._get('Sid')) + '', 'GET', body, element_name, **kwargs)
					
				
				class _Comments(_CommonAPIClass):
					def __call__(self, Cid=None):
						self.Cid = Cid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Abuses = Api._Marketplace._Products._Items._Comments._Abuses(self)
						self.Likes = Api._Marketplace._Products._Items._Comments._Likes(self)
						self.Replies = Api._Marketplace._Products._Items._Comments._Replies(self)
						pass
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/comments
					def Create(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments', 'POST', body, element_name, **kwargs)
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/comments/{cid}
					def Update(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '', 'PUT', body, element_name, **kwargs)
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/comments
					def Getall(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments', 'GET', body, element_name, **kwargs)
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/comments/{cid}
					def Get(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '', 'GET', body, element_name, **kwargs)
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/comments/{cid}
					def Delete(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '', 'DELETE', body, element_name, **kwargs)
					class _Abuses(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: marketplace/{mid}/products/{pid}/items/{piid}/comments/{cid}/abuses
						def Report(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '/abuses', 'POST', body, element_name, **kwargs)
						
					
					class _Likes(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: marketplace/{mid}/products/{pid}/items/{piid}/comments/{cid}/likes
						def Like(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '/likes', 'POST', body, element_name, **kwargs)
						
						#URL: marketplace/{mid}/products/{pid}/items/{piid}/comments/{cid}/likes
						def Dislike(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '/likes', 'DELETE', body, element_name, **kwargs)
						
					
					class _Replies(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: marketplace/{mid}/products/{pid}/items/{piid}/comments/{cid}/replies
						def Reply(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '/replies', 'POST', body, element_name, **kwargs)
						
					
				
				class _Purchases(_CommonAPIClass):
					def __call__(self, Puid=None):
						self.Puid = Puid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Billing = Api._Marketplace._Products._Items._Purchases._Billing(self)
						pass
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/purchases
					def Purchase(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/purchases', 'POST', body, element_name, **kwargs)
					
					#URL: marketplace/{mid}/products/{pid}/items/{piid}/purchases/{puid}
					def Get(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/purchases/' + str(self._get('Puid')) + '', 'GET', body, element_name, **kwargs)
					class _Billing(_CommonAPIClass):
						def __call__(self, Action=None):
							self.Action = Action
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: marketplace/{mid}/products/{pid}/items/{piid}/purchases/{puid}/billing/{action}
						def Reorder(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/purchases/' + str(self._get('Puid')) + '/billing/' + str(self._get('Action')) + '', 'POST', body, element_name, **kwargs)
						
					
				
			
			class _Comments(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: marketplace/{mid}/products/{pid}/comments
				def Getall(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/comments', 'GET', body, element_name, **kwargs)
				
			
			class _Notifications(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: marketplace/{mid}/products/{pid}/notifications
				def Remove(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/notifications', 'DELETE', body, element_name, **kwargs)
				
				#URL: marketplace/{mid}/products/{pid}/notifications
				def Add(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/marketplace/' + str(self._get('Mid')) + '/products/' + str(self._get('Pid')) + '/notifications', 'POST', body, element_name, **kwargs)
				
			
		
		class _Types(_CommonAPIClass):
			def __call__(self, Ptid=None):
				self.Ptid = Ptid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Productitems = Api._Marketplace._Types._Productitems(self)
				pass
			
			#URL: marketplace/{mid}/types/{ptid}
			def Update(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/types/' + str(self._get('Ptid')) + '', 'PUT', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/types/{ptid}
			def Get(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/types/' + str(self._get('Ptid')) + '', 'GET', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/types
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/types', 'GET', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/types
			def Create(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/types', 'POST', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/types/{ptid}
			def Delete(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/types/' + str(self._get('Ptid')) + '', 'DELETE', body, element_name, **kwargs)
			class _Productitems(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: marketplace/{mid}/types/{ptid}/productitems
				def Getlistings(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/marketplace/' + str(self._get('Mid')) + '/types/' + str(self._get('Ptid')) + '/productitems', 'GET', body, element_name, **kwargs)
				
			
		
		class _Compatibleproducts(_CommonAPIClass):
			def __call__(self, Cpid=None):
				self.Cpid = Cpid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Productitems = Api._Marketplace._Compatibleproducts._Productitems(self)
				pass
			
			#URL: marketplace/{mid}/compatibleproducts/{cpid}
			def Delete(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/compatibleproducts/' + str(self._get('Cpid')) + '', 'DELETE', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/compatibleproducts/{cpid}
			def Get(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/compatibleproducts/' + str(self._get('Cpid')) + '', 'GET', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/compatibleproducts
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/compatibleproducts', 'GET', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/compatibleproducts/{cpid}
			def Update(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/compatibleproducts/' + str(self._get('Cpid')) + '', 'PUT', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/compatibleproducts
			def Create(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/compatibleproducts', 'POST', body, element_name, **kwargs)
			class _Productitems(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: marketplace/{mid}/compatibleproducts/{cpid}/productitems
				def Getlistings(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/marketplace/' + str(self._get('Mid')) + '/compatibleproducts/' + str(self._get('Cpid')) + '/productitems', 'GET', body, element_name, **kwargs)
				
			
		
		class _Productsnotifications(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: marketplace/{mid}/productsnotifications
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/productsnotifications', 'GET', body, element_name, **kwargs)
			
		
		class _Badges(_CommonAPIClass):
			def __call__(self, Bid=None):
				self.Bid = Bid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Icon = Api._Marketplace._Badges._Icon(self)
				pass
			
			#URL: marketplace/{mid}/badges/{bid}
			def Delete(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/badges/' + str(self._get('Bid')) + '', 'DELETE', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/badges/{bid}
			def Update(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/badges/' + str(self._get('Bid')) + '', 'PUT', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/badges
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/badges', 'GET', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/badges
			def Create(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/badges', 'POST', body, element_name, **kwargs)
			
			#URL: marketplace/{mid}/badges/{bid}
			def Get(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/marketplace/' + str(self._get('Mid')) + '/badges/' + str(self._get('Bid')) + '', 'GET', body, element_name, **kwargs)
			class _Icon(_CommonAPIClass):
				def __call__(self, Logoid=None, Filename=None):
					self.Logoid = Logoid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: marketplace/{mid}/badges/{bid}/icon/{logoId}/{fileName}
				def Getfilename(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/marketplace/' + str(self._get('Mid')) + '/badges/' + str(self._get('Bid')) + '/icon/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, **kwargs)
				
				#URL: marketplace/{mid}/badges/{bid}/icon/{logoId}
				def Delete(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/marketplace/' + str(self._get('Mid')) + '/badges/' + str(self._get('Bid')) + '/icon/' + str(self._get('Logoid')) + '', 'DELETE', body, element_name, **kwargs)
				
				#URL: marketplace/{mid}/badges/{bid}/icon/{logoId}/{fileName}
				def Upload(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/marketplace/' + str(self._get('Mid')) + '/badges/' + str(self._get('Bid')) + '/icon/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, **kwargs)
				
				#URL: marketplace/{mid}/badges/{bid}/icon/{logoId}
				def Get(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/marketplace/' + str(self._get('Mid')) + '/badges/' + str(self._get('Bid')) + '/icon/' + str(self._get('Logoid')) + '', 'GET', body, element_name, **kwargs)
				
			
		
	
	class _Users(_CommonAPIClass):
		def __call__(self, Uid=None):
			self.Uid = Uid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Purchases = Api._Users._Purchases(self)
			self.Exports = Api._Users._Exports(self)
			self.Uforgeaccounts = Api._Users._Uforgeaccounts(self)
			self.Roles = Api._Users._Roles(self)
			self.Forgotpassword = Api._Users._Forgotpassword(self)
			self.Photo = Api._Users._Photo(self)
			self.Vendors = Api._Users._Vendors(self)
			self.Usage = Api._Users._Usage(self)
			self.Orgs = Api._Users._Orgs(self)
			self.Apikeys = Api._Users._Apikeys(self)
			pass
		
		#URL: users/{uid}
		def Get(self, body=None, element_name=None):
			kwargs = {}
			return self._REST('/users/' + str(self._get('Uid')) + '', 'GET', body, element_name, **kwargs)
		
		#URL: users
		def Getall(self, Orgname, Active, body=None, element_name=None):
			kwargs = {'orgName': Orgname, 'active': Active}
			return self._REST('/users', 'GET', body, element_name, **kwargs)
		
		#URL: users
		def Create(self, Notify, Notifyadmin, Org, Publisher, Admin, Autopasswd, body=None, element_name=None):
			kwargs = {'notify': Notify, 'notifyAdmin': Notifyadmin, 'org': Org, 'publisher': Publisher, 'admin': Admin, 'autopasswd': Autopasswd}
			return self._REST('/users', 'POST', body, element_name, **kwargs)
		
		#URL: users/{uid}
		def Update(self, body=None, element_name=None):
			kwargs = {}
			return self._REST('/users/' + str(self._get('Uid')) + '', 'PUT', body, element_name, **kwargs)
		class _Purchases(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/purchases
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/purchases', 'GET', body, element_name, **kwargs)
			
		
		class _Exports(_CommonAPIClass):
			def __call__(self, Eid=None):
				self.Eid = Eid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Status = Api._Users._Exports._Status(self)
				pass
			
			#URL: users/{uid}/exports
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/exports', 'GET', body, element_name, **kwargs)
			
			#URL: users/{uid}/exports
			def Export(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/exports', 'POST', body, element_name, **kwargs)
			class _Status(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/exports/{eid}/status
				def Getstatus(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/exports/' + str(self._get('Eid')) + '/status', 'GET', body, element_name, **kwargs)
				
			
		
		class _Uforgeaccounts(_CommonAPIClass):
			def __call__(self, Caid=None):
				self.Caid = Caid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Machineimages = Api._Users._Uforgeaccounts._Machineimages(self)
				self.Appliances = Api._Users._Uforgeaccounts._Appliances(self)
				pass
			
			#URL: users/{uid}/uforgeaccounts
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/uforgeaccounts', 'GET', body, element_name, **kwargs)
			
			#URL: users/{uid}/uforgeaccounts/{caid}
			def Get(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/uforgeaccounts/' + str(self._get('Caid')) + '', 'GET', body, element_name, **kwargs)
			
			#URL: users/{uid}/uforgeaccounts/{caid}
			def Update(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/uforgeaccounts/' + str(self._get('Caid')) + '', 'PUT', body, element_name, **kwargs)
			
			#URL: users/{uid}/uforgeaccounts
			def Create(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/uforgeaccounts', 'POST', body, element_name, **kwargs)
			
			#URL: users/{uid}/uforgeaccounts/{caid}
			def Delete(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/uforgeaccounts/' + str(self._get('Caid')) + '', 'DELETE', body, element_name, **kwargs)
			class _Machineimages(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/uforgeaccounts/{caid}/machineimages
				def Getall(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/uforgeaccounts/' + str(self._get('Caid')) + '/machineimages', 'GET', body, element_name, **kwargs)
				
			
			class _Appliances(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/uforgeaccounts/{caid}/appliances
				def Getall(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/uforgeaccounts/' + str(self._get('Caid')) + '/appliances', 'GET', body, element_name, **kwargs)
				
			
		
		class _Roles(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/roles
			def Update(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/roles', 'PUT', body, element_name, **kwargs)
			
			#URL: users/{uid}/roles
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/roles', 'GET', body, element_name, **kwargs)
			
		
		class _Forgotpassword(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/forgotpassword
			def Reset(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/forgotpassword', 'PUT', body, element_name, **kwargs)
			
		
		class _Photo(_CommonAPIClass):
			def __call__(self, Photoid=None, Filename=None):
				self.Photoid = Photoid
				self.Filename = Filename
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/photo/{photoId}/{fileName}
			def Getfilename(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/photo/' + str(self._get('Photoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, **kwargs)
			
			#URL: users/{uid}/photo/{photoId}/{fileName}
			def Upload(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/photo/' + str(self._get('Photoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, **kwargs)
			
			#URL: users/{uid}/photo/{photoId}
			def Delete(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/photo/' + str(self._get('Photoid')) + '', 'DELETE', body, element_name, **kwargs)
			
			#URL: users/{uid}/photo/{photoId}
			def Get(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/photo/' + str(self._get('Photoid')) + '', 'GET', body, element_name, **kwargs)
			
		
		class _Vendors(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/vendors
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/vendors', 'GET', body, element_name, **kwargs)
			
		
		class _Usage(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/usage
			def Get(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/usage', 'GET', body, element_name, **kwargs)
			
		
		class _Orgs(_CommonAPIClass):
			def __call__(self, Oid=None):
				self.Oid = Oid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/orgs
			def Getall(self, Name, body=None, element_name=None):
				kwargs = {'name': Name}
				return self._REST('/users/' + str(self._get('Uid')) + '/orgs', 'GET', body, element_name, **kwargs)
			
			#URL: users/{uid}/orgs/{oid}
			def Change(self, Admin, body=None, element_name=None):
				kwargs = {'admin': Admin}
				return self._REST('/users/' + str(self._get('Uid')) + '/orgs/' + str(self._get('Oid')) + '', 'PUT', body, element_name, **kwargs)
			
			#URL: users/{uid}/orgs/{oid}
			def Remove(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/orgs/' + str(self._get('Oid')) + '', 'DELETE', body, element_name, **kwargs)
			
		
		class _Apikeys(_CommonAPIClass):
			def __call__(self, Akid=None):
				self.Akid = Akid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/apikeys
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/apikeys', 'GET', body, element_name, **kwargs)
			
			#URL: users/{uid}/apikeys
			def Create(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/apikeys', 'POST', body, element_name, **kwargs)
			
			#URL: users/{uid}/apikeys/{akid}
			def Delete(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/apikeys/' + str(self._get('Akid')) + '', 'DELETE', body, element_name, **kwargs)
			
		
	
	class _Maintenance(_CommonAPIClass):
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Productdownloads = Api._Maintenance._Productdownloads(self)
			self.Productdates = Api._Maintenance._Productdates(self)
			self.Updatetalenddefaultsupportplan = Api._Maintenance._Updatetalenddefaultsupportplan(self)
			self.Comments = Api._Maintenance._Comments(self)
			self.Flatcategories = Api._Maintenance._Flatcategories(self)
			pass
		
		class _Productdownloads(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: maintenance/productdownloads
			def Maintainmarketplaceproductdownloads(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/maintenance//productdownloads', 'POST', body, element_name, **kwargs)
			
		
		class _Productdates(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: maintenance/productdates
			def Maintainmarketplaceproducts(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/maintenance//productdates', 'POST', body, element_name, **kwargs)
			
		
		class _Updatetalenddefaultsupportplan(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: maintenance/updateTalendDefaultSupportPlan
			def Maintenanceupdatetalenddefaultsupportplan(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/maintenance//updateTalendDefaultSupportPlan', 'POST', body, element_name, **kwargs)
			
		
		class _Comments(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: maintenance/comments
			def Maintainmarketplacecommentdates(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/maintenance//comments', 'POST', body, element_name, **kwargs)
			
		
		class _Flatcategories(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: maintenance/flatcategories
			def Maintainmarketplacecategories(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/maintenance//flatcategories', 'POST', body, element_name, **kwargs)
			
		
	
	class _Entitlements(_CommonAPIClass):
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			pass
		
		#URL: entitlements
		def Getall(self, body=None, element_name=None):
			kwargs = {}
			return self._REST('/entitlements', 'GET', body, element_name, **kwargs)
		
	
	class _Orgs(_CommonAPIClass):
		def __call__(self, Oid=None):
			self.Oid = Oid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Vendors = Api._Orgs._Vendors(self)
			self.Categories = Api._Orgs._Categories(self)
			self.Roles = Api._Orgs._Roles(self)
			self.Members = Api._Orgs._Members(self)
			self.Subscriptions = Api._Orgs._Subscriptions(self)
			pass
		
		#URL: orgs/{oid}
		def Get(self, body=None, element_name=None):
			kwargs = {}
			return self._REST('/orgs/' + str(self._get('Oid')) + '', 'GET', body, element_name, **kwargs)
		
		#URL: orgs
		def Create(self, Autoactivate, body=None, element_name=None):
			kwargs = {'autoActivate': Autoactivate}
			return self._REST('/orgs', 'POST', body, element_name, **kwargs)
		
		#URL: orgs
		def Getall(self, body=None, element_name=None):
			kwargs = {}
			return self._REST('/orgs', 'GET', body, element_name, **kwargs)
		class _Vendors(_CommonAPIClass):
			def __call__(self, Vid=None):
				self.Vid = Vid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Purchases = Api._Orgs._Vendors._Purchases(self)
				self.Pricingplans = Api._Orgs._Vendors._Pricingplans(self)
				self.Billing = Api._Orgs._Vendors._Billing(self)
				self.Approvals = Api._Orgs._Vendors._Approvals(self)
				self.Marketingplans = Api._Orgs._Vendors._Marketingplans(self)
				self.Products = Api._Orgs._Vendors._Products(self)
				self.Members = Api._Orgs._Vendors._Members(self)
				self.Logo = Api._Orgs._Vendors._Logo(self)
				self.Supportplans = Api._Orgs._Vendors._Supportplans(self)
				pass
			
			#URL: orgs/{oid}/vendors
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors', 'GET', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/vendors/{vid}
			def Update(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '', 'PUT', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/vendors
			def Create(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors', 'POST', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/vendors/{vid}
			def Delete(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '', 'DELETE', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/vendors/{vid}
			def Getdetails(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '', 'GET', body, element_name, **kwargs)
			class _Purchases(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/vendors/{vid}/purchases
				def Getall(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/purchases', 'GET', body, element_name, **kwargs)
				
			
			class _Pricingplans(_CommonAPIClass):
				def __call__(self, Ppid=None):
					self.Ppid = Ppid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Clones = Api._Orgs._Vendors._Pricingplans._Clones(self)
					self.Editions = Api._Orgs._Vendors._Pricingplans._Editions(self)
					self.Productitems = Api._Orgs._Vendors._Pricingplans._Productitems(self)
					pass
				
				#URL: orgs/{oid}/vendors/{vid}/pricingplans
				def Getall(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans', 'GET', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/pricingplans/{ppid}
				def Update(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans/' + str(self._get('Ppid')) + '', 'PUT', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/pricingplans
				def Create(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans', 'POST', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/pricingplans/{ppid}
				def Delete(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans/' + str(self._get('Ppid')) + '', 'DELETE', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/pricingplans/{ppid}
				def Get(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans/' + str(self._get('Ppid')) + '', 'GET', body, element_name, **kwargs)
				class _Clones(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/vendors/{vid}/pricingplans/{ppid}/clones
					def Clone(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans/' + str(self._get('Ppid')) + '/clones', 'POST', body, element_name, **kwargs)
					
				
				class _Editions(_CommonAPIClass):
					def __call__(self, Eid=None):
						self.Eid = Eid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/vendors/{vid}/pricingplans/{ppid}/editions/{eid}
					def Update(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans/' + str(self._get('Ppid')) + '/editions/' + str(self._get('Eid')) + '', 'PUT', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/pricingplans/{ppid}/editions
					def Create(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans/' + str(self._get('Ppid')) + '/editions', 'POST', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/pricingplans/{ppid}/editions/{eid}
					def Get(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans/' + str(self._get('Ppid')) + '/editions/' + str(self._get('Eid')) + '', 'GET', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/pricingplans/{ppid}/editions/{eid}
					def Delete(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans/' + str(self._get('Ppid')) + '/editions/' + str(self._get('Eid')) + '', 'DELETE', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/pricingplans/{ppid}/editions
					def Getall(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans/' + str(self._get('Ppid')) + '/editions', 'GET', body, element_name, **kwargs)
					
				
				class _Productitems(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/vendors/{vid}/pricingplans/{ppid}/productitems
					def Getlistings(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/pricingplans/' + str(self._get('Ppid')) + '/productitems', 'GET', body, element_name, **kwargs)
					
				
			
			class _Billing(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Token = Api._Orgs._Vendors._Billing._Token(self)
					pass
				
				#URL: orgs/{oid}/vendors/{vid}/billing
				def Get(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/billing', 'GET', body, element_name, **kwargs)
				class _Token(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/vendors/{vid}/billing/token
					def Renewcredentials(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/billing/token', 'PUT', body, element_name, **kwargs)
					
				
			
			class _Approvals(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/vendors/{vid}/approvals
				def Getall(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/approvals', 'GET', body, element_name, **kwargs)
				
			
			class _Marketingplans(_CommonAPIClass):
				def __call__(self, Mpid=None):
					self.Mpid = Mpid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Clones = Api._Orgs._Vendors._Marketingplans._Clones(self)
					self.Logo = Api._Orgs._Vendors._Marketingplans._Logo(self)
					self.Screenshots = Api._Orgs._Vendors._Marketingplans._Screenshots(self)
					self.Productitems = Api._Orgs._Vendors._Marketingplans._Productitems(self)
					pass
				
				#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}
				def Get(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '', 'GET', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}
				def Update(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '', 'PUT', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/marketingplans
				def Create(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans', 'POST', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/marketingplans
				def Getall(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans', 'GET', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}
				def Delete(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '', 'DELETE', body, element_name, **kwargs)
				class _Clones(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/clones
					def Clone(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/clones', 'POST', body, element_name, **kwargs)
					
				
				class _Logo(_CommonAPIClass):
					def __call__(self, Logoid=None, Filename=None):
						self.Logoid = Logoid
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/logo/{logoId}/{fileName}
					def Upload(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/logo/{logoId}
					def Delete(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/logo/' + str(self._get('Logoid')) + '', 'DELETE', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/logo/{logoId}
					def Get(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/logo/' + str(self._get('Logoid')) + '', 'GET', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/logo/{logoId}/{fileName}
					def Getfilename(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, **kwargs)
					
				
				class _Screenshots(_CommonAPIClass):
					def __call__(self, Ssid=None, Filename=None):
						self.Ssid = Ssid
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/screenshots/{ssid}/{fileName}
					def Download(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/screenshots/' + str(self._get('Ssid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/screenshots
					def Create(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/screenshots', 'POST', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/screenshots/{ssid}/{fileName}
					def Upload(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/screenshots/' + str(self._get('Ssid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/screenshots/{ssid}
					def Get(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/screenshots/' + str(self._get('Ssid')) + '', 'GET', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/screenshots/{ssid}
					def Delete(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/screenshots/' + str(self._get('Ssid')) + '', 'DELETE', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/screenshots/{ssid}
					def Update(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/screenshots/' + str(self._get('Ssid')) + '', 'PUT', body, element_name, **kwargs)
					
				
				class _Productitems(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/vendors/{vid}/marketingplans/{mpid}/productitems
					def Getlistings(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/marketingplans/' + str(self._get('Mpid')) + '/productitems', 'GET', body, element_name, **kwargs)
					
				
			
			class _Products(_CommonAPIClass):
				def __call__(self, Pid=None):
					self.Pid = Pid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Purchases = Api._Orgs._Vendors._Products._Purchases(self)
					self.Items = Api._Orgs._Vendors._Products._Items(self)
					pass
				
				#URL: orgs/{oid}/vendors/{vid}/products/{pid}
				def Update(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '', 'PUT', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/products
				def Create(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products', 'POST', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/products/{pid}
				def Get(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '', 'GET', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/products/{pid}
				def Delete(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '', 'DELETE', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/products
				def Getall(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products', 'GET', body, element_name, **kwargs)
				class _Purchases(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/vendors/{vid}/products/{pid}/purchases
					def Getall(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/purchases', 'GET', body, element_name, **kwargs)
					
				
				class _Items(_CommonAPIClass):
					def __call__(self, Piid=None):
						self.Piid = Piid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Artifacts = Api._Orgs._Vendors._Products._Items._Artifacts(self)
						self.Approvals = Api._Orgs._Vendors._Products._Items._Approvals(self)
						self.Comments = Api._Orgs._Vendors._Products._Items._Comments(self)
						self.Purchases = Api._Orgs._Vendors._Products._Items._Purchases(self)
						pass
					
					#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items
					def Getall(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items', 'GET', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}
					def Update(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '', 'PUT', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}
					def Delete(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '', 'DELETE', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items
					def Create(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items', 'POST', body, element_name, **kwargs)
					
					#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}
					def Get(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '', 'GET', body, element_name, **kwargs)
					class _Artifacts(_CommonAPIClass):
						def __call__(self, Aid=None, Bpiid=None):
							self.Aid = Aid
							self.Bpiid = Bpiid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							self.Bin = Api._Orgs._Vendors._Products._Items._Artifacts._Bin(self)
							self.Downloads = Api._Orgs._Vendors._Products._Items._Artifacts._Downloads(self)
							pass
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/artifacts/{bpiid}
						def Get(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts/' + str(self._get('Bpiid')) + '', 'GET', body, element_name, **kwargs)
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/artifacts/{aid}
						def Update(self, Uforgeaccountid, body=None, element_name=None):
							kwargs = {'uforgeaccountid': Uforgeaccountid}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts/' + str(self._get('Aid')) + '', 'PUT', body, element_name, **kwargs)
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/artifacts
						def Delete(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts', 'DELETE', body, element_name, **kwargs)
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/artifacts
						def Getall(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts', 'GET', body, element_name, **kwargs)
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/artifacts
						def Add(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts', 'POST', body, element_name, **kwargs)
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/artifacts/{bpiid}
						def Delete(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts/' + str(self._get('Bpiid')) + '', 'DELETE', body, element_name, **kwargs)
						class _Bin(_CommonAPIClass):
							def __call__(self, Filename=None):
								self.Filename = Filename
								return self
						
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/artifacts/{bpiid}/bin
							def Download(self, Downloadid, body=None, element_name=None):
								kwargs = {'downloadId': Downloadid}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts/' + str(self._get('Bpiid')) + '/bin', 'GET', body, element_name, **kwargs)
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/artifacts/{bpiid}/bin/{fileName}
							def Upload(self, body=None, element_name=None):
								kwargs = {}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts/' + str(self._get('Bpiid')) + '/bin/' + str(self._get('Filename')) + '', 'POST', body, element_name, **kwargs)
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/artifacts/{bpiid}/bin/{fileName}
							def Downloadfilename(self, Downloadid, body=None, element_name=None):
								kwargs = {'downloadId': Downloadid}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts/' + str(self._get('Bpiid')) + '/bin/' + str(self._get('Filename')) + '', 'GET', body, element_name, **kwargs)
							
						
						class _Downloads(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/artifacts/{bpiid}/downloads
							def Downloadrequest(self, body=None, element_name=None):
								kwargs = {}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/artifacts/' + str(self._get('Bpiid')) + '/downloads', 'POST', body, element_name, **kwargs)
							
						
					
					class _Approvals(_CommonAPIClass):
						def __call__(self, Apiid=None):
							self.Apiid = Apiid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							self.Comments = Api._Orgs._Vendors._Products._Items._Approvals._Comments(self)
							pass
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/approvals/{apiid}
						def Update(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/approvals/' + str(self._get('Apiid')) + '', 'PUT', body, element_name, **kwargs)
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/approvals/{apiid}
						def Get(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/approvals/' + str(self._get('Apiid')) + '', 'GET', body, element_name, **kwargs)
						class _Comments(_CommonAPIClass):
							def __call__(self, Cid=None):
								self.Cid = Cid
								return self
						
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								self.Abuses = Api._Orgs._Vendors._Products._Items._Approvals._Comments._Abuses(self)
								self.Replies = Api._Orgs._Vendors._Products._Items._Approvals._Comments._Replies(self)
								pass
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/approvals/{apiid}/comments/{cid}
							def Delete(self, body=None, element_name=None):
								kwargs = {}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/approvals/' + str(self._get('Apiid')) + '/comments/' + str(self._get('Cid')) + '', 'DELETE', body, element_name, **kwargs)
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/approvals/{apiid}/comments/{cid}
							def Get(self, body=None, element_name=None):
								kwargs = {}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/approvals/' + str(self._get('Apiid')) + '/comments/' + str(self._get('Cid')) + '', 'GET', body, element_name, **kwargs)
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/approvals/{apiid}/comments
							def Getall(self, body=None, element_name=None):
								kwargs = {}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/approvals/' + str(self._get('Apiid')) + '/comments', 'GET', body, element_name, **kwargs)
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/approvals/{apiid}/comments
							def Create(self, body=None, element_name=None):
								kwargs = {}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/approvals/' + str(self._get('Apiid')) + '/comments', 'POST', body, element_name, **kwargs)
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/approvals/{apiid}/comments/{cid}
							def Update(self, body=None, element_name=None):
								kwargs = {}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/approvals/' + str(self._get('Apiid')) + '/comments/' + str(self._get('Cid')) + '', 'PUT', body, element_name, **kwargs)
							class _Abuses(_CommonAPIClass):
								def __init__(self, parent, **kwargs):
									self._parent = parent
									self.__dict__.update(kwargs)
									pass
								
								#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/approvals/{apiid}/comments/{cid}/abuses
								def Report(self, body=None, element_name=None):
									kwargs = {}
									return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/approvals/' + str(self._get('Apiid')) + '/comments/' + str(self._get('Cid')) + '/abuses', 'POST', body, element_name, **kwargs)
								
							
							class _Replies(_CommonAPIClass):
								def __init__(self, parent, **kwargs):
									self._parent = parent
									self.__dict__.update(kwargs)
									pass
								
								#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/approvals/{apiid}/comments/{cid}/replies
								def Reply(self, body=None, element_name=None):
									kwargs = {}
									return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/approvals/' + str(self._get('Apiid')) + '/comments/' + str(self._get('Cid')) + '/replies', 'POST', body, element_name, **kwargs)
								
							
						
					
					class _Comments(_CommonAPIClass):
						def __call__(self, Cid=None):
							self.Cid = Cid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							self.Abuses = Api._Orgs._Vendors._Products._Items._Comments._Abuses(self)
							self.Likes = Api._Orgs._Vendors._Products._Items._Comments._Likes(self)
							self.Replies = Api._Orgs._Vendors._Products._Items._Comments._Replies(self)
							pass
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/comments/{cid}
						def Update(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '', 'PUT', body, element_name, **kwargs)
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/comments/{cid}
						def Get(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '', 'GET', body, element_name, **kwargs)
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/comments/{cid}
						def Delete(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '', 'DELETE', body, element_name, **kwargs)
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/comments
						def Getall(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments', 'GET', body, element_name, **kwargs)
						class _Abuses(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/comments/{cid}/abuses
							def Report(self, body=None, element_name=None):
								kwargs = {}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '/abuses', 'POST', body, element_name, **kwargs)
							
						
						class _Likes(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/comments/{cid}/likes
							def Like(self, body=None, element_name=None):
								kwargs = {}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '/likes', 'POST', body, element_name, **kwargs)
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/comments/{cid}/likes
							def Dislike(self, body=None, element_name=None):
								kwargs = {}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '/likes', 'DELETE', body, element_name, **kwargs)
							
						
						class _Replies(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/comments/{cid}/replies
							def Reply(self, body=None, element_name=None):
								kwargs = {}
								return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/comments/' + str(self._get('Cid')) + '/replies', 'POST', body, element_name, **kwargs)
							
						
					
					class _Purchases(_CommonAPIClass):
						def __call__(self, Puid=None):
							self.Puid = Puid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/purchases/{puid}
						def Get(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/purchases/' + str(self._get('Puid')) + '', 'GET', body, element_name, **kwargs)
						
						#URL: orgs/{oid}/vendors/{vid}/products/{pid}/items/{piid}/purchases
						def Getall(self, body=None, element_name=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/products/' + str(self._get('Pid')) + '/items/' + str(self._get('Piid')) + '/purchases', 'GET', body, element_name, **kwargs)
						
					
				
			
			class _Members(_CommonAPIClass):
				def __call__(self, Vmid=None):
					self.Vmid = Vmid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/vendors/{vid}/members/{vmid}
				def Remove(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/members/' + str(self._get('Vmid')) + '', 'DELETE', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/members
				def Add(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/members', 'POST', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/members
				def Getall(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/members', 'GET', body, element_name, **kwargs)
				
			
			class _Logo(_CommonAPIClass):
				def __call__(self, Logoid=None, Filename=None):
					self.Logoid = Logoid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/vendors/{vid}/logo/{logoId}/{fileName}
				def Upload(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/logo/{logoId}
				def Get(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/logo/' + str(self._get('Logoid')) + '', 'GET', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/logo/{logoId}
				def Delete(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/logo/' + str(self._get('Logoid')) + '', 'DELETE', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/logo/{logoId}/{fileName}
				def Getfilename(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, **kwargs)
				
			
			class _Supportplans(_CommonAPIClass):
				def __call__(self, Spid=None):
					self.Spid = Spid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Productitems = Api._Orgs._Vendors._Supportplans._Productitems(self)
					pass
				
				#URL: orgs/{oid}/vendors/{vid}/supportplans/{spid}
				def Delete(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/supportplans/' + str(self._get('Spid')) + '', 'DELETE', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/supportplans/{spid}
				def Get(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/supportplans/' + str(self._get('Spid')) + '', 'GET', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/supportplans
				def Getall(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/supportplans', 'GET', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/supportplans
				def Create(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/supportplans', 'POST', body, element_name, **kwargs)
				
				#URL: orgs/{oid}/vendors/{vid}/supportplans/{spid}
				def Update(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/supportplans/' + str(self._get('Spid')) + '', 'PUT', body, element_name, **kwargs)
				class _Productitems(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/vendors/{vid}/supportplans/{spid}/productitems
					def Getlistings(self, body=None, element_name=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/vendors/' + str(self._get('Vid')) + '/supportplans/' + str(self._get('Spid')) + '/productitems', 'GET', body, element_name, **kwargs)
					
				
			
		
		class _Categories(_CommonAPIClass):
			def __call__(self, Cid=None):
				self.Cid = Cid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Subcategories = Api._Orgs._Categories._Subcategories(self)
				pass
			
			#URL: orgs/{oid}/categories
			def Create(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories', 'POST', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/categories/{cid}
			def Delete(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories/' + str(self._get('Cid')) + '', 'DELETE', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/categories/{cid}
			def Update(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories/' + str(self._get('Cid')) + '', 'PUT', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/categories/{cid}
			def Get(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories/' + str(self._get('Cid')) + '', 'GET', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/categories
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories', 'GET', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/categories
			def Reset(self, Reset, body=None, element_name=None):
				kwargs = {'reset': Reset}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories', 'DELETE', body, element_name, **kwargs)
			class _Subcategories(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/categories/{cid}/subcategories
				def Createchild(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/categories/' + str(self._get('Cid')) + '/subcategories', 'POST', body, element_name, **kwargs)
				
			
		
		class _Roles(_CommonAPIClass):
			def __call__(self, Rolename=None):
				self.Rolename = Rolename
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/roles
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/roles', 'GET', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/roles
			def Create(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/roles', 'POST', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/roles/{rolename}
			def Delete(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/roles/' + str(self._get('Rolename')) + '', 'DELETE', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/roles
			def Update(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/roles', 'PUT', body, element_name, **kwargs)
			
		
		class _Members(_CommonAPIClass):
			def __call__(self, Uid=None):
				self.Uid = Uid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/members/{uid}
			def Change(self, Admin, body=None, element_name=None):
				kwargs = {'admin': Admin}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/members/' + str(self._get('Uid')) + '', 'PUT', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/members
			def Getall(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/members', 'GET', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/members/{uid}
			def Remove(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/members/' + str(self._get('Uid')) + '', 'DELETE', body, element_name, **kwargs)
			
		
		class _Subscriptions(_CommonAPIClass):
			def __call__(self, Spid=None):
				self.Spid = Spid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Admins = Api._Orgs._Subscriptions._Admins(self)
				self.Quotas = Api._Orgs._Subscriptions._Quotas(self)
				self.Roles = Api._Orgs._Subscriptions._Roles(self)
				pass
			
			#URL: orgs/{oid}/subscriptions
			def Add(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions', 'POST', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/subscriptions/{spid}
			def Get(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '', 'GET', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/subscriptions/{spid}
			def Update(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '', 'PUT', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/subscriptions/{spid}
			def Remove(self, body=None, element_name=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '', 'DELETE', body, element_name, **kwargs)
			
			#URL: orgs/{oid}/subscriptions
			def Getall(self, Search, body=None, element_name=None):
				kwargs = {'search': Search}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions', 'GET', body, element_name, **kwargs)
			class _Admins(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/admins
				def Update(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/admins', 'PUT', body, element_name, **kwargs)
				
			
			class _Quotas(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/quotas
				def Update(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/quotas', 'PUT', body, element_name, **kwargs)
				
			
			class _Roles(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/roles
				def Update(self, body=None, element_name=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/roles', 'PUT', body, element_name, **kwargs)
				
			
		
	
