import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface Aadb2CDirectoryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Country code of the B2C tenant. See https://aka.ms/B2CDataResidency for valid country codes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#country_code Aadb2CDirectory#country_code}
     *
     * @stability stable
     */
    readonly countryCode?: string;
    /**
     * Location in which the B2C tenant is hosted and data resides. See https://aka.ms/B2CDataResidency for more information.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#data_residency_location Aadb2CDirectory#data_residency_location}
     *
     * @stability stable
     */
    readonly dataResidencyLocation: string;
    /**
     * The initial display name of the B2C tenant.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#display_name Aadb2CDirectory#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Domain name of the B2C tenant, including onmicrosoft.com suffix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#domain_name Aadb2CDirectory#domain_name}
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#resource_group_name Aadb2CDirectory#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Billing SKU for the B2C tenant. See https://aka.ms/b2cBilling for more information.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#sku_name Aadb2CDirectory#sku_name}
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#tags Aadb2CDirectory#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#timeouts Aadb2CDirectory#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: Aadb2CDirectoryTimeouts;
}
/**
 * @stability stable
 */
export interface Aadb2CDirectoryTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#create Aadb2CDirectory#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#delete Aadb2CDirectory#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#read Aadb2CDirectory#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory#update Aadb2CDirectory#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function aadb2CDirectoryTimeoutsToTerraform(struct?: Aadb2CDirectoryTimeoutsOutputReference | Aadb2CDirectoryTimeouts): any;
/**
 * @stability stable
 */
export declare class Aadb2CDirectoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): Aadb2CDirectoryTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: Aadb2CDirectoryTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory azurerm_aadb2c_directory}.
 *
 * @stability stable
 */
export declare class Aadb2CDirectory extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/aadb2c_directory azurerm_aadb2c_directory} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: Aadb2CDirectoryConfig);
    /**
     * @stability stable
     */
    get billingType(): string;
    private _countryCode?;
    /**
     * @stability stable
     */
    get countryCode(): string;
    /**
     * @stability stable
     */
    set countryCode(value: string);
    /**
     * @stability stable
     */
    resetCountryCode(): void;
    /**
     * @stability stable
     */
    get countryCodeInput(): string | undefined;
    private _dataResidencyLocation?;
    /**
     * @stability stable
     */
    get dataResidencyLocation(): string;
    /**
     * @stability stable
     */
    set dataResidencyLocation(value: string);
    /**
     * @stability stable
     */
    get dataResidencyLocationInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    set domainName(value: string);
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get effectiveStartDate(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): Aadb2CDirectoryTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: Aadb2CDirectoryTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): Aadb2CDirectoryTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
