import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AdvancedThreatProtectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/advanced_threat_protection#enabled AdvancedThreatProtection#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/advanced_threat_protection#target_resource_id AdvancedThreatProtection#target_resource_id}.
     *
     * @stability stable
     */
    readonly targetResourceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/advanced_threat_protection#timeouts AdvancedThreatProtection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AdvancedThreatProtectionTimeouts;
}
/**
 * @stability stable
 */
export interface AdvancedThreatProtectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/advanced_threat_protection#create AdvancedThreatProtection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/advanced_threat_protection#delete AdvancedThreatProtection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/advanced_threat_protection#read AdvancedThreatProtection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/advanced_threat_protection#update AdvancedThreatProtection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function advancedThreatProtectionTimeoutsToTerraform(struct?: AdvancedThreatProtectionTimeoutsOutputReference | AdvancedThreatProtectionTimeouts): any;
/**
 * @stability stable
 */
export declare class AdvancedThreatProtectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AdvancedThreatProtectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AdvancedThreatProtectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/advanced_threat_protection azurerm_advanced_threat_protection}.
 *
 * @stability stable
 */
export declare class AdvancedThreatProtection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/advanced_threat_protection azurerm_advanced_threat_protection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AdvancedThreatProtectionConfig);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _targetResourceId?;
    /**
     * @stability stable
     */
    get targetResourceId(): string;
    /**
     * @stability stable
     */
    set targetResourceId(value: string);
    /**
     * @stability stable
     */
    get targetResourceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AdvancedThreatProtectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AdvancedThreatProtectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AdvancedThreatProtectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
