import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#always_log_errors ApiManagementApiDiagnostic#always_log_errors}.
     *
     * @stability stable
     */
    readonly alwaysLogErrors?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#api_management_logger_id ApiManagementApiDiagnostic#api_management_logger_id}.
     *
     * @stability stable
     */
    readonly apiManagementLoggerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#api_management_name ApiManagementApiDiagnostic#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#api_name ApiManagementApiDiagnostic#api_name}.
     *
     * @stability stable
     */
    readonly apiName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#http_correlation_protocol ApiManagementApiDiagnostic#http_correlation_protocol}.
     *
     * @stability stable
     */
    readonly httpCorrelationProtocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#identifier ApiManagementApiDiagnostic#identifier}.
     *
     * @stability stable
     */
    readonly identifier: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#log_client_ip ApiManagementApiDiagnostic#log_client_ip}.
     *
     * @stability stable
     */
    readonly logClientIp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#operation_name_format ApiManagementApiDiagnostic#operation_name_format}.
     *
     * @stability stable
     */
    readonly operationNameFormat?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#resource_group_name ApiManagementApiDiagnostic#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#sampling_percentage ApiManagementApiDiagnostic#sampling_percentage}.
     *
     * @stability stable
     */
    readonly samplingPercentage?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#verbosity ApiManagementApiDiagnostic#verbosity}.
     *
     * @stability stable
     */
    readonly verbosity?: string;
    /**
     * backend_request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#backend_request ApiManagementApiDiagnostic#backend_request}
     *
     * @stability stable
     */
    readonly backendRequest?: ApiManagementApiDiagnosticBackendRequest;
    /**
     * backend_response block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#backend_response ApiManagementApiDiagnostic#backend_response}
     *
     * @stability stable
     */
    readonly backendResponse?: ApiManagementApiDiagnosticBackendResponse;
    /**
     * frontend_request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#frontend_request ApiManagementApiDiagnostic#frontend_request}
     *
     * @stability stable
     */
    readonly frontendRequest?: ApiManagementApiDiagnosticFrontendRequest;
    /**
     * frontend_response block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#frontend_response ApiManagementApiDiagnostic#frontend_response}
     *
     * @stability stable
     */
    readonly frontendResponse?: ApiManagementApiDiagnosticFrontendResponse;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#timeouts ApiManagementApiDiagnostic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementApiDiagnosticTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticBackendRequestDataMaskingHeadersToTerraform(struct?: ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders): any;
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticBackendRequestDataMaskingQueryParamsToTerraform(struct?: ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams): any;
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticBackendRequestDataMasking {
    /**
     * headers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers ApiManagementApiDiagnostic#headers}
     *
     * @stability stable
     */
    readonly headers?: ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders[];
    /**
     * query_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#query_params ApiManagementApiDiagnostic#query_params}
     *
     * @stability stable
     */
    readonly queryParams?: ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams[];
}
export declare function apiManagementApiDiagnosticBackendRequestDataMaskingToTerraform(struct?: ApiManagementApiDiagnosticBackendRequestDataMaskingOutputReference | ApiManagementApiDiagnosticBackendRequestDataMasking): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiDiagnosticBackendRequestDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiDiagnosticBackendRequestDataMasking | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiDiagnosticBackendRequestDataMasking | undefined);
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders[];
    /**
     * @stability stable
     */
    set headers(value: ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders[]);
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): ApiManagementApiDiagnosticBackendRequestDataMaskingHeaders[] | undefined;
    private _queryParams?;
    /**
     * @stability stable
     */
    get queryParams(): ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams[];
    /**
     * @stability stable
     */
    set queryParams(value: ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams[]);
    /**
     * @stability stable
     */
    resetQueryParams(): void;
    /**
     * @stability stable
     */
    get queryParamsInput(): ApiManagementApiDiagnosticBackendRequestDataMaskingQueryParams[] | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticBackendRequest {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#body_bytes ApiManagementApiDiagnostic#body_bytes}.
     *
     * @stability stable
     */
    readonly bodyBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers_to_log ApiManagementApiDiagnostic#headers_to_log}.
     *
     * @stability stable
     */
    readonly headersToLog?: string[];
    /**
     * data_masking block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#data_masking ApiManagementApiDiagnostic#data_masking}
     *
     * @stability stable
     */
    readonly dataMasking?: ApiManagementApiDiagnosticBackendRequestDataMasking;
}
export declare function apiManagementApiDiagnosticBackendRequestToTerraform(struct?: ApiManagementApiDiagnosticBackendRequestOutputReference | ApiManagementApiDiagnosticBackendRequest): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiDiagnosticBackendRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiDiagnosticBackendRequest | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiDiagnosticBackendRequest | undefined);
    private _bodyBytes?;
    /**
     * @stability stable
     */
    get bodyBytes(): number;
    /**
     * @stability stable
     */
    set bodyBytes(value: number);
    /**
     * @stability stable
     */
    resetBodyBytes(): void;
    /**
     * @stability stable
     */
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    /**
     * @stability stable
     */
    get headersToLog(): string[];
    /**
     * @stability stable
     */
    set headersToLog(value: string[]);
    /**
     * @stability stable
     */
    resetHeadersToLog(): void;
    /**
     * @stability stable
     */
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    /**
     * @stability stable
     */
    get dataMasking(): ApiManagementApiDiagnosticBackendRequestDataMaskingOutputReference;
    /**
     * @stability stable
     */
    putDataMasking(value: ApiManagementApiDiagnosticBackendRequestDataMasking): void;
    /**
     * @stability stable
     */
    resetDataMasking(): void;
    /**
     * @stability stable
     */
    get dataMaskingInput(): ApiManagementApiDiagnosticBackendRequestDataMasking | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticBackendResponseDataMaskingHeadersToTerraform(struct?: ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders): any;
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticBackendResponseDataMaskingQueryParamsToTerraform(struct?: ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams): any;
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticBackendResponseDataMasking {
    /**
     * headers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers ApiManagementApiDiagnostic#headers}
     *
     * @stability stable
     */
    readonly headers?: ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders[];
    /**
     * query_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#query_params ApiManagementApiDiagnostic#query_params}
     *
     * @stability stable
     */
    readonly queryParams?: ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams[];
}
export declare function apiManagementApiDiagnosticBackendResponseDataMaskingToTerraform(struct?: ApiManagementApiDiagnosticBackendResponseDataMaskingOutputReference | ApiManagementApiDiagnosticBackendResponseDataMasking): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiDiagnosticBackendResponseDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiDiagnosticBackendResponseDataMasking | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiDiagnosticBackendResponseDataMasking | undefined);
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders[];
    /**
     * @stability stable
     */
    set headers(value: ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders[]);
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): ApiManagementApiDiagnosticBackendResponseDataMaskingHeaders[] | undefined;
    private _queryParams?;
    /**
     * @stability stable
     */
    get queryParams(): ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams[];
    /**
     * @stability stable
     */
    set queryParams(value: ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams[]);
    /**
     * @stability stable
     */
    resetQueryParams(): void;
    /**
     * @stability stable
     */
    get queryParamsInput(): ApiManagementApiDiagnosticBackendResponseDataMaskingQueryParams[] | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticBackendResponse {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#body_bytes ApiManagementApiDiagnostic#body_bytes}.
     *
     * @stability stable
     */
    readonly bodyBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers_to_log ApiManagementApiDiagnostic#headers_to_log}.
     *
     * @stability stable
     */
    readonly headersToLog?: string[];
    /**
     * data_masking block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#data_masking ApiManagementApiDiagnostic#data_masking}
     *
     * @stability stable
     */
    readonly dataMasking?: ApiManagementApiDiagnosticBackendResponseDataMasking;
}
export declare function apiManagementApiDiagnosticBackendResponseToTerraform(struct?: ApiManagementApiDiagnosticBackendResponseOutputReference | ApiManagementApiDiagnosticBackendResponse): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiDiagnosticBackendResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiDiagnosticBackendResponse | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiDiagnosticBackendResponse | undefined);
    private _bodyBytes?;
    /**
     * @stability stable
     */
    get bodyBytes(): number;
    /**
     * @stability stable
     */
    set bodyBytes(value: number);
    /**
     * @stability stable
     */
    resetBodyBytes(): void;
    /**
     * @stability stable
     */
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    /**
     * @stability stable
     */
    get headersToLog(): string[];
    /**
     * @stability stable
     */
    set headersToLog(value: string[]);
    /**
     * @stability stable
     */
    resetHeadersToLog(): void;
    /**
     * @stability stable
     */
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    /**
     * @stability stable
     */
    get dataMasking(): ApiManagementApiDiagnosticBackendResponseDataMaskingOutputReference;
    /**
     * @stability stable
     */
    putDataMasking(value: ApiManagementApiDiagnosticBackendResponseDataMasking): void;
    /**
     * @stability stable
     */
    resetDataMasking(): void;
    /**
     * @stability stable
     */
    get dataMaskingInput(): ApiManagementApiDiagnosticBackendResponseDataMasking | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticFrontendRequestDataMaskingHeadersToTerraform(struct?: ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders): any;
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticFrontendRequestDataMaskingQueryParamsToTerraform(struct?: ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams): any;
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticFrontendRequestDataMasking {
    /**
     * headers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers ApiManagementApiDiagnostic#headers}
     *
     * @stability stable
     */
    readonly headers?: ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders[];
    /**
     * query_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#query_params ApiManagementApiDiagnostic#query_params}
     *
     * @stability stable
     */
    readonly queryParams?: ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams[];
}
export declare function apiManagementApiDiagnosticFrontendRequestDataMaskingToTerraform(struct?: ApiManagementApiDiagnosticFrontendRequestDataMaskingOutputReference | ApiManagementApiDiagnosticFrontendRequestDataMasking): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiDiagnosticFrontendRequestDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiDiagnosticFrontendRequestDataMasking | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiDiagnosticFrontendRequestDataMasking | undefined);
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders[];
    /**
     * @stability stable
     */
    set headers(value: ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders[]);
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): ApiManagementApiDiagnosticFrontendRequestDataMaskingHeaders[] | undefined;
    private _queryParams?;
    /**
     * @stability stable
     */
    get queryParams(): ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams[];
    /**
     * @stability stable
     */
    set queryParams(value: ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams[]);
    /**
     * @stability stable
     */
    resetQueryParams(): void;
    /**
     * @stability stable
     */
    get queryParamsInput(): ApiManagementApiDiagnosticFrontendRequestDataMaskingQueryParams[] | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticFrontendRequest {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#body_bytes ApiManagementApiDiagnostic#body_bytes}.
     *
     * @stability stable
     */
    readonly bodyBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers_to_log ApiManagementApiDiagnostic#headers_to_log}.
     *
     * @stability stable
     */
    readonly headersToLog?: string[];
    /**
     * data_masking block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#data_masking ApiManagementApiDiagnostic#data_masking}
     *
     * @stability stable
     */
    readonly dataMasking?: ApiManagementApiDiagnosticFrontendRequestDataMasking;
}
export declare function apiManagementApiDiagnosticFrontendRequestToTerraform(struct?: ApiManagementApiDiagnosticFrontendRequestOutputReference | ApiManagementApiDiagnosticFrontendRequest): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiDiagnosticFrontendRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiDiagnosticFrontendRequest | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiDiagnosticFrontendRequest | undefined);
    private _bodyBytes?;
    /**
     * @stability stable
     */
    get bodyBytes(): number;
    /**
     * @stability stable
     */
    set bodyBytes(value: number);
    /**
     * @stability stable
     */
    resetBodyBytes(): void;
    /**
     * @stability stable
     */
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    /**
     * @stability stable
     */
    get headersToLog(): string[];
    /**
     * @stability stable
     */
    set headersToLog(value: string[]);
    /**
     * @stability stable
     */
    resetHeadersToLog(): void;
    /**
     * @stability stable
     */
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    /**
     * @stability stable
     */
    get dataMasking(): ApiManagementApiDiagnosticFrontendRequestDataMaskingOutputReference;
    /**
     * @stability stable
     */
    putDataMasking(value: ApiManagementApiDiagnosticFrontendRequestDataMasking): void;
    /**
     * @stability stable
     */
    resetDataMasking(): void;
    /**
     * @stability stable
     */
    get dataMaskingInput(): ApiManagementApiDiagnosticFrontendRequestDataMasking | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticFrontendResponseDataMaskingHeadersToTerraform(struct?: ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders): any;
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#mode ApiManagementApiDiagnostic#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#value ApiManagementApiDiagnostic#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementApiDiagnosticFrontendResponseDataMaskingQueryParamsToTerraform(struct?: ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams): any;
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticFrontendResponseDataMasking {
    /**
     * headers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers ApiManagementApiDiagnostic#headers}
     *
     * @stability stable
     */
    readonly headers?: ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders[];
    /**
     * query_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#query_params ApiManagementApiDiagnostic#query_params}
     *
     * @stability stable
     */
    readonly queryParams?: ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams[];
}
export declare function apiManagementApiDiagnosticFrontendResponseDataMaskingToTerraform(struct?: ApiManagementApiDiagnosticFrontendResponseDataMaskingOutputReference | ApiManagementApiDiagnosticFrontendResponseDataMasking): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiDiagnosticFrontendResponseDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiDiagnosticFrontendResponseDataMasking | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiDiagnosticFrontendResponseDataMasking | undefined);
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders[];
    /**
     * @stability stable
     */
    set headers(value: ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders[]);
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): ApiManagementApiDiagnosticFrontendResponseDataMaskingHeaders[] | undefined;
    private _queryParams?;
    /**
     * @stability stable
     */
    get queryParams(): ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams[];
    /**
     * @stability stable
     */
    set queryParams(value: ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams[]);
    /**
     * @stability stable
     */
    resetQueryParams(): void;
    /**
     * @stability stable
     */
    get queryParamsInput(): ApiManagementApiDiagnosticFrontendResponseDataMaskingQueryParams[] | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticFrontendResponse {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#body_bytes ApiManagementApiDiagnostic#body_bytes}.
     *
     * @stability stable
     */
    readonly bodyBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#headers_to_log ApiManagementApiDiagnostic#headers_to_log}.
     *
     * @stability stable
     */
    readonly headersToLog?: string[];
    /**
     * data_masking block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#data_masking ApiManagementApiDiagnostic#data_masking}
     *
     * @stability stable
     */
    readonly dataMasking?: ApiManagementApiDiagnosticFrontendResponseDataMasking;
}
export declare function apiManagementApiDiagnosticFrontendResponseToTerraform(struct?: ApiManagementApiDiagnosticFrontendResponseOutputReference | ApiManagementApiDiagnosticFrontendResponse): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiDiagnosticFrontendResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiDiagnosticFrontendResponse | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiDiagnosticFrontendResponse | undefined);
    private _bodyBytes?;
    /**
     * @stability stable
     */
    get bodyBytes(): number;
    /**
     * @stability stable
     */
    set bodyBytes(value: number);
    /**
     * @stability stable
     */
    resetBodyBytes(): void;
    /**
     * @stability stable
     */
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    /**
     * @stability stable
     */
    get headersToLog(): string[];
    /**
     * @stability stable
     */
    set headersToLog(value: string[]);
    /**
     * @stability stable
     */
    resetHeadersToLog(): void;
    /**
     * @stability stable
     */
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    /**
     * @stability stable
     */
    get dataMasking(): ApiManagementApiDiagnosticFrontendResponseDataMaskingOutputReference;
    /**
     * @stability stable
     */
    putDataMasking(value: ApiManagementApiDiagnosticFrontendResponseDataMasking): void;
    /**
     * @stability stable
     */
    resetDataMasking(): void;
    /**
     * @stability stable
     */
    get dataMaskingInput(): ApiManagementApiDiagnosticFrontendResponseDataMasking | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiDiagnosticTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#create ApiManagementApiDiagnostic#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#delete ApiManagementApiDiagnostic#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#read ApiManagementApiDiagnostic#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic#update ApiManagementApiDiagnostic#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementApiDiagnosticTimeoutsToTerraform(struct?: ApiManagementApiDiagnosticTimeoutsOutputReference | ApiManagementApiDiagnosticTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiDiagnosticTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiDiagnosticTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiDiagnosticTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic azurerm_api_management_api_diagnostic}.
 *
 * @stability stable
 */
export declare class ApiManagementApiDiagnostic extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_diagnostic azurerm_api_management_api_diagnostic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementApiDiagnosticConfig);
    private _alwaysLogErrors?;
    /**
     * @stability stable
     */
    get alwaysLogErrors(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alwaysLogErrors(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAlwaysLogErrors(): void;
    /**
     * @stability stable
     */
    get alwaysLogErrorsInput(): boolean | cdktf.IResolvable | undefined;
    private _apiManagementLoggerId?;
    /**
     * @stability stable
     */
    get apiManagementLoggerId(): string;
    /**
     * @stability stable
     */
    set apiManagementLoggerId(value: string);
    /**
     * @stability stable
     */
    get apiManagementLoggerIdInput(): string | undefined;
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _apiName?;
    /**
     * @stability stable
     */
    get apiName(): string;
    /**
     * @stability stable
     */
    set apiName(value: string);
    /**
     * @stability stable
     */
    get apiNameInput(): string | undefined;
    private _httpCorrelationProtocol?;
    /**
     * @stability stable
     */
    get httpCorrelationProtocol(): string;
    /**
     * @stability stable
     */
    set httpCorrelationProtocol(value: string);
    /**
     * @stability stable
     */
    resetHttpCorrelationProtocol(): void;
    /**
     * @stability stable
     */
    get httpCorrelationProtocolInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _identifier?;
    /**
     * @stability stable
     */
    get identifier(): string;
    /**
     * @stability stable
     */
    set identifier(value: string);
    /**
     * @stability stable
     */
    get identifierInput(): string | undefined;
    private _logClientIp?;
    /**
     * @stability stable
     */
    get logClientIp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set logClientIp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLogClientIp(): void;
    /**
     * @stability stable
     */
    get logClientIpInput(): boolean | cdktf.IResolvable | undefined;
    private _operationNameFormat?;
    /**
     * @stability stable
     */
    get operationNameFormat(): string;
    /**
     * @stability stable
     */
    set operationNameFormat(value: string);
    /**
     * @stability stable
     */
    resetOperationNameFormat(): void;
    /**
     * @stability stable
     */
    get operationNameFormatInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _samplingPercentage?;
    /**
     * @stability stable
     */
    get samplingPercentage(): number;
    /**
     * @stability stable
     */
    set samplingPercentage(value: number);
    /**
     * @stability stable
     */
    resetSamplingPercentage(): void;
    /**
     * @stability stable
     */
    get samplingPercentageInput(): number | undefined;
    private _verbosity?;
    /**
     * @stability stable
     */
    get verbosity(): string;
    /**
     * @stability stable
     */
    set verbosity(value: string);
    /**
     * @stability stable
     */
    resetVerbosity(): void;
    /**
     * @stability stable
     */
    get verbosityInput(): string | undefined;
    private _backendRequest;
    /**
     * @stability stable
     */
    get backendRequest(): ApiManagementApiDiagnosticBackendRequestOutputReference;
    /**
     * @stability stable
     */
    putBackendRequest(value: ApiManagementApiDiagnosticBackendRequest): void;
    /**
     * @stability stable
     */
    resetBackendRequest(): void;
    /**
     * @stability stable
     */
    get backendRequestInput(): ApiManagementApiDiagnosticBackendRequest | undefined;
    private _backendResponse;
    /**
     * @stability stable
     */
    get backendResponse(): ApiManagementApiDiagnosticBackendResponseOutputReference;
    /**
     * @stability stable
     */
    putBackendResponse(value: ApiManagementApiDiagnosticBackendResponse): void;
    /**
     * @stability stable
     */
    resetBackendResponse(): void;
    /**
     * @stability stable
     */
    get backendResponseInput(): ApiManagementApiDiagnosticBackendResponse | undefined;
    private _frontendRequest;
    /**
     * @stability stable
     */
    get frontendRequest(): ApiManagementApiDiagnosticFrontendRequestOutputReference;
    /**
     * @stability stable
     */
    putFrontendRequest(value: ApiManagementApiDiagnosticFrontendRequest): void;
    /**
     * @stability stable
     */
    resetFrontendRequest(): void;
    /**
     * @stability stable
     */
    get frontendRequestInput(): ApiManagementApiDiagnosticFrontendRequest | undefined;
    private _frontendResponse;
    /**
     * @stability stable
     */
    get frontendResponse(): ApiManagementApiDiagnosticFrontendResponseOutputReference;
    /**
     * @stability stable
     */
    putFrontendResponse(value: ApiManagementApiDiagnosticFrontendResponse): void;
    /**
     * @stability stable
     */
    resetFrontendResponse(): void;
    /**
     * @stability stable
     */
    get frontendResponseInput(): ApiManagementApiDiagnosticFrontendResponse | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementApiDiagnosticTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementApiDiagnosticTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementApiDiagnosticTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
