import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementAuthorizationServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#api_management_name ApiManagementAuthorizationServer#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#authorization_endpoint ApiManagementAuthorizationServer#authorization_endpoint}.
     *
     * @stability stable
     */
    readonly authorizationEndpoint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#authorization_methods ApiManagementAuthorizationServer#authorization_methods}.
     *
     * @stability stable
     */
    readonly authorizationMethods: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#bearer_token_sending_methods ApiManagementAuthorizationServer#bearer_token_sending_methods}.
     *
     * @stability stable
     */
    readonly bearerTokenSendingMethods?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#client_authentication_method ApiManagementAuthorizationServer#client_authentication_method}.
     *
     * @stability stable
     */
    readonly clientAuthenticationMethod?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#client_id ApiManagementAuthorizationServer#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#client_registration_endpoint ApiManagementAuthorizationServer#client_registration_endpoint}.
     *
     * @stability stable
     */
    readonly clientRegistrationEndpoint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#client_secret ApiManagementAuthorizationServer#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#default_scope ApiManagementAuthorizationServer#default_scope}.
     *
     * @stability stable
     */
    readonly defaultScope?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#description ApiManagementAuthorizationServer#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#display_name ApiManagementAuthorizationServer#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#grant_types ApiManagementAuthorizationServer#grant_types}.
     *
     * @stability stable
     */
    readonly grantTypes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#name ApiManagementAuthorizationServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#resource_group_name ApiManagementAuthorizationServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#resource_owner_password ApiManagementAuthorizationServer#resource_owner_password}.
     *
     * @stability stable
     */
    readonly resourceOwnerPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#resource_owner_username ApiManagementAuthorizationServer#resource_owner_username}.
     *
     * @stability stable
     */
    readonly resourceOwnerUsername?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#support_state ApiManagementAuthorizationServer#support_state}.
     *
     * @stability stable
     */
    readonly supportState?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#token_endpoint ApiManagementAuthorizationServer#token_endpoint}.
     *
     * @stability stable
     */
    readonly tokenEndpoint?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#timeouts ApiManagementAuthorizationServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementAuthorizationServerTimeouts;
    /**
     * token_body_parameter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#token_body_parameter ApiManagementAuthorizationServer#token_body_parameter}
     *
     * @stability stable
     */
    readonly tokenBodyParameter?: ApiManagementAuthorizationServerTokenBodyParameter[];
}
/**
 * @stability stable
 */
export interface ApiManagementAuthorizationServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#create ApiManagementAuthorizationServer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#delete ApiManagementAuthorizationServer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#read ApiManagementAuthorizationServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#update ApiManagementAuthorizationServer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementAuthorizationServerTimeoutsToTerraform(struct?: ApiManagementAuthorizationServerTimeoutsOutputReference | ApiManagementAuthorizationServerTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementAuthorizationServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementAuthorizationServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementAuthorizationServerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementAuthorizationServerTokenBodyParameter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#name ApiManagementAuthorizationServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#value ApiManagementAuthorizationServer#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function apiManagementAuthorizationServerTokenBodyParameterToTerraform(struct?: ApiManagementAuthorizationServerTokenBodyParameter): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server azurerm_api_management_authorization_server}.
 *
 * @stability stable
 */
export declare class ApiManagementAuthorizationServer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server azurerm_api_management_authorization_server} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementAuthorizationServerConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _authorizationEndpoint?;
    /**
     * @stability stable
     */
    get authorizationEndpoint(): string;
    /**
     * @stability stable
     */
    set authorizationEndpoint(value: string);
    /**
     * @stability stable
     */
    get authorizationEndpointInput(): string | undefined;
    private _authorizationMethods?;
    /**
     * @stability stable
     */
    get authorizationMethods(): string[];
    /**
     * @stability stable
     */
    set authorizationMethods(value: string[]);
    /**
     * @stability stable
     */
    get authorizationMethodsInput(): string[] | undefined;
    private _bearerTokenSendingMethods?;
    /**
     * @stability stable
     */
    get bearerTokenSendingMethods(): string[];
    /**
     * @stability stable
     */
    set bearerTokenSendingMethods(value: string[]);
    /**
     * @stability stable
     */
    resetBearerTokenSendingMethods(): void;
    /**
     * @stability stable
     */
    get bearerTokenSendingMethodsInput(): string[] | undefined;
    private _clientAuthenticationMethod?;
    /**
     * @stability stable
     */
    get clientAuthenticationMethod(): string[];
    /**
     * @stability stable
     */
    set clientAuthenticationMethod(value: string[]);
    /**
     * @stability stable
     */
    resetClientAuthenticationMethod(): void;
    /**
     * @stability stable
     */
    get clientAuthenticationMethodInput(): string[] | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientRegistrationEndpoint?;
    /**
     * @stability stable
     */
    get clientRegistrationEndpoint(): string;
    /**
     * @stability stable
     */
    set clientRegistrationEndpoint(value: string);
    /**
     * @stability stable
     */
    get clientRegistrationEndpointInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    resetClientSecret(): void;
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _defaultScope?;
    /**
     * @stability stable
     */
    get defaultScope(): string;
    /**
     * @stability stable
     */
    set defaultScope(value: string);
    /**
     * @stability stable
     */
    resetDefaultScope(): void;
    /**
     * @stability stable
     */
    get defaultScopeInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _grantTypes?;
    /**
     * @stability stable
     */
    get grantTypes(): string[];
    /**
     * @stability stable
     */
    set grantTypes(value: string[]);
    /**
     * @stability stable
     */
    get grantTypesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _resourceOwnerPassword?;
    /**
     * @stability stable
     */
    get resourceOwnerPassword(): string;
    /**
     * @stability stable
     */
    set resourceOwnerPassword(value: string);
    /**
     * @stability stable
     */
    resetResourceOwnerPassword(): void;
    /**
     * @stability stable
     */
    get resourceOwnerPasswordInput(): string | undefined;
    private _resourceOwnerUsername?;
    /**
     * @stability stable
     */
    get resourceOwnerUsername(): string;
    /**
     * @stability stable
     */
    set resourceOwnerUsername(value: string);
    /**
     * @stability stable
     */
    resetResourceOwnerUsername(): void;
    /**
     * @stability stable
     */
    get resourceOwnerUsernameInput(): string | undefined;
    private _supportState?;
    /**
     * @stability stable
     */
    get supportState(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set supportState(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSupportState(): void;
    /**
     * @stability stable
     */
    get supportStateInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenEndpoint?;
    /**
     * @stability stable
     */
    get tokenEndpoint(): string;
    /**
     * @stability stable
     */
    set tokenEndpoint(value: string);
    /**
     * @stability stable
     */
    resetTokenEndpoint(): void;
    /**
     * @stability stable
     */
    get tokenEndpointInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementAuthorizationServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementAuthorizationServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementAuthorizationServerTimeouts | undefined;
    private _tokenBodyParameter?;
    /**
     * @stability stable
     */
    get tokenBodyParameter(): ApiManagementAuthorizationServerTokenBodyParameter[];
    /**
     * @stability stable
     */
    set tokenBodyParameter(value: ApiManagementAuthorizationServerTokenBodyParameter[]);
    /**
     * @stability stable
     */
    resetTokenBodyParameter(): void;
    /**
     * @stability stable
     */
    get tokenBodyParameterInput(): ApiManagementAuthorizationServerTokenBodyParameter[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
