import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementCustomDomainConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#api_management_id ApiManagementCustomDomain#api_management_id}.
     *
     * @stability stable
     */
    readonly apiManagementId: string;
    /**
     * developer_portal block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#developer_portal ApiManagementCustomDomain#developer_portal}
     *
     * @stability stable
     */
    readonly developerPortal?: ApiManagementCustomDomainDeveloperPortal[];
    /**
     * management block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#management ApiManagementCustomDomain#management}
     *
     * @stability stable
     */
    readonly management?: ApiManagementCustomDomainManagement[];
    /**
     * portal block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#portal ApiManagementCustomDomain#portal}
     *
     * @stability stable
     */
    readonly portal?: ApiManagementCustomDomainPortal[];
    /**
     * proxy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#proxy ApiManagementCustomDomain#proxy}
     *
     * @stability stable
     */
    readonly proxy?: ApiManagementCustomDomainProxy[];
    /**
     * scm block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#scm ApiManagementCustomDomain#scm}
     *
     * @stability stable
     */
    readonly scm?: ApiManagementCustomDomainScm[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#timeouts ApiManagementCustomDomain#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementCustomDomainTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementCustomDomainDeveloperPortal {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#certificate ApiManagementCustomDomain#certificate}.
     *
     * @stability stable
     */
    readonly certificate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#certificate_password ApiManagementCustomDomain#certificate_password}.
     *
     * @stability stable
     */
    readonly certificatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#host_name ApiManagementCustomDomain#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#key_vault_id ApiManagementCustomDomain#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#negotiate_client_certificate ApiManagementCustomDomain#negotiate_client_certificate}.
     *
     * @stability stable
     */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#ssl_keyvault_identity_client_id ApiManagementCustomDomain#ssl_keyvault_identity_client_id}.
     *
     * @stability stable
     */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementCustomDomainDeveloperPortalToTerraform(struct?: ApiManagementCustomDomainDeveloperPortal): any;
/**
 * @stability stable
 */
export interface ApiManagementCustomDomainManagement {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#certificate ApiManagementCustomDomain#certificate}.
     *
     * @stability stable
     */
    readonly certificate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#certificate_password ApiManagementCustomDomain#certificate_password}.
     *
     * @stability stable
     */
    readonly certificatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#host_name ApiManagementCustomDomain#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#key_vault_id ApiManagementCustomDomain#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#negotiate_client_certificate ApiManagementCustomDomain#negotiate_client_certificate}.
     *
     * @stability stable
     */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#ssl_keyvault_identity_client_id ApiManagementCustomDomain#ssl_keyvault_identity_client_id}.
     *
     * @stability stable
     */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementCustomDomainManagementToTerraform(struct?: ApiManagementCustomDomainManagement): any;
/**
 * @stability stable
 */
export interface ApiManagementCustomDomainPortal {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#certificate ApiManagementCustomDomain#certificate}.
     *
     * @stability stable
     */
    readonly certificate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#certificate_password ApiManagementCustomDomain#certificate_password}.
     *
     * @stability stable
     */
    readonly certificatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#host_name ApiManagementCustomDomain#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#key_vault_id ApiManagementCustomDomain#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#negotiate_client_certificate ApiManagementCustomDomain#negotiate_client_certificate}.
     *
     * @stability stable
     */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#ssl_keyvault_identity_client_id ApiManagementCustomDomain#ssl_keyvault_identity_client_id}.
     *
     * @stability stable
     */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementCustomDomainPortalToTerraform(struct?: ApiManagementCustomDomainPortal): any;
/**
 * @stability stable
 */
export interface ApiManagementCustomDomainProxy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#certificate ApiManagementCustomDomain#certificate}.
     *
     * @stability stable
     */
    readonly certificate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#certificate_password ApiManagementCustomDomain#certificate_password}.
     *
     * @stability stable
     */
    readonly certificatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#default_ssl_binding ApiManagementCustomDomain#default_ssl_binding}.
     *
     * @stability stable
     */
    readonly defaultSslBinding?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#host_name ApiManagementCustomDomain#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#key_vault_id ApiManagementCustomDomain#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#negotiate_client_certificate ApiManagementCustomDomain#negotiate_client_certificate}.
     *
     * @stability stable
     */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#ssl_keyvault_identity_client_id ApiManagementCustomDomain#ssl_keyvault_identity_client_id}.
     *
     * @stability stable
     */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementCustomDomainProxyToTerraform(struct?: ApiManagementCustomDomainProxy): any;
/**
 * @stability stable
 */
export interface ApiManagementCustomDomainScm {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#certificate ApiManagementCustomDomain#certificate}.
     *
     * @stability stable
     */
    readonly certificate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#certificate_password ApiManagementCustomDomain#certificate_password}.
     *
     * @stability stable
     */
    readonly certificatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#host_name ApiManagementCustomDomain#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#key_vault_id ApiManagementCustomDomain#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#negotiate_client_certificate ApiManagementCustomDomain#negotiate_client_certificate}.
     *
     * @stability stable
     */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#ssl_keyvault_identity_client_id ApiManagementCustomDomain#ssl_keyvault_identity_client_id}.
     *
     * @stability stable
     */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementCustomDomainScmToTerraform(struct?: ApiManagementCustomDomainScm): any;
/**
 * @stability stable
 */
export interface ApiManagementCustomDomainTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#create ApiManagementCustomDomain#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#delete ApiManagementCustomDomain#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#read ApiManagementCustomDomain#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain#update ApiManagementCustomDomain#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementCustomDomainTimeoutsToTerraform(struct?: ApiManagementCustomDomainTimeoutsOutputReference | ApiManagementCustomDomainTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementCustomDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementCustomDomainTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementCustomDomainTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain azurerm_api_management_custom_domain}.
 *
 * @stability stable
 */
export declare class ApiManagementCustomDomain extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_custom_domain azurerm_api_management_custom_domain} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementCustomDomainConfig);
    private _apiManagementId?;
    /**
     * @stability stable
     */
    get apiManagementId(): string;
    /**
     * @stability stable
     */
    set apiManagementId(value: string);
    /**
     * @stability stable
     */
    get apiManagementIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _developerPortal?;
    /**
     * @stability stable
     */
    get developerPortal(): ApiManagementCustomDomainDeveloperPortal[];
    /**
     * @stability stable
     */
    set developerPortal(value: ApiManagementCustomDomainDeveloperPortal[]);
    /**
     * @stability stable
     */
    resetDeveloperPortal(): void;
    /**
     * @stability stable
     */
    get developerPortalInput(): ApiManagementCustomDomainDeveloperPortal[] | undefined;
    private _management?;
    /**
     * @stability stable
     */
    get management(): ApiManagementCustomDomainManagement[];
    /**
     * @stability stable
     */
    set management(value: ApiManagementCustomDomainManagement[]);
    /**
     * @stability stable
     */
    resetManagement(): void;
    /**
     * @stability stable
     */
    get managementInput(): ApiManagementCustomDomainManagement[] | undefined;
    private _portal?;
    /**
     * @stability stable
     */
    get portal(): ApiManagementCustomDomainPortal[];
    /**
     * @stability stable
     */
    set portal(value: ApiManagementCustomDomainPortal[]);
    /**
     * @stability stable
     */
    resetPortal(): void;
    /**
     * @stability stable
     */
    get portalInput(): ApiManagementCustomDomainPortal[] | undefined;
    private _proxy?;
    /**
     * @stability stable
     */
    get proxy(): ApiManagementCustomDomainProxy[];
    /**
     * @stability stable
     */
    set proxy(value: ApiManagementCustomDomainProxy[]);
    /**
     * @stability stable
     */
    resetProxy(): void;
    /**
     * @stability stable
     */
    get proxyInput(): ApiManagementCustomDomainProxy[] | undefined;
    private _scm?;
    /**
     * @stability stable
     */
    get scm(): ApiManagementCustomDomainScm[];
    /**
     * @stability stable
     */
    set scm(value: ApiManagementCustomDomainScm[]);
    /**
     * @stability stable
     */
    resetScm(): void;
    /**
     * @stability stable
     */
    get scmInput(): ApiManagementCustomDomainScm[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementCustomDomainTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementCustomDomainTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementCustomDomainTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
