import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppConfigurationFeatureConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#configuration_store_id AppConfigurationFeature#configuration_store_id}.
     *
     * @stability stable
     */
    readonly configurationStoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#description AppConfigurationFeature#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#enabled AppConfigurationFeature#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#etag AppConfigurationFeature#etag}.
     *
     * @stability stable
     */
    readonly etag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#label AppConfigurationFeature#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#locked AppConfigurationFeature#locked}.
     *
     * @stability stable
     */
    readonly locked?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#name AppConfigurationFeature#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#percentage_filter_value AppConfigurationFeature#percentage_filter_value}.
     *
     * @stability stable
     */
    readonly percentageFilterValue?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#tags AppConfigurationFeature#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * targeting_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#targeting_filter AppConfigurationFeature#targeting_filter}
     *
     * @stability stable
     */
    readonly targetingFilter?: AppConfigurationFeatureTargetingFilter[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#timeouts AppConfigurationFeature#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppConfigurationFeatureTimeouts;
    /**
     * timewindow_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#timewindow_filter AppConfigurationFeature#timewindow_filter}
     *
     * @stability stable
     */
    readonly timewindowFilter?: AppConfigurationFeatureTimewindowFilter[];
}
/**
 * @stability stable
 */
export interface AppConfigurationFeatureTargetingFilterGroups {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#name AppConfigurationFeature#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#rollout_percentage AppConfigurationFeature#rollout_percentage}.
     *
     * @stability stable
     */
    readonly rolloutPercentage: number;
}
export declare function appConfigurationFeatureTargetingFilterGroupsToTerraform(struct?: AppConfigurationFeatureTargetingFilterGroups): any;
/**
 * @stability stable
 */
export interface AppConfigurationFeatureTargetingFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#default_rollout_percentage AppConfigurationFeature#default_rollout_percentage}.
     *
     * @stability stable
     */
    readonly defaultRolloutPercentage: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#users AppConfigurationFeature#users}.
     *
     * @stability stable
     */
    readonly users?: string[];
    /**
     * groups block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#groups AppConfigurationFeature#groups}
     *
     * @stability stable
     */
    readonly groups?: AppConfigurationFeatureTargetingFilterGroups[];
}
export declare function appConfigurationFeatureTargetingFilterToTerraform(struct?: AppConfigurationFeatureTargetingFilter): any;
/**
 * @stability stable
 */
export interface AppConfigurationFeatureTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#create AppConfigurationFeature#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#delete AppConfigurationFeature#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#read AppConfigurationFeature#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#update AppConfigurationFeature#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appConfigurationFeatureTimeoutsToTerraform(struct?: AppConfigurationFeatureTimeoutsOutputReference | AppConfigurationFeatureTimeouts): any;
/**
 * @stability stable
 */
export declare class AppConfigurationFeatureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppConfigurationFeatureTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppConfigurationFeatureTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppConfigurationFeatureTimewindowFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#end AppConfigurationFeature#end}.
     *
     * @stability stable
     */
    readonly end?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature#start AppConfigurationFeature#start}.
     *
     * @stability stable
     */
    readonly start?: string;
}
export declare function appConfigurationFeatureTimewindowFilterToTerraform(struct?: AppConfigurationFeatureTimewindowFilter): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature azurerm_app_configuration_feature}.
 *
 * @stability stable
 */
export declare class AppConfigurationFeature extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration_feature azurerm_app_configuration_feature} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppConfigurationFeatureConfig);
    private _configurationStoreId?;
    /**
     * @stability stable
     */
    get configurationStoreId(): string;
    /**
     * @stability stable
     */
    set configurationStoreId(value: string);
    /**
     * @stability stable
     */
    get configurationStoreIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _etag?;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    set etag(value: string);
    /**
     * @stability stable
     */
    resetEtag(): void;
    /**
     * @stability stable
     */
    get etagInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _locked?;
    /**
     * @stability stable
     */
    get locked(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set locked(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocked(): void;
    /**
     * @stability stable
     */
    get lockedInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _percentageFilterValue?;
    /**
     * @stability stable
     */
    get percentageFilterValue(): number;
    /**
     * @stability stable
     */
    set percentageFilterValue(value: number);
    /**
     * @stability stable
     */
    resetPercentageFilterValue(): void;
    /**
     * @stability stable
     */
    get percentageFilterValueInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _targetingFilter?;
    /**
     * @stability stable
     */
    get targetingFilter(): AppConfigurationFeatureTargetingFilter[];
    /**
     * @stability stable
     */
    set targetingFilter(value: AppConfigurationFeatureTargetingFilter[]);
    /**
     * @stability stable
     */
    resetTargetingFilter(): void;
    /**
     * @stability stable
     */
    get targetingFilterInput(): AppConfigurationFeatureTargetingFilter[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppConfigurationFeatureTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppConfigurationFeatureTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppConfigurationFeatureTimeouts | undefined;
    private _timewindowFilter?;
    /**
     * @stability stable
     */
    get timewindowFilter(): AppConfigurationFeatureTimewindowFilter[];
    /**
     * @stability stable
     */
    set timewindowFilter(value: AppConfigurationFeatureTimewindowFilter[]);
    /**
     * @stability stable
     */
    resetTimewindowFilter(): void;
    /**
     * @stability stable
     */
    get timewindowFilterInput(): AppConfigurationFeatureTimewindowFilter[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
