import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServiceCertificateBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_binding#certificate_id AppServiceCertificateBinding#certificate_id}.
     *
     * @stability stable
     */
    readonly certificateId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_binding#hostname_binding_id AppServiceCertificateBinding#hostname_binding_id}.
     *
     * @stability stable
     */
    readonly hostnameBindingId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_binding#ssl_state AppServiceCertificateBinding#ssl_state}.
     *
     * @stability stable
     */
    readonly sslState: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_binding#timeouts AppServiceCertificateBinding#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServiceCertificateBindingTimeouts;
}
/**
 * @stability stable
 */
export interface AppServiceCertificateBindingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_binding#create AppServiceCertificateBinding#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_binding#delete AppServiceCertificateBinding#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_binding#read AppServiceCertificateBinding#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function appServiceCertificateBindingTimeoutsToTerraform(struct?: AppServiceCertificateBindingTimeoutsOutputReference | AppServiceCertificateBindingTimeouts): any;
/**
 * @stability stable
 */
export declare class AppServiceCertificateBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceCertificateBindingTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceCertificateBindingTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_binding azurerm_app_service_certificate_binding}.
 *
 * @stability stable
 */
export declare class AppServiceCertificateBinding extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_binding azurerm_app_service_certificate_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServiceCertificateBindingConfig);
    /**
     * @stability stable
     */
    get appServiceName(): string;
    private _certificateId?;
    /**
     * @stability stable
     */
    get certificateId(): string;
    /**
     * @stability stable
     */
    set certificateId(value: string);
    /**
     * @stability stable
     */
    get certificateIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get hostname(): string;
    private _hostnameBindingId?;
    /**
     * @stability stable
     */
    get hostnameBindingId(): string;
    /**
     * @stability stable
     */
    set hostnameBindingId(value: string);
    /**
     * @stability stable
     */
    get hostnameBindingIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _sslState?;
    /**
     * @stability stable
     */
    get sslState(): string;
    /**
     * @stability stable
     */
    set sslState(value: string);
    /**
     * @stability stable
     */
    get sslStateInput(): string | undefined;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServiceCertificateBindingTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServiceCertificateBindingTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServiceCertificateBindingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
