import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServiceCertificateOrderConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#auto_renew AppServiceCertificateOrder#auto_renew}.
     *
     * @stability stable
     */
    readonly autoRenew?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#csr AppServiceCertificateOrder#csr}.
     *
     * @stability stable
     */
    readonly csr?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#distinguished_name AppServiceCertificateOrder#distinguished_name}.
     *
     * @stability stable
     */
    readonly distinguishedName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#key_size AppServiceCertificateOrder#key_size}.
     *
     * @stability stable
     */
    readonly keySize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#location AppServiceCertificateOrder#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#name AppServiceCertificateOrder#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#product_type AppServiceCertificateOrder#product_type}.
     *
     * @stability stable
     */
    readonly productType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#resource_group_name AppServiceCertificateOrder#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#tags AppServiceCertificateOrder#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#validity_in_years AppServiceCertificateOrder#validity_in_years}.
     *
     * @stability stable
     */
    readonly validityInYears?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#timeouts AppServiceCertificateOrder#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServiceCertificateOrderTimeouts;
}
/**
 * @stability stable
 */
export declare class AppServiceCertificateOrderCertificates extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get certificateName(): string;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    get keyVaultSecretName(): string;
    /**
     * @stability stable
     */
    get provisioningState(): string;
}
/**
 * @stability stable
 */
export interface AppServiceCertificateOrderTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#create AppServiceCertificateOrder#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#delete AppServiceCertificateOrder#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#read AppServiceCertificateOrder#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#update AppServiceCertificateOrder#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appServiceCertificateOrderTimeoutsToTerraform(struct?: AppServiceCertificateOrderTimeoutsOutputReference | AppServiceCertificateOrderTimeouts): any;
/**
 * @stability stable
 */
export declare class AppServiceCertificateOrderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceCertificateOrderTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceCertificateOrderTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order azurerm_app_service_certificate_order}.
 *
 * @stability stable
 */
export declare class AppServiceCertificateOrder extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order azurerm_app_service_certificate_order} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServiceCertificateOrderConfig);
    /**
     * @stability stable
     */
    get appServiceCertificateNotRenewableReasons(): string[];
    private _autoRenew?;
    /**
     * @stability stable
     */
    get autoRenew(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoRenew(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoRenew(): void;
    /**
     * @stability stable
     */
    get autoRenewInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    certificates(index: string): AppServiceCertificateOrderCertificates;
    private _csr?;
    /**
     * @stability stable
     */
    get csr(): string;
    /**
     * @stability stable
     */
    set csr(value: string);
    /**
     * @stability stable
     */
    resetCsr(): void;
    /**
     * @stability stable
     */
    get csrInput(): string | undefined;
    private _distinguishedName?;
    /**
     * @stability stable
     */
    get distinguishedName(): string;
    /**
     * @stability stable
     */
    set distinguishedName(value: string);
    /**
     * @stability stable
     */
    resetDistinguishedName(): void;
    /**
     * @stability stable
     */
    get distinguishedNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get domainVerificationToken(): string;
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get intermediateThumbprint(): string;
    /**
     * @stability stable
     */
    get isPrivateKeyExternal(): any;
    private _keySize?;
    /**
     * @stability stable
     */
    get keySize(): number;
    /**
     * @stability stable
     */
    set keySize(value: number);
    /**
     * @stability stable
     */
    resetKeySize(): void;
    /**
     * @stability stable
     */
    get keySizeInput(): number | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _productType?;
    /**
     * @stability stable
     */
    get productType(): string;
    /**
     * @stability stable
     */
    set productType(value: string);
    /**
     * @stability stable
     */
    resetProductType(): void;
    /**
     * @stability stable
     */
    get productTypeInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get rootThumbprint(): string;
    /**
     * @stability stable
     */
    get signedCertificateThumbprint(): string;
    /**
     * @stability stable
     */
    get status(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _validityInYears?;
    /**
     * @stability stable
     */
    get validityInYears(): number;
    /**
     * @stability stable
     */
    set validityInYears(value: number);
    /**
     * @stability stable
     */
    resetValidityInYears(): void;
    /**
     * @stability stable
     */
    get validityInYearsInput(): number | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServiceCertificateOrderTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServiceCertificateOrderTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServiceCertificateOrderTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
