import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServicePlanConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#app_service_environment_id AppServicePlan#app_service_environment_id}.
     *
     * @stability stable
     */
    readonly appServiceEnvironmentId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#is_xenon AppServicePlan#is_xenon}.
     *
     * @stability stable
     */
    readonly isXenon?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#kind AppServicePlan#kind}.
     *
     * @stability stable
     */
    readonly kind?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#location AppServicePlan#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#maximum_elastic_worker_count AppServicePlan#maximum_elastic_worker_count}.
     *
     * @stability stable
     */
    readonly maximumElasticWorkerCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#name AppServicePlan#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#per_site_scaling AppServicePlan#per_site_scaling}.
     *
     * @stability stable
     */
    readonly perSiteScaling?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#reserved AppServicePlan#reserved}.
     *
     * @stability stable
     */
    readonly reserved?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#resource_group_name AppServicePlan#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#tags AppServicePlan#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#zone_redundant AppServicePlan#zone_redundant}.
     *
     * @stability stable
     */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
     * sku block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#sku AppServicePlan#sku}
     *
     * @stability stable
     */
    readonly sku: AppServicePlanSku;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#timeouts AppServicePlan#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServicePlanTimeouts;
}
/**
 * @stability stable
 */
export interface AppServicePlanSku {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#capacity AppServicePlan#capacity}.
     *
     * @stability stable
     */
    readonly capacity?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#size AppServicePlan#size}.
     *
     * @stability stable
     */
    readonly size: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#tier AppServicePlan#tier}.
     *
     * @stability stable
     */
    readonly tier: string;
}
export declare function appServicePlanSkuToTerraform(struct?: AppServicePlanSkuOutputReference | AppServicePlanSku): any;
/**
 * @stability stable
 */
export declare class AppServicePlanSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServicePlanSku | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServicePlanSku | undefined);
    private _capacity?;
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    set capacity(value: number);
    /**
     * @stability stable
     */
    resetCapacity(): void;
    /**
     * @stability stable
     */
    get capacityInput(): number | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): string;
    /**
     * @stability stable
     */
    set size(value: string);
    /**
     * @stability stable
     */
    get sizeInput(): string | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServicePlanTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#create AppServicePlan#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#delete AppServicePlan#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#read AppServicePlan#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan#update AppServicePlan#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appServicePlanTimeoutsToTerraform(struct?: AppServicePlanTimeoutsOutputReference | AppServicePlanTimeouts): any;
/**
 * @stability stable
 */
export declare class AppServicePlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServicePlanTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServicePlanTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan azurerm_app_service_plan}.
 *
 * @stability stable
 */
export declare class AppServicePlan extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_plan azurerm_app_service_plan} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServicePlanConfig);
    private _appServiceEnvironmentId?;
    /**
     * @stability stable
     */
    get appServiceEnvironmentId(): string;
    /**
     * @stability stable
     */
    set appServiceEnvironmentId(value: string);
    /**
     * @stability stable
     */
    resetAppServiceEnvironmentId(): void;
    /**
     * @stability stable
     */
    get appServiceEnvironmentIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isXenon?;
    /**
     * @stability stable
     */
    get isXenon(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isXenon(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsXenon(): void;
    /**
     * @stability stable
     */
    get isXenonInput(): boolean | cdktf.IResolvable | undefined;
    private _kind?;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    set kind(value: string);
    /**
     * @stability stable
     */
    resetKind(): void;
    /**
     * @stability stable
     */
    get kindInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maximumElasticWorkerCount?;
    /**
     * @stability stable
     */
    get maximumElasticWorkerCount(): number;
    /**
     * @stability stable
     */
    set maximumElasticWorkerCount(value: number);
    /**
     * @stability stable
     */
    resetMaximumElasticWorkerCount(): void;
    /**
     * @stability stable
     */
    get maximumElasticWorkerCountInput(): number | undefined;
    /**
     * @stability stable
     */
    get maximumNumberOfWorkers(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _perSiteScaling?;
    /**
     * @stability stable
     */
    get perSiteScaling(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set perSiteScaling(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPerSiteScaling(): void;
    /**
     * @stability stable
     */
    get perSiteScalingInput(): boolean | cdktf.IResolvable | undefined;
    private _reserved?;
    /**
     * @stability stable
     */
    get reserved(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set reserved(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReserved(): void;
    /**
     * @stability stable
     */
    get reservedInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _zoneRedundant?;
    /**
     * @stability stable
     */
    get zoneRedundant(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetZoneRedundant(): void;
    /**
     * @stability stable
     */
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _sku;
    /**
     * @stability stable
     */
    get sku(): AppServicePlanSkuOutputReference;
    /**
     * @stability stable
     */
    putSku(value: AppServicePlanSku): void;
    /**
     * @stability stable
     */
    get skuInput(): AppServicePlanSku | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServicePlanTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServicePlanTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServicePlanTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
