import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServicePublicCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#app_service_name AppServicePublicCertificate#app_service_name}.
     *
     * @stability stable
     */
    readonly appServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#blob AppServicePublicCertificate#blob}.
     *
     * @stability stable
     */
    readonly blob: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#certificate_location AppServicePublicCertificate#certificate_location}.
     *
     * @stability stable
     */
    readonly certificateLocation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#certificate_name AppServicePublicCertificate#certificate_name}.
     *
     * @stability stable
     */
    readonly certificateName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#resource_group_name AppServicePublicCertificate#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#timeouts AppServicePublicCertificate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServicePublicCertificateTimeouts;
}
/**
 * @stability stable
 */
export interface AppServicePublicCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#create AppServicePublicCertificate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#delete AppServicePublicCertificate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#read AppServicePublicCertificate#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate#update AppServicePublicCertificate#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appServicePublicCertificateTimeoutsToTerraform(struct?: AppServicePublicCertificateTimeoutsOutputReference | AppServicePublicCertificateTimeouts): any;
/**
 * @stability stable
 */
export declare class AppServicePublicCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServicePublicCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServicePublicCertificateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate azurerm_app_service_public_certificate}.
 *
 * @stability stable
 */
export declare class AppServicePublicCertificate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_public_certificate azurerm_app_service_public_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServicePublicCertificateConfig);
    private _appServiceName?;
    /**
     * @stability stable
     */
    get appServiceName(): string;
    /**
     * @stability stable
     */
    set appServiceName(value: string);
    /**
     * @stability stable
     */
    get appServiceNameInput(): string | undefined;
    private _blob?;
    /**
     * @stability stable
     */
    get blob(): string;
    /**
     * @stability stable
     */
    set blob(value: string);
    /**
     * @stability stable
     */
    get blobInput(): string | undefined;
    private _certificateLocation?;
    /**
     * @stability stable
     */
    get certificateLocation(): string;
    /**
     * @stability stable
     */
    set certificateLocation(value: string);
    /**
     * @stability stable
     */
    get certificateLocationInput(): string | undefined;
    private _certificateName?;
    /**
     * @stability stable
     */
    get certificateName(): string;
    /**
     * @stability stable
     */
    set certificateName(value: string);
    /**
     * @stability stable
     */
    get certificateNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServicePublicCertificateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServicePublicCertificateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServicePublicCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
