import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#enable_http2 ApplicationGateway#enable_http2}.
     *
     * @stability stable
     */
    readonly enableHttp2?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#fips_enabled ApplicationGateway#fips_enabled}.
     *
     * @stability stable
     */
    readonly fipsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#firewall_policy_id ApplicationGateway#firewall_policy_id}.
     *
     * @stability stable
     */
    readonly firewallPolicyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#force_firewall_policy_association ApplicationGateway#force_firewall_policy_association}.
     *
     * @stability stable
     */
    readonly forceFirewallPolicyAssociation?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#location ApplicationGateway#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#resource_group_name ApplicationGateway#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#tags ApplicationGateway#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#zones ApplicationGateway#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * authentication_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#authentication_certificate ApplicationGateway#authentication_certificate}
     *
     * @stability stable
     */
    readonly authenticationCertificate?: ApplicationGatewayAuthenticationCertificate[];
    /**
     * autoscale_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#autoscale_configuration ApplicationGateway#autoscale_configuration}
     *
     * @stability stable
     */
    readonly autoscaleConfiguration?: ApplicationGatewayAutoscaleConfiguration;
    /**
     * backend_address_pool block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_address_pool ApplicationGateway#backend_address_pool}
     *
     * @stability stable
     */
    readonly backendAddressPool: ApplicationGatewayBackendAddressPool[];
    /**
     * backend_http_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_http_settings ApplicationGateway#backend_http_settings}
     *
     * @stability stable
     */
    readonly backendHttpSettings: ApplicationGatewayBackendHttpSettings[];
    /**
     * custom_error_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#custom_error_configuration ApplicationGateway#custom_error_configuration}
     *
     * @stability stable
     */
    readonly customErrorConfiguration?: ApplicationGatewayCustomErrorConfiguration[];
    /**
     * frontend_ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#frontend_ip_configuration ApplicationGateway#frontend_ip_configuration}
     *
     * @stability stable
     */
    readonly frontendIpConfiguration: ApplicationGatewayFrontendIpConfiguration[];
    /**
     * frontend_port block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#frontend_port ApplicationGateway#frontend_port}
     *
     * @stability stable
     */
    readonly frontendPort: ApplicationGatewayFrontendPort[];
    /**
     * gateway_ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#gateway_ip_configuration ApplicationGateway#gateway_ip_configuration}
     *
     * @stability stable
     */
    readonly gatewayIpConfiguration: ApplicationGatewayGatewayIpConfiguration[];
    /**
     * http_listener block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#http_listener ApplicationGateway#http_listener}
     *
     * @stability stable
     */
    readonly httpListener: ApplicationGatewayHttpListener[];
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#identity ApplicationGateway#identity}
     *
     * @stability stable
     */
    readonly identity?: ApplicationGatewayIdentity;
    /**
     * private_link_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_link_configuration ApplicationGateway#private_link_configuration}
     *
     * @stability stable
     */
    readonly privateLinkConfiguration?: ApplicationGatewayPrivateLinkConfiguration[];
    /**
     * probe block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#probe ApplicationGateway#probe}
     *
     * @stability stable
     */
    readonly probe?: ApplicationGatewayProbe[];
    /**
     * redirect_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#redirect_configuration ApplicationGateway#redirect_configuration}
     *
     * @stability stable
     */
    readonly redirectConfiguration?: ApplicationGatewayRedirectConfiguration[];
    /**
     * request_routing_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#request_routing_rule ApplicationGateway#request_routing_rule}
     *
     * @stability stable
     */
    readonly requestRoutingRule: ApplicationGatewayRequestRoutingRule[];
    /**
     * rewrite_rule_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rewrite_rule_set ApplicationGateway#rewrite_rule_set}
     *
     * @stability stable
     */
    readonly rewriteRuleSet?: ApplicationGatewayRewriteRuleSet[];
    /**
     * sku block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#sku ApplicationGateway#sku}
     *
     * @stability stable
     */
    readonly sku: ApplicationGatewaySku;
    /**
     * ssl_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_certificate ApplicationGateway#ssl_certificate}
     *
     * @stability stable
     */
    readonly sslCertificate?: ApplicationGatewaySslCertificate[];
    /**
     * ssl_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_policy ApplicationGateway#ssl_policy}
     *
     * @stability stable
     */
    readonly sslPolicy?: ApplicationGatewaySslPolicy;
    /**
     * ssl_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_profile ApplicationGateway#ssl_profile}
     *
     * @stability stable
     */
    readonly sslProfile?: ApplicationGatewaySslProfile[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#timeouts ApplicationGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApplicationGatewayTimeouts;
    /**
     * trusted_client_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#trusted_client_certificate ApplicationGateway#trusted_client_certificate}
     *
     * @stability stable
     */
    readonly trustedClientCertificate?: ApplicationGatewayTrustedClientCertificate[];
    /**
     * trusted_root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#trusted_root_certificate ApplicationGateway#trusted_root_certificate}
     *
     * @stability stable
     */
    readonly trustedRootCertificate?: ApplicationGatewayTrustedRootCertificate[];
    /**
     * url_path_map block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#url_path_map ApplicationGateway#url_path_map}
     *
     * @stability stable
     */
    readonly urlPathMap?: ApplicationGatewayUrlPathMap[];
    /**
     * waf_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#waf_configuration ApplicationGateway#waf_configuration}
     *
     * @stability stable
     */
    readonly wafConfiguration?: ApplicationGatewayWafConfiguration;
}
/**
 * @stability stable
 */
export declare class ApplicationGatewayPrivateEndpointConnection extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export interface ApplicationGatewayAuthenticationCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#data ApplicationGateway#data}.
     *
     * @stability stable
     */
    readonly data: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function applicationGatewayAuthenticationCertificateToTerraform(struct?: ApplicationGatewayAuthenticationCertificate): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayAutoscaleConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#max_capacity ApplicationGateway#max_capacity}.
     *
     * @stability stable
     */
    readonly maxCapacity?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#min_capacity ApplicationGateway#min_capacity}.
     *
     * @stability stable
     */
    readonly minCapacity: number;
}
export declare function applicationGatewayAutoscaleConfigurationToTerraform(struct?: ApplicationGatewayAutoscaleConfigurationOutputReference | ApplicationGatewayAutoscaleConfiguration): any;
/**
 * @stability stable
 */
export declare class ApplicationGatewayAutoscaleConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationGatewayAutoscaleConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationGatewayAutoscaleConfiguration | undefined);
    private _maxCapacity?;
    /**
     * @stability stable
     */
    get maxCapacity(): number;
    /**
     * @stability stable
     */
    set maxCapacity(value: number);
    /**
     * @stability stable
     */
    resetMaxCapacity(): void;
    /**
     * @stability stable
     */
    get maxCapacityInput(): number | undefined;
    private _minCapacity?;
    /**
     * @stability stable
     */
    get minCapacity(): number;
    /**
     * @stability stable
     */
    set minCapacity(value: number);
    /**
     * @stability stable
     */
    get minCapacityInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationGatewayBackendAddressPool {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#fqdns ApplicationGateway#fqdns}.
     *
     * @stability stable
     */
    readonly fqdns?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ip_addresses ApplicationGateway#ip_addresses}.
     *
     * @stability stable
     */
    readonly ipAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function applicationGatewayBackendAddressPoolToTerraform(struct?: ApplicationGatewayBackendAddressPool): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayBackendHttpSettingsAuthenticationCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function applicationGatewayBackendHttpSettingsAuthenticationCertificateToTerraform(struct?: ApplicationGatewayBackendHttpSettingsAuthenticationCertificate): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayBackendHttpSettingsConnectionDraining {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#drain_timeout_sec ApplicationGateway#drain_timeout_sec}.
     *
     * @stability stable
     */
    readonly drainTimeoutSec: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#enabled ApplicationGateway#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function applicationGatewayBackendHttpSettingsConnectionDrainingToTerraform(struct?: ApplicationGatewayBackendHttpSettingsConnectionDrainingOutputReference | ApplicationGatewayBackendHttpSettingsConnectionDraining): any;
/**
 * @stability stable
 */
export declare class ApplicationGatewayBackendHttpSettingsConnectionDrainingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationGatewayBackendHttpSettingsConnectionDraining | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationGatewayBackendHttpSettingsConnectionDraining | undefined);
    private _drainTimeoutSec?;
    /**
     * @stability stable
     */
    get drainTimeoutSec(): number;
    /**
     * @stability stable
     */
    set drainTimeoutSec(value: number);
    /**
     * @stability stable
     */
    get drainTimeoutSecInput(): number | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationGatewayBackendHttpSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#affinity_cookie_name ApplicationGateway#affinity_cookie_name}.
     *
     * @stability stable
     */
    readonly affinityCookieName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#cookie_based_affinity ApplicationGateway#cookie_based_affinity}.
     *
     * @stability stable
     */
    readonly cookieBasedAffinity: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#host_name ApplicationGateway#host_name}.
     *
     * @stability stable
     */
    readonly hostName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#path ApplicationGateway#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#pick_host_name_from_backend_address ApplicationGateway#pick_host_name_from_backend_address}.
     *
     * @stability stable
     */
    readonly pickHostNameFromBackendAddress?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#port ApplicationGateway#port}.
     *
     * @stability stable
     */
    readonly port: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#probe_name ApplicationGateway#probe_name}.
     *
     * @stability stable
     */
    readonly probeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#protocol ApplicationGateway#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#request_timeout ApplicationGateway#request_timeout}.
     *
     * @stability stable
     */
    readonly requestTimeout?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#trusted_root_certificate_names ApplicationGateway#trusted_root_certificate_names}.
     *
     * @stability stable
     */
    readonly trustedRootCertificateNames?: string[];
    /**
     * authentication_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#authentication_certificate ApplicationGateway#authentication_certificate}
     *
     * @stability stable
     */
    readonly authenticationCertificate?: ApplicationGatewayBackendHttpSettingsAuthenticationCertificate[];
    /**
     * connection_draining block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#connection_draining ApplicationGateway#connection_draining}
     *
     * @stability stable
     */
    readonly connectionDraining?: ApplicationGatewayBackendHttpSettingsConnectionDraining;
}
export declare function applicationGatewayBackendHttpSettingsToTerraform(struct?: ApplicationGatewayBackendHttpSettings): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayCustomErrorConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#custom_error_page_url ApplicationGateway#custom_error_page_url}.
     *
     * @stability stable
     */
    readonly customErrorPageUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#status_code ApplicationGateway#status_code}.
     *
     * @stability stable
     */
    readonly statusCode: string;
}
export declare function applicationGatewayCustomErrorConfigurationToTerraform(struct?: ApplicationGatewayCustomErrorConfiguration): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayFrontendIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_ip_address ApplicationGateway#private_ip_address}.
     *
     * @stability stable
     */
    readonly privateIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_ip_address_allocation ApplicationGateway#private_ip_address_allocation}.
     *
     * @stability stable
     */
    readonly privateIpAddressAllocation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_link_configuration_name ApplicationGateway#private_link_configuration_name}.
     *
     * @stability stable
     */
    readonly privateLinkConfigurationName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#public_ip_address_id ApplicationGateway#public_ip_address_id}.
     *
     * @stability stable
     */
    readonly publicIpAddressId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#subnet_id ApplicationGateway#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
}
export declare function applicationGatewayFrontendIpConfigurationToTerraform(struct?: ApplicationGatewayFrontendIpConfiguration): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayFrontendPort {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#port ApplicationGateway#port}.
     *
     * @stability stable
     */
    readonly port: number;
}
export declare function applicationGatewayFrontendPortToTerraform(struct?: ApplicationGatewayFrontendPort): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayGatewayIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#subnet_id ApplicationGateway#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function applicationGatewayGatewayIpConfigurationToTerraform(struct?: ApplicationGatewayGatewayIpConfiguration): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayHttpListenerCustomErrorConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#custom_error_page_url ApplicationGateway#custom_error_page_url}.
     *
     * @stability stable
     */
    readonly customErrorPageUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#status_code ApplicationGateway#status_code}.
     *
     * @stability stable
     */
    readonly statusCode: string;
}
export declare function applicationGatewayHttpListenerCustomErrorConfigurationToTerraform(struct?: ApplicationGatewayHttpListenerCustomErrorConfiguration): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayHttpListener {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#firewall_policy_id ApplicationGateway#firewall_policy_id}.
     *
     * @stability stable
     */
    readonly firewallPolicyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#frontend_ip_configuration_name ApplicationGateway#frontend_ip_configuration_name}.
     *
     * @stability stable
     */
    readonly frontendIpConfigurationName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#frontend_port_name ApplicationGateway#frontend_port_name}.
     *
     * @stability stable
     */
    readonly frontendPortName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#host_name ApplicationGateway#host_name}.
     *
     * @stability stable
     */
    readonly hostName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#host_names ApplicationGateway#host_names}.
     *
     * @stability stable
     */
    readonly hostNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#protocol ApplicationGateway#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#require_sni ApplicationGateway#require_sni}.
     *
     * @stability stable
     */
    readonly requireSni?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_certificate_name ApplicationGateway#ssl_certificate_name}.
     *
     * @stability stable
     */
    readonly sslCertificateName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_profile_name ApplicationGateway#ssl_profile_name}.
     *
     * @stability stable
     */
    readonly sslProfileName?: string;
    /**
     * custom_error_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#custom_error_configuration ApplicationGateway#custom_error_configuration}
     *
     * @stability stable
     */
    readonly customErrorConfiguration?: ApplicationGatewayHttpListenerCustomErrorConfiguration[];
}
export declare function applicationGatewayHttpListenerToTerraform(struct?: ApplicationGatewayHttpListener): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#identity_ids ApplicationGateway#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#type ApplicationGateway#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function applicationGatewayIdentityToTerraform(struct?: ApplicationGatewayIdentityOutputReference | ApplicationGatewayIdentity): any;
/**
 * @stability stable
 */
export declare class ApplicationGatewayIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationGatewayIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationGatewayIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationGatewayPrivateLinkConfigurationIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#primary ApplicationGateway#primary}.
     *
     * @stability stable
     */
    readonly primary: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_ip_address ApplicationGateway#private_ip_address}.
     *
     * @stability stable
     */
    readonly privateIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#private_ip_address_allocation ApplicationGateway#private_ip_address_allocation}.
     *
     * @stability stable
     */
    readonly privateIpAddressAllocation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#subnet_id ApplicationGateway#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function applicationGatewayPrivateLinkConfigurationIpConfigurationToTerraform(struct?: ApplicationGatewayPrivateLinkConfigurationIpConfiguration): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayPrivateLinkConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ip_configuration ApplicationGateway#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration: ApplicationGatewayPrivateLinkConfigurationIpConfiguration[];
}
export declare function applicationGatewayPrivateLinkConfigurationToTerraform(struct?: ApplicationGatewayPrivateLinkConfiguration): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayProbeMatch {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#body ApplicationGateway#body}.
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#status_code ApplicationGateway#status_code}.
     *
     * @stability stable
     */
    readonly statusCode?: string[];
}
export declare function applicationGatewayProbeMatchToTerraform(struct?: ApplicationGatewayProbeMatchOutputReference | ApplicationGatewayProbeMatch): any;
/**
 * @stability stable
 */
export declare class ApplicationGatewayProbeMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationGatewayProbeMatch | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationGatewayProbeMatch | undefined);
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _statusCode?;
    /**
     * @stability stable
     */
    get statusCode(): string[];
    /**
     * @stability stable
     */
    set statusCode(value: string[]);
    /**
     * @stability stable
     */
    resetStatusCode(): void;
    /**
     * @stability stable
     */
    get statusCodeInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationGatewayProbe {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#host ApplicationGateway#host}.
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#interval ApplicationGateway#interval}.
     *
     * @stability stable
     */
    readonly interval: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#minimum_servers ApplicationGateway#minimum_servers}.
     *
     * @stability stable
     */
    readonly minimumServers?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#path ApplicationGateway#path}.
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#pick_host_name_from_backend_http_settings ApplicationGateway#pick_host_name_from_backend_http_settings}.
     *
     * @stability stable
     */
    readonly pickHostNameFromBackendHttpSettings?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#port ApplicationGateway#port}.
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#protocol ApplicationGateway#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#timeout ApplicationGateway#timeout}.
     *
     * @stability stable
     */
    readonly timeout: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#unhealthy_threshold ApplicationGateway#unhealthy_threshold}.
     *
     * @stability stable
     */
    readonly unhealthyThreshold: number;
    /**
     * match block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#match ApplicationGateway#match}
     *
     * @stability stable
     */
    readonly match?: ApplicationGatewayProbeMatch;
}
export declare function applicationGatewayProbeToTerraform(struct?: ApplicationGatewayProbe): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayRedirectConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#include_path ApplicationGateway#include_path}.
     *
     * @stability stable
     */
    readonly includePath?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#include_query_string ApplicationGateway#include_query_string}.
     *
     * @stability stable
     */
    readonly includeQueryString?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#redirect_type ApplicationGateway#redirect_type}.
     *
     * @stability stable
     */
    readonly redirectType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#target_listener_name ApplicationGateway#target_listener_name}.
     *
     * @stability stable
     */
    readonly targetListenerName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#target_url ApplicationGateway#target_url}.
     *
     * @stability stable
     */
    readonly targetUrl?: string;
}
export declare function applicationGatewayRedirectConfigurationToTerraform(struct?: ApplicationGatewayRedirectConfiguration): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayRequestRoutingRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_address_pool_name ApplicationGateway#backend_address_pool_name}.
     *
     * @stability stable
     */
    readonly backendAddressPoolName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_http_settings_name ApplicationGateway#backend_http_settings_name}.
     *
     * @stability stable
     */
    readonly backendHttpSettingsName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#http_listener_name ApplicationGateway#http_listener_name}.
     *
     * @stability stable
     */
    readonly httpListenerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#priority ApplicationGateway#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#redirect_configuration_name ApplicationGateway#redirect_configuration_name}.
     *
     * @stability stable
     */
    readonly redirectConfigurationName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rewrite_rule_set_name ApplicationGateway#rewrite_rule_set_name}.
     *
     * @stability stable
     */
    readonly rewriteRuleSetName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rule_type ApplicationGateway#rule_type}.
     *
     * @stability stable
     */
    readonly ruleType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#url_path_map_name ApplicationGateway#url_path_map_name}.
     *
     * @stability stable
     */
    readonly urlPathMapName?: string;
}
export declare function applicationGatewayRequestRoutingRuleToTerraform(struct?: ApplicationGatewayRequestRoutingRule): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayRewriteRuleSetRewriteRuleCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ignore_case ApplicationGateway#ignore_case}.
     *
     * @stability stable
     */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#negate ApplicationGateway#negate}.
     *
     * @stability stable
     */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#pattern ApplicationGateway#pattern}.
     *
     * @stability stable
     */
    readonly pattern: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#variable ApplicationGateway#variable}.
     *
     * @stability stable
     */
    readonly variable: string;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleConditionToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleCondition): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#header_name ApplicationGateway#header_name}.
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#header_value ApplicationGateway#header_value}.
     *
     * @stability stable
     */
    readonly headerValue: string;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#header_name ApplicationGateway#header_name}.
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#header_value ApplicationGateway#header_value}.
     *
     * @stability stable
     */
    readonly headerValue: string;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayRewriteRuleSetRewriteRuleUrl {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#path ApplicationGateway#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#query_string ApplicationGateway#query_string}.
     *
     * @stability stable
     */
    readonly queryString?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#reroute ApplicationGateway#reroute}.
     *
     * @stability stable
     */
    readonly reroute?: boolean | cdktf.IResolvable;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleUrlToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRuleUrlOutputReference | ApplicationGatewayRewriteRuleSetRewriteRuleUrl): any;
/**
 * @stability stable
 */
export declare class ApplicationGatewayRewriteRuleSetRewriteRuleUrlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationGatewayRewriteRuleSetRewriteRuleUrl | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationGatewayRewriteRuleSetRewriteRuleUrl | undefined);
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _queryString?;
    /**
     * @stability stable
     */
    get queryString(): string;
    /**
     * @stability stable
     */
    set queryString(value: string);
    /**
     * @stability stable
     */
    resetQueryString(): void;
    /**
     * @stability stable
     */
    get queryStringInput(): string | undefined;
    private _reroute?;
    /**
     * @stability stable
     */
    get reroute(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set reroute(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReroute(): void;
    /**
     * @stability stable
     */
    get rerouteInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationGatewayRewriteRuleSetRewriteRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rule_sequence ApplicationGateway#rule_sequence}.
     *
     * @stability stable
     */
    readonly ruleSequence: number;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#condition ApplicationGateway#condition}
     *
     * @stability stable
     */
    readonly condition?: ApplicationGatewayRewriteRuleSetRewriteRuleCondition[];
    /**
     * request_header_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#request_header_configuration ApplicationGateway#request_header_configuration}
     *
     * @stability stable
     */
    readonly requestHeaderConfiguration?: ApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration[];
    /**
     * response_header_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#response_header_configuration ApplicationGateway#response_header_configuration}
     *
     * @stability stable
     */
    readonly responseHeaderConfiguration?: ApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration[];
    /**
     * url block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#url ApplicationGateway#url}
     *
     * @stability stable
     */
    readonly url?: ApplicationGatewayRewriteRuleSetRewriteRuleUrl;
}
export declare function applicationGatewayRewriteRuleSetRewriteRuleToTerraform(struct?: ApplicationGatewayRewriteRuleSetRewriteRule): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayRewriteRuleSet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * rewrite_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rewrite_rule ApplicationGateway#rewrite_rule}
     *
     * @stability stable
     */
    readonly rewriteRule?: ApplicationGatewayRewriteRuleSetRewriteRule[];
}
export declare function applicationGatewayRewriteRuleSetToTerraform(struct?: ApplicationGatewayRewriteRuleSet): any;
/**
 * @stability stable
 */
export interface ApplicationGatewaySku {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#capacity ApplicationGateway#capacity}.
     *
     * @stability stable
     */
    readonly capacity?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#tier ApplicationGateway#tier}.
     *
     * @stability stable
     */
    readonly tier: string;
}
export declare function applicationGatewaySkuToTerraform(struct?: ApplicationGatewaySkuOutputReference | ApplicationGatewaySku): any;
/**
 * @stability stable
 */
export declare class ApplicationGatewaySkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationGatewaySku | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationGatewaySku | undefined);
    private _capacity?;
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    set capacity(value: number);
    /**
     * @stability stable
     */
    resetCapacity(): void;
    /**
     * @stability stable
     */
    get capacityInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationGatewaySslCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#data ApplicationGateway#data}.
     *
     * @stability stable
     */
    readonly data?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#key_vault_secret_id ApplicationGateway#key_vault_secret_id}.
     *
     * @stability stable
     */
    readonly keyVaultSecretId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#password ApplicationGateway#password}.
     *
     * @stability stable
     */
    readonly password?: string;
}
export declare function applicationGatewaySslCertificateToTerraform(struct?: ApplicationGatewaySslCertificate): any;
/**
 * @stability stable
 */
export interface ApplicationGatewaySslPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#cipher_suites ApplicationGateway#cipher_suites}.
     *
     * @stability stable
     */
    readonly cipherSuites?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#disabled_protocols ApplicationGateway#disabled_protocols}.
     *
     * @stability stable
     */
    readonly disabledProtocols?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#min_protocol_version ApplicationGateway#min_protocol_version}.
     *
     * @stability stable
     */
    readonly minProtocolVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#policy_name ApplicationGateway#policy_name}.
     *
     * @stability stable
     */
    readonly policyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#policy_type ApplicationGateway#policy_type}.
     *
     * @stability stable
     */
    readonly policyType?: string;
}
export declare function applicationGatewaySslPolicyToTerraform(struct?: ApplicationGatewaySslPolicyOutputReference | ApplicationGatewaySslPolicy): any;
/**
 * @stability stable
 */
export declare class ApplicationGatewaySslPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationGatewaySslPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationGatewaySslPolicy | undefined);
    private _cipherSuites?;
    /**
     * @stability stable
     */
    get cipherSuites(): string[];
    /**
     * @stability stable
     */
    set cipherSuites(value: string[]);
    /**
     * @stability stable
     */
    resetCipherSuites(): void;
    /**
     * @stability stable
     */
    get cipherSuitesInput(): string[] | undefined;
    private _disabledProtocols?;
    /**
     * @stability stable
     */
    get disabledProtocols(): string[];
    /**
     * @stability stable
     */
    set disabledProtocols(value: string[]);
    /**
     * @stability stable
     */
    resetDisabledProtocols(): void;
    /**
     * @stability stable
     */
    get disabledProtocolsInput(): string[] | undefined;
    private _minProtocolVersion?;
    /**
     * @stability stable
     */
    get minProtocolVersion(): string;
    /**
     * @stability stable
     */
    set minProtocolVersion(value: string);
    /**
     * @stability stable
     */
    resetMinProtocolVersion(): void;
    /**
     * @stability stable
     */
    get minProtocolVersionInput(): string | undefined;
    private _policyName?;
    /**
     * @stability stable
     */
    get policyName(): string;
    /**
     * @stability stable
     */
    set policyName(value: string);
    /**
     * @stability stable
     */
    resetPolicyName(): void;
    /**
     * @stability stable
     */
    get policyNameInput(): string | undefined;
    private _policyType?;
    /**
     * @stability stable
     */
    get policyType(): string;
    /**
     * @stability stable
     */
    set policyType(value: string);
    /**
     * @stability stable
     */
    resetPolicyType(): void;
    /**
     * @stability stable
     */
    get policyTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationGatewaySslProfileSslPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#cipher_suites ApplicationGateway#cipher_suites}.
     *
     * @stability stable
     */
    readonly cipherSuites?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#disabled_protocols ApplicationGateway#disabled_protocols}.
     *
     * @stability stable
     */
    readonly disabledProtocols?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#min_protocol_version ApplicationGateway#min_protocol_version}.
     *
     * @stability stable
     */
    readonly minProtocolVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#policy_name ApplicationGateway#policy_name}.
     *
     * @stability stable
     */
    readonly policyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#policy_type ApplicationGateway#policy_type}.
     *
     * @stability stable
     */
    readonly policyType?: string;
}
export declare function applicationGatewaySslProfileSslPolicyToTerraform(struct?: ApplicationGatewaySslProfileSslPolicyOutputReference | ApplicationGatewaySslProfileSslPolicy): any;
/**
 * @stability stable
 */
export declare class ApplicationGatewaySslProfileSslPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationGatewaySslProfileSslPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationGatewaySslProfileSslPolicy | undefined);
    private _cipherSuites?;
    /**
     * @stability stable
     */
    get cipherSuites(): string[];
    /**
     * @stability stable
     */
    set cipherSuites(value: string[]);
    /**
     * @stability stable
     */
    resetCipherSuites(): void;
    /**
     * @stability stable
     */
    get cipherSuitesInput(): string[] | undefined;
    private _disabledProtocols?;
    /**
     * @stability stable
     */
    get disabledProtocols(): string[];
    /**
     * @stability stable
     */
    set disabledProtocols(value: string[]);
    /**
     * @stability stable
     */
    resetDisabledProtocols(): void;
    /**
     * @stability stable
     */
    get disabledProtocolsInput(): string[] | undefined;
    private _minProtocolVersion?;
    /**
     * @stability stable
     */
    get minProtocolVersion(): string;
    /**
     * @stability stable
     */
    set minProtocolVersion(value: string);
    /**
     * @stability stable
     */
    resetMinProtocolVersion(): void;
    /**
     * @stability stable
     */
    get minProtocolVersionInput(): string | undefined;
    private _policyName?;
    /**
     * @stability stable
     */
    get policyName(): string;
    /**
     * @stability stable
     */
    set policyName(value: string);
    /**
     * @stability stable
     */
    resetPolicyName(): void;
    /**
     * @stability stable
     */
    get policyNameInput(): string | undefined;
    private _policyType?;
    /**
     * @stability stable
     */
    get policyType(): string;
    /**
     * @stability stable
     */
    set policyType(value: string);
    /**
     * @stability stable
     */
    resetPolicyType(): void;
    /**
     * @stability stable
     */
    get policyTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationGatewaySslProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#trusted_client_certificate_names ApplicationGateway#trusted_client_certificate_names}.
     *
     * @stability stable
     */
    readonly trustedClientCertificateNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#verify_client_cert_issuer_dn ApplicationGateway#verify_client_cert_issuer_dn}.
     *
     * @stability stable
     */
    readonly verifyClientCertIssuerDn?: boolean | cdktf.IResolvable;
    /**
     * ssl_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#ssl_policy ApplicationGateway#ssl_policy}
     *
     * @stability stable
     */
    readonly sslPolicy?: ApplicationGatewaySslProfileSslPolicy;
}
export declare function applicationGatewaySslProfileToTerraform(struct?: ApplicationGatewaySslProfile): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#create ApplicationGateway#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#delete ApplicationGateway#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#read ApplicationGateway#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#update ApplicationGateway#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function applicationGatewayTimeoutsToTerraform(struct?: ApplicationGatewayTimeoutsOutputReference | ApplicationGatewayTimeouts): any;
/**
 * @stability stable
 */
export declare class ApplicationGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationGatewayTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApplicationGatewayTrustedClientCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#data ApplicationGateway#data}.
     *
     * @stability stable
     */
    readonly data: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function applicationGatewayTrustedClientCertificateToTerraform(struct?: ApplicationGatewayTrustedClientCertificate): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayTrustedRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#data ApplicationGateway#data}.
     *
     * @stability stable
     */
    readonly data?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#key_vault_secret_id ApplicationGateway#key_vault_secret_id}.
     *
     * @stability stable
     */
    readonly keyVaultSecretId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function applicationGatewayTrustedRootCertificateToTerraform(struct?: ApplicationGatewayTrustedRootCertificate): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayUrlPathMapPathRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_address_pool_name ApplicationGateway#backend_address_pool_name}.
     *
     * @stability stable
     */
    readonly backendAddressPoolName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#backend_http_settings_name ApplicationGateway#backend_http_settings_name}.
     *
     * @stability stable
     */
    readonly backendHttpSettingsName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#firewall_policy_id ApplicationGateway#firewall_policy_id}.
     *
     * @stability stable
     */
    readonly firewallPolicyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#paths ApplicationGateway#paths}.
     *
     * @stability stable
     */
    readonly paths: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#redirect_configuration_name ApplicationGateway#redirect_configuration_name}.
     *
     * @stability stable
     */
    readonly redirectConfigurationName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rewrite_rule_set_name ApplicationGateway#rewrite_rule_set_name}.
     *
     * @stability stable
     */
    readonly rewriteRuleSetName?: string;
}
export declare function applicationGatewayUrlPathMapPathRuleToTerraform(struct?: ApplicationGatewayUrlPathMapPathRule): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayUrlPathMap {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#default_backend_address_pool_name ApplicationGateway#default_backend_address_pool_name}.
     *
     * @stability stable
     */
    readonly defaultBackendAddressPoolName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#default_backend_http_settings_name ApplicationGateway#default_backend_http_settings_name}.
     *
     * @stability stable
     */
    readonly defaultBackendHttpSettingsName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#default_redirect_configuration_name ApplicationGateway#default_redirect_configuration_name}.
     *
     * @stability stable
     */
    readonly defaultRedirectConfigurationName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#default_rewrite_rule_set_name ApplicationGateway#default_rewrite_rule_set_name}.
     *
     * @stability stable
     */
    readonly defaultRewriteRuleSetName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#name ApplicationGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * path_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#path_rule ApplicationGateway#path_rule}
     *
     * @stability stable
     */
    readonly pathRule: ApplicationGatewayUrlPathMapPathRule[];
}
export declare function applicationGatewayUrlPathMapToTerraform(struct?: ApplicationGatewayUrlPathMap): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayWafConfigurationDisabledRuleGroup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rule_group_name ApplicationGateway#rule_group_name}.
     *
     * @stability stable
     */
    readonly ruleGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rules ApplicationGateway#rules}.
     *
     * @stability stable
     */
    readonly rules?: number[];
}
export declare function applicationGatewayWafConfigurationDisabledRuleGroupToTerraform(struct?: ApplicationGatewayWafConfigurationDisabledRuleGroup): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayWafConfigurationExclusion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#match_variable ApplicationGateway#match_variable}.
     *
     * @stability stable
     */
    readonly matchVariable: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#selector ApplicationGateway#selector}.
     *
     * @stability stable
     */
    readonly selector?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#selector_match_operator ApplicationGateway#selector_match_operator}.
     *
     * @stability stable
     */
    readonly selectorMatchOperator?: string;
}
export declare function applicationGatewayWafConfigurationExclusionToTerraform(struct?: ApplicationGatewayWafConfigurationExclusion): any;
/**
 * @stability stable
 */
export interface ApplicationGatewayWafConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#enabled ApplicationGateway#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#file_upload_limit_mb ApplicationGateway#file_upload_limit_mb}.
     *
     * @stability stable
     */
    readonly fileUploadLimitMb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#firewall_mode ApplicationGateway#firewall_mode}.
     *
     * @stability stable
     */
    readonly firewallMode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#max_request_body_size_kb ApplicationGateway#max_request_body_size_kb}.
     *
     * @stability stable
     */
    readonly maxRequestBodySizeKb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#request_body_check ApplicationGateway#request_body_check}.
     *
     * @stability stable
     */
    readonly requestBodyCheck?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rule_set_type ApplicationGateway#rule_set_type}.
     *
     * @stability stable
     */
    readonly ruleSetType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#rule_set_version ApplicationGateway#rule_set_version}.
     *
     * @stability stable
     */
    readonly ruleSetVersion: string;
    /**
     * disabled_rule_group block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#disabled_rule_group ApplicationGateway#disabled_rule_group}
     *
     * @stability stable
     */
    readonly disabledRuleGroup?: ApplicationGatewayWafConfigurationDisabledRuleGroup[];
    /**
     * exclusion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway#exclusion ApplicationGateway#exclusion}
     *
     * @stability stable
     */
    readonly exclusion?: ApplicationGatewayWafConfigurationExclusion[];
}
export declare function applicationGatewayWafConfigurationToTerraform(struct?: ApplicationGatewayWafConfigurationOutputReference | ApplicationGatewayWafConfiguration): any;
/**
 * @stability stable
 */
export declare class ApplicationGatewayWafConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationGatewayWafConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationGatewayWafConfiguration | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _fileUploadLimitMb?;
    /**
     * @stability stable
     */
    get fileUploadLimitMb(): number;
    /**
     * @stability stable
     */
    set fileUploadLimitMb(value: number);
    /**
     * @stability stable
     */
    resetFileUploadLimitMb(): void;
    /**
     * @stability stable
     */
    get fileUploadLimitMbInput(): number | undefined;
    private _firewallMode?;
    /**
     * @stability stable
     */
    get firewallMode(): string;
    /**
     * @stability stable
     */
    set firewallMode(value: string);
    /**
     * @stability stable
     */
    get firewallModeInput(): string | undefined;
    private _maxRequestBodySizeKb?;
    /**
     * @stability stable
     */
    get maxRequestBodySizeKb(): number;
    /**
     * @stability stable
     */
    set maxRequestBodySizeKb(value: number);
    /**
     * @stability stable
     */
    resetMaxRequestBodySizeKb(): void;
    /**
     * @stability stable
     */
    get maxRequestBodySizeKbInput(): number | undefined;
    private _requestBodyCheck?;
    /**
     * @stability stable
     */
    get requestBodyCheck(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requestBodyCheck(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequestBodyCheck(): void;
    /**
     * @stability stable
     */
    get requestBodyCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _ruleSetType?;
    /**
     * @stability stable
     */
    get ruleSetType(): string;
    /**
     * @stability stable
     */
    set ruleSetType(value: string);
    /**
     * @stability stable
     */
    resetRuleSetType(): void;
    /**
     * @stability stable
     */
    get ruleSetTypeInput(): string | undefined;
    private _ruleSetVersion?;
    /**
     * @stability stable
     */
    get ruleSetVersion(): string;
    /**
     * @stability stable
     */
    set ruleSetVersion(value: string);
    /**
     * @stability stable
     */
    get ruleSetVersionInput(): string | undefined;
    private _disabledRuleGroup?;
    /**
     * @stability stable
     */
    get disabledRuleGroup(): ApplicationGatewayWafConfigurationDisabledRuleGroup[];
    /**
     * @stability stable
     */
    set disabledRuleGroup(value: ApplicationGatewayWafConfigurationDisabledRuleGroup[]);
    /**
     * @stability stable
     */
    resetDisabledRuleGroup(): void;
    /**
     * @stability stable
     */
    get disabledRuleGroupInput(): ApplicationGatewayWafConfigurationDisabledRuleGroup[] | undefined;
    private _exclusion?;
    /**
     * @stability stable
     */
    get exclusion(): ApplicationGatewayWafConfigurationExclusion[];
    /**
     * @stability stable
     */
    set exclusion(value: ApplicationGatewayWafConfigurationExclusion[]);
    /**
     * @stability stable
     */
    resetExclusion(): void;
    /**
     * @stability stable
     */
    get exclusionInput(): ApplicationGatewayWafConfigurationExclusion[] | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway azurerm_application_gateway}.
 *
 * @stability stable
 */
export declare class ApplicationGateway extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/application_gateway azurerm_application_gateway} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationGatewayConfig);
    private _enableHttp2?;
    /**
     * @stability stable
     */
    get enableHttp2(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableHttp2(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableHttp2(): void;
    /**
     * @stability stable
     */
    get enableHttp2Input(): boolean | cdktf.IResolvable | undefined;
    private _fipsEnabled?;
    /**
     * @stability stable
     */
    get fipsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set fipsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFipsEnabled(): void;
    /**
     * @stability stable
     */
    get fipsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallPolicyId?;
    /**
     * @stability stable
     */
    get firewallPolicyId(): string;
    /**
     * @stability stable
     */
    set firewallPolicyId(value: string);
    /**
     * @stability stable
     */
    resetFirewallPolicyId(): void;
    /**
     * @stability stable
     */
    get firewallPolicyIdInput(): string | undefined;
    private _forceFirewallPolicyAssociation?;
    /**
     * @stability stable
     */
    get forceFirewallPolicyAssociation(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set forceFirewallPolicyAssociation(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetForceFirewallPolicyAssociation(): void;
    /**
     * @stability stable
     */
    get forceFirewallPolicyAssociationInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    privateEndpointConnection(index: string): ApplicationGatewayPrivateEndpointConnection;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _authenticationCertificate?;
    /**
     * @stability stable
     */
    get authenticationCertificate(): ApplicationGatewayAuthenticationCertificate[];
    /**
     * @stability stable
     */
    set authenticationCertificate(value: ApplicationGatewayAuthenticationCertificate[]);
    /**
     * @stability stable
     */
    resetAuthenticationCertificate(): void;
    /**
     * @stability stable
     */
    get authenticationCertificateInput(): ApplicationGatewayAuthenticationCertificate[] | undefined;
    private _autoscaleConfiguration;
    /**
     * @stability stable
     */
    get autoscaleConfiguration(): ApplicationGatewayAutoscaleConfigurationOutputReference;
    /**
     * @stability stable
     */
    putAutoscaleConfiguration(value: ApplicationGatewayAutoscaleConfiguration): void;
    /**
     * @stability stable
     */
    resetAutoscaleConfiguration(): void;
    /**
     * @stability stable
     */
    get autoscaleConfigurationInput(): ApplicationGatewayAutoscaleConfiguration | undefined;
    private _backendAddressPool?;
    /**
     * @stability stable
     */
    get backendAddressPool(): ApplicationGatewayBackendAddressPool[];
    /**
     * @stability stable
     */
    set backendAddressPool(value: ApplicationGatewayBackendAddressPool[]);
    /**
     * @stability stable
     */
    get backendAddressPoolInput(): ApplicationGatewayBackendAddressPool[] | undefined;
    private _backendHttpSettings?;
    /**
     * @stability stable
     */
    get backendHttpSettings(): ApplicationGatewayBackendHttpSettings[];
    /**
     * @stability stable
     */
    set backendHttpSettings(value: ApplicationGatewayBackendHttpSettings[]);
    /**
     * @stability stable
     */
    get backendHttpSettingsInput(): ApplicationGatewayBackendHttpSettings[] | undefined;
    private _customErrorConfiguration?;
    /**
     * @stability stable
     */
    get customErrorConfiguration(): ApplicationGatewayCustomErrorConfiguration[];
    /**
     * @stability stable
     */
    set customErrorConfiguration(value: ApplicationGatewayCustomErrorConfiguration[]);
    /**
     * @stability stable
     */
    resetCustomErrorConfiguration(): void;
    /**
     * @stability stable
     */
    get customErrorConfigurationInput(): ApplicationGatewayCustomErrorConfiguration[] | undefined;
    private _frontendIpConfiguration?;
    /**
     * @stability stable
     */
    get frontendIpConfiguration(): ApplicationGatewayFrontendIpConfiguration[];
    /**
     * @stability stable
     */
    set frontendIpConfiguration(value: ApplicationGatewayFrontendIpConfiguration[]);
    /**
     * @stability stable
     */
    get frontendIpConfigurationInput(): ApplicationGatewayFrontendIpConfiguration[] | undefined;
    private _frontendPort?;
    /**
     * @stability stable
     */
    get frontendPort(): ApplicationGatewayFrontendPort[];
    /**
     * @stability stable
     */
    set frontendPort(value: ApplicationGatewayFrontendPort[]);
    /**
     * @stability stable
     */
    get frontendPortInput(): ApplicationGatewayFrontendPort[] | undefined;
    private _gatewayIpConfiguration?;
    /**
     * @stability stable
     */
    get gatewayIpConfiguration(): ApplicationGatewayGatewayIpConfiguration[];
    /**
     * @stability stable
     */
    set gatewayIpConfiguration(value: ApplicationGatewayGatewayIpConfiguration[]);
    /**
     * @stability stable
     */
    get gatewayIpConfigurationInput(): ApplicationGatewayGatewayIpConfiguration[] | undefined;
    private _httpListener?;
    /**
     * @stability stable
     */
    get httpListener(): ApplicationGatewayHttpListener[];
    /**
     * @stability stable
     */
    set httpListener(value: ApplicationGatewayHttpListener[]);
    /**
     * @stability stable
     */
    get httpListenerInput(): ApplicationGatewayHttpListener[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): ApplicationGatewayIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: ApplicationGatewayIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): ApplicationGatewayIdentity | undefined;
    private _privateLinkConfiguration?;
    /**
     * @stability stable
     */
    get privateLinkConfiguration(): ApplicationGatewayPrivateLinkConfiguration[];
    /**
     * @stability stable
     */
    set privateLinkConfiguration(value: ApplicationGatewayPrivateLinkConfiguration[]);
    /**
     * @stability stable
     */
    resetPrivateLinkConfiguration(): void;
    /**
     * @stability stable
     */
    get privateLinkConfigurationInput(): ApplicationGatewayPrivateLinkConfiguration[] | undefined;
    private _probe?;
    /**
     * @stability stable
     */
    get probe(): ApplicationGatewayProbe[];
    /**
     * @stability stable
     */
    set probe(value: ApplicationGatewayProbe[]);
    /**
     * @stability stable
     */
    resetProbe(): void;
    /**
     * @stability stable
     */
    get probeInput(): ApplicationGatewayProbe[] | undefined;
    private _redirectConfiguration?;
    /**
     * @stability stable
     */
    get redirectConfiguration(): ApplicationGatewayRedirectConfiguration[];
    /**
     * @stability stable
     */
    set redirectConfiguration(value: ApplicationGatewayRedirectConfiguration[]);
    /**
     * @stability stable
     */
    resetRedirectConfiguration(): void;
    /**
     * @stability stable
     */
    get redirectConfigurationInput(): ApplicationGatewayRedirectConfiguration[] | undefined;
    private _requestRoutingRule?;
    /**
     * @stability stable
     */
    get requestRoutingRule(): ApplicationGatewayRequestRoutingRule[];
    /**
     * @stability stable
     */
    set requestRoutingRule(value: ApplicationGatewayRequestRoutingRule[]);
    /**
     * @stability stable
     */
    get requestRoutingRuleInput(): ApplicationGatewayRequestRoutingRule[] | undefined;
    private _rewriteRuleSet?;
    /**
     * @stability stable
     */
    get rewriteRuleSet(): ApplicationGatewayRewriteRuleSet[];
    /**
     * @stability stable
     */
    set rewriteRuleSet(value: ApplicationGatewayRewriteRuleSet[]);
    /**
     * @stability stable
     */
    resetRewriteRuleSet(): void;
    /**
     * @stability stable
     */
    get rewriteRuleSetInput(): ApplicationGatewayRewriteRuleSet[] | undefined;
    private _sku;
    /**
     * @stability stable
     */
    get sku(): ApplicationGatewaySkuOutputReference;
    /**
     * @stability stable
     */
    putSku(value: ApplicationGatewaySku): void;
    /**
     * @stability stable
     */
    get skuInput(): ApplicationGatewaySku | undefined;
    private _sslCertificate?;
    /**
     * @stability stable
     */
    get sslCertificate(): ApplicationGatewaySslCertificate[];
    /**
     * @stability stable
     */
    set sslCertificate(value: ApplicationGatewaySslCertificate[]);
    /**
     * @stability stable
     */
    resetSslCertificate(): void;
    /**
     * @stability stable
     */
    get sslCertificateInput(): ApplicationGatewaySslCertificate[] | undefined;
    private _sslPolicy;
    /**
     * @stability stable
     */
    get sslPolicy(): ApplicationGatewaySslPolicyOutputReference;
    /**
     * @stability stable
     */
    putSslPolicy(value: ApplicationGatewaySslPolicy): void;
    /**
     * @stability stable
     */
    resetSslPolicy(): void;
    /**
     * @stability stable
     */
    get sslPolicyInput(): ApplicationGatewaySslPolicy | undefined;
    private _sslProfile?;
    /**
     * @stability stable
     */
    get sslProfile(): ApplicationGatewaySslProfile[];
    /**
     * @stability stable
     */
    set sslProfile(value: ApplicationGatewaySslProfile[]);
    /**
     * @stability stable
     */
    resetSslProfile(): void;
    /**
     * @stability stable
     */
    get sslProfileInput(): ApplicationGatewaySslProfile[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApplicationGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApplicationGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApplicationGatewayTimeouts | undefined;
    private _trustedClientCertificate?;
    /**
     * @stability stable
     */
    get trustedClientCertificate(): ApplicationGatewayTrustedClientCertificate[];
    /**
     * @stability stable
     */
    set trustedClientCertificate(value: ApplicationGatewayTrustedClientCertificate[]);
    /**
     * @stability stable
     */
    resetTrustedClientCertificate(): void;
    /**
     * @stability stable
     */
    get trustedClientCertificateInput(): ApplicationGatewayTrustedClientCertificate[] | undefined;
    private _trustedRootCertificate?;
    /**
     * @stability stable
     */
    get trustedRootCertificate(): ApplicationGatewayTrustedRootCertificate[];
    /**
     * @stability stable
     */
    set trustedRootCertificate(value: ApplicationGatewayTrustedRootCertificate[]);
    /**
     * @stability stable
     */
    resetTrustedRootCertificate(): void;
    /**
     * @stability stable
     */
    get trustedRootCertificateInput(): ApplicationGatewayTrustedRootCertificate[] | undefined;
    private _urlPathMap?;
    /**
     * @stability stable
     */
    get urlPathMap(): ApplicationGatewayUrlPathMap[];
    /**
     * @stability stable
     */
    set urlPathMap(value: ApplicationGatewayUrlPathMap[]);
    /**
     * @stability stable
     */
    resetUrlPathMap(): void;
    /**
     * @stability stable
     */
    get urlPathMapInput(): ApplicationGatewayUrlPathMap[] | undefined;
    private _wafConfiguration;
    /**
     * @stability stable
     */
    get wafConfiguration(): ApplicationGatewayWafConfigurationOutputReference;
    /**
     * @stability stable
     */
    putWafConfiguration(value: ApplicationGatewayWafConfiguration): void;
    /**
     * @stability stable
     */
    resetWafConfiguration(): void;
    /**
     * @stability stable
     */
    get wafConfigurationInput(): ApplicationGatewayWafConfiguration | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
