import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationInsightsApiKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_api_key#application_insights_id ApplicationInsightsApiKey#application_insights_id}.
     *
     * @stability stable
     */
    readonly applicationInsightsId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_api_key#name ApplicationInsightsApiKey#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_api_key#read_permissions ApplicationInsightsApiKey#read_permissions}.
     *
     * @stability stable
     */
    readonly readPermissions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_api_key#write_permissions ApplicationInsightsApiKey#write_permissions}.
     *
     * @stability stable
     */
    readonly writePermissions?: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_api_key#timeouts ApplicationInsightsApiKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApplicationInsightsApiKeyTimeouts;
}
/**
 * @stability stable
 */
export interface ApplicationInsightsApiKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_api_key#create ApplicationInsightsApiKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_api_key#delete ApplicationInsightsApiKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_api_key#read ApplicationInsightsApiKey#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_api_key#update ApplicationInsightsApiKey#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function applicationInsightsApiKeyTimeoutsToTerraform(struct?: ApplicationInsightsApiKeyTimeoutsOutputReference | ApplicationInsightsApiKeyTimeouts): any;
/**
 * @stability stable
 */
export declare class ApplicationInsightsApiKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationInsightsApiKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationInsightsApiKeyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_api_key azurerm_application_insights_api_key}.
 *
 * @stability stable
 */
export declare class ApplicationInsightsApiKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_api_key azurerm_application_insights_api_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationInsightsApiKeyConfig);
    /**
     * @stability stable
     */
    get apiKey(): string;
    private _applicationInsightsId?;
    /**
     * @stability stable
     */
    get applicationInsightsId(): string;
    /**
     * @stability stable
     */
    set applicationInsightsId(value: string);
    /**
     * @stability stable
     */
    get applicationInsightsIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _readPermissions?;
    /**
     * @stability stable
     */
    get readPermissions(): string[];
    /**
     * @stability stable
     */
    set readPermissions(value: string[]);
    /**
     * @stability stable
     */
    resetReadPermissions(): void;
    /**
     * @stability stable
     */
    get readPermissionsInput(): string[] | undefined;
    private _writePermissions?;
    /**
     * @stability stable
     */
    get writePermissions(): string[];
    /**
     * @stability stable
     */
    set writePermissions(value: string[]);
    /**
     * @stability stable
     */
    resetWritePermissions(): void;
    /**
     * @stability stable
     */
    get writePermissionsInput(): string[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApplicationInsightsApiKeyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApplicationInsightsApiKeyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApplicationInsightsApiKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
