import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationInsightsSmartDetectionRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule#additional_email_recipients ApplicationInsightsSmartDetectionRule#additional_email_recipients}.
     *
     * @stability stable
     */
    readonly additionalEmailRecipients?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule#application_insights_id ApplicationInsightsSmartDetectionRule#application_insights_id}.
     *
     * @stability stable
     */
    readonly applicationInsightsId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule#enabled ApplicationInsightsSmartDetectionRule#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule#name ApplicationInsightsSmartDetectionRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule#send_emails_to_subscription_owners ApplicationInsightsSmartDetectionRule#send_emails_to_subscription_owners}.
     *
     * @stability stable
     */
    readonly sendEmailsToSubscriptionOwners?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule#timeouts ApplicationInsightsSmartDetectionRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApplicationInsightsSmartDetectionRuleTimeouts;
}
/**
 * @stability stable
 */
export interface ApplicationInsightsSmartDetectionRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule#create ApplicationInsightsSmartDetectionRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule#delete ApplicationInsightsSmartDetectionRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule#read ApplicationInsightsSmartDetectionRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule#update ApplicationInsightsSmartDetectionRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function applicationInsightsSmartDetectionRuleTimeoutsToTerraform(struct?: ApplicationInsightsSmartDetectionRuleTimeoutsOutputReference | ApplicationInsightsSmartDetectionRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class ApplicationInsightsSmartDetectionRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationInsightsSmartDetectionRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationInsightsSmartDetectionRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule azurerm_application_insights_smart_detection_rule}.
 *
 * @stability stable
 */
export declare class ApplicationInsightsSmartDetectionRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_smart_detection_rule azurerm_application_insights_smart_detection_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationInsightsSmartDetectionRuleConfig);
    private _additionalEmailRecipients?;
    /**
     * @stability stable
     */
    get additionalEmailRecipients(): string[];
    /**
     * @stability stable
     */
    set additionalEmailRecipients(value: string[]);
    /**
     * @stability stable
     */
    resetAdditionalEmailRecipients(): void;
    /**
     * @stability stable
     */
    get additionalEmailRecipientsInput(): string[] | undefined;
    private _applicationInsightsId?;
    /**
     * @stability stable
     */
    get applicationInsightsId(): string;
    /**
     * @stability stable
     */
    set applicationInsightsId(value: string);
    /**
     * @stability stable
     */
    get applicationInsightsIdInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sendEmailsToSubscriptionOwners?;
    /**
     * @stability stable
     */
    get sendEmailsToSubscriptionOwners(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sendEmailsToSubscriptionOwners(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSendEmailsToSubscriptionOwners(): void;
    /**
     * @stability stable
     */
    get sendEmailsToSubscriptionOwnersInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApplicationInsightsSmartDetectionRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApplicationInsightsSmartDetectionRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApplicationInsightsSmartDetectionRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
