import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationInsightsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#application_type ApplicationInsights#application_type}.
     *
     * @stability stable
     */
    readonly applicationType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#daily_data_cap_in_gb ApplicationInsights#daily_data_cap_in_gb}.
     *
     * @stability stable
     */
    readonly dailyDataCapInGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#daily_data_cap_notifications_disabled ApplicationInsights#daily_data_cap_notifications_disabled}.
     *
     * @stability stable
     */
    readonly dailyDataCapNotificationsDisabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#disable_ip_masking ApplicationInsights#disable_ip_masking}.
     *
     * @stability stable
     */
    readonly disableIpMasking?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#internet_ingestion_enabled ApplicationInsights#internet_ingestion_enabled}.
     *
     * @stability stable
     */
    readonly internetIngestionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#internet_query_enabled ApplicationInsights#internet_query_enabled}.
     *
     * @stability stable
     */
    readonly internetQueryEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#local_authentication_disabled ApplicationInsights#local_authentication_disabled}.
     *
     * @stability stable
     */
    readonly localAuthenticationDisabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#location ApplicationInsights#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#name ApplicationInsights#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#resource_group_name ApplicationInsights#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#retention_in_days ApplicationInsights#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#sampling_percentage ApplicationInsights#sampling_percentage}.
     *
     * @stability stable
     */
    readonly samplingPercentage?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#tags ApplicationInsights#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#workspace_id ApplicationInsights#workspace_id}.
     *
     * @stability stable
     */
    readonly workspaceId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#timeouts ApplicationInsights#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApplicationInsightsTimeouts;
}
/**
 * @stability stable
 */
export interface ApplicationInsightsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#create ApplicationInsights#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#delete ApplicationInsights#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#read ApplicationInsights#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights#update ApplicationInsights#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function applicationInsightsTimeoutsToTerraform(struct?: ApplicationInsightsTimeoutsOutputReference | ApplicationInsightsTimeouts): any;
/**
 * @stability stable
 */
export declare class ApplicationInsightsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationInsightsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationInsightsTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights azurerm_application_insights}.
 *
 * @stability stable
 */
export declare class ApplicationInsights extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights azurerm_application_insights} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationInsightsConfig);
    /**
     * @stability stable
     */
    get appId(): string;
    private _applicationType?;
    /**
     * @stability stable
     */
    get applicationType(): string;
    /**
     * @stability stable
     */
    set applicationType(value: string);
    /**
     * @stability stable
     */
    get applicationTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get connectionString(): string;
    private _dailyDataCapInGb?;
    /**
     * @stability stable
     */
    get dailyDataCapInGb(): number;
    /**
     * @stability stable
     */
    set dailyDataCapInGb(value: number);
    /**
     * @stability stable
     */
    resetDailyDataCapInGb(): void;
    /**
     * @stability stable
     */
    get dailyDataCapInGbInput(): number | undefined;
    private _dailyDataCapNotificationsDisabled?;
    /**
     * @stability stable
     */
    get dailyDataCapNotificationsDisabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dailyDataCapNotificationsDisabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDailyDataCapNotificationsDisabled(): void;
    /**
     * @stability stable
     */
    get dailyDataCapNotificationsDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _disableIpMasking?;
    /**
     * @stability stable
     */
    get disableIpMasking(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableIpMasking(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableIpMasking(): void;
    /**
     * @stability stable
     */
    get disableIpMaskingInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get instrumentationKey(): string;
    private _internetIngestionEnabled?;
    /**
     * @stability stable
     */
    get internetIngestionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set internetIngestionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInternetIngestionEnabled(): void;
    /**
     * @stability stable
     */
    get internetIngestionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _internetQueryEnabled?;
    /**
     * @stability stable
     */
    get internetQueryEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set internetQueryEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInternetQueryEnabled(): void;
    /**
     * @stability stable
     */
    get internetQueryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _localAuthenticationDisabled?;
    /**
     * @stability stable
     */
    get localAuthenticationDisabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localAuthenticationDisabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalAuthenticationDisabled(): void;
    /**
     * @stability stable
     */
    get localAuthenticationDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _retentionInDays?;
    /**
     * @stability stable
     */
    get retentionInDays(): number;
    /**
     * @stability stable
     */
    set retentionInDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionInDays(): void;
    /**
     * @stability stable
     */
    get retentionInDaysInput(): number | undefined;
    private _samplingPercentage?;
    /**
     * @stability stable
     */
    get samplingPercentage(): number;
    /**
     * @stability stable
     */
    set samplingPercentage(value: number);
    /**
     * @stability stable
     */
    resetSamplingPercentage(): void;
    /**
     * @stability stable
     */
    get samplingPercentageInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _workspaceId?;
    /**
     * @stability stable
     */
    get workspaceId(): string;
    /**
     * @stability stable
     */
    set workspaceId(value: string);
    /**
     * @stability stable
     */
    resetWorkspaceId(): void;
    /**
     * @stability stable
     */
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApplicationInsightsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApplicationInsightsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApplicationInsightsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
