import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AutomationJobScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#automation_account_name AutomationJobSchedule#automation_account_name}.
     *
     * @stability stable
     */
    readonly automationAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#job_schedule_id AutomationJobSchedule#job_schedule_id}.
     *
     * @stability stable
     */
    readonly jobScheduleId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#parameters AutomationJobSchedule#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#resource_group_name AutomationJobSchedule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#run_on AutomationJobSchedule#run_on}.
     *
     * @stability stable
     */
    readonly runOn?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#runbook_name AutomationJobSchedule#runbook_name}.
     *
     * @stability stable
     */
    readonly runbookName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#schedule_name AutomationJobSchedule#schedule_name}.
     *
     * @stability stable
     */
    readonly scheduleName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#timeouts AutomationJobSchedule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AutomationJobScheduleTimeouts;
}
/**
 * @stability stable
 */
export interface AutomationJobScheduleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#create AutomationJobSchedule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#delete AutomationJobSchedule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#read AutomationJobSchedule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#update AutomationJobSchedule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function automationJobScheduleTimeoutsToTerraform(struct?: AutomationJobScheduleTimeoutsOutputReference | AutomationJobScheduleTimeouts): any;
/**
 * @stability stable
 */
export declare class AutomationJobScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AutomationJobScheduleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AutomationJobScheduleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule azurerm_automation_job_schedule}.
 *
 * @stability stable
 */
export declare class AutomationJobSchedule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule azurerm_automation_job_schedule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AutomationJobScheduleConfig);
    private _automationAccountName?;
    /**
     * @stability stable
     */
    get automationAccountName(): string;
    /**
     * @stability stable
     */
    set automationAccountName(value: string);
    /**
     * @stability stable
     */
    get automationAccountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _jobScheduleId?;
    /**
     * @stability stable
     */
    get jobScheduleId(): string;
    /**
     * @stability stable
     */
    set jobScheduleId(value: string);
    /**
     * @stability stable
     */
    resetJobScheduleId(): void;
    /**
     * @stability stable
     */
    get jobScheduleIdInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _runOn?;
    /**
     * @stability stable
     */
    get runOn(): string;
    /**
     * @stability stable
     */
    set runOn(value: string);
    /**
     * @stability stable
     */
    resetRunOn(): void;
    /**
     * @stability stable
     */
    get runOnInput(): string | undefined;
    private _runbookName?;
    /**
     * @stability stable
     */
    get runbookName(): string;
    /**
     * @stability stable
     */
    set runbookName(value: string);
    /**
     * @stability stable
     */
    get runbookNameInput(): string | undefined;
    private _scheduleName?;
    /**
     * @stability stable
     */
    get scheduleName(): string;
    /**
     * @stability stable
     */
    set scheduleName(value: string);
    /**
     * @stability stable
     */
    get scheduleNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AutomationJobScheduleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AutomationJobScheduleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AutomationJobScheduleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
