import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AutomationScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#automation_account_name AutomationSchedule#automation_account_name}.
     *
     * @stability stable
     */
    readonly automationAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#description AutomationSchedule#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#expiry_time AutomationSchedule#expiry_time}.
     *
     * @stability stable
     */
    readonly expiryTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#frequency AutomationSchedule#frequency}.
     *
     * @stability stable
     */
    readonly frequency: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#interval AutomationSchedule#interval}.
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#month_days AutomationSchedule#month_days}.
     *
     * @stability stable
     */
    readonly monthDays?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#name AutomationSchedule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#resource_group_name AutomationSchedule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#start_time AutomationSchedule#start_time}.
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#timezone AutomationSchedule#timezone}.
     *
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#week_days AutomationSchedule#week_days}.
     *
     * @stability stable
     */
    readonly weekDays?: string[];
    /**
     * monthly_occurrence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#monthly_occurrence AutomationSchedule#monthly_occurrence}
     *
     * @stability stable
     */
    readonly monthlyOccurrence?: AutomationScheduleMonthlyOccurrence[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#timeouts AutomationSchedule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AutomationScheduleTimeouts;
}
/**
 * @stability stable
 */
export interface AutomationScheduleMonthlyOccurrence {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#day AutomationSchedule#day}.
     *
     * @stability stable
     */
    readonly day: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#occurrence AutomationSchedule#occurrence}.
     *
     * @stability stable
     */
    readonly occurrence: number;
}
export declare function automationScheduleMonthlyOccurrenceToTerraform(struct?: AutomationScheduleMonthlyOccurrence): any;
/**
 * @stability stable
 */
export interface AutomationScheduleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#create AutomationSchedule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#delete AutomationSchedule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#read AutomationSchedule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule#update AutomationSchedule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function automationScheduleTimeoutsToTerraform(struct?: AutomationScheduleTimeoutsOutputReference | AutomationScheduleTimeouts): any;
/**
 * @stability stable
 */
export declare class AutomationScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AutomationScheduleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AutomationScheduleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule azurerm_automation_schedule}.
 *
 * @stability stable
 */
export declare class AutomationSchedule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/automation_schedule azurerm_automation_schedule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AutomationScheduleConfig);
    private _automationAccountName?;
    /**
     * @stability stable
     */
    get automationAccountName(): string;
    /**
     * @stability stable
     */
    set automationAccountName(value: string);
    /**
     * @stability stable
     */
    get automationAccountNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expiryTime?;
    /**
     * @stability stable
     */
    get expiryTime(): string;
    /**
     * @stability stable
     */
    set expiryTime(value: string);
    /**
     * @stability stable
     */
    resetExpiryTime(): void;
    /**
     * @stability stable
     */
    get expiryTimeInput(): string | undefined;
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): string;
    /**
     * @stability stable
     */
    set frequency(value: string);
    /**
     * @stability stable
     */
    get frequencyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
    private _monthDays?;
    /**
     * @stability stable
     */
    get monthDays(): number[];
    /**
     * @stability stable
     */
    set monthDays(value: number[]);
    /**
     * @stability stable
     */
    resetMonthDays(): void;
    /**
     * @stability stable
     */
    get monthDaysInput(): number[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _weekDays?;
    /**
     * @stability stable
     */
    get weekDays(): string[];
    /**
     * @stability stable
     */
    set weekDays(value: string[]);
    /**
     * @stability stable
     */
    resetWeekDays(): void;
    /**
     * @stability stable
     */
    get weekDaysInput(): string[] | undefined;
    private _monthlyOccurrence?;
    /**
     * @stability stable
     */
    get monthlyOccurrence(): AutomationScheduleMonthlyOccurrence[];
    /**
     * @stability stable
     */
    set monthlyOccurrence(value: AutomationScheduleMonthlyOccurrence[]);
    /**
     * @stability stable
     */
    resetMonthlyOccurrence(): void;
    /**
     * @stability stable
     */
    get monthlyOccurrenceInput(): AutomationScheduleMonthlyOccurrence[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AutomationScheduleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AutomationScheduleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AutomationScheduleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
