import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BackupPolicyVmConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#instant_restore_retention_days BackupPolicyVm#instant_restore_retention_days}.
     *
     * @stability stable
     */
    readonly instantRestoreRetentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#name BackupPolicyVm#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#recovery_vault_name BackupPolicyVm#recovery_vault_name}.
     *
     * @stability stable
     */
    readonly recoveryVaultName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#resource_group_name BackupPolicyVm#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#tags BackupPolicyVm#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#timezone BackupPolicyVm#timezone}.
     *
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * backup block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#backup BackupPolicyVm#backup}
     *
     * @stability stable
     */
    readonly backup: BackupPolicyVmBackup;
    /**
     * retention_daily block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#retention_daily BackupPolicyVm#retention_daily}
     *
     * @stability stable
     */
    readonly retentionDaily?: BackupPolicyVmRetentionDaily;
    /**
     * retention_monthly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#retention_monthly BackupPolicyVm#retention_monthly}
     *
     * @stability stable
     */
    readonly retentionMonthly?: BackupPolicyVmRetentionMonthly;
    /**
     * retention_weekly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#retention_weekly BackupPolicyVm#retention_weekly}
     *
     * @stability stable
     */
    readonly retentionWeekly?: BackupPolicyVmRetentionWeekly;
    /**
     * retention_yearly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#retention_yearly BackupPolicyVm#retention_yearly}
     *
     * @stability stable
     */
    readonly retentionYearly?: BackupPolicyVmRetentionYearly;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#timeouts BackupPolicyVm#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BackupPolicyVmTimeouts;
}
/**
 * @stability stable
 */
export interface BackupPolicyVmBackup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#frequency BackupPolicyVm#frequency}.
     *
     * @stability stable
     */
    readonly frequency: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#time BackupPolicyVm#time}.
     *
     * @stability stable
     */
    readonly time: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#weekdays BackupPolicyVm#weekdays}.
     *
     * @stability stable
     */
    readonly weekdays?: string[];
}
export declare function backupPolicyVmBackupToTerraform(struct?: BackupPolicyVmBackupOutputReference | BackupPolicyVmBackup): any;
/**
 * @stability stable
 */
export declare class BackupPolicyVmBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyVmBackup | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyVmBackup | undefined);
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): string;
    /**
     * @stability stable
     */
    set frequency(value: string);
    /**
     * @stability stable
     */
    get frequencyInput(): string | undefined;
    private _time?;
    /**
     * @stability stable
     */
    get time(): string;
    /**
     * @stability stable
     */
    set time(value: string);
    /**
     * @stability stable
     */
    get timeInput(): string | undefined;
    private _weekdays?;
    /**
     * @stability stable
     */
    get weekdays(): string[];
    /**
     * @stability stable
     */
    set weekdays(value: string[]);
    /**
     * @stability stable
     */
    resetWeekdays(): void;
    /**
     * @stability stable
     */
    get weekdaysInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface BackupPolicyVmRetentionDaily {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#count BackupPolicyVm#count}.
     *
     * @stability stable
     */
    readonly count: number;
}
export declare function backupPolicyVmRetentionDailyToTerraform(struct?: BackupPolicyVmRetentionDailyOutputReference | BackupPolicyVmRetentionDaily): any;
/**
 * @stability stable
 */
export declare class BackupPolicyVmRetentionDailyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyVmRetentionDaily | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyVmRetentionDaily | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface BackupPolicyVmRetentionMonthly {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#count BackupPolicyVm#count}.
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#weekdays BackupPolicyVm#weekdays}.
     *
     * @stability stable
     */
    readonly weekdays: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#weeks BackupPolicyVm#weeks}.
     *
     * @stability stable
     */
    readonly weeks: string[];
}
export declare function backupPolicyVmRetentionMonthlyToTerraform(struct?: BackupPolicyVmRetentionMonthlyOutputReference | BackupPolicyVmRetentionMonthly): any;
/**
 * @stability stable
 */
export declare class BackupPolicyVmRetentionMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyVmRetentionMonthly | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyVmRetentionMonthly | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _weekdays?;
    /**
     * @stability stable
     */
    get weekdays(): string[];
    /**
     * @stability stable
     */
    set weekdays(value: string[]);
    /**
     * @stability stable
     */
    get weekdaysInput(): string[] | undefined;
    private _weeks?;
    /**
     * @stability stable
     */
    get weeks(): string[];
    /**
     * @stability stable
     */
    set weeks(value: string[]);
    /**
     * @stability stable
     */
    get weeksInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface BackupPolicyVmRetentionWeekly {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#count BackupPolicyVm#count}.
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#weekdays BackupPolicyVm#weekdays}.
     *
     * @stability stable
     */
    readonly weekdays: string[];
}
export declare function backupPolicyVmRetentionWeeklyToTerraform(struct?: BackupPolicyVmRetentionWeeklyOutputReference | BackupPolicyVmRetentionWeekly): any;
/**
 * @stability stable
 */
export declare class BackupPolicyVmRetentionWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyVmRetentionWeekly | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyVmRetentionWeekly | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _weekdays?;
    /**
     * @stability stable
     */
    get weekdays(): string[];
    /**
     * @stability stable
     */
    set weekdays(value: string[]);
    /**
     * @stability stable
     */
    get weekdaysInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface BackupPolicyVmRetentionYearly {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#count BackupPolicyVm#count}.
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#months BackupPolicyVm#months}.
     *
     * @stability stable
     */
    readonly months: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#weekdays BackupPolicyVm#weekdays}.
     *
     * @stability stable
     */
    readonly weekdays: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#weeks BackupPolicyVm#weeks}.
     *
     * @stability stable
     */
    readonly weeks: string[];
}
export declare function backupPolicyVmRetentionYearlyToTerraform(struct?: BackupPolicyVmRetentionYearlyOutputReference | BackupPolicyVmRetentionYearly): any;
/**
 * @stability stable
 */
export declare class BackupPolicyVmRetentionYearlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyVmRetentionYearly | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyVmRetentionYearly | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _months?;
    /**
     * @stability stable
     */
    get months(): string[];
    /**
     * @stability stable
     */
    set months(value: string[]);
    /**
     * @stability stable
     */
    get monthsInput(): string[] | undefined;
    private _weekdays?;
    /**
     * @stability stable
     */
    get weekdays(): string[];
    /**
     * @stability stable
     */
    set weekdays(value: string[]);
    /**
     * @stability stable
     */
    get weekdaysInput(): string[] | undefined;
    private _weeks?;
    /**
     * @stability stable
     */
    get weeks(): string[];
    /**
     * @stability stable
     */
    set weeks(value: string[]);
    /**
     * @stability stable
     */
    get weeksInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface BackupPolicyVmTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#create BackupPolicyVm#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#delete BackupPolicyVm#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#read BackupPolicyVm#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm#update BackupPolicyVm#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function backupPolicyVmTimeoutsToTerraform(struct?: BackupPolicyVmTimeoutsOutputReference | BackupPolicyVmTimeouts): any;
/**
 * @stability stable
 */
export declare class BackupPolicyVmTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyVmTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyVmTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm azurerm_backup_policy_vm}.
 *
 * @stability stable
 */
export declare class BackupPolicyVm extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_vm azurerm_backup_policy_vm} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BackupPolicyVmConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _instantRestoreRetentionDays?;
    /**
     * @stability stable
     */
    get instantRestoreRetentionDays(): number;
    /**
     * @stability stable
     */
    set instantRestoreRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetInstantRestoreRetentionDays(): void;
    /**
     * @stability stable
     */
    get instantRestoreRetentionDaysInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _recoveryVaultName?;
    /**
     * @stability stable
     */
    get recoveryVaultName(): string;
    /**
     * @stability stable
     */
    set recoveryVaultName(value: string);
    /**
     * @stability stable
     */
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _backup;
    /**
     * @stability stable
     */
    get backup(): BackupPolicyVmBackupOutputReference;
    /**
     * @stability stable
     */
    putBackup(value: BackupPolicyVmBackup): void;
    /**
     * @stability stable
     */
    get backupInput(): BackupPolicyVmBackup | undefined;
    private _retentionDaily;
    /**
     * @stability stable
     */
    get retentionDaily(): BackupPolicyVmRetentionDailyOutputReference;
    /**
     * @stability stable
     */
    putRetentionDaily(value: BackupPolicyVmRetentionDaily): void;
    /**
     * @stability stable
     */
    resetRetentionDaily(): void;
    /**
     * @stability stable
     */
    get retentionDailyInput(): BackupPolicyVmRetentionDaily | undefined;
    private _retentionMonthly;
    /**
     * @stability stable
     */
    get retentionMonthly(): BackupPolicyVmRetentionMonthlyOutputReference;
    /**
     * @stability stable
     */
    putRetentionMonthly(value: BackupPolicyVmRetentionMonthly): void;
    /**
     * @stability stable
     */
    resetRetentionMonthly(): void;
    /**
     * @stability stable
     */
    get retentionMonthlyInput(): BackupPolicyVmRetentionMonthly | undefined;
    private _retentionWeekly;
    /**
     * @stability stable
     */
    get retentionWeekly(): BackupPolicyVmRetentionWeeklyOutputReference;
    /**
     * @stability stable
     */
    putRetentionWeekly(value: BackupPolicyVmRetentionWeekly): void;
    /**
     * @stability stable
     */
    resetRetentionWeekly(): void;
    /**
     * @stability stable
     */
    get retentionWeeklyInput(): BackupPolicyVmRetentionWeekly | undefined;
    private _retentionYearly;
    /**
     * @stability stable
     */
    get retentionYearly(): BackupPolicyVmRetentionYearlyOutputReference;
    /**
     * @stability stable
     */
    putRetentionYearly(value: BackupPolicyVmRetentionYearly): void;
    /**
     * @stability stable
     */
    resetRetentionYearly(): void;
    /**
     * @stability stable
     */
    get retentionYearlyInput(): BackupPolicyVmRetentionYearly | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BackupPolicyVmTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BackupPolicyVmTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BackupPolicyVmTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
