import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BatchPoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#account_name BatchPool#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#display_name BatchPool#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#max_tasks_per_node BatchPool#max_tasks_per_node}.
     *
     * @stability stable
     */
    readonly maxTasksPerNode?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#metadata BatchPool#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#name BatchPool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#node_agent_sku_id BatchPool#node_agent_sku_id}.
     *
     * @stability stable
     */
    readonly nodeAgentSkuId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#resource_group_name BatchPool#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#stop_pending_resize_operation BatchPool#stop_pending_resize_operation}.
     *
     * @stability stable
     */
    readonly stopPendingResizeOperation?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#vm_size BatchPool#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
    /**
     * auto_scale block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#auto_scale BatchPool#auto_scale}
     *
     * @stability stable
     */
    readonly autoScale?: BatchPoolAutoScale;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#certificate BatchPool#certificate}
     *
     * @stability stable
     */
    readonly certificate?: BatchPoolCertificate[];
    /**
     * container_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#container_configuration BatchPool#container_configuration}
     *
     * @stability stable
     */
    readonly containerConfiguration?: BatchPoolContainerConfiguration;
    /**
     * fixed_scale block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#fixed_scale BatchPool#fixed_scale}
     *
     * @stability stable
     */
    readonly fixedScale?: BatchPoolFixedScale;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#identity BatchPool#identity}
     *
     * @stability stable
     */
    readonly identity?: BatchPoolIdentity;
    /**
     * network_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#network_configuration BatchPool#network_configuration}
     *
     * @stability stable
     */
    readonly networkConfiguration?: BatchPoolNetworkConfiguration;
    /**
     * start_task block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#start_task BatchPool#start_task}
     *
     * @stability stable
     */
    readonly startTask?: BatchPoolStartTask;
    /**
     * storage_image_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#storage_image_reference BatchPool#storage_image_reference}
     *
     * @stability stable
     */
    readonly storageImageReference: BatchPoolStorageImageReference;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#timeouts BatchPool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BatchPoolTimeouts;
}
/**
 * @stability stable
 */
export interface BatchPoolAutoScale {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#evaluation_interval BatchPool#evaluation_interval}.
     *
     * @stability stable
     */
    readonly evaluationInterval?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#formula BatchPool#formula}.
     *
     * @stability stable
     */
    readonly formula: string;
}
export declare function batchPoolAutoScaleToTerraform(struct?: BatchPoolAutoScaleOutputReference | BatchPoolAutoScale): any;
/**
 * @stability stable
 */
export declare class BatchPoolAutoScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BatchPoolAutoScale | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BatchPoolAutoScale | undefined);
    private _evaluationInterval?;
    /**
     * @stability stable
     */
    get evaluationInterval(): string;
    /**
     * @stability stable
     */
    set evaluationInterval(value: string);
    /**
     * @stability stable
     */
    resetEvaluationInterval(): void;
    /**
     * @stability stable
     */
    get evaluationIntervalInput(): string | undefined;
    private _formula?;
    /**
     * @stability stable
     */
    get formula(): string;
    /**
     * @stability stable
     */
    set formula(value: string);
    /**
     * @stability stable
     */
    get formulaInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BatchPoolCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#id BatchPool#id}.
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#store_location BatchPool#store_location}.
     *
     * @stability stable
     */
    readonly storeLocation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#store_name BatchPool#store_name}.
     *
     * @stability stable
     */
    readonly storeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#visibility BatchPool#visibility}.
     *
     * @stability stable
     */
    readonly visibility?: string[];
}
export declare function batchPoolCertificateToTerraform(struct?: BatchPoolCertificate): any;
/**
 * @stability stable
 */
export interface BatchPoolContainerConfigurationContainerRegistries {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#password BatchPool#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#registry_server BatchPool#registry_server}.
     *
     * @stability stable
     */
    readonly registryServer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#user_name BatchPool#user_name}.
     *
     * @stability stable
     */
    readonly userName?: string;
}
export declare function batchPoolContainerConfigurationContainerRegistriesToTerraform(struct?: BatchPoolContainerConfigurationContainerRegistries): any;
/**
 * @stability stable
 */
export interface BatchPoolContainerConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#container_image_names BatchPool#container_image_names}.
     *
     * @stability stable
     */
    readonly containerImageNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#container_registries BatchPool#container_registries}.
     *
     * @stability stable
     */
    readonly containerRegistries?: BatchPoolContainerConfigurationContainerRegistries[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#type BatchPool#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function batchPoolContainerConfigurationToTerraform(struct?: BatchPoolContainerConfigurationOutputReference | BatchPoolContainerConfiguration): any;
/**
 * @stability stable
 */
export declare class BatchPoolContainerConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BatchPoolContainerConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BatchPoolContainerConfiguration | undefined);
    private _containerImageNames?;
    /**
     * @stability stable
     */
    get containerImageNames(): string[];
    /**
     * @stability stable
     */
    set containerImageNames(value: string[]);
    /**
     * @stability stable
     */
    resetContainerImageNames(): void;
    /**
     * @stability stable
     */
    get containerImageNamesInput(): string[] | undefined;
    private _containerRegistries?;
    /**
     * @stability stable
     */
    get containerRegistries(): BatchPoolContainerConfigurationContainerRegistries[];
    /**
     * @stability stable
     */
    set containerRegistries(value: BatchPoolContainerConfigurationContainerRegistries[]);
    /**
     * @stability stable
     */
    resetContainerRegistries(): void;
    /**
     * @stability stable
     */
    get containerRegistriesInput(): BatchPoolContainerConfigurationContainerRegistries[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BatchPoolFixedScale {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#resize_timeout BatchPool#resize_timeout}.
     *
     * @stability stable
     */
    readonly resizeTimeout?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#target_dedicated_nodes BatchPool#target_dedicated_nodes}.
     *
     * @stability stable
     */
    readonly targetDedicatedNodes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#target_low_priority_nodes BatchPool#target_low_priority_nodes}.
     *
     * @stability stable
     */
    readonly targetLowPriorityNodes?: number;
}
export declare function batchPoolFixedScaleToTerraform(struct?: BatchPoolFixedScaleOutputReference | BatchPoolFixedScale): any;
/**
 * @stability stable
 */
export declare class BatchPoolFixedScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BatchPoolFixedScale | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BatchPoolFixedScale | undefined);
    private _resizeTimeout?;
    /**
     * @stability stable
     */
    get resizeTimeout(): string;
    /**
     * @stability stable
     */
    set resizeTimeout(value: string);
    /**
     * @stability stable
     */
    resetResizeTimeout(): void;
    /**
     * @stability stable
     */
    get resizeTimeoutInput(): string | undefined;
    private _targetDedicatedNodes?;
    /**
     * @stability stable
     */
    get targetDedicatedNodes(): number;
    /**
     * @stability stable
     */
    set targetDedicatedNodes(value: number);
    /**
     * @stability stable
     */
    resetTargetDedicatedNodes(): void;
    /**
     * @stability stable
     */
    get targetDedicatedNodesInput(): number | undefined;
    private _targetLowPriorityNodes?;
    /**
     * @stability stable
     */
    get targetLowPriorityNodes(): number;
    /**
     * @stability stable
     */
    set targetLowPriorityNodes(value: number);
    /**
     * @stability stable
     */
    resetTargetLowPriorityNodes(): void;
    /**
     * @stability stable
     */
    get targetLowPriorityNodesInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface BatchPoolIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#identity_ids BatchPool#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#type BatchPool#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function batchPoolIdentityToTerraform(struct?: BatchPoolIdentityOutputReference | BatchPoolIdentity): any;
/**
 * @stability stable
 */
export declare class BatchPoolIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BatchPoolIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BatchPoolIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#access BatchPool#access}.
     *
     * @stability stable
     */
    readonly access: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#priority BatchPool#priority}.
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#source_address_prefix BatchPool#source_address_prefix}.
     *
     * @stability stable
     */
    readonly sourceAddressPrefix: string;
}
export declare function batchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesToTerraform(struct?: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules): any;
/**
 * @stability stable
 */
export interface BatchPoolNetworkConfigurationEndpointConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#backend_port BatchPool#backend_port}.
     *
     * @stability stable
     */
    readonly backendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#frontend_port_range BatchPool#frontend_port_range}.
     *
     * @stability stable
     */
    readonly frontendPortRange: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#name BatchPool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#protocol BatchPool#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * network_security_group_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#network_security_group_rules BatchPool#network_security_group_rules}
     *
     * @stability stable
     */
    readonly networkSecurityGroupRules?: BatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules[];
}
export declare function batchPoolNetworkConfigurationEndpointConfigurationToTerraform(struct?: BatchPoolNetworkConfigurationEndpointConfiguration): any;
/**
 * @stability stable
 */
export interface BatchPoolNetworkConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#public_address_provisioning_type BatchPool#public_address_provisioning_type}.
     *
     * @stability stable
     */
    readonly publicAddressProvisioningType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#public_ips BatchPool#public_ips}.
     *
     * @stability stable
     */
    readonly publicIps?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#subnet_id BatchPool#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * endpoint_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#endpoint_configuration BatchPool#endpoint_configuration}
     *
     * @stability stable
     */
    readonly endpointConfiguration?: BatchPoolNetworkConfigurationEndpointConfiguration[];
}
export declare function batchPoolNetworkConfigurationToTerraform(struct?: BatchPoolNetworkConfigurationOutputReference | BatchPoolNetworkConfiguration): any;
/**
 * @stability stable
 */
export declare class BatchPoolNetworkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BatchPoolNetworkConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BatchPoolNetworkConfiguration | undefined);
    private _publicAddressProvisioningType?;
    /**
     * @stability stable
     */
    get publicAddressProvisioningType(): string;
    /**
     * @stability stable
     */
    set publicAddressProvisioningType(value: string);
    /**
     * @stability stable
     */
    resetPublicAddressProvisioningType(): void;
    /**
     * @stability stable
     */
    get publicAddressProvisioningTypeInput(): string | undefined;
    private _publicIps?;
    /**
     * @stability stable
     */
    get publicIps(): string[];
    /**
     * @stability stable
     */
    set publicIps(value: string[]);
    /**
     * @stability stable
     */
    resetPublicIps(): void;
    /**
     * @stability stable
     */
    get publicIpsInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _endpointConfiguration?;
    /**
     * @stability stable
     */
    get endpointConfiguration(): BatchPoolNetworkConfigurationEndpointConfiguration[];
    /**
     * @stability stable
     */
    set endpointConfiguration(value: BatchPoolNetworkConfigurationEndpointConfiguration[]);
    /**
     * @stability stable
     */
    resetEndpointConfiguration(): void;
    /**
     * @stability stable
     */
    get endpointConfigurationInput(): BatchPoolNetworkConfigurationEndpointConfiguration[] | undefined;
}
/**
 * @stability stable
 */
export interface BatchPoolStartTaskResourceFile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#auto_storage_container_name BatchPool#auto_storage_container_name}.
     *
     * @stability stable
     */
    readonly autoStorageContainerName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#blob_prefix BatchPool#blob_prefix}.
     *
     * @stability stable
     */
    readonly blobPrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#file_mode BatchPool#file_mode}.
     *
     * @stability stable
     */
    readonly fileMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#file_path BatchPool#file_path}.
     *
     * @stability stable
     */
    readonly filePath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#http_url BatchPool#http_url}.
     *
     * @stability stable
     */
    readonly httpUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#storage_container_url BatchPool#storage_container_url}.
     *
     * @stability stable
     */
    readonly storageContainerUrl?: string;
}
export declare function batchPoolStartTaskResourceFileToTerraform(struct?: BatchPoolStartTaskResourceFile): any;
/**
 * @stability stable
 */
export interface BatchPoolStartTaskUserIdentityAutoUser {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#elevation_level BatchPool#elevation_level}.
     *
     * @stability stable
     */
    readonly elevationLevel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#scope BatchPool#scope}.
     *
     * @stability stable
     */
    readonly scope?: string;
}
export declare function batchPoolStartTaskUserIdentityAutoUserToTerraform(struct?: BatchPoolStartTaskUserIdentityAutoUserOutputReference | BatchPoolStartTaskUserIdentityAutoUser): any;
/**
 * @stability stable
 */
export declare class BatchPoolStartTaskUserIdentityAutoUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BatchPoolStartTaskUserIdentityAutoUser | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BatchPoolStartTaskUserIdentityAutoUser | undefined);
    private _elevationLevel?;
    /**
     * @stability stable
     */
    get elevationLevel(): string;
    /**
     * @stability stable
     */
    set elevationLevel(value: string);
    /**
     * @stability stable
     */
    resetElevationLevel(): void;
    /**
     * @stability stable
     */
    get elevationLevelInput(): string | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BatchPoolStartTaskUserIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#user_name BatchPool#user_name}.
     *
     * @stability stable
     */
    readonly userName?: string;
    /**
     * auto_user block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#auto_user BatchPool#auto_user}
     *
     * @stability stable
     */
    readonly autoUser?: BatchPoolStartTaskUserIdentityAutoUser;
}
export declare function batchPoolStartTaskUserIdentityToTerraform(struct?: BatchPoolStartTaskUserIdentityOutputReference | BatchPoolStartTaskUserIdentity): any;
/**
 * @stability stable
 */
export declare class BatchPoolStartTaskUserIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BatchPoolStartTaskUserIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BatchPoolStartTaskUserIdentity | undefined);
    private _userName?;
    /**
     * @stability stable
     */
    get userName(): string;
    /**
     * @stability stable
     */
    set userName(value: string);
    /**
     * @stability stable
     */
    resetUserName(): void;
    /**
     * @stability stable
     */
    get userNameInput(): string | undefined;
    private _autoUser;
    /**
     * @stability stable
     */
    get autoUser(): BatchPoolStartTaskUserIdentityAutoUserOutputReference;
    /**
     * @stability stable
     */
    putAutoUser(value: BatchPoolStartTaskUserIdentityAutoUser): void;
    /**
     * @stability stable
     */
    resetAutoUser(): void;
    /**
     * @stability stable
     */
    get autoUserInput(): BatchPoolStartTaskUserIdentityAutoUser | undefined;
}
/**
 * @stability stable
 */
export interface BatchPoolStartTask {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#command_line BatchPool#command_line}.
     *
     * @stability stable
     */
    readonly commandLine: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#common_environment_properties BatchPool#common_environment_properties}.
     *
     * @stability stable
     */
    readonly commonEnvironmentProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#environment BatchPool#environment}.
     *
     * @stability stable
     */
    readonly environment?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#max_task_retry_count BatchPool#max_task_retry_count}.
     *
     * @stability stable
     */
    readonly maxTaskRetryCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#task_retry_maximum BatchPool#task_retry_maximum}.
     *
     * @stability stable
     */
    readonly taskRetryMaximum?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#wait_for_success BatchPool#wait_for_success}.
     *
     * @stability stable
     */
    readonly waitForSuccess?: boolean | cdktf.IResolvable;
    /**
     * resource_file block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#resource_file BatchPool#resource_file}
     *
     * @stability stable
     */
    readonly resourceFile?: BatchPoolStartTaskResourceFile[];
    /**
     * user_identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#user_identity BatchPool#user_identity}
     *
     * @stability stable
     */
    readonly userIdentity: BatchPoolStartTaskUserIdentity;
}
export declare function batchPoolStartTaskToTerraform(struct?: BatchPoolStartTaskOutputReference | BatchPoolStartTask): any;
/**
 * @stability stable
 */
export declare class BatchPoolStartTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BatchPoolStartTask | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BatchPoolStartTask | undefined);
    private _commandLine?;
    /**
     * @stability stable
     */
    get commandLine(): string;
    /**
     * @stability stable
     */
    set commandLine(value: string);
    /**
     * @stability stable
     */
    get commandLineInput(): string | undefined;
    private _commonEnvironmentProperties?;
    /**
     * @stability stable
     */
    get commonEnvironmentProperties(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set commonEnvironmentProperties(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCommonEnvironmentProperties(): void;
    /**
     * @stability stable
     */
    get commonEnvironmentPropertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _environment?;
    /**
     * @stability stable
     */
    get environment(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set environment(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnvironment(): void;
    /**
     * @stability stable
     */
    get environmentInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _maxTaskRetryCount?;
    /**
     * @stability stable
     */
    get maxTaskRetryCount(): number;
    /**
     * @stability stable
     */
    set maxTaskRetryCount(value: number);
    /**
     * @stability stable
     */
    resetMaxTaskRetryCount(): void;
    /**
     * @stability stable
     */
    get maxTaskRetryCountInput(): number | undefined;
    private _taskRetryMaximum?;
    /**
     * @stability stable
     */
    get taskRetryMaximum(): number;
    /**
     * @stability stable
     */
    set taskRetryMaximum(value: number);
    /**
     * @stability stable
     */
    resetTaskRetryMaximum(): void;
    /**
     * @stability stable
     */
    get taskRetryMaximumInput(): number | undefined;
    private _waitForSuccess?;
    /**
     * @stability stable
     */
    get waitForSuccess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set waitForSuccess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWaitForSuccess(): void;
    /**
     * @stability stable
     */
    get waitForSuccessInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceFile?;
    /**
     * @stability stable
     */
    get resourceFile(): BatchPoolStartTaskResourceFile[];
    /**
     * @stability stable
     */
    set resourceFile(value: BatchPoolStartTaskResourceFile[]);
    /**
     * @stability stable
     */
    resetResourceFile(): void;
    /**
     * @stability stable
     */
    get resourceFileInput(): BatchPoolStartTaskResourceFile[] | undefined;
    private _userIdentity;
    /**
     * @stability stable
     */
    get userIdentity(): BatchPoolStartTaskUserIdentityOutputReference;
    /**
     * @stability stable
     */
    putUserIdentity(value: BatchPoolStartTaskUserIdentity): void;
    /**
     * @stability stable
     */
    get userIdentityInput(): BatchPoolStartTaskUserIdentity | undefined;
}
/**
 * @stability stable
 */
export interface BatchPoolStorageImageReference {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#id BatchPool#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#offer BatchPool#offer}.
     *
     * @stability stable
     */
    readonly offer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#publisher BatchPool#publisher}.
     *
     * @stability stable
     */
    readonly publisher?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#sku BatchPool#sku}.
     *
     * @stability stable
     */
    readonly sku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#version BatchPool#version}.
     *
     * @stability stable
     */
    readonly version?: string;
}
export declare function batchPoolStorageImageReferenceToTerraform(struct?: BatchPoolStorageImageReferenceOutputReference | BatchPoolStorageImageReference): any;
/**
 * @stability stable
 */
export declare class BatchPoolStorageImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BatchPoolStorageImageReference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BatchPoolStorageImageReference | undefined);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _offer?;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    set offer(value: string);
    /**
     * @stability stable
     */
    resetOffer(): void;
    /**
     * @stability stable
     */
    get offerInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    resetPublisher(): void;
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    resetSku(): void;
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BatchPoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#create BatchPool#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#delete BatchPool#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#read BatchPool#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool#update BatchPool#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function batchPoolTimeoutsToTerraform(struct?: BatchPoolTimeoutsOutputReference | BatchPoolTimeouts): any;
/**
 * @stability stable
 */
export declare class BatchPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BatchPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BatchPoolTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool azurerm_batch_pool}.
 *
 * @stability stable
 */
export declare class BatchPool extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/batch_pool azurerm_batch_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BatchPoolConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _maxTasksPerNode?;
    /**
     * @stability stable
     */
    get maxTasksPerNode(): number;
    /**
     * @stability stable
     */
    set maxTasksPerNode(value: number);
    /**
     * @stability stable
     */
    resetMaxTasksPerNode(): void;
    /**
     * @stability stable
     */
    get maxTasksPerNodeInput(): number | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeAgentSkuId?;
    /**
     * @stability stable
     */
    get nodeAgentSkuId(): string;
    /**
     * @stability stable
     */
    set nodeAgentSkuId(value: string);
    /**
     * @stability stable
     */
    get nodeAgentSkuIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _stopPendingResizeOperation?;
    /**
     * @stability stable
     */
    get stopPendingResizeOperation(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stopPendingResizeOperation(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStopPendingResizeOperation(): void;
    /**
     * @stability stable
     */
    get stopPendingResizeOperationInput(): boolean | cdktf.IResolvable | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
    private _autoScale;
    /**
     * @stability stable
     */
    get autoScale(): BatchPoolAutoScaleOutputReference;
    /**
     * @stability stable
     */
    putAutoScale(value: BatchPoolAutoScale): void;
    /**
     * @stability stable
     */
    resetAutoScale(): void;
    /**
     * @stability stable
     */
    get autoScaleInput(): BatchPoolAutoScale | undefined;
    private _certificate?;
    /**
     * @stability stable
     */
    get certificate(): BatchPoolCertificate[];
    /**
     * @stability stable
     */
    set certificate(value: BatchPoolCertificate[]);
    /**
     * @stability stable
     */
    resetCertificate(): void;
    /**
     * @stability stable
     */
    get certificateInput(): BatchPoolCertificate[] | undefined;
    private _containerConfiguration;
    /**
     * @stability stable
     */
    get containerConfiguration(): BatchPoolContainerConfigurationOutputReference;
    /**
     * @stability stable
     */
    putContainerConfiguration(value: BatchPoolContainerConfiguration): void;
    /**
     * @stability stable
     */
    resetContainerConfiguration(): void;
    /**
     * @stability stable
     */
    get containerConfigurationInput(): BatchPoolContainerConfiguration | undefined;
    private _fixedScale;
    /**
     * @stability stable
     */
    get fixedScale(): BatchPoolFixedScaleOutputReference;
    /**
     * @stability stable
     */
    putFixedScale(value: BatchPoolFixedScale): void;
    /**
     * @stability stable
     */
    resetFixedScale(): void;
    /**
     * @stability stable
     */
    get fixedScaleInput(): BatchPoolFixedScale | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): BatchPoolIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: BatchPoolIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): BatchPoolIdentity | undefined;
    private _networkConfiguration;
    /**
     * @stability stable
     */
    get networkConfiguration(): BatchPoolNetworkConfigurationOutputReference;
    /**
     * @stability stable
     */
    putNetworkConfiguration(value: BatchPoolNetworkConfiguration): void;
    /**
     * @stability stable
     */
    resetNetworkConfiguration(): void;
    /**
     * @stability stable
     */
    get networkConfigurationInput(): BatchPoolNetworkConfiguration | undefined;
    private _startTask;
    /**
     * @stability stable
     */
    get startTask(): BatchPoolStartTaskOutputReference;
    /**
     * @stability stable
     */
    putStartTask(value: BatchPoolStartTask): void;
    /**
     * @stability stable
     */
    resetStartTask(): void;
    /**
     * @stability stable
     */
    get startTaskInput(): BatchPoolStartTask | undefined;
    private _storageImageReference;
    /**
     * @stability stable
     */
    get storageImageReference(): BatchPoolStorageImageReferenceOutputReference;
    /**
     * @stability stable
     */
    putStorageImageReference(value: BatchPoolStorageImageReference): void;
    /**
     * @stability stable
     */
    get storageImageReferenceInput(): BatchPoolStorageImageReference | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BatchPoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BatchPoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BatchPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
