import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BotChannelWebChatConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#bot_name BotChannelWebChat#bot_name}.
     *
     * @stability stable
     */
    readonly botName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#location BotChannelWebChat#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#resource_group_name BotChannelWebChat#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#site_names BotChannelWebChat#site_names}.
     *
     * @stability stable
     */
    readonly siteNames: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#timeouts BotChannelWebChat#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BotChannelWebChatTimeouts;
}
/**
 * @stability stable
 */
export interface BotChannelWebChatTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#create BotChannelWebChat#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#delete BotChannelWebChat#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#read BotChannelWebChat#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#update BotChannelWebChat#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function botChannelWebChatTimeoutsToTerraform(struct?: BotChannelWebChatTimeoutsOutputReference | BotChannelWebChatTimeouts): any;
/**
 * @stability stable
 */
export declare class BotChannelWebChatTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BotChannelWebChatTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BotChannelWebChatTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat azurerm_bot_channel_web_chat}.
 *
 * @stability stable
 */
export declare class BotChannelWebChat extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat azurerm_bot_channel_web_chat} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BotChannelWebChatConfig);
    private _botName?;
    /**
     * @stability stable
     */
    get botName(): string;
    /**
     * @stability stable
     */
    set botName(value: string);
    /**
     * @stability stable
     */
    get botNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _siteNames?;
    /**
     * @stability stable
     */
    get siteNames(): string[];
    /**
     * @stability stable
     */
    set siteNames(value: string[]);
    /**
     * @stability stable
     */
    get siteNamesInput(): string[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BotChannelWebChatTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BotChannelWebChatTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BotChannelWebChatTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
