import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CdnEndpointCustomDomainConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#cdn_endpoint_id CdnEndpointCustomDomain#cdn_endpoint_id}.
     *
     * @stability stable
     */
    readonly cdnEndpointId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#host_name CdnEndpointCustomDomain#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#name CdnEndpointCustomDomain#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * cdn_managed_https block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#cdn_managed_https CdnEndpointCustomDomain#cdn_managed_https}
     *
     * @stability stable
     */
    readonly cdnManagedHttps?: CdnEndpointCustomDomainCdnManagedHttps;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#timeouts CdnEndpointCustomDomain#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CdnEndpointCustomDomainTimeouts;
    /**
     * user_managed_https block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#user_managed_https CdnEndpointCustomDomain#user_managed_https}
     *
     * @stability stable
     */
    readonly userManagedHttps?: CdnEndpointCustomDomainUserManagedHttps;
}
/**
 * @stability stable
 */
export interface CdnEndpointCustomDomainCdnManagedHttps {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#certificate_type CdnEndpointCustomDomain#certificate_type}.
     *
     * @stability stable
     */
    readonly certificateType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#protocol_type CdnEndpointCustomDomain#protocol_type}.
     *
     * @stability stable
     */
    readonly protocolType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#tls_version CdnEndpointCustomDomain#tls_version}.
     *
     * @stability stable
     */
    readonly tlsVersion?: string;
}
export declare function cdnEndpointCustomDomainCdnManagedHttpsToTerraform(struct?: CdnEndpointCustomDomainCdnManagedHttpsOutputReference | CdnEndpointCustomDomainCdnManagedHttps): any;
/**
 * @stability stable
 */
export declare class CdnEndpointCustomDomainCdnManagedHttpsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointCustomDomainCdnManagedHttps | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointCustomDomainCdnManagedHttps | undefined);
    private _certificateType?;
    /**
     * @stability stable
     */
    get certificateType(): string;
    /**
     * @stability stable
     */
    set certificateType(value: string);
    /**
     * @stability stable
     */
    get certificateTypeInput(): string | undefined;
    private _protocolType?;
    /**
     * @stability stable
     */
    get protocolType(): string;
    /**
     * @stability stable
     */
    set protocolType(value: string);
    /**
     * @stability stable
     */
    get protocolTypeInput(): string | undefined;
    private _tlsVersion?;
    /**
     * @stability stable
     */
    get tlsVersion(): string;
    /**
     * @stability stable
     */
    set tlsVersion(value: string);
    /**
     * @stability stable
     */
    resetTlsVersion(): void;
    /**
     * @stability stable
     */
    get tlsVersionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointCustomDomainTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#create CdnEndpointCustomDomain#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#delete CdnEndpointCustomDomain#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#read CdnEndpointCustomDomain#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#update CdnEndpointCustomDomain#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cdnEndpointCustomDomainTimeoutsToTerraform(struct?: CdnEndpointCustomDomainTimeoutsOutputReference | CdnEndpointCustomDomainTimeouts): any;
/**
 * @stability stable
 */
export declare class CdnEndpointCustomDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointCustomDomainTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointCustomDomainTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointCustomDomainUserManagedHttps {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#key_vault_certificate_id CdnEndpointCustomDomain#key_vault_certificate_id}.
     *
     * @stability stable
     */
    readonly keyVaultCertificateId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain#tls_version CdnEndpointCustomDomain#tls_version}.
     *
     * @stability stable
     */
    readonly tlsVersion?: string;
}
export declare function cdnEndpointCustomDomainUserManagedHttpsToTerraform(struct?: CdnEndpointCustomDomainUserManagedHttpsOutputReference | CdnEndpointCustomDomainUserManagedHttps): any;
/**
 * @stability stable
 */
export declare class CdnEndpointCustomDomainUserManagedHttpsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointCustomDomainUserManagedHttps | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointCustomDomainUserManagedHttps | undefined);
    private _keyVaultCertificateId?;
    /**
     * @stability stable
     */
    get keyVaultCertificateId(): string;
    /**
     * @stability stable
     */
    set keyVaultCertificateId(value: string);
    /**
     * @stability stable
     */
    get keyVaultCertificateIdInput(): string | undefined;
    private _tlsVersion?;
    /**
     * @stability stable
     */
    get tlsVersion(): string;
    /**
     * @stability stable
     */
    set tlsVersion(value: string);
    /**
     * @stability stable
     */
    resetTlsVersion(): void;
    /**
     * @stability stable
     */
    get tlsVersionInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain azurerm_cdn_endpoint_custom_domain}.
 *
 * @stability stable
 */
export declare class CdnEndpointCustomDomain extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint_custom_domain azurerm_cdn_endpoint_custom_domain} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CdnEndpointCustomDomainConfig);
    private _cdnEndpointId?;
    /**
     * @stability stable
     */
    get cdnEndpointId(): string;
    /**
     * @stability stable
     */
    set cdnEndpointId(value: string);
    /**
     * @stability stable
     */
    get cdnEndpointIdInput(): string | undefined;
    private _hostName?;
    /**
     * @stability stable
     */
    get hostName(): string;
    /**
     * @stability stable
     */
    set hostName(value: string);
    /**
     * @stability stable
     */
    get hostNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _cdnManagedHttps;
    /**
     * @stability stable
     */
    get cdnManagedHttps(): CdnEndpointCustomDomainCdnManagedHttpsOutputReference;
    /**
     * @stability stable
     */
    putCdnManagedHttps(value: CdnEndpointCustomDomainCdnManagedHttps): void;
    /**
     * @stability stable
     */
    resetCdnManagedHttps(): void;
    /**
     * @stability stable
     */
    get cdnManagedHttpsInput(): CdnEndpointCustomDomainCdnManagedHttps | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CdnEndpointCustomDomainTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CdnEndpointCustomDomainTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CdnEndpointCustomDomainTimeouts | undefined;
    private _userManagedHttps;
    /**
     * @stability stable
     */
    get userManagedHttps(): CdnEndpointCustomDomainUserManagedHttpsOutputReference;
    /**
     * @stability stable
     */
    putUserManagedHttps(value: CdnEndpointCustomDomainUserManagedHttps): void;
    /**
     * @stability stable
     */
    resetUserManagedHttps(): void;
    /**
     * @stability stable
     */
    get userManagedHttpsInput(): CdnEndpointCustomDomainUserManagedHttps | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
