import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CdnEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#content_types_to_compress CdnEndpoint#content_types_to_compress}.
     *
     * @stability stable
     */
    readonly contentTypesToCompress?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#is_compression_enabled CdnEndpoint#is_compression_enabled}.
     *
     * @stability stable
     */
    readonly isCompressionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#is_http_allowed CdnEndpoint#is_http_allowed}.
     *
     * @stability stable
     */
    readonly isHttpAllowed?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#is_https_allowed CdnEndpoint#is_https_allowed}.
     *
     * @stability stable
     */
    readonly isHttpsAllowed?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#location CdnEndpoint#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#name CdnEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#optimization_type CdnEndpoint#optimization_type}.
     *
     * @stability stable
     */
    readonly optimizationType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#origin_host_header CdnEndpoint#origin_host_header}.
     *
     * @stability stable
     */
    readonly originHostHeader?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#origin_path CdnEndpoint#origin_path}.
     *
     * @stability stable
     */
    readonly originPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#probe_path CdnEndpoint#probe_path}.
     *
     * @stability stable
     */
    readonly probePath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#profile_name CdnEndpoint#profile_name}.
     *
     * @stability stable
     */
    readonly profileName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#querystring_caching_behaviour CdnEndpoint#querystring_caching_behaviour}.
     *
     * @stability stable
     */
    readonly querystringCachingBehaviour?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#resource_group_name CdnEndpoint#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#tags CdnEndpoint#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * delivery_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#delivery_rule CdnEndpoint#delivery_rule}
     *
     * @stability stable
     */
    readonly deliveryRule?: CdnEndpointDeliveryRule[];
    /**
     * geo_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#geo_filter CdnEndpoint#geo_filter}
     *
     * @stability stable
     */
    readonly geoFilter?: CdnEndpointGeoFilter[];
    /**
     * global_delivery_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#global_delivery_rule CdnEndpoint#global_delivery_rule}
     *
     * @stability stable
     */
    readonly globalDeliveryRule?: CdnEndpointGlobalDeliveryRule;
    /**
     * origin block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#origin CdnEndpoint#origin}
     *
     * @stability stable
     */
    readonly origin: CdnEndpointOrigin[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#timeouts CdnEndpoint#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CdnEndpointTimeouts;
}
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleCacheExpirationAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#behavior CdnEndpoint#behavior}.
     *
     * @stability stable
     */
    readonly behavior: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#duration CdnEndpoint#duration}.
     *
     * @stability stable
     */
    readonly duration?: string;
}
export declare function cdnEndpointDeliveryRuleCacheExpirationActionToTerraform(struct?: CdnEndpointDeliveryRuleCacheExpirationActionOutputReference | CdnEndpointDeliveryRuleCacheExpirationAction): any;
/**
 * @stability stable
 */
export declare class CdnEndpointDeliveryRuleCacheExpirationActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointDeliveryRuleCacheExpirationAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointDeliveryRuleCacheExpirationAction | undefined);
    private _behavior?;
    /**
     * @stability stable
     */
    get behavior(): string;
    /**
     * @stability stable
     */
    set behavior(value: string);
    /**
     * @stability stable
     */
    get behaviorInput(): string | undefined;
    private _duration?;
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    set duration(value: string);
    /**
     * @stability stable
     */
    resetDuration(): void;
    /**
     * @stability stable
     */
    get durationInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleCacheKeyQueryStringAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#behavior CdnEndpoint#behavior}.
     *
     * @stability stable
     */
    readonly behavior: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#parameters CdnEndpoint#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: string;
}
export declare function cdnEndpointDeliveryRuleCacheKeyQueryStringActionToTerraform(struct?: CdnEndpointDeliveryRuleCacheKeyQueryStringActionOutputReference | CdnEndpointDeliveryRuleCacheKeyQueryStringAction): any;
/**
 * @stability stable
 */
export declare class CdnEndpointDeliveryRuleCacheKeyQueryStringActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointDeliveryRuleCacheKeyQueryStringAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointDeliveryRuleCacheKeyQueryStringAction | undefined);
    private _behavior?;
    /**
     * @stability stable
     */
    get behavior(): string;
    /**
     * @stability stable
     */
    set behavior(value: string);
    /**
     * @stability stable
     */
    get behaviorInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): string;
    /**
     * @stability stable
     */
    set parameters(value: string);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleCookiesCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#selector CdnEndpoint#selector}.
     *
     * @stability stable
     */
    readonly selector: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#transforms CdnEndpoint#transforms}.
     *
     * @stability stable
     */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleCookiesConditionToTerraform(struct?: CdnEndpointDeliveryRuleCookiesCondition): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleDeviceCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
}
export declare function cdnEndpointDeliveryRuleDeviceConditionToTerraform(struct?: CdnEndpointDeliveryRuleDeviceConditionOutputReference | CdnEndpointDeliveryRuleDeviceCondition): any;
/**
 * @stability stable
 */
export declare class CdnEndpointDeliveryRuleDeviceConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointDeliveryRuleDeviceCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointDeliveryRuleDeviceCondition | undefined);
    private _matchValues?;
    /**
     * @stability stable
     */
    get matchValues(): string[];
    /**
     * @stability stable
     */
    set matchValues(value: string[]);
    /**
     * @stability stable
     */
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    /**
     * @stability stable
     */
    get negateCondition(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set negateCondition(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNegateCondition(): void;
    /**
     * @stability stable
     */
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    resetOperator(): void;
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleHttpVersionCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
}
export declare function cdnEndpointDeliveryRuleHttpVersionConditionToTerraform(struct?: CdnEndpointDeliveryRuleHttpVersionCondition): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleModifyRequestHeaderAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#action CdnEndpoint#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#name CdnEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#value CdnEndpoint#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function cdnEndpointDeliveryRuleModifyRequestHeaderActionToTerraform(struct?: CdnEndpointDeliveryRuleModifyRequestHeaderAction): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleModifyResponseHeaderAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#action CdnEndpoint#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#name CdnEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#value CdnEndpoint#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function cdnEndpointDeliveryRuleModifyResponseHeaderActionToTerraform(struct?: CdnEndpointDeliveryRuleModifyResponseHeaderAction): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRulePostArgCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#selector CdnEndpoint#selector}.
     *
     * @stability stable
     */
    readonly selector: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#transforms CdnEndpoint#transforms}.
     *
     * @stability stable
     */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRulePostArgConditionToTerraform(struct?: CdnEndpointDeliveryRulePostArgCondition): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleQueryStringCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#transforms CdnEndpoint#transforms}.
     *
     * @stability stable
     */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleQueryStringConditionToTerraform(struct?: CdnEndpointDeliveryRuleQueryStringCondition): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleRemoteAddressCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
}
export declare function cdnEndpointDeliveryRuleRemoteAddressConditionToTerraform(struct?: CdnEndpointDeliveryRuleRemoteAddressCondition): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleRequestBodyCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#transforms CdnEndpoint#transforms}.
     *
     * @stability stable
     */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleRequestBodyConditionToTerraform(struct?: CdnEndpointDeliveryRuleRequestBodyCondition): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleRequestHeaderCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#selector CdnEndpoint#selector}.
     *
     * @stability stable
     */
    readonly selector: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#transforms CdnEndpoint#transforms}.
     *
     * @stability stable
     */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleRequestHeaderConditionToTerraform(struct?: CdnEndpointDeliveryRuleRequestHeaderCondition): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleRequestMethodCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
}
export declare function cdnEndpointDeliveryRuleRequestMethodConditionToTerraform(struct?: CdnEndpointDeliveryRuleRequestMethodConditionOutputReference | CdnEndpointDeliveryRuleRequestMethodCondition): any;
/**
 * @stability stable
 */
export declare class CdnEndpointDeliveryRuleRequestMethodConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointDeliveryRuleRequestMethodCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointDeliveryRuleRequestMethodCondition | undefined);
    private _matchValues?;
    /**
     * @stability stable
     */
    get matchValues(): string[];
    /**
     * @stability stable
     */
    set matchValues(value: string[]);
    /**
     * @stability stable
     */
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    /**
     * @stability stable
     */
    get negateCondition(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set negateCondition(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNegateCondition(): void;
    /**
     * @stability stable
     */
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    resetOperator(): void;
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleRequestSchemeCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
}
export declare function cdnEndpointDeliveryRuleRequestSchemeConditionToTerraform(struct?: CdnEndpointDeliveryRuleRequestSchemeConditionOutputReference | CdnEndpointDeliveryRuleRequestSchemeCondition): any;
/**
 * @stability stable
 */
export declare class CdnEndpointDeliveryRuleRequestSchemeConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointDeliveryRuleRequestSchemeCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointDeliveryRuleRequestSchemeCondition | undefined);
    private _matchValues?;
    /**
     * @stability stable
     */
    get matchValues(): string[];
    /**
     * @stability stable
     */
    set matchValues(value: string[]);
    /**
     * @stability stable
     */
    get matchValuesInput(): string[] | undefined;
    private _negateCondition?;
    /**
     * @stability stable
     */
    get negateCondition(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set negateCondition(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNegateCondition(): void;
    /**
     * @stability stable
     */
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    resetOperator(): void;
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleRequestUriCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#transforms CdnEndpoint#transforms}.
     *
     * @stability stable
     */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleRequestUriConditionToTerraform(struct?: CdnEndpointDeliveryRuleRequestUriCondition): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleUrlFileExtensionCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#transforms CdnEndpoint#transforms}.
     *
     * @stability stable
     */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleUrlFileExtensionConditionToTerraform(struct?: CdnEndpointDeliveryRuleUrlFileExtensionCondition): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleUrlFileNameCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#transforms CdnEndpoint#transforms}.
     *
     * @stability stable
     */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleUrlFileNameConditionToTerraform(struct?: CdnEndpointDeliveryRuleUrlFileNameCondition): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleUrlPathCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#match_values CdnEndpoint#match_values}.
     *
     * @stability stable
     */
    readonly matchValues?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#negate_condition CdnEndpoint#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#operator CdnEndpoint#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#transforms CdnEndpoint#transforms}.
     *
     * @stability stable
     */
    readonly transforms?: string[];
}
export declare function cdnEndpointDeliveryRuleUrlPathConditionToTerraform(struct?: CdnEndpointDeliveryRuleUrlPathCondition): any;
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleUrlRedirectAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#fragment CdnEndpoint#fragment}.
     *
     * @stability stable
     */
    readonly fragment?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#hostname CdnEndpoint#hostname}.
     *
     * @stability stable
     */
    readonly hostname?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#path CdnEndpoint#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#protocol CdnEndpoint#protocol}.
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#query_string CdnEndpoint#query_string}.
     *
     * @stability stable
     */
    readonly queryString?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#redirect_type CdnEndpoint#redirect_type}.
     *
     * @stability stable
     */
    readonly redirectType: string;
}
export declare function cdnEndpointDeliveryRuleUrlRedirectActionToTerraform(struct?: CdnEndpointDeliveryRuleUrlRedirectActionOutputReference | CdnEndpointDeliveryRuleUrlRedirectAction): any;
/**
 * @stability stable
 */
export declare class CdnEndpointDeliveryRuleUrlRedirectActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointDeliveryRuleUrlRedirectAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointDeliveryRuleUrlRedirectAction | undefined);
    private _fragment?;
    /**
     * @stability stable
     */
    get fragment(): string;
    /**
     * @stability stable
     */
    set fragment(value: string);
    /**
     * @stability stable
     */
    resetFragment(): void;
    /**
     * @stability stable
     */
    get fragmentInput(): string | undefined;
    private _hostname?;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    set hostname(value: string);
    /**
     * @stability stable
     */
    resetHostname(): void;
    /**
     * @stability stable
     */
    get hostnameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    resetProtocol(): void;
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _queryString?;
    /**
     * @stability stable
     */
    get queryString(): string;
    /**
     * @stability stable
     */
    set queryString(value: string);
    /**
     * @stability stable
     */
    resetQueryString(): void;
    /**
     * @stability stable
     */
    get queryStringInput(): string | undefined;
    private _redirectType?;
    /**
     * @stability stable
     */
    get redirectType(): string;
    /**
     * @stability stable
     */
    set redirectType(value: string);
    /**
     * @stability stable
     */
    get redirectTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRuleUrlRewriteAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#destination CdnEndpoint#destination}.
     *
     * @stability stable
     */
    readonly destination: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#preserve_unmatched_path CdnEndpoint#preserve_unmatched_path}.
     *
     * @stability stable
     */
    readonly preserveUnmatchedPath?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#source_pattern CdnEndpoint#source_pattern}.
     *
     * @stability stable
     */
    readonly sourcePattern: string;
}
export declare function cdnEndpointDeliveryRuleUrlRewriteActionToTerraform(struct?: CdnEndpointDeliveryRuleUrlRewriteActionOutputReference | CdnEndpointDeliveryRuleUrlRewriteAction): any;
/**
 * @stability stable
 */
export declare class CdnEndpointDeliveryRuleUrlRewriteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointDeliveryRuleUrlRewriteAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointDeliveryRuleUrlRewriteAction | undefined);
    private _destination?;
    /**
     * @stability stable
     */
    get destination(): string;
    /**
     * @stability stable
     */
    set destination(value: string);
    /**
     * @stability stable
     */
    get destinationInput(): string | undefined;
    private _preserveUnmatchedPath?;
    /**
     * @stability stable
     */
    get preserveUnmatchedPath(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preserveUnmatchedPath(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreserveUnmatchedPath(): void;
    /**
     * @stability stable
     */
    get preserveUnmatchedPathInput(): boolean | cdktf.IResolvable | undefined;
    private _sourcePattern?;
    /**
     * @stability stable
     */
    get sourcePattern(): string;
    /**
     * @stability stable
     */
    set sourcePattern(value: string);
    /**
     * @stability stable
     */
    get sourcePatternInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointDeliveryRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#name CdnEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#order CdnEndpoint#order}.
     *
     * @stability stable
     */
    readonly order: number;
    /**
     * cache_expiration_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#cache_expiration_action CdnEndpoint#cache_expiration_action}
     *
     * @stability stable
     */
    readonly cacheExpirationAction?: CdnEndpointDeliveryRuleCacheExpirationAction;
    /**
     * cache_key_query_string_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#cache_key_query_string_action CdnEndpoint#cache_key_query_string_action}
     *
     * @stability stable
     */
    readonly cacheKeyQueryStringAction?: CdnEndpointDeliveryRuleCacheKeyQueryStringAction;
    /**
     * cookies_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#cookies_condition CdnEndpoint#cookies_condition}
     *
     * @stability stable
     */
    readonly cookiesCondition?: CdnEndpointDeliveryRuleCookiesCondition[];
    /**
     * device_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#device_condition CdnEndpoint#device_condition}
     *
     * @stability stable
     */
    readonly deviceCondition?: CdnEndpointDeliveryRuleDeviceCondition;
    /**
     * http_version_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#http_version_condition CdnEndpoint#http_version_condition}
     *
     * @stability stable
     */
    readonly httpVersionCondition?: CdnEndpointDeliveryRuleHttpVersionCondition[];
    /**
     * modify_request_header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#modify_request_header_action CdnEndpoint#modify_request_header_action}
     *
     * @stability stable
     */
    readonly modifyRequestHeaderAction?: CdnEndpointDeliveryRuleModifyRequestHeaderAction[];
    /**
     * modify_response_header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#modify_response_header_action CdnEndpoint#modify_response_header_action}
     *
     * @stability stable
     */
    readonly modifyResponseHeaderAction?: CdnEndpointDeliveryRuleModifyResponseHeaderAction[];
    /**
     * post_arg_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#post_arg_condition CdnEndpoint#post_arg_condition}
     *
     * @stability stable
     */
    readonly postArgCondition?: CdnEndpointDeliveryRulePostArgCondition[];
    /**
     * query_string_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#query_string_condition CdnEndpoint#query_string_condition}
     *
     * @stability stable
     */
    readonly queryStringCondition?: CdnEndpointDeliveryRuleQueryStringCondition[];
    /**
     * remote_address_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#remote_address_condition CdnEndpoint#remote_address_condition}
     *
     * @stability stable
     */
    readonly remoteAddressCondition?: CdnEndpointDeliveryRuleRemoteAddressCondition[];
    /**
     * request_body_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#request_body_condition CdnEndpoint#request_body_condition}
     *
     * @stability stable
     */
    readonly requestBodyCondition?: CdnEndpointDeliveryRuleRequestBodyCondition[];
    /**
     * request_header_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#request_header_condition CdnEndpoint#request_header_condition}
     *
     * @stability stable
     */
    readonly requestHeaderCondition?: CdnEndpointDeliveryRuleRequestHeaderCondition[];
    /**
     * request_method_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#request_method_condition CdnEndpoint#request_method_condition}
     *
     * @stability stable
     */
    readonly requestMethodCondition?: CdnEndpointDeliveryRuleRequestMethodCondition;
    /**
     * request_scheme_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#request_scheme_condition CdnEndpoint#request_scheme_condition}
     *
     * @stability stable
     */
    readonly requestSchemeCondition?: CdnEndpointDeliveryRuleRequestSchemeCondition;
    /**
     * request_uri_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#request_uri_condition CdnEndpoint#request_uri_condition}
     *
     * @stability stable
     */
    readonly requestUriCondition?: CdnEndpointDeliveryRuleRequestUriCondition[];
    /**
     * url_file_extension_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#url_file_extension_condition CdnEndpoint#url_file_extension_condition}
     *
     * @stability stable
     */
    readonly urlFileExtensionCondition?: CdnEndpointDeliveryRuleUrlFileExtensionCondition[];
    /**
     * url_file_name_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#url_file_name_condition CdnEndpoint#url_file_name_condition}
     *
     * @stability stable
     */
    readonly urlFileNameCondition?: CdnEndpointDeliveryRuleUrlFileNameCondition[];
    /**
     * url_path_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#url_path_condition CdnEndpoint#url_path_condition}
     *
     * @stability stable
     */
    readonly urlPathCondition?: CdnEndpointDeliveryRuleUrlPathCondition[];
    /**
     * url_redirect_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#url_redirect_action CdnEndpoint#url_redirect_action}
     *
     * @stability stable
     */
    readonly urlRedirectAction?: CdnEndpointDeliveryRuleUrlRedirectAction;
    /**
     * url_rewrite_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#url_rewrite_action CdnEndpoint#url_rewrite_action}
     *
     * @stability stable
     */
    readonly urlRewriteAction?: CdnEndpointDeliveryRuleUrlRewriteAction;
}
export declare function cdnEndpointDeliveryRuleToTerraform(struct?: CdnEndpointDeliveryRule): any;
/**
 * @stability stable
 */
export interface CdnEndpointGeoFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#action CdnEndpoint#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#country_codes CdnEndpoint#country_codes}.
     *
     * @stability stable
     */
    readonly countryCodes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#relative_path CdnEndpoint#relative_path}.
     *
     * @stability stable
     */
    readonly relativePath: string;
}
export declare function cdnEndpointGeoFilterToTerraform(struct?: CdnEndpointGeoFilter): any;
/**
 * @stability stable
 */
export interface CdnEndpointGlobalDeliveryRuleCacheExpirationAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#behavior CdnEndpoint#behavior}.
     *
     * @stability stable
     */
    readonly behavior: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#duration CdnEndpoint#duration}.
     *
     * @stability stable
     */
    readonly duration?: string;
}
export declare function cdnEndpointGlobalDeliveryRuleCacheExpirationActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleCacheExpirationActionOutputReference | CdnEndpointGlobalDeliveryRuleCacheExpirationAction): any;
/**
 * @stability stable
 */
export declare class CdnEndpointGlobalDeliveryRuleCacheExpirationActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointGlobalDeliveryRuleCacheExpirationAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointGlobalDeliveryRuleCacheExpirationAction | undefined);
    private _behavior?;
    /**
     * @stability stable
     */
    get behavior(): string;
    /**
     * @stability stable
     */
    set behavior(value: string);
    /**
     * @stability stable
     */
    get behaviorInput(): string | undefined;
    private _duration?;
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    set duration(value: string);
    /**
     * @stability stable
     */
    resetDuration(): void;
    /**
     * @stability stable
     */
    get durationInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#behavior CdnEndpoint#behavior}.
     *
     * @stability stable
     */
    readonly behavior: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#parameters CdnEndpoint#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: string;
}
export declare function cdnEndpointGlobalDeliveryRuleCacheKeyQueryStringActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringActionOutputReference | CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction): any;
/**
 * @stability stable
 */
export declare class CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction | undefined);
    private _behavior?;
    /**
     * @stability stable
     */
    get behavior(): string;
    /**
     * @stability stable
     */
    set behavior(value: string);
    /**
     * @stability stable
     */
    get behaviorInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): string;
    /**
     * @stability stable
     */
    set parameters(value: string);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#action CdnEndpoint#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#name CdnEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#value CdnEndpoint#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function cdnEndpointGlobalDeliveryRuleModifyRequestHeaderActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction): any;
/**
 * @stability stable
 */
export interface CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#action CdnEndpoint#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#name CdnEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#value CdnEndpoint#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function cdnEndpointGlobalDeliveryRuleModifyResponseHeaderActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction): any;
/**
 * @stability stable
 */
export interface CdnEndpointGlobalDeliveryRuleUrlRedirectAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#fragment CdnEndpoint#fragment}.
     *
     * @stability stable
     */
    readonly fragment?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#hostname CdnEndpoint#hostname}.
     *
     * @stability stable
     */
    readonly hostname?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#path CdnEndpoint#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#protocol CdnEndpoint#protocol}.
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#query_string CdnEndpoint#query_string}.
     *
     * @stability stable
     */
    readonly queryString?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#redirect_type CdnEndpoint#redirect_type}.
     *
     * @stability stable
     */
    readonly redirectType: string;
}
export declare function cdnEndpointGlobalDeliveryRuleUrlRedirectActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleUrlRedirectActionOutputReference | CdnEndpointGlobalDeliveryRuleUrlRedirectAction): any;
/**
 * @stability stable
 */
export declare class CdnEndpointGlobalDeliveryRuleUrlRedirectActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointGlobalDeliveryRuleUrlRedirectAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointGlobalDeliveryRuleUrlRedirectAction | undefined);
    private _fragment?;
    /**
     * @stability stable
     */
    get fragment(): string;
    /**
     * @stability stable
     */
    set fragment(value: string);
    /**
     * @stability stable
     */
    resetFragment(): void;
    /**
     * @stability stable
     */
    get fragmentInput(): string | undefined;
    private _hostname?;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    set hostname(value: string);
    /**
     * @stability stable
     */
    resetHostname(): void;
    /**
     * @stability stable
     */
    get hostnameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    resetProtocol(): void;
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _queryString?;
    /**
     * @stability stable
     */
    get queryString(): string;
    /**
     * @stability stable
     */
    set queryString(value: string);
    /**
     * @stability stable
     */
    resetQueryString(): void;
    /**
     * @stability stable
     */
    get queryStringInput(): string | undefined;
    private _redirectType?;
    /**
     * @stability stable
     */
    get redirectType(): string;
    /**
     * @stability stable
     */
    set redirectType(value: string);
    /**
     * @stability stable
     */
    get redirectTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointGlobalDeliveryRuleUrlRewriteAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#destination CdnEndpoint#destination}.
     *
     * @stability stable
     */
    readonly destination: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#preserve_unmatched_path CdnEndpoint#preserve_unmatched_path}.
     *
     * @stability stable
     */
    readonly preserveUnmatchedPath?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#source_pattern CdnEndpoint#source_pattern}.
     *
     * @stability stable
     */
    readonly sourcePattern: string;
}
export declare function cdnEndpointGlobalDeliveryRuleUrlRewriteActionToTerraform(struct?: CdnEndpointGlobalDeliveryRuleUrlRewriteActionOutputReference | CdnEndpointGlobalDeliveryRuleUrlRewriteAction): any;
/**
 * @stability stable
 */
export declare class CdnEndpointGlobalDeliveryRuleUrlRewriteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointGlobalDeliveryRuleUrlRewriteAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointGlobalDeliveryRuleUrlRewriteAction | undefined);
    private _destination?;
    /**
     * @stability stable
     */
    get destination(): string;
    /**
     * @stability stable
     */
    set destination(value: string);
    /**
     * @stability stable
     */
    get destinationInput(): string | undefined;
    private _preserveUnmatchedPath?;
    /**
     * @stability stable
     */
    get preserveUnmatchedPath(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preserveUnmatchedPath(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreserveUnmatchedPath(): void;
    /**
     * @stability stable
     */
    get preserveUnmatchedPathInput(): boolean | cdktf.IResolvable | undefined;
    private _sourcePattern?;
    /**
     * @stability stable
     */
    get sourcePattern(): string;
    /**
     * @stability stable
     */
    set sourcePattern(value: string);
    /**
     * @stability stable
     */
    get sourcePatternInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointGlobalDeliveryRule {
    /**
     * cache_expiration_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#cache_expiration_action CdnEndpoint#cache_expiration_action}
     *
     * @stability stable
     */
    readonly cacheExpirationAction?: CdnEndpointGlobalDeliveryRuleCacheExpirationAction;
    /**
     * cache_key_query_string_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#cache_key_query_string_action CdnEndpoint#cache_key_query_string_action}
     *
     * @stability stable
     */
    readonly cacheKeyQueryStringAction?: CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction;
    /**
     * modify_request_header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#modify_request_header_action CdnEndpoint#modify_request_header_action}
     *
     * @stability stable
     */
    readonly modifyRequestHeaderAction?: CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction[];
    /**
     * modify_response_header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#modify_response_header_action CdnEndpoint#modify_response_header_action}
     *
     * @stability stable
     */
    readonly modifyResponseHeaderAction?: CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction[];
    /**
     * url_redirect_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#url_redirect_action CdnEndpoint#url_redirect_action}
     *
     * @stability stable
     */
    readonly urlRedirectAction?: CdnEndpointGlobalDeliveryRuleUrlRedirectAction;
    /**
     * url_rewrite_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#url_rewrite_action CdnEndpoint#url_rewrite_action}
     *
     * @stability stable
     */
    readonly urlRewriteAction?: CdnEndpointGlobalDeliveryRuleUrlRewriteAction;
}
export declare function cdnEndpointGlobalDeliveryRuleToTerraform(struct?: CdnEndpointGlobalDeliveryRuleOutputReference | CdnEndpointGlobalDeliveryRule): any;
/**
 * @stability stable
 */
export declare class CdnEndpointGlobalDeliveryRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointGlobalDeliveryRule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointGlobalDeliveryRule | undefined);
    private _cacheExpirationAction;
    /**
     * @stability stable
     */
    get cacheExpirationAction(): CdnEndpointGlobalDeliveryRuleCacheExpirationActionOutputReference;
    /**
     * @stability stable
     */
    putCacheExpirationAction(value: CdnEndpointGlobalDeliveryRuleCacheExpirationAction): void;
    /**
     * @stability stable
     */
    resetCacheExpirationAction(): void;
    /**
     * @stability stable
     */
    get cacheExpirationActionInput(): CdnEndpointGlobalDeliveryRuleCacheExpirationAction | undefined;
    private _cacheKeyQueryStringAction;
    /**
     * @stability stable
     */
    get cacheKeyQueryStringAction(): CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringActionOutputReference;
    /**
     * @stability stable
     */
    putCacheKeyQueryStringAction(value: CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction): void;
    /**
     * @stability stable
     */
    resetCacheKeyQueryStringAction(): void;
    /**
     * @stability stable
     */
    get cacheKeyQueryStringActionInput(): CdnEndpointGlobalDeliveryRuleCacheKeyQueryStringAction | undefined;
    private _modifyRequestHeaderAction?;
    /**
     * @stability stable
     */
    get modifyRequestHeaderAction(): CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction[];
    /**
     * @stability stable
     */
    set modifyRequestHeaderAction(value: CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction[]);
    /**
     * @stability stable
     */
    resetModifyRequestHeaderAction(): void;
    /**
     * @stability stable
     */
    get modifyRequestHeaderActionInput(): CdnEndpointGlobalDeliveryRuleModifyRequestHeaderAction[] | undefined;
    private _modifyResponseHeaderAction?;
    /**
     * @stability stable
     */
    get modifyResponseHeaderAction(): CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction[];
    /**
     * @stability stable
     */
    set modifyResponseHeaderAction(value: CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction[]);
    /**
     * @stability stable
     */
    resetModifyResponseHeaderAction(): void;
    /**
     * @stability stable
     */
    get modifyResponseHeaderActionInput(): CdnEndpointGlobalDeliveryRuleModifyResponseHeaderAction[] | undefined;
    private _urlRedirectAction;
    /**
     * @stability stable
     */
    get urlRedirectAction(): CdnEndpointGlobalDeliveryRuleUrlRedirectActionOutputReference;
    /**
     * @stability stable
     */
    putUrlRedirectAction(value: CdnEndpointGlobalDeliveryRuleUrlRedirectAction): void;
    /**
     * @stability stable
     */
    resetUrlRedirectAction(): void;
    /**
     * @stability stable
     */
    get urlRedirectActionInput(): CdnEndpointGlobalDeliveryRuleUrlRedirectAction | undefined;
    private _urlRewriteAction;
    /**
     * @stability stable
     */
    get urlRewriteAction(): CdnEndpointGlobalDeliveryRuleUrlRewriteActionOutputReference;
    /**
     * @stability stable
     */
    putUrlRewriteAction(value: CdnEndpointGlobalDeliveryRuleUrlRewriteAction): void;
    /**
     * @stability stable
     */
    resetUrlRewriteAction(): void;
    /**
     * @stability stable
     */
    get urlRewriteActionInput(): CdnEndpointGlobalDeliveryRuleUrlRewriteAction | undefined;
}
/**
 * @stability stable
 */
export interface CdnEndpointOrigin {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#host_name CdnEndpoint#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#http_port CdnEndpoint#http_port}.
     *
     * @stability stable
     */
    readonly httpPort?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#https_port CdnEndpoint#https_port}.
     *
     * @stability stable
     */
    readonly httpsPort?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#name CdnEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function cdnEndpointOriginToTerraform(struct?: CdnEndpointOrigin): any;
/**
 * @stability stable
 */
export interface CdnEndpointTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#create CdnEndpoint#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#delete CdnEndpoint#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#read CdnEndpoint#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint#update CdnEndpoint#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cdnEndpointTimeoutsToTerraform(struct?: CdnEndpointTimeoutsOutputReference | CdnEndpointTimeouts): any;
/**
 * @stability stable
 */
export declare class CdnEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CdnEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CdnEndpointTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint azurerm_cdn_endpoint}.
 *
 * @stability stable
 */
export declare class CdnEndpoint extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_endpoint azurerm_cdn_endpoint} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CdnEndpointConfig);
    private _contentTypesToCompress?;
    /**
     * @stability stable
     */
    get contentTypesToCompress(): string[];
    /**
     * @stability stable
     */
    set contentTypesToCompress(value: string[]);
    /**
     * @stability stable
     */
    resetContentTypesToCompress(): void;
    /**
     * @stability stable
     */
    get contentTypesToCompressInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get hostName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _isCompressionEnabled?;
    /**
     * @stability stable
     */
    get isCompressionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isCompressionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsCompressionEnabled(): void;
    /**
     * @stability stable
     */
    get isCompressionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isHttpAllowed?;
    /**
     * @stability stable
     */
    get isHttpAllowed(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isHttpAllowed(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsHttpAllowed(): void;
    /**
     * @stability stable
     */
    get isHttpAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _isHttpsAllowed?;
    /**
     * @stability stable
     */
    get isHttpsAllowed(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isHttpsAllowed(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsHttpsAllowed(): void;
    /**
     * @stability stable
     */
    get isHttpsAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _optimizationType?;
    /**
     * @stability stable
     */
    get optimizationType(): string;
    /**
     * @stability stable
     */
    set optimizationType(value: string);
    /**
     * @stability stable
     */
    resetOptimizationType(): void;
    /**
     * @stability stable
     */
    get optimizationTypeInput(): string | undefined;
    private _originHostHeader?;
    /**
     * @stability stable
     */
    get originHostHeader(): string;
    /**
     * @stability stable
     */
    set originHostHeader(value: string);
    /**
     * @stability stable
     */
    resetOriginHostHeader(): void;
    /**
     * @stability stable
     */
    get originHostHeaderInput(): string | undefined;
    private _originPath?;
    /**
     * @stability stable
     */
    get originPath(): string;
    /**
     * @stability stable
     */
    set originPath(value: string);
    /**
     * @stability stable
     */
    resetOriginPath(): void;
    /**
     * @stability stable
     */
    get originPathInput(): string | undefined;
    private _probePath?;
    /**
     * @stability stable
     */
    get probePath(): string;
    /**
     * @stability stable
     */
    set probePath(value: string);
    /**
     * @stability stable
     */
    resetProbePath(): void;
    /**
     * @stability stable
     */
    get probePathInput(): string | undefined;
    private _profileName?;
    /**
     * @stability stable
     */
    get profileName(): string;
    /**
     * @stability stable
     */
    set profileName(value: string);
    /**
     * @stability stable
     */
    get profileNameInput(): string | undefined;
    private _querystringCachingBehaviour?;
    /**
     * @stability stable
     */
    get querystringCachingBehaviour(): string;
    /**
     * @stability stable
     */
    set querystringCachingBehaviour(value: string);
    /**
     * @stability stable
     */
    resetQuerystringCachingBehaviour(): void;
    /**
     * @stability stable
     */
    get querystringCachingBehaviourInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _deliveryRule?;
    /**
     * @stability stable
     */
    get deliveryRule(): CdnEndpointDeliveryRule[];
    /**
     * @stability stable
     */
    set deliveryRule(value: CdnEndpointDeliveryRule[]);
    /**
     * @stability stable
     */
    resetDeliveryRule(): void;
    /**
     * @stability stable
     */
    get deliveryRuleInput(): CdnEndpointDeliveryRule[] | undefined;
    private _geoFilter?;
    /**
     * @stability stable
     */
    get geoFilter(): CdnEndpointGeoFilter[];
    /**
     * @stability stable
     */
    set geoFilter(value: CdnEndpointGeoFilter[]);
    /**
     * @stability stable
     */
    resetGeoFilter(): void;
    /**
     * @stability stable
     */
    get geoFilterInput(): CdnEndpointGeoFilter[] | undefined;
    private _globalDeliveryRule;
    /**
     * @stability stable
     */
    get globalDeliveryRule(): CdnEndpointGlobalDeliveryRuleOutputReference;
    /**
     * @stability stable
     */
    putGlobalDeliveryRule(value: CdnEndpointGlobalDeliveryRule): void;
    /**
     * @stability stable
     */
    resetGlobalDeliveryRule(): void;
    /**
     * @stability stable
     */
    get globalDeliveryRuleInput(): CdnEndpointGlobalDeliveryRule | undefined;
    private _origin?;
    /**
     * @stability stable
     */
    get origin(): CdnEndpointOrigin[];
    /**
     * @stability stable
     */
    set origin(value: CdnEndpointOrigin[]);
    /**
     * @stability stable
     */
    get originInput(): CdnEndpointOrigin[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CdnEndpointTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CdnEndpointTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CdnEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
