import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ConsumptionBudgetResourceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#amount ConsumptionBudgetResourceGroup#amount}.
     *
     * @stability stable
     */
    readonly amount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#etag ConsumptionBudgetResourceGroup#etag}.
     *
     * @stability stable
     */
    readonly etag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#resource_group_id ConsumptionBudgetResourceGroup#resource_group_id}.
     *
     * @stability stable
     */
    readonly resourceGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#time_grain ConsumptionBudgetResourceGroup#time_grain}.
     *
     * @stability stable
     */
    readonly timeGrain?: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#filter ConsumptionBudgetResourceGroup#filter}
     *
     * @stability stable
     */
    readonly filter?: ConsumptionBudgetResourceGroupFilter;
    /**
     * notification block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#notification ConsumptionBudgetResourceGroup#notification}
     *
     * @stability stable
     */
    readonly notification: ConsumptionBudgetResourceGroupNotification[];
    /**
     * time_period block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#time_period ConsumptionBudgetResourceGroup#time_period}
     *
     * @stability stable
     */
    readonly timePeriod: ConsumptionBudgetResourceGroupTimePeriod;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#timeouts ConsumptionBudgetResourceGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ConsumptionBudgetResourceGroupTimeouts;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetResourceGroupFilterDimension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#values ConsumptionBudgetResourceGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetResourceGroupFilterDimensionToTerraform(struct?: ConsumptionBudgetResourceGroupFilterDimension): any;
/**
 * @stability stable
 */
export interface ConsumptionBudgetResourceGroupFilterNotDimension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#values ConsumptionBudgetResourceGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetResourceGroupFilterNotDimensionToTerraform(struct?: ConsumptionBudgetResourceGroupFilterNotDimensionOutputReference | ConsumptionBudgetResourceGroupFilterNotDimension): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetResourceGroupFilterNotDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetResourceGroupFilterNotDimension | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetResourceGroupFilterNotDimension | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    resetOperator(): void;
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetResourceGroupFilterNotTag {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#values ConsumptionBudgetResourceGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetResourceGroupFilterNotTagToTerraform(struct?: ConsumptionBudgetResourceGroupFilterNotTagOutputReference | ConsumptionBudgetResourceGroupFilterNotTag): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetResourceGroupFilterNotTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetResourceGroupFilterNotTag | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetResourceGroupFilterNotTag | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    resetOperator(): void;
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetResourceGroupFilterNot {
    /**
     * dimension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#dimension ConsumptionBudgetResourceGroup#dimension}
     *
     * @stability stable
     */
    readonly dimension?: ConsumptionBudgetResourceGroupFilterNotDimension;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#tag ConsumptionBudgetResourceGroup#tag}
     *
     * @stability stable
     */
    readonly tag?: ConsumptionBudgetResourceGroupFilterNotTag;
}
export declare function consumptionBudgetResourceGroupFilterNotToTerraform(struct?: ConsumptionBudgetResourceGroupFilterNotOutputReference | ConsumptionBudgetResourceGroupFilterNot): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetResourceGroupFilterNotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetResourceGroupFilterNot | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetResourceGroupFilterNot | undefined);
    private _dimension;
    /**
     * @stability stable
     */
    get dimension(): ConsumptionBudgetResourceGroupFilterNotDimensionOutputReference;
    /**
     * @stability stable
     */
    putDimension(value: ConsumptionBudgetResourceGroupFilterNotDimension): void;
    /**
     * @stability stable
     */
    resetDimension(): void;
    /**
     * @stability stable
     */
    get dimensionInput(): ConsumptionBudgetResourceGroupFilterNotDimension | undefined;
    private _tag;
    /**
     * @stability stable
     */
    get tag(): ConsumptionBudgetResourceGroupFilterNotTagOutputReference;
    /**
     * @stability stable
     */
    putTag(value: ConsumptionBudgetResourceGroupFilterNotTag): void;
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): ConsumptionBudgetResourceGroupFilterNotTag | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetResourceGroupFilterTag {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#values ConsumptionBudgetResourceGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetResourceGroupFilterTagToTerraform(struct?: ConsumptionBudgetResourceGroupFilterTag): any;
/**
 * @stability stable
 */
export interface ConsumptionBudgetResourceGroupFilter {
    /**
     * dimension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#dimension ConsumptionBudgetResourceGroup#dimension}
     *
     * @stability stable
     */
    readonly dimension?: ConsumptionBudgetResourceGroupFilterDimension[];
    /**
     * not block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#not ConsumptionBudgetResourceGroup#not}
     *
     * @stability stable
     */
    readonly not?: ConsumptionBudgetResourceGroupFilterNot;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#tag ConsumptionBudgetResourceGroup#tag}
     *
     * @stability stable
     */
    readonly tag?: ConsumptionBudgetResourceGroupFilterTag[];
}
export declare function consumptionBudgetResourceGroupFilterToTerraform(struct?: ConsumptionBudgetResourceGroupFilterOutputReference | ConsumptionBudgetResourceGroupFilter): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetResourceGroupFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetResourceGroupFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetResourceGroupFilter | undefined);
    private _dimension?;
    /**
     * @stability stable
     */
    get dimension(): ConsumptionBudgetResourceGroupFilterDimension[];
    /**
     * @stability stable
     */
    set dimension(value: ConsumptionBudgetResourceGroupFilterDimension[]);
    /**
     * @stability stable
     */
    resetDimension(): void;
    /**
     * @stability stable
     */
    get dimensionInput(): ConsumptionBudgetResourceGroupFilterDimension[] | undefined;
    private _not;
    /**
     * @stability stable
     */
    get not(): ConsumptionBudgetResourceGroupFilterNotOutputReference;
    /**
     * @stability stable
     */
    putNot(value: ConsumptionBudgetResourceGroupFilterNot): void;
    /**
     * @stability stable
     */
    resetNot(): void;
    /**
     * @stability stable
     */
    get notInput(): ConsumptionBudgetResourceGroupFilterNot | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): ConsumptionBudgetResourceGroupFilterTag[];
    /**
     * @stability stable
     */
    set tag(value: ConsumptionBudgetResourceGroupFilterTag[]);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): ConsumptionBudgetResourceGroupFilterTag[] | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetResourceGroupNotification {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#contact_emails ConsumptionBudgetResourceGroup#contact_emails}.
     *
     * @stability stable
     */
    readonly contactEmails?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#contact_groups ConsumptionBudgetResourceGroup#contact_groups}.
     *
     * @stability stable
     */
    readonly contactGroups?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#contact_roles ConsumptionBudgetResourceGroup#contact_roles}.
     *
     * @stability stable
     */
    readonly contactRoles?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#enabled ConsumptionBudgetResourceGroup#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#threshold ConsumptionBudgetResourceGroup#threshold}.
     *
     * @stability stable
     */
    readonly threshold: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#threshold_type ConsumptionBudgetResourceGroup#threshold_type}.
     *
     * @stability stable
     */
    readonly thresholdType?: string;
}
export declare function consumptionBudgetResourceGroupNotificationToTerraform(struct?: ConsumptionBudgetResourceGroupNotification): any;
/**
 * @stability stable
 */
export interface ConsumptionBudgetResourceGroupTimePeriod {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#end_date ConsumptionBudgetResourceGroup#end_date}.
     *
     * @stability stable
     */
    readonly endDate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#start_date ConsumptionBudgetResourceGroup#start_date}.
     *
     * @stability stable
     */
    readonly startDate: string;
}
export declare function consumptionBudgetResourceGroupTimePeriodToTerraform(struct?: ConsumptionBudgetResourceGroupTimePeriodOutputReference | ConsumptionBudgetResourceGroupTimePeriod): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetResourceGroupTimePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetResourceGroupTimePeriod | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetResourceGroupTimePeriod | undefined);
    private _endDate?;
    /**
     * @stability stable
     */
    get endDate(): string;
    /**
     * @stability stable
     */
    set endDate(value: string);
    /**
     * @stability stable
     */
    resetEndDate(): void;
    /**
     * @stability stable
     */
    get endDateInput(): string | undefined;
    private _startDate?;
    /**
     * @stability stable
     */
    get startDate(): string;
    /**
     * @stability stable
     */
    set startDate(value: string);
    /**
     * @stability stable
     */
    get startDateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetResourceGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#create ConsumptionBudgetResourceGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#delete ConsumptionBudgetResourceGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#read ConsumptionBudgetResourceGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#update ConsumptionBudgetResourceGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function consumptionBudgetResourceGroupTimeoutsToTerraform(struct?: ConsumptionBudgetResourceGroupTimeoutsOutputReference | ConsumptionBudgetResourceGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetResourceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetResourceGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetResourceGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group azurerm_consumption_budget_resource_group}.
 *
 * @stability stable
 */
export declare class ConsumptionBudgetResourceGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group azurerm_consumption_budget_resource_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ConsumptionBudgetResourceGroupConfig);
    private _amount?;
    /**
     * @stability stable
     */
    get amount(): number;
    /**
     * @stability stable
     */
    set amount(value: number);
    /**
     * @stability stable
     */
    get amountInput(): number | undefined;
    private _etag?;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    set etag(value: string);
    /**
     * @stability stable
     */
    resetEtag(): void;
    /**
     * @stability stable
     */
    get etagInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupId?;
    /**
     * @stability stable
     */
    get resourceGroupId(): string;
    /**
     * @stability stable
     */
    set resourceGroupId(value: string);
    /**
     * @stability stable
     */
    get resourceGroupIdInput(): string | undefined;
    private _timeGrain?;
    /**
     * @stability stable
     */
    get timeGrain(): string;
    /**
     * @stability stable
     */
    set timeGrain(value: string);
    /**
     * @stability stable
     */
    resetTimeGrain(): void;
    /**
     * @stability stable
     */
    get timeGrainInput(): string | undefined;
    private _filter;
    /**
     * @stability stable
     */
    get filter(): ConsumptionBudgetResourceGroupFilterOutputReference;
    /**
     * @stability stable
     */
    putFilter(value: ConsumptionBudgetResourceGroupFilter): void;
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): ConsumptionBudgetResourceGroupFilter | undefined;
    private _notification?;
    /**
     * @stability stable
     */
    get notification(): ConsumptionBudgetResourceGroupNotification[];
    /**
     * @stability stable
     */
    set notification(value: ConsumptionBudgetResourceGroupNotification[]);
    /**
     * @stability stable
     */
    get notificationInput(): ConsumptionBudgetResourceGroupNotification[] | undefined;
    private _timePeriod;
    /**
     * @stability stable
     */
    get timePeriod(): ConsumptionBudgetResourceGroupTimePeriodOutputReference;
    /**
     * @stability stable
     */
    putTimePeriod(value: ConsumptionBudgetResourceGroupTimePeriod): void;
    /**
     * @stability stable
     */
    get timePeriodInput(): ConsumptionBudgetResourceGroupTimePeriod | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ConsumptionBudgetResourceGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ConsumptionBudgetResourceGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ConsumptionBudgetResourceGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
