import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ContainerRegistryTaskConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#agent_pool_name ContainerRegistryTask#agent_pool_name}.
     *
     * @stability stable
     */
    readonly agentPoolName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#container_registry_id ContainerRegistryTask#container_registry_id}.
     *
     * @stability stable
     */
    readonly containerRegistryId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#enabled ContainerRegistryTask#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#is_system_task ContainerRegistryTask#is_system_task}.
     *
     * @stability stable
     */
    readonly isSystemTask?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#log_template ContainerRegistryTask#log_template}.
     *
     * @stability stable
     */
    readonly logTemplate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#name ContainerRegistryTask#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#tags ContainerRegistryTask#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#timeout_in_seconds ContainerRegistryTask#timeout_in_seconds}.
     *
     * @stability stable
     */
    readonly timeoutInSeconds?: number;
    /**
     * agent_setting block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#agent_setting ContainerRegistryTask#agent_setting}
     *
     * @stability stable
     */
    readonly agentSetting?: ContainerRegistryTaskAgentSetting;
    /**
     * base_image_trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#base_image_trigger ContainerRegistryTask#base_image_trigger}
     *
     * @stability stable
     */
    readonly baseImageTrigger?: ContainerRegistryTaskBaseImageTrigger;
    /**
     * docker_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#docker_step ContainerRegistryTask#docker_step}
     *
     * @stability stable
     */
    readonly dockerStep?: ContainerRegistryTaskDockerStep;
    /**
     * encoded_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#encoded_step ContainerRegistryTask#encoded_step}
     *
     * @stability stable
     */
    readonly encodedStep?: ContainerRegistryTaskEncodedStep;
    /**
     * file_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#file_step ContainerRegistryTask#file_step}
     *
     * @stability stable
     */
    readonly fileStep?: ContainerRegistryTaskFileStep;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#identity ContainerRegistryTask#identity}
     *
     * @stability stable
     */
    readonly identity?: ContainerRegistryTaskIdentity;
    /**
     * platform block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#platform ContainerRegistryTask#platform}
     *
     * @stability stable
     */
    readonly platform?: ContainerRegistryTaskPlatform;
    /**
     * registry_credential block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#registry_credential ContainerRegistryTask#registry_credential}
     *
     * @stability stable
     */
    readonly registryCredential?: ContainerRegistryTaskRegistryCredential;
    /**
     * source_trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#source_trigger ContainerRegistryTask#source_trigger}
     *
     * @stability stable
     */
    readonly sourceTrigger?: ContainerRegistryTaskSourceTrigger[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#timeouts ContainerRegistryTask#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ContainerRegistryTaskTimeouts;
    /**
     * timer_trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#timer_trigger ContainerRegistryTask#timer_trigger}
     *
     * @stability stable
     */
    readonly timerTrigger?: ContainerRegistryTaskTimerTrigger[];
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskAgentSetting {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#cpu ContainerRegistryTask#cpu}.
     *
     * @stability stable
     */
    readonly cpu: number;
}
export declare function containerRegistryTaskAgentSettingToTerraform(struct?: ContainerRegistryTaskAgentSettingOutputReference | ContainerRegistryTaskAgentSetting): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTaskAgentSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTaskAgentSetting | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTaskAgentSetting | undefined);
    private _cpu?;
    /**
     * @stability stable
     */
    get cpu(): number;
    /**
     * @stability stable
     */
    set cpu(value: number);
    /**
     * @stability stable
     */
    get cpuInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskBaseImageTrigger {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#enabled ContainerRegistryTask#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#name ContainerRegistryTask#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#type ContainerRegistryTask#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#update_trigger_endpoint ContainerRegistryTask#update_trigger_endpoint}.
     *
     * @stability stable
     */
    readonly updateTriggerEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#update_trigger_payload_type ContainerRegistryTask#update_trigger_payload_type}.
     *
     * @stability stable
     */
    readonly updateTriggerPayloadType?: string;
}
export declare function containerRegistryTaskBaseImageTriggerToTerraform(struct?: ContainerRegistryTaskBaseImageTriggerOutputReference | ContainerRegistryTaskBaseImageTrigger): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTaskBaseImageTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTaskBaseImageTrigger | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTaskBaseImageTrigger | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _updateTriggerEndpoint?;
    /**
     * @stability stable
     */
    get updateTriggerEndpoint(): string;
    /**
     * @stability stable
     */
    set updateTriggerEndpoint(value: string);
    /**
     * @stability stable
     */
    resetUpdateTriggerEndpoint(): void;
    /**
     * @stability stable
     */
    get updateTriggerEndpointInput(): string | undefined;
    private _updateTriggerPayloadType?;
    /**
     * @stability stable
     */
    get updateTriggerPayloadType(): string;
    /**
     * @stability stable
     */
    set updateTriggerPayloadType(value: string);
    /**
     * @stability stable
     */
    resetUpdateTriggerPayloadType(): void;
    /**
     * @stability stable
     */
    get updateTriggerPayloadTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskDockerStep {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#arguments ContainerRegistryTask#arguments}.
     *
     * @stability stable
     */
    readonly arguments?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#cache_enabled ContainerRegistryTask#cache_enabled}.
     *
     * @stability stable
     */
    readonly cacheEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_access_token ContainerRegistryTask#context_access_token}.
     *
     * @stability stable
     */
    readonly contextAccessToken: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_path ContainerRegistryTask#context_path}.
     *
     * @stability stable
     */
    readonly contextPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#dockerfile_path ContainerRegistryTask#dockerfile_path}.
     *
     * @stability stable
     */
    readonly dockerfilePath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#image_names ContainerRegistryTask#image_names}.
     *
     * @stability stable
     */
    readonly imageNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#push_enabled ContainerRegistryTask#push_enabled}.
     *
     * @stability stable
     */
    readonly pushEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#secret_arguments ContainerRegistryTask#secret_arguments}.
     *
     * @stability stable
     */
    readonly secretArguments?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#target ContainerRegistryTask#target}.
     *
     * @stability stable
     */
    readonly target?: string;
}
export declare function containerRegistryTaskDockerStepToTerraform(struct?: ContainerRegistryTaskDockerStepOutputReference | ContainerRegistryTaskDockerStep): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTaskDockerStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTaskDockerStep | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTaskDockerStep | undefined);
    private _arguments?;
    /**
     * @stability stable
     */
    get arguments(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set arguments(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetArguments(): void;
    /**
     * @stability stable
     */
    get argumentsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _cacheEnabled?;
    /**
     * @stability stable
     */
    get cacheEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set cacheEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCacheEnabled(): void;
    /**
     * @stability stable
     */
    get cacheEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _contextAccessToken?;
    /**
     * @stability stable
     */
    get contextAccessToken(): string;
    /**
     * @stability stable
     */
    set contextAccessToken(value: string);
    /**
     * @stability stable
     */
    get contextAccessTokenInput(): string | undefined;
    private _contextPath?;
    /**
     * @stability stable
     */
    get contextPath(): string;
    /**
     * @stability stable
     */
    set contextPath(value: string);
    /**
     * @stability stable
     */
    get contextPathInput(): string | undefined;
    private _dockerfilePath?;
    /**
     * @stability stable
     */
    get dockerfilePath(): string;
    /**
     * @stability stable
     */
    set dockerfilePath(value: string);
    /**
     * @stability stable
     */
    get dockerfilePathInput(): string | undefined;
    private _imageNames?;
    /**
     * @stability stable
     */
    get imageNames(): string[];
    /**
     * @stability stable
     */
    set imageNames(value: string[]);
    /**
     * @stability stable
     */
    resetImageNames(): void;
    /**
     * @stability stable
     */
    get imageNamesInput(): string[] | undefined;
    private _pushEnabled?;
    /**
     * @stability stable
     */
    get pushEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set pushEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPushEnabled(): void;
    /**
     * @stability stable
     */
    get pushEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _secretArguments?;
    /**
     * @stability stable
     */
    get secretArguments(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set secretArguments(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecretArguments(): void;
    /**
     * @stability stable
     */
    get secretArgumentsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    resetTarget(): void;
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskEncodedStep {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_access_token ContainerRegistryTask#context_access_token}.
     *
     * @stability stable
     */
    readonly contextAccessToken?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_path ContainerRegistryTask#context_path}.
     *
     * @stability stable
     */
    readonly contextPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#secret_values ContainerRegistryTask#secret_values}.
     *
     * @stability stable
     */
    readonly secretValues?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#task_content ContainerRegistryTask#task_content}.
     *
     * @stability stable
     */
    readonly taskContent: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#value_content ContainerRegistryTask#value_content}.
     *
     * @stability stable
     */
    readonly valueContent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#values ContainerRegistryTask#values}.
     *
     * @stability stable
     */
    readonly values?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare function containerRegistryTaskEncodedStepToTerraform(struct?: ContainerRegistryTaskEncodedStepOutputReference | ContainerRegistryTaskEncodedStep): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTaskEncodedStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTaskEncodedStep | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTaskEncodedStep | undefined);
    private _contextAccessToken?;
    /**
     * @stability stable
     */
    get contextAccessToken(): string;
    /**
     * @stability stable
     */
    set contextAccessToken(value: string);
    /**
     * @stability stable
     */
    resetContextAccessToken(): void;
    /**
     * @stability stable
     */
    get contextAccessTokenInput(): string | undefined;
    private _contextPath?;
    /**
     * @stability stable
     */
    get contextPath(): string;
    /**
     * @stability stable
     */
    set contextPath(value: string);
    /**
     * @stability stable
     */
    resetContextPath(): void;
    /**
     * @stability stable
     */
    get contextPathInput(): string | undefined;
    private _secretValues?;
    /**
     * @stability stable
     */
    get secretValues(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set secretValues(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecretValues(): void;
    /**
     * @stability stable
     */
    get secretValuesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _taskContent?;
    /**
     * @stability stable
     */
    get taskContent(): string;
    /**
     * @stability stable
     */
    set taskContent(value: string);
    /**
     * @stability stable
     */
    get taskContentInput(): string | undefined;
    private _valueContent?;
    /**
     * @stability stable
     */
    get valueContent(): string;
    /**
     * @stability stable
     */
    set valueContent(value: string);
    /**
     * @stability stable
     */
    resetValueContent(): void;
    /**
     * @stability stable
     */
    get valueContentInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set values(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskFileStep {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_access_token ContainerRegistryTask#context_access_token}.
     *
     * @stability stable
     */
    readonly contextAccessToken?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#context_path ContainerRegistryTask#context_path}.
     *
     * @stability stable
     */
    readonly contextPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#secret_values ContainerRegistryTask#secret_values}.
     *
     * @stability stable
     */
    readonly secretValues?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#task_file_path ContainerRegistryTask#task_file_path}.
     *
     * @stability stable
     */
    readonly taskFilePath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#value_file_path ContainerRegistryTask#value_file_path}.
     *
     * @stability stable
     */
    readonly valueFilePath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#values ContainerRegistryTask#values}.
     *
     * @stability stable
     */
    readonly values?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare function containerRegistryTaskFileStepToTerraform(struct?: ContainerRegistryTaskFileStepOutputReference | ContainerRegistryTaskFileStep): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTaskFileStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTaskFileStep | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTaskFileStep | undefined);
    private _contextAccessToken?;
    /**
     * @stability stable
     */
    get contextAccessToken(): string;
    /**
     * @stability stable
     */
    set contextAccessToken(value: string);
    /**
     * @stability stable
     */
    resetContextAccessToken(): void;
    /**
     * @stability stable
     */
    get contextAccessTokenInput(): string | undefined;
    private _contextPath?;
    /**
     * @stability stable
     */
    get contextPath(): string;
    /**
     * @stability stable
     */
    set contextPath(value: string);
    /**
     * @stability stable
     */
    resetContextPath(): void;
    /**
     * @stability stable
     */
    get contextPathInput(): string | undefined;
    private _secretValues?;
    /**
     * @stability stable
     */
    get secretValues(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set secretValues(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecretValues(): void;
    /**
     * @stability stable
     */
    get secretValuesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _taskFilePath?;
    /**
     * @stability stable
     */
    get taskFilePath(): string;
    /**
     * @stability stable
     */
    set taskFilePath(value: string);
    /**
     * @stability stable
     */
    get taskFilePathInput(): string | undefined;
    private _valueFilePath?;
    /**
     * @stability stable
     */
    get valueFilePath(): string;
    /**
     * @stability stable
     */
    set valueFilePath(value: string);
    /**
     * @stability stable
     */
    resetValueFilePath(): void;
    /**
     * @stability stable
     */
    get valueFilePathInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set values(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#identity_ids ContainerRegistryTask#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#type ContainerRegistryTask#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function containerRegistryTaskIdentityToTerraform(struct?: ContainerRegistryTaskIdentityOutputReference | ContainerRegistryTaskIdentity): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTaskIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTaskIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTaskIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskPlatform {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#architecture ContainerRegistryTask#architecture}.
     *
     * @stability stable
     */
    readonly architecture?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#os ContainerRegistryTask#os}.
     *
     * @stability stable
     */
    readonly os: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#variant ContainerRegistryTask#variant}.
     *
     * @stability stable
     */
    readonly variant?: string;
}
export declare function containerRegistryTaskPlatformToTerraform(struct?: ContainerRegistryTaskPlatformOutputReference | ContainerRegistryTaskPlatform): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTaskPlatformOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTaskPlatform | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTaskPlatform | undefined);
    private _architecture?;
    /**
     * @stability stable
     */
    get architecture(): string;
    /**
     * @stability stable
     */
    set architecture(value: string);
    /**
     * @stability stable
     */
    resetArchitecture(): void;
    /**
     * @stability stable
     */
    get architectureInput(): string | undefined;
    private _os?;
    /**
     * @stability stable
     */
    get os(): string;
    /**
     * @stability stable
     */
    set os(value: string);
    /**
     * @stability stable
     */
    get osInput(): string | undefined;
    private _variant?;
    /**
     * @stability stable
     */
    get variant(): string;
    /**
     * @stability stable
     */
    set variant(value: string);
    /**
     * @stability stable
     */
    resetVariant(): void;
    /**
     * @stability stable
     */
    get variantInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskRegistryCredentialCustom {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#identity ContainerRegistryTask#identity}.
     *
     * @stability stable
     */
    readonly identity?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#login_server ContainerRegistryTask#login_server}.
     *
     * @stability stable
     */
    readonly loginServer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#password ContainerRegistryTask#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#username ContainerRegistryTask#username}.
     *
     * @stability stable
     */
    readonly username?: string;
}
export declare function containerRegistryTaskRegistryCredentialCustomToTerraform(struct?: ContainerRegistryTaskRegistryCredentialCustom): any;
/**
 * @stability stable
 */
export interface ContainerRegistryTaskRegistryCredentialSource {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#login_mode ContainerRegistryTask#login_mode}.
     *
     * @stability stable
     */
    readonly loginMode: string;
}
export declare function containerRegistryTaskRegistryCredentialSourceToTerraform(struct?: ContainerRegistryTaskRegistryCredentialSourceOutputReference | ContainerRegistryTaskRegistryCredentialSource): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTaskRegistryCredentialSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTaskRegistryCredentialSource | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTaskRegistryCredentialSource | undefined);
    private _loginMode?;
    /**
     * @stability stable
     */
    get loginMode(): string;
    /**
     * @stability stable
     */
    set loginMode(value: string);
    /**
     * @stability stable
     */
    get loginModeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskRegistryCredential {
    /**
     * custom block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#custom ContainerRegistryTask#custom}
     *
     * @stability stable
     */
    readonly custom?: ContainerRegistryTaskRegistryCredentialCustom[];
    /**
     * source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#source ContainerRegistryTask#source}
     *
     * @stability stable
     */
    readonly source?: ContainerRegistryTaskRegistryCredentialSource;
}
export declare function containerRegistryTaskRegistryCredentialToTerraform(struct?: ContainerRegistryTaskRegistryCredentialOutputReference | ContainerRegistryTaskRegistryCredential): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTaskRegistryCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTaskRegistryCredential | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTaskRegistryCredential | undefined);
    private _custom?;
    /**
     * @stability stable
     */
    get custom(): ContainerRegistryTaskRegistryCredentialCustom[];
    /**
     * @stability stable
     */
    set custom(value: ContainerRegistryTaskRegistryCredentialCustom[]);
    /**
     * @stability stable
     */
    resetCustom(): void;
    /**
     * @stability stable
     */
    get customInput(): ContainerRegistryTaskRegistryCredentialCustom[] | undefined;
    private _source;
    /**
     * @stability stable
     */
    get source(): ContainerRegistryTaskRegistryCredentialSourceOutputReference;
    /**
     * @stability stable
     */
    putSource(value: ContainerRegistryTaskRegistryCredentialSource): void;
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): ContainerRegistryTaskRegistryCredentialSource | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskSourceTriggerAuthentication {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#expire_in_seconds ContainerRegistryTask#expire_in_seconds}.
     *
     * @stability stable
     */
    readonly expireInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#refresh_token ContainerRegistryTask#refresh_token}.
     *
     * @stability stable
     */
    readonly refreshToken?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#scope ContainerRegistryTask#scope}.
     *
     * @stability stable
     */
    readonly scope?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#token ContainerRegistryTask#token}.
     *
     * @stability stable
     */
    readonly token: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#token_type ContainerRegistryTask#token_type}.
     *
     * @stability stable
     */
    readonly tokenType: string;
}
export declare function containerRegistryTaskSourceTriggerAuthenticationToTerraform(struct?: ContainerRegistryTaskSourceTriggerAuthenticationOutputReference | ContainerRegistryTaskSourceTriggerAuthentication): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTaskSourceTriggerAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTaskSourceTriggerAuthentication | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTaskSourceTriggerAuthentication | undefined);
    private _expireInSeconds?;
    /**
     * @stability stable
     */
    get expireInSeconds(): number;
    /**
     * @stability stable
     */
    set expireInSeconds(value: number);
    /**
     * @stability stable
     */
    resetExpireInSeconds(): void;
    /**
     * @stability stable
     */
    get expireInSecondsInput(): number | undefined;
    private _refreshToken?;
    /**
     * @stability stable
     */
    get refreshToken(): string;
    /**
     * @stability stable
     */
    set refreshToken(value: string);
    /**
     * @stability stable
     */
    resetRefreshToken(): void;
    /**
     * @stability stable
     */
    get refreshTokenInput(): string | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    private _token?;
    /**
     * @stability stable
     */
    get token(): string;
    /**
     * @stability stable
     */
    set token(value: string);
    /**
     * @stability stable
     */
    get tokenInput(): string | undefined;
    private _tokenType?;
    /**
     * @stability stable
     */
    get tokenType(): string;
    /**
     * @stability stable
     */
    set tokenType(value: string);
    /**
     * @stability stable
     */
    get tokenTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskSourceTrigger {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#branch ContainerRegistryTask#branch}.
     *
     * @stability stable
     */
    readonly branch?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#enabled ContainerRegistryTask#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#events ContainerRegistryTask#events}.
     *
     * @stability stable
     */
    readonly events: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#name ContainerRegistryTask#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#repository_url ContainerRegistryTask#repository_url}.
     *
     * @stability stable
     */
    readonly repositoryUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#source_type ContainerRegistryTask#source_type}.
     *
     * @stability stable
     */
    readonly sourceType: string;
    /**
     * authentication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#authentication ContainerRegistryTask#authentication}
     *
     * @stability stable
     */
    readonly authentication?: ContainerRegistryTaskSourceTriggerAuthentication;
}
export declare function containerRegistryTaskSourceTriggerToTerraform(struct?: ContainerRegistryTaskSourceTrigger): any;
/**
 * @stability stable
 */
export interface ContainerRegistryTaskTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#create ContainerRegistryTask#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#delete ContainerRegistryTask#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#read ContainerRegistryTask#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#update ContainerRegistryTask#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function containerRegistryTaskTimeoutsToTerraform(struct?: ContainerRegistryTaskTimeoutsOutputReference | ContainerRegistryTaskTimeouts): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTaskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTaskTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTaskTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTaskTimerTrigger {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#enabled ContainerRegistryTask#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#name ContainerRegistryTask#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task#schedule ContainerRegistryTask#schedule}.
     *
     * @stability stable
     */
    readonly schedule: string;
}
export declare function containerRegistryTaskTimerTriggerToTerraform(struct?: ContainerRegistryTaskTimerTrigger): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task azurerm_container_registry_task}.
 *
 * @stability stable
 */
export declare class ContainerRegistryTask extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_task azurerm_container_registry_task} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ContainerRegistryTaskConfig);
    private _agentPoolName?;
    /**
     * @stability stable
     */
    get agentPoolName(): string;
    /**
     * @stability stable
     */
    set agentPoolName(value: string);
    /**
     * @stability stable
     */
    resetAgentPoolName(): void;
    /**
     * @stability stable
     */
    get agentPoolNameInput(): string | undefined;
    private _containerRegistryId?;
    /**
     * @stability stable
     */
    get containerRegistryId(): string;
    /**
     * @stability stable
     */
    set containerRegistryId(value: string);
    /**
     * @stability stable
     */
    get containerRegistryIdInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isSystemTask?;
    /**
     * @stability stable
     */
    get isSystemTask(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isSystemTask(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsSystemTask(): void;
    /**
     * @stability stable
     */
    get isSystemTaskInput(): boolean | cdktf.IResolvable | undefined;
    private _logTemplate?;
    /**
     * @stability stable
     */
    get logTemplate(): string;
    /**
     * @stability stable
     */
    set logTemplate(value: string);
    /**
     * @stability stable
     */
    resetLogTemplate(): void;
    /**
     * @stability stable
     */
    get logTemplateInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timeoutInSeconds?;
    /**
     * @stability stable
     */
    get timeoutInSeconds(): number;
    /**
     * @stability stable
     */
    set timeoutInSeconds(value: number);
    /**
     * @stability stable
     */
    resetTimeoutInSeconds(): void;
    /**
     * @stability stable
     */
    get timeoutInSecondsInput(): number | undefined;
    private _agentSetting;
    /**
     * @stability stable
     */
    get agentSetting(): ContainerRegistryTaskAgentSettingOutputReference;
    /**
     * @stability stable
     */
    putAgentSetting(value: ContainerRegistryTaskAgentSetting): void;
    /**
     * @stability stable
     */
    resetAgentSetting(): void;
    /**
     * @stability stable
     */
    get agentSettingInput(): ContainerRegistryTaskAgentSetting | undefined;
    private _baseImageTrigger;
    /**
     * @stability stable
     */
    get baseImageTrigger(): ContainerRegistryTaskBaseImageTriggerOutputReference;
    /**
     * @stability stable
     */
    putBaseImageTrigger(value: ContainerRegistryTaskBaseImageTrigger): void;
    /**
     * @stability stable
     */
    resetBaseImageTrigger(): void;
    /**
     * @stability stable
     */
    get baseImageTriggerInput(): ContainerRegistryTaskBaseImageTrigger | undefined;
    private _dockerStep;
    /**
     * @stability stable
     */
    get dockerStep(): ContainerRegistryTaskDockerStepOutputReference;
    /**
     * @stability stable
     */
    putDockerStep(value: ContainerRegistryTaskDockerStep): void;
    /**
     * @stability stable
     */
    resetDockerStep(): void;
    /**
     * @stability stable
     */
    get dockerStepInput(): ContainerRegistryTaskDockerStep | undefined;
    private _encodedStep;
    /**
     * @stability stable
     */
    get encodedStep(): ContainerRegistryTaskEncodedStepOutputReference;
    /**
     * @stability stable
     */
    putEncodedStep(value: ContainerRegistryTaskEncodedStep): void;
    /**
     * @stability stable
     */
    resetEncodedStep(): void;
    /**
     * @stability stable
     */
    get encodedStepInput(): ContainerRegistryTaskEncodedStep | undefined;
    private _fileStep;
    /**
     * @stability stable
     */
    get fileStep(): ContainerRegistryTaskFileStepOutputReference;
    /**
     * @stability stable
     */
    putFileStep(value: ContainerRegistryTaskFileStep): void;
    /**
     * @stability stable
     */
    resetFileStep(): void;
    /**
     * @stability stable
     */
    get fileStepInput(): ContainerRegistryTaskFileStep | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): ContainerRegistryTaskIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: ContainerRegistryTaskIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): ContainerRegistryTaskIdentity | undefined;
    private _platform;
    /**
     * @stability stable
     */
    get platform(): ContainerRegistryTaskPlatformOutputReference;
    /**
     * @stability stable
     */
    putPlatform(value: ContainerRegistryTaskPlatform): void;
    /**
     * @stability stable
     */
    resetPlatform(): void;
    /**
     * @stability stable
     */
    get platformInput(): ContainerRegistryTaskPlatform | undefined;
    private _registryCredential;
    /**
     * @stability stable
     */
    get registryCredential(): ContainerRegistryTaskRegistryCredentialOutputReference;
    /**
     * @stability stable
     */
    putRegistryCredential(value: ContainerRegistryTaskRegistryCredential): void;
    /**
     * @stability stable
     */
    resetRegistryCredential(): void;
    /**
     * @stability stable
     */
    get registryCredentialInput(): ContainerRegistryTaskRegistryCredential | undefined;
    private _sourceTrigger?;
    /**
     * @stability stable
     */
    get sourceTrigger(): ContainerRegistryTaskSourceTrigger[];
    /**
     * @stability stable
     */
    set sourceTrigger(value: ContainerRegistryTaskSourceTrigger[]);
    /**
     * @stability stable
     */
    resetSourceTrigger(): void;
    /**
     * @stability stable
     */
    get sourceTriggerInput(): ContainerRegistryTaskSourceTrigger[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ContainerRegistryTaskTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ContainerRegistryTaskTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ContainerRegistryTaskTimeouts | undefined;
    private _timerTrigger?;
    /**
     * @stability stable
     */
    get timerTrigger(): ContainerRegistryTaskTimerTrigger[];
    /**
     * @stability stable
     */
    set timerTrigger(value: ContainerRegistryTaskTimerTrigger[]);
    /**
     * @stability stable
     */
    resetTimerTrigger(): void;
    /**
     * @stability stable
     */
    get timerTriggerInput(): ContainerRegistryTaskTimerTrigger[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
