import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CosmosdbSqlContainerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#account_name CosmosdbSqlContainer#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#analytical_storage_ttl CosmosdbSqlContainer#analytical_storage_ttl}.
     *
     * @stability stable
     */
    readonly analyticalStorageTtl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#database_name CosmosdbSqlContainer#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#default_ttl CosmosdbSqlContainer#default_ttl}.
     *
     * @stability stable
     */
    readonly defaultTtl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#name CosmosdbSqlContainer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#partition_key_path CosmosdbSqlContainer#partition_key_path}.
     *
     * @stability stable
     */
    readonly partitionKeyPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#partition_key_version CosmosdbSqlContainer#partition_key_version}.
     *
     * @stability stable
     */
    readonly partitionKeyVersion?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#resource_group_name CosmosdbSqlContainer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#throughput CosmosdbSqlContainer#throughput}.
     *
     * @stability stable
     */
    readonly throughput?: number;
    /**
     * autoscale_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#autoscale_settings CosmosdbSqlContainer#autoscale_settings}
     *
     * @stability stable
     */
    readonly autoscaleSettings?: CosmosdbSqlContainerAutoscaleSettings;
    /**
     * conflict_resolution_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#conflict_resolution_policy CosmosdbSqlContainer#conflict_resolution_policy}
     *
     * @stability stable
     */
    readonly conflictResolutionPolicy?: CosmosdbSqlContainerConflictResolutionPolicy;
    /**
     * indexing_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#indexing_policy CosmosdbSqlContainer#indexing_policy}
     *
     * @stability stable
     */
    readonly indexingPolicy?: CosmosdbSqlContainerIndexingPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#timeouts CosmosdbSqlContainer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CosmosdbSqlContainerTimeouts;
    /**
     * unique_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#unique_key CosmosdbSqlContainer#unique_key}
     *
     * @stability stable
     */
    readonly uniqueKey?: CosmosdbSqlContainerUniqueKey[];
}
/**
 * @stability stable
 */
export interface CosmosdbSqlContainerAutoscaleSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#max_throughput CosmosdbSqlContainer#max_throughput}.
     *
     * @stability stable
     */
    readonly maxThroughput?: number;
}
export declare function cosmosdbSqlContainerAutoscaleSettingsToTerraform(struct?: CosmosdbSqlContainerAutoscaleSettingsOutputReference | CosmosdbSqlContainerAutoscaleSettings): any;
/**
 * @stability stable
 */
export declare class CosmosdbSqlContainerAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbSqlContainerAutoscaleSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbSqlContainerAutoscaleSettings | undefined);
    private _maxThroughput?;
    /**
     * @stability stable
     */
    get maxThroughput(): number;
    /**
     * @stability stable
     */
    set maxThroughput(value: number);
    /**
     * @stability stable
     */
    resetMaxThroughput(): void;
    /**
     * @stability stable
     */
    get maxThroughputInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbSqlContainerConflictResolutionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#conflict_resolution_path CosmosdbSqlContainer#conflict_resolution_path}.
     *
     * @stability stable
     */
    readonly conflictResolutionPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#conflict_resolution_procedure CosmosdbSqlContainer#conflict_resolution_procedure}.
     *
     * @stability stable
     */
    readonly conflictResolutionProcedure?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#mode CosmosdbSqlContainer#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
}
export declare function cosmosdbSqlContainerConflictResolutionPolicyToTerraform(struct?: CosmosdbSqlContainerConflictResolutionPolicyOutputReference | CosmosdbSqlContainerConflictResolutionPolicy): any;
/**
 * @stability stable
 */
export declare class CosmosdbSqlContainerConflictResolutionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbSqlContainerConflictResolutionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbSqlContainerConflictResolutionPolicy | undefined);
    private _conflictResolutionPath?;
    /**
     * @stability stable
     */
    get conflictResolutionPath(): string;
    /**
     * @stability stable
     */
    set conflictResolutionPath(value: string);
    /**
     * @stability stable
     */
    resetConflictResolutionPath(): void;
    /**
     * @stability stable
     */
    get conflictResolutionPathInput(): string | undefined;
    private _conflictResolutionProcedure?;
    /**
     * @stability stable
     */
    get conflictResolutionProcedure(): string;
    /**
     * @stability stable
     */
    set conflictResolutionProcedure(value: string);
    /**
     * @stability stable
     */
    resetConflictResolutionProcedure(): void;
    /**
     * @stability stable
     */
    get conflictResolutionProcedureInput(): string | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbSqlContainerIndexingPolicyCompositeIndexIndex {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#order CosmosdbSqlContainer#order}.
     *
     * @stability stable
     */
    readonly order: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#path CosmosdbSqlContainer#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function cosmosdbSqlContainerIndexingPolicyCompositeIndexIndexToTerraform(struct?: CosmosdbSqlContainerIndexingPolicyCompositeIndexIndex): any;
/**
 * @stability stable
 */
export interface CosmosdbSqlContainerIndexingPolicyCompositeIndex {
    /**
     * index block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#index CosmosdbSqlContainer#index}
     *
     * @stability stable
     */
    readonly index: CosmosdbSqlContainerIndexingPolicyCompositeIndexIndex[];
}
export declare function cosmosdbSqlContainerIndexingPolicyCompositeIndexToTerraform(struct?: CosmosdbSqlContainerIndexingPolicyCompositeIndex): any;
/**
 * @stability stable
 */
export interface CosmosdbSqlContainerIndexingPolicyExcludedPath {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#path CosmosdbSqlContainer#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function cosmosdbSqlContainerIndexingPolicyExcludedPathToTerraform(struct?: CosmosdbSqlContainerIndexingPolicyExcludedPath): any;
/**
 * @stability stable
 */
export interface CosmosdbSqlContainerIndexingPolicyIncludedPath {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#path CosmosdbSqlContainer#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function cosmosdbSqlContainerIndexingPolicyIncludedPathToTerraform(struct?: CosmosdbSqlContainerIndexingPolicyIncludedPath): any;
/**
 * @stability stable
 */
export interface CosmosdbSqlContainerIndexingPolicySpatialIndex {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#path CosmosdbSqlContainer#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function cosmosdbSqlContainerIndexingPolicySpatialIndexToTerraform(struct?: CosmosdbSqlContainerIndexingPolicySpatialIndex): any;
/**
 * @stability stable
 */
export interface CosmosdbSqlContainerIndexingPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#indexing_mode CosmosdbSqlContainer#indexing_mode}.
     *
     * @stability stable
     */
    readonly indexingMode?: string;
    /**
     * composite_index block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#composite_index CosmosdbSqlContainer#composite_index}
     *
     * @stability stable
     */
    readonly compositeIndex?: CosmosdbSqlContainerIndexingPolicyCompositeIndex[];
    /**
     * excluded_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#excluded_path CosmosdbSqlContainer#excluded_path}
     *
     * @stability stable
     */
    readonly excludedPath?: CosmosdbSqlContainerIndexingPolicyExcludedPath[];
    /**
     * included_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#included_path CosmosdbSqlContainer#included_path}
     *
     * @stability stable
     */
    readonly includedPath?: CosmosdbSqlContainerIndexingPolicyIncludedPath[];
    /**
     * spatial_index block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#spatial_index CosmosdbSqlContainer#spatial_index}
     *
     * @stability stable
     */
    readonly spatialIndex?: CosmosdbSqlContainerIndexingPolicySpatialIndex[];
}
export declare function cosmosdbSqlContainerIndexingPolicyToTerraform(struct?: CosmosdbSqlContainerIndexingPolicyOutputReference | CosmosdbSqlContainerIndexingPolicy): any;
/**
 * @stability stable
 */
export declare class CosmosdbSqlContainerIndexingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbSqlContainerIndexingPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbSqlContainerIndexingPolicy | undefined);
    private _indexingMode?;
    /**
     * @stability stable
     */
    get indexingMode(): string;
    /**
     * @stability stable
     */
    set indexingMode(value: string);
    /**
     * @stability stable
     */
    resetIndexingMode(): void;
    /**
     * @stability stable
     */
    get indexingModeInput(): string | undefined;
    private _compositeIndex?;
    /**
     * @stability stable
     */
    get compositeIndex(): CosmosdbSqlContainerIndexingPolicyCompositeIndex[];
    /**
     * @stability stable
     */
    set compositeIndex(value: CosmosdbSqlContainerIndexingPolicyCompositeIndex[]);
    /**
     * @stability stable
     */
    resetCompositeIndex(): void;
    /**
     * @stability stable
     */
    get compositeIndexInput(): CosmosdbSqlContainerIndexingPolicyCompositeIndex[] | undefined;
    private _excludedPath?;
    /**
     * @stability stable
     */
    get excludedPath(): CosmosdbSqlContainerIndexingPolicyExcludedPath[];
    /**
     * @stability stable
     */
    set excludedPath(value: CosmosdbSqlContainerIndexingPolicyExcludedPath[]);
    /**
     * @stability stable
     */
    resetExcludedPath(): void;
    /**
     * @stability stable
     */
    get excludedPathInput(): CosmosdbSqlContainerIndexingPolicyExcludedPath[] | undefined;
    private _includedPath?;
    /**
     * @stability stable
     */
    get includedPath(): CosmosdbSqlContainerIndexingPolicyIncludedPath[];
    /**
     * @stability stable
     */
    set includedPath(value: CosmosdbSqlContainerIndexingPolicyIncludedPath[]);
    /**
     * @stability stable
     */
    resetIncludedPath(): void;
    /**
     * @stability stable
     */
    get includedPathInput(): CosmosdbSqlContainerIndexingPolicyIncludedPath[] | undefined;
    private _spatialIndex?;
    /**
     * @stability stable
     */
    get spatialIndex(): CosmosdbSqlContainerIndexingPolicySpatialIndex[];
    /**
     * @stability stable
     */
    set spatialIndex(value: CosmosdbSqlContainerIndexingPolicySpatialIndex[]);
    /**
     * @stability stable
     */
    resetSpatialIndex(): void;
    /**
     * @stability stable
     */
    get spatialIndexInput(): CosmosdbSqlContainerIndexingPolicySpatialIndex[] | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbSqlContainerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#create CosmosdbSqlContainer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#delete CosmosdbSqlContainer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#read CosmosdbSqlContainer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#update CosmosdbSqlContainer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cosmosdbSqlContainerTimeoutsToTerraform(struct?: CosmosdbSqlContainerTimeoutsOutputReference | CosmosdbSqlContainerTimeouts): any;
/**
 * @stability stable
 */
export declare class CosmosdbSqlContainerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbSqlContainerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbSqlContainerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbSqlContainerUniqueKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#paths CosmosdbSqlContainer#paths}.
     *
     * @stability stable
     */
    readonly paths: string[];
}
export declare function cosmosdbSqlContainerUniqueKeyToTerraform(struct?: CosmosdbSqlContainerUniqueKey): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container azurerm_cosmosdb_sql_container}.
 *
 * @stability stable
 */
export declare class CosmosdbSqlContainer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container azurerm_cosmosdb_sql_container} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CosmosdbSqlContainerConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    private _analyticalStorageTtl?;
    /**
     * @stability stable
     */
    get analyticalStorageTtl(): number;
    /**
     * @stability stable
     */
    set analyticalStorageTtl(value: number);
    /**
     * @stability stable
     */
    resetAnalyticalStorageTtl(): void;
    /**
     * @stability stable
     */
    get analyticalStorageTtlInput(): number | undefined;
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _defaultTtl?;
    /**
     * @stability stable
     */
    get defaultTtl(): number;
    /**
     * @stability stable
     */
    set defaultTtl(value: number);
    /**
     * @stability stable
     */
    resetDefaultTtl(): void;
    /**
     * @stability stable
     */
    get defaultTtlInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _partitionKeyPath?;
    /**
     * @stability stable
     */
    get partitionKeyPath(): string;
    /**
     * @stability stable
     */
    set partitionKeyPath(value: string);
    /**
     * @stability stable
     */
    get partitionKeyPathInput(): string | undefined;
    private _partitionKeyVersion?;
    /**
     * @stability stable
     */
    get partitionKeyVersion(): number;
    /**
     * @stability stable
     */
    set partitionKeyVersion(value: number);
    /**
     * @stability stable
     */
    resetPartitionKeyVersion(): void;
    /**
     * @stability stable
     */
    get partitionKeyVersionInput(): number | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _throughput?;
    /**
     * @stability stable
     */
    get throughput(): number;
    /**
     * @stability stable
     */
    set throughput(value: number);
    /**
     * @stability stable
     */
    resetThroughput(): void;
    /**
     * @stability stable
     */
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    /**
     * @stability stable
     */
    get autoscaleSettings(): CosmosdbSqlContainerAutoscaleSettingsOutputReference;
    /**
     * @stability stable
     */
    putAutoscaleSettings(value: CosmosdbSqlContainerAutoscaleSettings): void;
    /**
     * @stability stable
     */
    resetAutoscaleSettings(): void;
    /**
     * @stability stable
     */
    get autoscaleSettingsInput(): CosmosdbSqlContainerAutoscaleSettings | undefined;
    private _conflictResolutionPolicy;
    /**
     * @stability stable
     */
    get conflictResolutionPolicy(): CosmosdbSqlContainerConflictResolutionPolicyOutputReference;
    /**
     * @stability stable
     */
    putConflictResolutionPolicy(value: CosmosdbSqlContainerConflictResolutionPolicy): void;
    /**
     * @stability stable
     */
    resetConflictResolutionPolicy(): void;
    /**
     * @stability stable
     */
    get conflictResolutionPolicyInput(): CosmosdbSqlContainerConflictResolutionPolicy | undefined;
    private _indexingPolicy;
    /**
     * @stability stable
     */
    get indexingPolicy(): CosmosdbSqlContainerIndexingPolicyOutputReference;
    /**
     * @stability stable
     */
    putIndexingPolicy(value: CosmosdbSqlContainerIndexingPolicy): void;
    /**
     * @stability stable
     */
    resetIndexingPolicy(): void;
    /**
     * @stability stable
     */
    get indexingPolicyInput(): CosmosdbSqlContainerIndexingPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CosmosdbSqlContainerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CosmosdbSqlContainerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CosmosdbSqlContainerTimeouts | undefined;
    private _uniqueKey?;
    /**
     * @stability stable
     */
    get uniqueKey(): CosmosdbSqlContainerUniqueKey[];
    /**
     * @stability stable
     */
    set uniqueKey(value: CosmosdbSqlContainerUniqueKey[]);
    /**
     * @stability stable
     */
    resetUniqueKey(): void;
    /**
     * @stability stable
     */
    get uniqueKeyInput(): CosmosdbSqlContainerUniqueKey[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
