import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermAadb2CDirectoryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Domain name of the B2C tenant, including onmicrosoft.com suffix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/aadb2c_directory#domain_name DataAzurermAadb2CDirectory#domain_name}
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/aadb2c_directory#resource_group_name DataAzurermAadb2CDirectory#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/aadb2c_directory#timeouts DataAzurermAadb2CDirectory#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermAadb2CDirectoryTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermAadb2CDirectoryTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/aadb2c_directory#read DataAzurermAadb2CDirectory#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermAadb2CDirectoryTimeoutsToTerraform(struct?: DataAzurermAadb2CDirectoryTimeoutsOutputReference | DataAzurermAadb2CDirectoryTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermAadb2CDirectoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermAadb2CDirectoryTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermAadb2CDirectoryTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/aadb2c_directory azurerm_aadb2c_directory}.
 *
 * @stability stable
 */
export declare class DataAzurermAadb2CDirectory extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/aadb2c_directory azurerm_aadb2c_directory} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermAadb2CDirectoryConfig);
    /**
     * @stability stable
     */
    get billingType(): string;
    /**
     * @stability stable
     */
    get dataResidencyLocation(): string;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    set domainName(value: string);
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get effectiveStartDate(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermAadb2CDirectoryTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermAadb2CDirectoryTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermAadb2CDirectoryTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
