import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermApiManagementApiVersionSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set#api_management_name DataAzurermApiManagementApiVersionSet#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set#name DataAzurermApiManagementApiVersionSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set#resource_group_name DataAzurermApiManagementApiVersionSet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set#timeouts DataAzurermApiManagementApiVersionSet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermApiManagementApiVersionSetTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermApiManagementApiVersionSetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set#read DataAzurermApiManagementApiVersionSet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermApiManagementApiVersionSetTimeoutsToTerraform(struct?: DataAzurermApiManagementApiVersionSetTimeoutsOutputReference | DataAzurermApiManagementApiVersionSetTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementApiVersionSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermApiManagementApiVersionSetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermApiManagementApiVersionSetTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set azurerm_api_management_api_version_set}.
 *
 * @stability stable
 */
export declare class DataAzurermApiManagementApiVersionSet extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set azurerm_api_management_api_version_set} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementApiVersionSetConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get versionHeaderName(): string;
    /**
     * @stability stable
     */
    get versionQueryName(): string;
    /**
     * @stability stable
     */
    get versioningScheme(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermApiManagementApiVersionSetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermApiManagementApiVersionSetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermApiManagementApiVersionSetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
