import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermApiManagementGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway#api_management_id DataAzurermApiManagementGateway#api_management_id}.
     *
     * @stability stable
     */
    readonly apiManagementId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway#name DataAzurermApiManagementGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway#timeouts DataAzurermApiManagementGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermApiManagementGatewayTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementGatewayLocationData extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get city(): string;
    /**
     * @stability stable
     */
    get district(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get region(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermApiManagementGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway#read DataAzurermApiManagementGateway#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermApiManagementGatewayTimeoutsToTerraform(struct?: DataAzurermApiManagementGatewayTimeoutsOutputReference | DataAzurermApiManagementGatewayTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermApiManagementGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermApiManagementGatewayTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway azurerm_api_management_gateway}.
 *
 * @stability stable
 */
export declare class DataAzurermApiManagementGateway extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway azurerm_api_management_gateway} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementGatewayConfig);
    private _apiManagementId?;
    /**
     * @stability stable
     */
    get apiManagementId(): string;
    /**
     * @stability stable
     */
    set apiManagementId(value: string);
    /**
     * @stability stable
     */
    get apiManagementIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    locationData(index: string): DataAzurermApiManagementGatewayLocationData;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermApiManagementGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermApiManagementGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermApiManagementGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
