import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermApiManagementGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_group#api_management_name DataAzurermApiManagementGroup#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_group#name DataAzurermApiManagementGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_group#resource_group_name DataAzurermApiManagementGroup#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_group#timeouts DataAzurermApiManagementGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermApiManagementGroupTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermApiManagementGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_group#read DataAzurermApiManagementGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermApiManagementGroupTimeoutsToTerraform(struct?: DataAzurermApiManagementGroupTimeoutsOutputReference | DataAzurermApiManagementGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermApiManagementGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermApiManagementGroupTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_group azurerm_api_management_group}.
 *
 * @stability stable
 */
export declare class DataAzurermApiManagementGroup extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_group azurerm_api_management_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementGroupConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get externalId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermApiManagementGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermApiManagementGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermApiManagementGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
