import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermApiManagementConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management#name DataAzurermApiManagement#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management#resource_group_name DataAzurermApiManagement#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management#timeouts DataAzurermApiManagement#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermApiManagementTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementAdditionalLocation extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get gatewayRegionalUrl(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get privateIpAddresses(): string[];
    /**
     * @stability stable
     */
    get publicIpAddresses(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementHostnameConfigurationDeveloperPortal extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hostName(): string;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    get negotiateClientCertificate(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementHostnameConfigurationManagement extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hostName(): string;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    get negotiateClientCertificate(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementHostnameConfigurationPortal extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hostName(): string;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    get negotiateClientCertificate(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementHostnameConfigurationProxy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get defaultSslBinding(): any;
    /**
     * @stability stable
     */
    get hostName(): string;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    get negotiateClientCertificate(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementHostnameConfigurationScm extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hostName(): string;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    get negotiateClientCertificate(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementHostnameConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get developerPortal(): any;
    /**
     * @stability stable
     */
    get management(): any;
    /**
     * @stability stable
     */
    get portal(): any;
    /**
     * @stability stable
     */
    get proxy(): any;
    /**
     * @stability stable
     */
    get scm(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermApiManagementTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management#read DataAzurermApiManagement#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermApiManagementTimeoutsToTerraform(struct?: DataAzurermApiManagementTimeoutsOutputReference | DataAzurermApiManagementTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermApiManagementTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermApiManagementTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/api_management azurerm_api_management}.
 *
 * @stability stable
 */
export declare class DataAzurermApiManagement extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/api_management azurerm_api_management} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementConfig);
    /**
     * @stability stable
     */
    additionalLocation(index: string): DataAzurermApiManagementAdditionalLocation;
    /**
     * @stability stable
     */
    get developerPortalUrl(): string;
    /**
     * @stability stable
     */
    get gatewayRegionalUrl(): string;
    /**
     * @stability stable
     */
    get gatewayUrl(): string;
    /**
     * @stability stable
     */
    hostnameConfiguration(index: string): DataAzurermApiManagementHostnameConfiguration;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermApiManagementIdentity;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get managementApiUrl(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get notificationSenderEmail(): string;
    /**
     * @stability stable
     */
    get portalUrl(): string;
    /**
     * @stability stable
     */
    get privateIpAddresses(): string[];
    /**
     * @stability stable
     */
    get publicIpAddresses(): string[];
    /**
     * @stability stable
     */
    get publisherEmail(): string;
    /**
     * @stability stable
     */
    get publisherName(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get scmUrl(): string;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermApiManagementTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermApiManagementTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermApiManagementTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
