import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermAppServiceCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate#name DataAzurermAppServiceCertificate#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate#resource_group_name DataAzurermAppServiceCertificate#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate#tags DataAzurermAppServiceCertificate#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate#timeouts DataAzurermAppServiceCertificate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermAppServiceCertificateTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermAppServiceCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate#read DataAzurermAppServiceCertificate#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermAppServiceCertificateTimeoutsToTerraform(struct?: DataAzurermAppServiceCertificateTimeoutsOutputReference | DataAzurermAppServiceCertificateTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermAppServiceCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermAppServiceCertificateTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate azurerm_app_service_certificate}.
 *
 * @stability stable
 */
export declare class DataAzurermAppServiceCertificate extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate azurerm_app_service_certificate} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermAppServiceCertificateConfig);
    /**
     * @stability stable
     */
    get expirationDate(): string;
    /**
     * @stability stable
     */
    get friendlyName(): string;
    /**
     * @stability stable
     */
    get hostNames(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get issueDate(): string;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get subjectName(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermAppServiceCertificateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermAppServiceCertificateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermAppServiceCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
