import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermClientConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/client_config#timeouts DataAzurermClientConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermClientConfigTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermClientConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/client_config#read DataAzurermClientConfig#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermClientConfigTimeoutsToTerraform(struct?: DataAzurermClientConfigTimeoutsOutputReference | DataAzurermClientConfigTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermClientConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermClientConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermClientConfigTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/client_config azurerm_client_config}.
 *
 * @stability stable
 */
export declare class DataAzurermClientConfig extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/client_config azurerm_client_config} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzurermClientConfigConfig);
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermClientConfigTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermClientConfigTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermClientConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
